/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.planner.physical;

import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.Expression;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.planner.physical.PhysicalPlanNodeVisitor;

public class FilterOperator
extends PhysicalPlan {
    private final PhysicalPlan input;
    private final Expression conditions;
    private ExprValue next = null;
    private boolean nextPrepared = false;

    @Override
    public <R, C> R accept(PhysicalPlanNodeVisitor<R, C> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public List<PhysicalPlan> getChild() {
        return Collections.singletonList(this.input);
    }

    @Override
    public boolean hasNext() {
        if (!this.nextPrepared) {
            this.prepareNext();
        }
        return this.next != null;
    }

    @Override
    public ExprValue next() {
        if (!this.nextPrepared) {
            this.prepareNext();
        }
        ExprValue result = this.next;
        this.next = null;
        this.nextPrepared = false;
        return result;
    }

    private void prepareNext() {
        while (this.input.hasNext()) {
            ExprValue inputValue = (ExprValue)this.input.next();
            ExprValue exprValue = this.conditions.valueOf(inputValue.bindingTuples());
            if (exprValue.isNull() || exprValue.isMissing() || !exprValue.booleanValue().booleanValue()) continue;
            this.next = inputValue;
            this.nextPrepared = true;
            return;
        }
        this.next = null;
        this.nextPrepared = true;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FilterOperator)) {
            return false;
        }
        FilterOperator other = (FilterOperator)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.nextPrepared != other.nextPrepared) {
            return false;
        }
        PhysicalPlan this$input = this.getInput();
        PhysicalPlan other$input = other.getInput();
        if (this$input == null ? other$input != null : !this$input.equals(other$input)) {
            return false;
        }
        Expression this$conditions = this.getConditions();
        Expression other$conditions = other.getConditions();
        if (this$conditions == null ? other$conditions != null : !this$conditions.equals(other$conditions)) {
            return false;
        }
        ExprValue this$next = this.next;
        ExprValue other$next = other.next;
        return !(this$next == null ? other$next != null : !this$next.equals(other$next));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FilterOperator;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.nextPrepared ? 79 : 97);
        PhysicalPlan $input = this.getInput();
        result = result * 59 + ($input == null ? 43 : $input.hashCode());
        Expression $conditions = this.getConditions();
        result = result * 59 + ($conditions == null ? 43 : $conditions.hashCode());
        ExprValue $next = this.next;
        result = result * 59 + ($next == null ? 43 : $next.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FilterOperator(input=" + String.valueOf(this.getInput()) + ", conditions=" + String.valueOf(this.getConditions()) + ")";
    }

    @Generated
    public FilterOperator(PhysicalPlan input, Expression conditions) {
        this.input = input;
        this.conditions = conditions;
    }

    @Generated
    public PhysicalPlan getInput() {
        return this.input;
    }

    @Generated
    public Expression getConditions() {
        return this.conditions;
    }
}

