/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.opensearch.planner.physical;

import java.util.Objects;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.immutables.value.Value;
import org.opensearch.sql.opensearch.planner.physical.ImmutableOpenSearchLimitIndexScanRule;
import org.opensearch.sql.opensearch.planner.physical.OpenSearchIndexScanRule;
import org.opensearch.sql.opensearch.storage.scan.CalciteLogicalIndexScan;

@Value.Enclosing
public class OpenSearchLimitIndexScanRule
extends RelRule<Config> {
    protected OpenSearchLimitIndexScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        CalciteLogicalIndexScan newScan;
        LogicalSort sort = (LogicalSort)call.rel(0);
        CalciteLogicalIndexScan scan = (CalciteLogicalIndexScan)call.rel(1);
        Integer limitValue = OpenSearchLimitIndexScanRule.extractLimitValue(sort.fetch);
        Integer offsetValue = OpenSearchLimitIndexScanRule.extractOffsetValue(sort.offset);
        if (limitValue != null && offsetValue != null && (newScan = scan.pushDownLimit(limitValue, offsetValue)) != null) {
            call.transformTo((RelNode)newScan);
        }
    }

    private static Integer extractLimitValue(RexNode fetch) {
        if (fetch instanceof RexLiteral) {
            return (Integer)((RexLiteral)fetch).getValueAs(Integer.class);
        }
        return null;
    }

    private static Integer extractOffsetValue(RexNode offset) {
        if (Objects.isNull(offset)) {
            return 0;
        }
        if (offset instanceof RexLiteral) {
            return (Integer)((RexLiteral)offset).getValueAs(Integer.class);
        }
        return null;
    }

    @Value.Immutable
    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = ImmutableOpenSearchLimitIndexScanRule.Config.builder().build().withOperandSupplier(b0 -> b0.operand(LogicalSort.class).predicate(OpenSearchIndexScanRule::isLogicalSortLimit).oneInput(b1 -> b1.operand(CalciteLogicalIndexScan.class).predicate(OpenSearchIndexScanRule::noAggregatePushed).noInputs()));

        default public OpenSearchLimitIndexScanRule toRule() {
            return new OpenSearchLimitIndexScanRule(this);
        }
    }
}

