/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.expression.function.udf.datetime;

import java.util.List;
import org.apache.calcite.adapter.enumerable.NotNullImplementor;
import org.apache.calcite.adapter.enumerable.NullPolicy;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.sql.type.ReturnTypes;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.opensearch.sql.calcite.utils.PPLOperandTypes;
import org.opensearch.sql.calcite.utils.UserDefinedFunctionUtils;
import org.opensearch.sql.data.model.ExprValue;
import org.opensearch.sql.expression.datetime.DateTimeFunctions;
import org.opensearch.sql.expression.function.FunctionProperties;
import org.opensearch.sql.expression.function.ImplementorUDF;
import org.opensearch.sql.expression.function.UDFOperandMetadata;

public class UnixTimestampFunction
extends ImplementorUDF {
    public UnixTimestampFunction() {
        super(new UnixTimestampImplementor(), NullPolicy.ANY);
    }

    @Override
    public SqlReturnTypeInference getReturnTypeInference() {
        return ReturnTypes.DOUBLE_FORCE_NULLABLE;
    }

    @Override
    public UDFOperandMetadata getOperandMetadata() {
        return PPLOperandTypes.OPTIONAL_DATE_OR_TIMESTAMP_OR_NUMERIC;
    }

    public static double unixTimestamp(FunctionProperties properties) {
        return DateTimeFunctions.unixTimeStamp(properties.getQueryStartClock()).doubleValue();
    }

    public static double unixTimestamp(FunctionProperties ignored, ExprValue timestamp) {
        return DateTimeFunctions.unixTimeStampOf(timestamp).doubleValue();
    }

    public static class UnixTimestampImplementor
    implements NotNullImplementor {
        public Expression implement(RexToLixTranslator rexToLixTranslator, RexCall rexCall, List<Expression> list) {
            List<Expression> operands = UserDefinedFunctionUtils.convertToExprValues(list, rexCall);
            List<Expression> operandsWithProperties = UserDefinedFunctionUtils.prependFunctionProperties(operands, rexToLixTranslator);
            return Expressions.call(UnixTimestampFunction.class, (String)"unixTimestamp", operandsWithProperties);
        }
    }
}

