/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.utils;

import java.io.IOException;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.common.xcontent.json.JsonXContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.memorycontainer.MemoryStorageConfig;
import org.opensearch.ml.common.memorycontainer.MemoryType;

public final class MemorySearchQueryBuilder {
    @Generated
    private static final Logger log = LogManager.getLogger(MemorySearchQueryBuilder.class);

    public static XContentBuilder buildNeuralQuery(String queryText, String embeddingModelId) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("neural").startObject("memory_embedding").field("query_text", queryText).field("model_id", embeddingModelId).endObject().endObject().endObject();
    }

    public static XContentBuilder buildNeuralSparseQuery(String queryText, String embeddingModelId) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("neural_sparse").startObject("memory_embedding").field("query_text", queryText).field("model_id", embeddingModelId).endObject().endObject().endObject();
    }

    public static XContentBuilder buildMatchQuery(String queryText) throws IOException {
        return JsonXContent.jsonXContent.contentBuilder().startObject().startObject("match").field("memory", queryText).endObject().endObject();
    }

    public static XContentBuilder buildQueryByStorageType(String queryText, MemoryStorageConfig storageConfig) throws IOException {
        if (storageConfig != null && storageConfig.isSemanticStorageEnabled()) {
            if (storageConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
                return MemorySearchQueryBuilder.buildNeuralQuery(queryText, storageConfig.getEmbeddingModelId());
            }
            if (storageConfig.getEmbeddingModelType() == FunctionName.SPARSE_ENCODING) {
                return MemorySearchQueryBuilder.buildNeuralSparseQuery(queryText, storageConfig.getEmbeddingModelId());
            }
            throw new IllegalStateException("Unsupported embedding model type: " + String.valueOf(storageConfig.getEmbeddingModelType()));
        }
        return MemorySearchQueryBuilder.buildMatchQuery(queryText);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XContentBuilder buildFactSearchQuery(String fact, String sessionId, MemoryStorageConfig storageConfig) throws IOException {
        XContentBuilder boolQuery = JsonXContent.jsonXContent.contentBuilder();
        boolQuery.startObject();
        boolQuery.startObject("bool");
        boolQuery.startObject("filter");
        boolQuery.startObject("bool");
        boolQuery.startArray("must");
        boolQuery.startObject();
        boolQuery.startObject("term");
        boolQuery.field("session_id", sessionId);
        boolQuery.endObject();
        boolQuery.endObject();
        boolQuery.startObject();
        boolQuery.startObject("term");
        boolQuery.field("memory_type", MemoryType.FACT.getValue());
        boolQuery.endObject();
        boolQuery.endObject();
        boolQuery.endArray();
        boolQuery.endObject();
        boolQuery.endObject();
        boolQuery.startArray("must");
        boolQuery.startObject();
        if (storageConfig != null && storageConfig.isSemanticStorageEnabled()) {
            if (storageConfig.getEmbeddingModelType() == FunctionName.TEXT_EMBEDDING) {
                boolQuery.startObject("neural");
                boolQuery.startObject("memory_embedding");
                boolQuery.field("query_text", fact);
                boolQuery.field("model_id", storageConfig.getEmbeddingModelId());
                boolQuery.endObject();
                boolQuery.endObject();
            } else {
                if (storageConfig.getEmbeddingModelType() != FunctionName.SPARSE_ENCODING) throw new IllegalStateException("Unsupported embedding model type: " + String.valueOf(storageConfig.getEmbeddingModelType()));
                boolQuery.startObject("neural_sparse");
                boolQuery.startObject("memory_embedding");
                boolQuery.field("query_text", fact);
                boolQuery.field("model_id", storageConfig.getEmbeddingModelId());
                boolQuery.endObject();
                boolQuery.endObject();
            }
        } else {
            boolQuery.startObject("match");
            boolQuery.field("memory", fact);
            boolQuery.endObject();
        }
        boolQuery.endObject();
        boolQuery.endArray();
        boolQuery.endObject();
        boolQuery.endObject();
        return boolQuery;
    }

    @Generated
    private MemorySearchQueryBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

