/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.rest.mcpserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.action.ActionType;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.annotation.ExperimentalApi;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.ml.common.settings.MLCommonsSettings;
import org.opensearch.ml.common.settings.MLFeatureEnabledSetting;
import org.opensearch.ml.common.transport.mcpserver.action.MLMcpToolsRemoveAction;
import org.opensearch.ml.common.transport.mcpserver.requests.remove.MLMcpToolsRemoveNodesRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@ExperimentalApi
public class RestMLMcpToolsRemoveAction
extends BaseRestHandler {
    @Generated
    private static final Logger log = LogManager.getLogger(RestMLMcpToolsRemoveAction.class);
    private static final String ML_REGISTER_MCP_TOOLS_ACTION = "ml_remove_mcp_tools_action";
    private final ClusterService clusterService;
    private final String REMOVE_PATH = String.format(Locale.ROOT, "%s/mcp/tools/_remove", "/_plugins/_ml");
    private final MLFeatureEnabledSetting mlFeatureEnabledSetting;

    public RestMLMcpToolsRemoveAction(ClusterService clusterService, MLFeatureEnabledSetting mlFeatureEnabledSetting) {
        this.clusterService = clusterService;
        this.mlFeatureEnabledSetting = mlFeatureEnabledSetting;
    }

    public String getName() {
        return ML_REGISTER_MCP_TOOLS_ACTION;
    }

    public List<RestHandler.Route> routes() {
        return ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.POST, this.REMOVE_PATH));
    }

    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        if (!this.mlFeatureEnabledSetting.isMcpServerEnabled()) {
            throw new OpenSearchException(MLCommonsSettings.ML_COMMONS_MCP_SERVER_DISABLED_MESSAGE, new Object[0]);
        }
        MLMcpToolsRemoveNodesRequest removeNodesRequest = this.getRequest(request);
        ActionRequestValidationException exception = new ActionRequestValidationException();
        if (CollectionUtils.isEmpty((Collection)removeNodesRequest.getMcpTools())) {
            exception.addValidationError("tools list can not be null");
            throw exception;
        }
        return channel -> client.execute((ActionType)MLMcpToolsRemoveAction.INSTANCE, (ActionRequest)removeNodesRequest, (ActionListener)new RestToXContentListener(channel));
    }

    @VisibleForTesting
    MLMcpToolsRemoveNodesRequest getRequest(RestRequest request) throws IOException {
        return MLMcpToolsRemoveNodesRequest.parse((XContentParser)request.contentParser(), (String[])this.clusterService.state().nodes().getNodes().keySet().toArray(new String[0]));
    }
}

