/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.materialproviders.model;

import java.util.List;
import java.util.Objects;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.cryptography.materialproviders.model.KmsEcdhStaticConfigurations;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class CreateAwsKmsEcdhKeyringInput {
    private final KmsEcdhStaticConfigurations KeyAgreementScheme;
    private final ECDHCurveSpec curveSpec;
    private final KmsClient kmsClient;
    private final List<String> grantTokens;

    protected CreateAwsKmsEcdhKeyringInput(BuilderImpl builder) {
        this.KeyAgreementScheme = builder.KeyAgreementScheme();
        this.curveSpec = builder.curveSpec();
        this.kmsClient = builder.kmsClient();
        this.grantTokens = builder.grantTokens();
    }

    public KmsEcdhStaticConfigurations KeyAgreementScheme() {
        return this.KeyAgreementScheme;
    }

    public ECDHCurveSpec curveSpec() {
        return this.curveSpec;
    }

    public KmsClient kmsClient() {
        return this.kmsClient;
    }

    public List<String> grantTokens() {
        return this.grantTokens;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected KmsEcdhStaticConfigurations KeyAgreementScheme;
        protected ECDHCurveSpec curveSpec;
        protected KmsClient kmsClient;
        protected List<String> grantTokens;

        protected BuilderImpl() {
        }

        protected BuilderImpl(CreateAwsKmsEcdhKeyringInput model) {
            this.KeyAgreementScheme = model.KeyAgreementScheme();
            this.curveSpec = model.curveSpec();
            this.kmsClient = model.kmsClient();
            this.grantTokens = model.grantTokens();
        }

        @Override
        public Builder KeyAgreementScheme(KmsEcdhStaticConfigurations KeyAgreementScheme2) {
            this.KeyAgreementScheme = KeyAgreementScheme2;
            return this;
        }

        @Override
        public KmsEcdhStaticConfigurations KeyAgreementScheme() {
            return this.KeyAgreementScheme;
        }

        @Override
        public Builder curveSpec(ECDHCurveSpec curveSpec) {
            this.curveSpec = curveSpec;
            return this;
        }

        @Override
        public ECDHCurveSpec curveSpec() {
            return this.curveSpec;
        }

        @Override
        public Builder kmsClient(KmsClient kmsClient) {
            this.kmsClient = kmsClient;
            return this;
        }

        @Override
        public KmsClient kmsClient() {
            return this.kmsClient;
        }

        @Override
        public Builder grantTokens(List<String> grantTokens) {
            this.grantTokens = grantTokens;
            return this;
        }

        @Override
        public List<String> grantTokens() {
            return this.grantTokens;
        }

        @Override
        public CreateAwsKmsEcdhKeyringInput build() {
            if (Objects.isNull(this.KeyAgreementScheme())) {
                throw new IllegalArgumentException("Missing value for required field `KeyAgreementScheme`");
            }
            if (Objects.isNull((Object)this.curveSpec())) {
                throw new IllegalArgumentException("Missing value for required field `curveSpec`");
            }
            if (Objects.isNull(this.kmsClient())) {
                throw new IllegalArgumentException("Missing value for required field `kmsClient`");
            }
            return new CreateAwsKmsEcdhKeyringInput(this);
        }
    }

    public static interface Builder {
        public Builder KeyAgreementScheme(KmsEcdhStaticConfigurations var1);

        public KmsEcdhStaticConfigurations KeyAgreementScheme();

        public Builder curveSpec(ECDHCurveSpec var1);

        public ECDHCurveSpec curveSpec();

        public Builder kmsClient(KmsClient var1);

        public KmsClient kmsClient();

        public Builder grantTokens(List<String> var1);

        public List<String> grantTokens();

        public CreateAwsKmsEcdhKeyringInput build();
    }
}

