/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.restriction;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.metamodel.SingularAttribute;
import java.util.List;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.query.criteria.JpaCriteriaQuery;
import org.hibernate.query.range.Range;
import org.hibernate.query.restriction.AttributeRange;
import org.hibernate.query.restriction.Conjunction;
import org.hibernate.query.restriction.Disjunction;
import org.hibernate.query.restriction.NamedAttributeRange;
import org.hibernate.query.restriction.Unrestricted;

@Incubating
public interface Restriction<X> {
    public Restriction<X> negated();

    default public Restriction<X> or(Restriction<X> restriction) {
        return Restriction.any(this, restriction);
    }

    default public Restriction<X> and(Restriction<X> restriction) {
        return Restriction.all(this, restriction);
    }

    @Internal
    public Predicate toPredicate(Root<? extends X> var1, CriteriaBuilder var2);

    default public void apply(CriteriaQuery<?> query, Root<? extends X> root) {
        if (!(query instanceof JpaCriteriaQuery)) {
            throw new IllegalArgumentException("Not a JpaCriteriaQuery");
        }
        JpaCriteriaQuery criteriaQuery = (JpaCriteriaQuery)query;
        query.where(new Predicate[]{query.getRestriction(), this.toPredicate(root, criteriaQuery.getCriteriaBuilder())});
    }

    public static <T, U> Restriction<T> restrict(SingularAttribute<T, U> attribute, Range<U> range) {
        return new AttributeRange<T, U>(attribute, range);
    }

    public static <T> Restriction<T> restrict(Class<T> type, String attributeName, Range<?> range) {
        return new NamedAttributeRange(type, attributeName, range);
    }

    public static <T, U> Restriction<T> equal(SingularAttribute<T, U> attribute, U value) {
        return Restriction.restrict(attribute, Range.singleValue(value));
    }

    public static <T, U> Restriction<T> unequal(SingularAttribute<T, U> attribute, U value) {
        return Restriction.equal(attribute, value).negated();
    }

    public static <T> Restriction<T> equalIgnoringCase(SingularAttribute<T, String> attribute, String value) {
        return Restriction.restrict(attribute, Range.singleCaseInsensitiveValue(value));
    }

    @SafeVarargs
    public static <T, U> Restriction<T> in(SingularAttribute<T, U> attribute, U ... values) {
        return Restriction.in(attribute, List.of(values));
    }

    @SafeVarargs
    public static <T, U> Restriction<T> notIn(SingularAttribute<T, U> attribute, U ... values) {
        return Restriction.notIn(attribute, List.of(values));
    }

    public static <T, U> Restriction<T> in(SingularAttribute<T, U> attribute, List<U> values) {
        return Restriction.restrict(attribute, Range.valueList(values));
    }

    public static <T, U> Restriction<T> notIn(SingularAttribute<T, U> attribute, List<U> values) {
        return Restriction.in(attribute, values).negated();
    }

    public static <T, U extends Comparable<U>> Restriction<T> between(SingularAttribute<T, U> attribute, U lowerBound, U upperBound) {
        return Restriction.restrict(attribute, Range.closed(lowerBound, upperBound));
    }

    public static <T, U extends Comparable<U>> Restriction<T> notBetween(SingularAttribute<T, U> attribute, U lowerBound, U upperBound) {
        return Restriction.between(attribute, lowerBound, upperBound).negated();
    }

    public static <T, U extends Comparable<U>> Restriction<T> greaterThan(SingularAttribute<T, U> attribute, U lowerBound) {
        return Restriction.restrict(attribute, Range.greaterThan(lowerBound));
    }

    public static <T, U extends Comparable<U>> Restriction<T> lessThan(SingularAttribute<T, U> attribute, U upperBound) {
        return Restriction.restrict(attribute, Range.lessThan(upperBound));
    }

    public static <T, U extends Comparable<U>> Restriction<T> greaterThanOrEqual(SingularAttribute<T, U> attribute, U lowerBound) {
        return Restriction.restrict(attribute, Range.greaterThanOrEqualTo(lowerBound));
    }

    public static <T, U extends Comparable<U>> Restriction<T> lessThanOrEqual(SingularAttribute<T, U> attribute, U upperBound) {
        return Restriction.restrict(attribute, Range.lessThanOrEqualTo(upperBound));
    }

    public static <T> Restriction<T> like(SingularAttribute<T, String> attribute, String pattern, boolean caseSensitive, char charWildcard, char stringWildcard) {
        return Restriction.restrict(attribute, Range.pattern(pattern, caseSensitive, charWildcard, stringWildcard));
    }

    public static <T> Restriction<T> like(SingularAttribute<T, String> attribute, String pattern, boolean caseSensitive) {
        return Restriction.restrict(attribute, Range.pattern(pattern, caseSensitive));
    }

    public static <T> Restriction<T> like(SingularAttribute<T, String> attribute, String pattern) {
        return Restriction.like(attribute, pattern, true);
    }

    public static <T> Restriction<T> notLike(SingularAttribute<T, String> attribute, String pattern) {
        return Restriction.like(attribute, pattern, true).negated();
    }

    public static <T> Restriction<T> notLike(SingularAttribute<T, String> attribute, String pattern, boolean caseSensitive) {
        return Restriction.like(attribute, pattern, caseSensitive).negated();
    }

    public static <T> Restriction<T> startsWith(SingularAttribute<T, String> attribute, String prefix) {
        return Restriction.startsWith(attribute, prefix, true);
    }

    public static <T> Restriction<T> endsWith(SingularAttribute<T, String> attribute, String suffix) {
        return Restriction.endsWith(attribute, suffix, true);
    }

    public static <T> Restriction<T> contains(SingularAttribute<T, String> attribute, String substring) {
        return Restriction.contains(attribute, substring, true);
    }

    public static <T> Restriction<T> notContains(SingularAttribute<T, String> attribute, String substring) {
        return Restriction.notContains(attribute, substring, true);
    }

    public static <T> Restriction<T> startsWith(SingularAttribute<T, String> attribute, String prefix, boolean caseSensitive) {
        return Restriction.restrict(attribute, Range.prefix(prefix, caseSensitive));
    }

    public static <T> Restriction<T> endsWith(SingularAttribute<T, String> attribute, String suffix, boolean caseSensitive) {
        return Restriction.restrict(attribute, Range.suffix(suffix, caseSensitive));
    }

    public static <T> Restriction<T> contains(SingularAttribute<T, String> attribute, String substring, boolean caseSensitive) {
        return Restriction.restrict(attribute, Range.containing(substring, caseSensitive));
    }

    public static <T> Restriction<T> notContains(SingularAttribute<T, String> attribute, String substring, boolean caseSensitive) {
        return Restriction.contains(attribute, substring, caseSensitive).negated();
    }

    public static <T, U> Restriction<T> notNull(SingularAttribute<T, U> attribute) {
        return Restriction.restrict(attribute, Range.notNull(attribute.getJavaType()));
    }

    public static <T> Restriction<T> all(List<? extends Restriction<? super T>> restrictions) {
        return new Conjunction(restrictions);
    }

    public static <T> Restriction<T> any(List<? extends Restriction<? super T>> restrictions) {
        return new Disjunction(restrictions);
    }

    @SafeVarargs
    public static <T> Restriction<T> all(Restriction<? super T> ... restrictions) {
        return new Conjunction<T>(List.of(restrictions));
    }

    @SafeVarargs
    public static <T> Restriction<T> any(Restriction<? super T> ... restrictions) {
        return new Disjunction<T>(List.of(restrictions));
    }

    public static <T> Restriction<T> unrestricted() {
        return new Unrestricted();
    }
}

