// Boost.Geometry

// Copyright (c) 2017-2018, Oracle and/or its affiliates.
// Contributed and/or modified by Adam Wulkiewicz, on behalf of Oracle

// Use, modification and distribution is subject to the Boost Software License,
// Version 1.0. (See accompanying file LICENSE_1_0.txt or copy at
// http://www.boost.org/LICENSE_1_0.txt)

#ifndef BOOST_GEOMETRY_PROJECTIONS_IAU2000_TRAITS_HPP
#define BOOST_GEOMETRY_PROJECTIONS_IAU2000_TRAITS_HPP


#include <boost/geometry/core/tags.hpp>

#include <boost/geometry/srs/projections/factory.hpp>
#include <boost/geometry/srs/projections/impl/projects.hpp>
#include <boost/geometry/srs/projections/spar.hpp>
#include <boost/geometry/srs/projections/srid_traits.hpp>


namespace boost { namespace geometry { namespace projections
{

#ifndef DOXYGEN_NO_DETAIL
namespace detail
{

/*!
    \brief IAU2000 traits
    \details With help of the IAU2000 traits library users can statically use projections
        or coordinate systems specifying an IAU2000 code. The correct projections for transformations
        are used automically then, still keeping static polymorphism.
    \ingroup projection
    \tparam IAU2000 iau2000 code
*/
template <int IAU2000>
struct iau2000_traits
{
    // Specializations define:
    // - type to get projection type
    // - function par to get parameters
};

BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2439700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 19979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(6051800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 29979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1737400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 30179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(6378140),srs::spar::b<>(6356750)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 39979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(13400),srs::spar::b<>(9200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(7500),srs::spar::b<>(5200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 40279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(3396190),srs::spar::b<>(3376200)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 49979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1829400),srs::spar::b<>(1815700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(1564130),srs::spar::b<>(1560930)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2632400),srs::spar::b<>(2632350)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(2409400),srs::spar::b<>(2409300)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(125000),srs::spar::b<>(64000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(85000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50700) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50701) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50710)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50711)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50712)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50713)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50714) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50715) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50716) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50717) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50718) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50719) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50720) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50721) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50760) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50761) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50762) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50763) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50766) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50767) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50768)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50769)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50770)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50771)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50772) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50773) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50774)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50775)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50776)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50777)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50778)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50779)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50800) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50801) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50810)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50811)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50813)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50814) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50815) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50816) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50817) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50818) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50819) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50820) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50821) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50860) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50861) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50862) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50863) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50866) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50867) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50868)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50869)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50870)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50871)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50872) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50873) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(18000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50874)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50875)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50876)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50877)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50878)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50879)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(14000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 50979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51000) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51001) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51010)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51011)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51012)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51013)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51014) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51015) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51016) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51017) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51018) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51019) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51020) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51021) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51060) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51061) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51062) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51063) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51064) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51065) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51066) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51067) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51068)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51069)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51070)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51071)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51072) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51073) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(12000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51074)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51075)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51076)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51077)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51078)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51079)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(5000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(58000),srs::spar::b<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(10000),srs::spar::b<>(7000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 51679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(71492000),srs::spar::b<>(66854000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 59979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(209100),srs::spar::b<>(191400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(256300),srs::spar::b<>(244600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(535600),srs::spar::b<>(525800)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(560000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(764000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(2575000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60700) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60701) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60710)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60711)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60712)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60713)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60714) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60715) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60716) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60717) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60718) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60719) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60720) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60721) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60760) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60761) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60762) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60763) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60766) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60767) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60768)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60769)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60770)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60771)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60772) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60773) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(164000),srs::spar::b<>(107000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60774)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60775)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60776)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60777)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60778)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60779)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60800) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60801) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60810)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60811)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60813)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60814) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60815) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60816) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60817) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60818) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60819) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60820) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60821) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60860) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60861) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60862) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60863) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60866) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60867) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60868)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60869)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60870)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60871)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60872) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60873) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(718000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60874)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60875)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60876)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60877)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60878)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60879)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(115000),srs::spar::b<>(105000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 60979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61000) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61001) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61010)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61011)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61012)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61013)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61014) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61015) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61016) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61017) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61018) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61019) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61020) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61021) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61060) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61061) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61062) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61063) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61064) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61065) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61066) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61067) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61068)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61069)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61070)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61071)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61072) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61073) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(97000),srs::spar::b<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61074)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61075)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61076)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61077)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61078)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61079)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(69000),srs::spar::b<>(55000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(16000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(7500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(15000),srs::spar::b<>(8000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(18500),srs::spar::b<>(13500)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(74000),srs::spar::b<>(34000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61700) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61701) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61710)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61711)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61712)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61713)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61714) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61715) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61716) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61717) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61718) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61719) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61720) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61721) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61760) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61761) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61762) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61763) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61766) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61767) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61768)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61769)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61770)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61771)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61772) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61773) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(55000),srs::spar::b<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61774)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61775)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61776)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61777)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61778)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61779)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61800) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61801) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61810)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61811)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61813)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61814) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61815) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61816) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61817) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61818) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61819) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61820) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61821) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61860) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61861) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61862) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61863) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61866) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61867) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61868)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61869)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61870)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61871)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61872) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61873) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(10000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61874)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61875)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61876)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61877)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61878)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 61879)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(60268000),srs::spar::b<>(54364000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 69979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(581100),srs::spar::b<>(577700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(584700)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(788900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(761400)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(240400),srs::spar::b<>(232900)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(13000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70700) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70701) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70710)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70711)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70712)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70713)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70714) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70715) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70716) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70717) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70718) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70719) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70720) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70721) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70760) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70761) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70762) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70763) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70766) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70767) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70768)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70769)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70770)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70771)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70772) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70773) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(15000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70774)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70775)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70776)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70777)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70778)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70779)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70800) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70801) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70810)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70811)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70813)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70814) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70815) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70816) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70817) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70818) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70819) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70820) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70821) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70860) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70861) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70862) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70863) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70866) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70867) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70868)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70869)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70870)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70871)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70872) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70873) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(21000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70874)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70875)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70876)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70877)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70878)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70879)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(31000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 70979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71000) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71001) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71010)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71011)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71012)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71013)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71014) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71015) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71016) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71017) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71018) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71019) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71020) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71021) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71060) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71061) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71062) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71063) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71064) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71065) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71066) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71067) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71068)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71069)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71070)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71071)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71072) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71073) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71074)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71075)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71076)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71077)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71078)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71079)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(42000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(54000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(27000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(33000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(77000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 71579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(25559000),srs::spar::b<>(24973000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 79979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1352600)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80200) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80201) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80210)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80211)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80212)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80213)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80214) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80215) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80216) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80217) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80218) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80219) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80220) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80221) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80260) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80261) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80262) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80263) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80264) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80265) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80266) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80267) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80268)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80269)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80270)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80271)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80272) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80273) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(170000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80274)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80275)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80276)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80277)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80278)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80279)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80300) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80301) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80310)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80311)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80312)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80313)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80314) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80315) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80316) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80317) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80318) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80319) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80320) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80321) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80360) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80361) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80362) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80363) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80364) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80365) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80366) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80367) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80368)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80369)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80370)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80371)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80372) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80373) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(29000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80374)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80375)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80376)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80377)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80378)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80379)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80400) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80401) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80410)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80411)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80412)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80413)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80414) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80415) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80416) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80417) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80418) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80419) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80420) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80421) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80460) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80461) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80462) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80463) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80464) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80465) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80466) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80467) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80468)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80469)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80470)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80471)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80472) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80473) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(40000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80474)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80475)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80476)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80477)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80478)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80479)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80500) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80501) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80510)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80511)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80512)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80513)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80514) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80515) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80516) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80517) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80518) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80519) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80520) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80521) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80560) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80561) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80562) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80563) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80564) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80565) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80566) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80567) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80568)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80569)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80570)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80571)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80572) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80573) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(74000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80574)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80575)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80576)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80577)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80578)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80579)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80600) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80601) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80610)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80611)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80612)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80613)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80614) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80615) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80616) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80617) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80618) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80619) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80620) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80621) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80660) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80661) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80662) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80663) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80664) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80665) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80666) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80667) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80668)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80669)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80670)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80671)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80672) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80673) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(79000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80674)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80675)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80676)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80677)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80678)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80679)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80700) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80701) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80710)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80711)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80712)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80713)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80714) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80715) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80716) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80717) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80718) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80719) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80720) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80721) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80760) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80761) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80762) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80763) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80764) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80765) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80766) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80767) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80768)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80769)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80770)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80771)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80772) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80773) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(96000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80774)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80775)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80776)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80777)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80778)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80779)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80800) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80801) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80810)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80811)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80812)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80813)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80814) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80815) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80816) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80817) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80818) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80819) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80820) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80821) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80860) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80861) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80862) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80863) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80864) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80865) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80866) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80867) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80868)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80869)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80870)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80871)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80872) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80873) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(218000),srs::spar::b<>(201000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80874)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80875)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80876)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80877)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80878)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 80879)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::a<>,srs::spar::b<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::a<>,srs::spar::b<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::a<>(24764000),srs::spar::b<>(24341000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 89979)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90100) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90101) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90110)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90111)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90112)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90113)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90114) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90115) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90116) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90117) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90118) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90119) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90120) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90121) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90160) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90161) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90162) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90163) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90164) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90165) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90166) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90167) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90168)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90169)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90170)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90171)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90172) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90173) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(593000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90174)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90175)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90176)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90177)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90178)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 90179)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99900) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99901) srs::spar::parameters<srs::spar::proj_longlat,srs::spar::r<>,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_longlat(),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99910)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99911)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99912)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99913)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99914) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99915) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99916) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99917) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99918) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99919) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99920) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99921) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(-90),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99960) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99961) srs::spar::parameters<srs::spar::proj_sinu,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_sinu(),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99962) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99963) srs::spar::parameters<srs::spar::proj_stere,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_stere(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(1),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99964) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99965) srs::spar::parameters<srs::spar::proj_tmerc,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::k<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_tmerc(),srs::spar::lat_0<>(0),srs::spar::lon_0<>(0),srs::spar::k<>(0.9996),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99966) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99967) srs::spar::parameters<srs::spar::proj_ortho,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_ortho(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99968)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99969)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99970)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99971)
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99972) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99973) srs::spar::parameters<srs::spar::proj_laea,srs::spar::lat_0<>,srs::spar::lon_0<>,srs::spar::x_0<>,srs::spar::y_0<>,srs::spar::r<>,srs::spar::units_m,srs::spar::no_defs> BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_MID() (srs::spar::proj_laea(),srs::spar::lat_0<>(90),srs::spar::lon_0<>(0),srs::spar::x_0<>(0),srs::spar::y_0<>(0),srs::spar::r<>(1195000)) BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_END()
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99974)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99975)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99976)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99977)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99978)
//BOOST_GEOMETRY_PROJECTIONS_DETAIL_SRID_TRAITS_BEG(iau2000, 99979)

} // namespace detail
#endif // DOXYGEN_NO_DETAIL

}}} // namespace boost::geometry::projections


#endif

