/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.values;

import java.math.BigDecimal;
import org.w3c.css.css.StyleSheet;
import org.w3c.css.properties.css.CssCustomProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssAngle;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFrequency;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssHashIdent;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLength;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssPercentage;
import org.w3c.css.values.CssString;
import org.w3c.css.values.CssTime;
import org.w3c.css.values.CssValue;
import org.w3c.css.values.CssVariableDefinition;

public class CssVariable
extends CssCheckableValue {
    public static final int type = 25;
    String variable_name = null;
    ApplContext ac;
    int computed_type = -1;
    CssExpression exp = null;
    CssValue _exp_value = null;
    String _toString = null;

    @Override
    public final int getRawType() {
        return 25;
    }

    @Override
    public final int getType() {
        if (this.computed_type == -1) {
            CssVariableDefinition vd;
            CssCustomProperty cp;
            StyleSheet s;
            if (this.ac != null && (s = this.ac.getStyleSheet()) != null && (cp = s.getCustomProperty(this.variable_name)) != null && (vd = (CssVariableDefinition)cp.value) != null && vd.size() == 1) {
                this._exp_value = vd.expression.getValue();
                this.computed_type = this._exp_value.getType();
                return this.computed_type;
            }
            return 25;
        }
        return this.computed_type;
    }

    public final CssExpression getVariableExpression() {
        CssVariableDefinition vd;
        CssCustomProperty cp;
        StyleSheet s;
        if (this.ac != null && (s = this.ac.getStyleSheet()) != null && (cp = s.getCustomProperty(this.variable_name)) != null && (vd = (CssVariableDefinition)cp.value) != null && vd.size() > 0) {
            return vd.expression;
        }
        return null;
    }

    public CssVariable() {
    }

    public CssVariable(ApplContext ac, String varname) {
        this(ac, varname, null);
    }

    public CssVariable(String varname, CssExpression expression) {
        this(null, varname, expression);
    }

    public CssVariable(ApplContext ac, String varname, CssExpression expression) {
        if (ac != null) {
            this.ac = ac;
        }
        if (varname != null) {
            this.variable_name = varname;
        }
        if (expression != null && expression.getCount() == 1) {
            this._exp_value = expression.getValue();
            this.computed_type = this._exp_value.getType();
        }
        this.exp = expression;
    }

    @Override
    public void set(String s, ApplContext ac) throws InvalidParamException {
        throw new InvalidParamException("unrecognize", s, ac);
    }

    public void set(CssExpression expression) {
        if (expression != null && expression.getCount() == 1) {
            this._exp_value = expression.getValue();
            this.computed_type = this._exp_value.getType();
        }
        this.exp = expression;
    }

    @Override
    public Object get() {
        return this.toString();
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder sb = new StringBuilder();
            sb.append("var(").append(this.variable_name);
            if (this.exp != null) {
                sb.append(", ").append(this.exp.toStringFromStart());
            }
            sb.append(')');
            this._toString = sb.toString();
        }
        return this._toString;
    }

    private boolean _isCheckableType(int type) {
        switch (type) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 17: 
            case 18: 
            case 21: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    @Override
    public CssCheckableValue getCheckableValue() {
        if (this._isCheckableType(this.computed_type)) {
            return this;
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public void checkPositiveness(ApplContext ac, String callername) throws InvalidParamException {
        if (this._isCheckableType(this.computed_type)) {
            this._exp_value.getCheckableValue().checkPositiveness(ac, callername);
        }
    }

    @Override
    public void checkStrictPositiveness(ApplContext ac, String callername) throws InvalidParamException {
        if (this._isCheckableType(this.computed_type)) {
            this._exp_value.getCheckableValue().checkStrictPositiveness(ac, callername);
        }
    }

    @Override
    public void checkEqualsZero(ApplContext ac, String callername) throws InvalidParamException {
        if (this._isCheckableType(this.computed_type)) {
            this._exp_value.getCheckableValue().checkEqualsZero(ac, callername);
        }
    }

    @Override
    public boolean warnPositiveness(ApplContext ac, String callername) {
        if (this._isCheckableType(this.computed_type)) {
            try {
                return this._exp_value.getCheckableValue().warnPositiveness(ac, callername);
            }
            catch (InvalidParamException invalidParamException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean warnEqualsZero(ApplContext ac, String callername) {
        if (this._isCheckableType(this.computed_type)) {
            try {
                return this._exp_value.getCheckableValue().warnEqualsZero(ac, callername);
            }
            catch (InvalidParamException invalidParamException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isPositive() {
        if (this._isCheckableType(this.computed_type)) {
            try {
                return this._exp_value.getCheckableValue().isPositive();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isStrictlyPositive() {
        if (this._isCheckableType(this.computed_type)) {
            try {
                return this._exp_value.getCheckableValue().isStrictlyPositive();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isZero() {
        if (this._isCheckableType(this.computed_type)) {
            try {
                return this._exp_value.getCheckableValue().isZero();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void checkInteger(ApplContext ac, String callername) throws InvalidParamException {
        if (this._isCheckableType(this.computed_type)) {
            this._exp_value.getCheckableValue().checkInteger(ac, callername);
        }
    }

    @Override
    public void setValue(BigDecimal v) {
    }

    @Override
    public boolean equals(Object value) {
        return value instanceof CssVariable && this.variable_name.equals(((CssVariable)value).variable_name);
    }

    @Override
    public CssLength getLength() throws InvalidParamException {
        if (this.computed_type == 6 || this.computed_type == 5) {
            return this._exp_value.getLength();
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssPercentage getPercentage() throws InvalidParamException {
        if (this.computed_type != 4) {
            throw new ClassCastException("unknown");
        }
        return this._exp_value.getPercentage();
    }

    @Override
    public CssNumber getNumber() throws InvalidParamException {
        if (this.computed_type != 5) {
            throw new ClassCastException("unknown");
        }
        return this._exp_value.getNumber();
    }

    @Override
    public CssTime getTime() throws InvalidParamException {
        if (this.computed_type == 8 || this.computed_type == 5) {
            return this._exp_value.getTime();
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssAngle getAngle() throws InvalidParamException {
        if (this.computed_type == 7 || this.computed_type == 5) {
            return this._exp_value.getAngle();
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssFrequency getFrequency() throws InvalidParamException {
        if (this.computed_type == 9 || this.computed_type == 5) {
            return this._exp_value.getFrequency();
        }
        throw new ClassCastException("unknown");
    }

    @Override
    public CssIdent getIdent() throws InvalidParamException {
        if (this.computed_type != 0) {
            throw new ClassCastException("unknown");
        }
        return this._exp_value.getIdent();
    }

    @Override
    public CssHashIdent getHashIdent() throws InvalidParamException {
        if (this.computed_type != 15) {
            throw new ClassCastException("unknown");
        }
        return this._exp_value.getHashIdent();
    }

    @Override
    public CssString getString() throws InvalidParamException {
        if (this.computed_type != 1) {
            throw new ClassCastException("unknown");
        }
        return this._exp_value.getString();
    }

    @Override
    public CssFunction getFunction() throws InvalidParamException {
        if (this.computed_type != 11) {
            throw new ClassCastException("unknown");
        }
        CssFunction f = this._exp_value.getFunction();
        if (f.getParameters() != null) {
            f.getParameters().starts();
        }
        return this._exp_value.getFunction();
    }
}

