/*
 * Decompiled with CFR 0.152.
 */
package redis.clients.jedis.mcf;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import redis.clients.jedis.Endpoint;
import redis.clients.jedis.exceptions.JedisConnectionException;
import redis.clients.jedis.exceptions.JedisValidationException;
import redis.clients.jedis.mcf.HealthStatus;
import redis.clients.jedis.mcf.HealthStatusChangeEvent;
import redis.clients.jedis.mcf.HealthStatusListener;
import redis.clients.jedis.mcf.HealthStatusManager;

public class StatusTracker {
    private final HealthStatusManager healthStatusManager;

    public StatusTracker(HealthStatusManager healthStatusManager) {
        this.healthStatusManager = healthStatusManager;
    }

    public HealthStatus waitForHealthStatus(final Endpoint endpoint) {
        HealthStatus currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
        if (currentStatus != HealthStatus.UNKNOWN) {
            return currentStatus;
        }
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicReference resultStatus = new AtomicReference();
        HealthStatusListener tempListener = new HealthStatusListener(){

            @Override
            public void onStatusChange(HealthStatusChangeEvent event) {
                if (event.getEndpoint().equals(endpoint) && event.getNewStatus() != HealthStatus.UNKNOWN) {
                    resultStatus.set(event.getNewStatus());
                    latch.countDown();
                }
            }
        };
        this.healthStatusManager.registerListener(endpoint, tempListener);
        try {
            currentStatus = this.healthStatusManager.getHealthStatus(endpoint);
            if (currentStatus != HealthStatus.UNKNOWN) {
                HealthStatus healthStatus = currentStatus;
                return healthStatus;
            }
            boolean completed = latch.await(this.healthStatusManager.getMaxWaitFor(endpoint), TimeUnit.MILLISECONDS);
            if (!completed) {
                throw new JedisValidationException("Timeout while waiting for health check result");
            }
            HealthStatus healthStatus = (HealthStatus)((Object)resultStatus.get());
            return healthStatus;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new JedisConnectionException("Interrupted while waiting for health check result", e);
        }
        finally {
            this.healthStatusManager.unregisterListener(endpoint, tempListener);
        }
    }
}

