/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.generic;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.generic.SerializeEnd$;
import scala.collection.mutable.Builder;
import scala.runtime.IntRef;

public final class DefaultSerializationProxy<A>
implements Serializable {
    private static final long serialVersionUID = 3L;
    private final Factory<A, Object> factory;
    private final transient Iterable<A> coll;
    private transient Builder<A, Object> builder;

    public DefaultSerializationProxy(Factory<A, Object> factory, Iterable<A> coll) {
        this.factory = factory;
        this.coll = coll;
    }

    private Iterable<A> coll() {
        return this.coll;
    }

    public Builder<A, Object> builder() {
        return this.builder;
    }

    public void builder_$eq(Builder<A, Object> x$1) {
        this.builder = x$1;
    }

    private void writeObject(ObjectOutputStream out) {
        out.defaultWriteObject();
        int k = this.coll().knownSize();
        out.writeInt(k);
        IntRef count = IntRef.create(0);
        this.coll().foreach(x -> {
            out.writeObject(x);
            ++count$1.elem;
        });
        if (k >= 0) {
            if (count.elem != k) {
                throw new IllegalStateException("Illegal size " + count.elem + " of collection, expected " + k);
            }
            return;
        }
        out.writeObject(SerializeEnd$.MODULE$);
    }

    private void readObject(ObjectInputStream in) {
        in.defaultReadObject();
        this.builder_$eq(this.factory.newBuilder());
        int k = in.readInt();
        if (k >= 0) {
            this.builder().sizeHint(k);
            for (int count = 0; count < k; ++count) {
                this.builder().$plus$eq(in.readObject());
            }
            return;
        }
        while (true) {
            Object object = in.readObject();
            if (SerializeEnd$.MODULE$.equals(object)) {
                return;
            }
            Object a = object;
            this.builder().$plus$eq(a);
        }
    }

    public Object readResolve() {
        return this.builder().result();
    }
}

