/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.CommonBundle;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.history.ActivityId;
import com.intellij.ide.IdeBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThreeState;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.progress.StepsProgressIndicator;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import git4idea.DialogManager;
import git4idea.GitActionIdsHolder;
import git4idea.GitActivity;
import git4idea.GitProtectedBranchesKt;
import git4idea.GitRestoreSavedChangesNotificationAction;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitRebaseCommandResult;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.history.GitHistoryUtils;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitConflictResolver;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaseResumeMode;
import git4idea.rebase.GitRebaseSpec;
import git4idea.rebase.GitRebaseStagingAreaHelper;
import git4idea.rebase.GitRebaseStatus;
import git4idea.rebase.GitRebaseUtils;
import git4idea.rebase.GitSuccessfulRebase;
import git4idea.rebase.conflict.GitRebaseMergeDialogCustomizerKt;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.stash.GitChangesSaver;
import git4idea.util.GitFreezingProcess;
import git4idea.util.GitUntrackedFilesHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseProcess {
    private static final Logger LOG = Logger.getInstance(GitRebaseProcess.class);
    private final NotificationAction ABORT_ACTION;
    private final NotificationAction CONTINUE_ACTION;
    private final NotificationAction RETRY_ACTION;
    private final NotificationAction VIEW_STASH_ACTION;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Git myGit;
    @NotNull
    private final ChangeListManager myChangeListManager;
    @NotNull
    private final VcsNotifier myNotifier;
    @NotNull
    private final GitRepositoryManager myRepositoryManager;
    @NotNull
    private final GitRebaseSpec myRebaseSpec;
    @Nullable
    private final GitRebaseResumeMode myCustomMode;
    @NotNull
    private final GitChangesSaver mySaver;
    @NotNull
    private final ProgressManager myProgressManager;
    @NotNull
    private final VcsDirtyScopeManager myDirtyScopeManager;
    private boolean isSuccessful;

    public GitRebaseProcess(@NotNull Project project, @NotNull GitRebaseSpec rebaseSpec, @Nullable GitRebaseResumeMode customMode) {
        if (project == null) {
            GitRebaseProcess.$$$reportNull$$$0(0);
        }
        if (rebaseSpec == null) {
            GitRebaseProcess.$$$reportNull$$$0(1);
        }
        this.ABORT_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.abort.text", new Object[0]), (String)GitActionIdsHolder.Id.ABORT.id, this::abort);
        this.CONTINUE_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.continue.text", new Object[0]), (String)GitActionIdsHolder.Id.CONTINUE.id, () -> this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0])));
        this.RETRY_ACTION = NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.retry.text", new Object[0]), (String)GitActionIdsHolder.Id.RETRY.id, () -> this.retry(GitBundle.message("rebase.progress.indicator.retry.title", new Object[0])));
        this.isSuccessful = false;
        this.myProject = project;
        this.myRebaseSpec = rebaseSpec;
        this.myCustomMode = customMode;
        this.mySaver = rebaseSpec.getSaver();
        this.myGit = Git.getInstance();
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myNotifier = VcsNotifier.getInstance((Project)this.myProject);
        this.myRepositoryManager = GitUtil.getRepositoryManager(this.myProject);
        this.myProgressManager = ProgressManager.getInstance();
        this.myDirtyScopeManager = VcsDirtyScopeManager.getInstance((Project)this.myProject);
        this.VIEW_STASH_ACTION = new GitRestoreSavedChangesNotificationAction(this.mySaver);
    }

    public void rebase() {
        if (this.checkForRebasingPublishedCommits()) {
            new GitFreezingProcess(this.myProject, GitBundle.message("rebase.git.operation.name", new Object[0]), this::doRebase).execute();
        }
    }

    void doRebase() {
        LOG.info("Started rebase");
        LOG.debug("Started rebase with the following spec: " + String.valueOf(this.myRebaseSpec));
        LinkedHashMap<GitRepository, GitRebaseStatus> statuses = new LinkedHashMap<GitRepository, GitRebaseStatus>(this.myRebaseSpec.getStatuses());
        List<GitRepository> repositoriesToRebase = this.myRepositoryManager.sortByDependency(this.myRebaseSpec.getIncompleteRepositories());
        if (repositoriesToRebase.isEmpty()) {
            LOG.info("Nothing to rebase");
            return;
        }
        try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message("activity.name.rebase", new Object[0]), (ActivityId)GitActivity.Rebase);){
            GitRebaseStatus.Type latestStatus;
            if (!this.saveDirtyRootsInitially(repositoriesToRebase)) {
                return;
            }
            GitRepository latestRepository = null;
            ProgressIndicator showingIndicator = this.myProgressManager.getProgressIndicator();
            StepsProgressIndicator indicator = new StepsProgressIndicator((ProgressIndicator)(showingIndicator != null ? showingIndicator : new EmptyProgressIndicator()), repositoriesToRebase.size());
            indicator.setIndeterminate(false);
            for (GitRepository repository2 : repositoriesToRebase) {
                GitRebaseResumeMode customMode = null;
                if (repository2 == this.myRebaseSpec.getOngoingRebase()) {
                    customMode = this.myCustomMode == null ? GitRebaseResumeMode.CONTINUE : this.myCustomMode;
                }
                Hash startHash = GitUtil.getHead(repository2);
                GitRebaseStatus rebaseStatus = this.rebaseSingleRoot(repository2, customMode, GitRebaseProcess.getSuccessfulRepositories(statuses), (ProgressIndicator)indicator);
                indicator.nextStep();
                repository2.update();
                if (customMode == GitRebaseResumeMode.CONTINUE) {
                    this.myDirtyScopeManager.rootDirty(repository2.getRoot());
                }
                latestRepository = repository2;
                statuses.put(repository2, rebaseStatus);
                GitUtil.refreshChangedVfs(repository2, startHash);
                if (rebaseStatus.getType() == GitRebaseStatus.Type.SUCCESS) continue;
                break;
            }
            if ((latestStatus = ((GitRebaseStatus)statuses.get(latestRepository)).getType()) == GitRebaseStatus.Type.SUCCESS || latestStatus == GitRebaseStatus.Type.NOT_STARTED) {
                LOG.debug("Rebase completed successfully.");
                this.mySaver.load();
            }
            if (latestStatus == GitRebaseStatus.Type.SUCCESS) {
                this.isSuccessful = true;
                this.notifySuccess();
            }
            this.saveUpdatedSpec(statuses);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
            ExceptionUtil.rethrowUnchecked((Throwable)e);
        }
    }

    private void saveUpdatedSpec(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(2);
        }
        if (this.myRebaseSpec.shouldBeSaved()) {
            GitRebaseSpec newRebaseInfo = this.myRebaseSpec.cloneWithNewStatuses(statuses);
            this.myRepositoryManager.setOngoingRebaseSpec(newRebaseInfo);
        } else {
            this.myRepositoryManager.setOngoingRebaseSpec(null);
        }
    }

    @NotNull
    private GitRebaseStatus rebaseSingleRoot(@NotNull GitRepository repository2, @Nullable GitRebaseResumeMode customMode, @NotNull Map<GitRepository, GitSuccessfulRebase> alreadyRebased, @NotNull ProgressIndicator indicator) {
        boolean somethingRebased;
        GitCommandResult result2;
        GitRebaseCommandResult rebaseCommandResult;
        String repoName;
        block17: {
            block18: {
                block19: {
                    if (repository2 == null) {
                        GitRebaseProcess.$$$reportNull$$$0(3);
                    }
                    if (alreadyRebased == null) {
                        GitRebaseProcess.$$$reportNull$$$0(4);
                    }
                    if (indicator == null) {
                        GitRebaseProcess.$$$reportNull$$$0(5);
                    }
                    VirtualFile root = repository2.getRoot();
                    repoName = DvcsUtil.getShortRepositoryName((Repository)repository2);
                    LOG.info("Rebasing root " + repoName + ", mode: " + String.valueOf(ObjectUtils.notNull((Object)((Object)customMode), (Object)"standard")));
                    boolean retryWhenDirty = false;
                    int commitsToRebase = 0;
                    try {
                        GitRebaseParams params = this.myRebaseSpec.getParams();
                        if (params != null) {
                            GitRebaseParams.RebaseUpstream upstream = params.getUpstream();
                            String branch = params.getBranch();
                            commitsToRebase = GitRebaseUtils.getNumberOfCommitsToRebase(repository2, upstream, branch);
                        }
                    }
                    catch (VcsException e) {
                        LOG.warn("Couldn't get the number of commits to rebase", (Throwable)e);
                    }
                    GitRebaseProgressListener progressListener = new GitRebaseProgressListener(commitsToRebase, indicator);
                    boolean canRetryNothingToMerge = true;
                    while (true) {
                        GitRebaseProblemDetector rebaseDetector = new GitRebaseProblemDetector();
                        GitUntrackedFilesOverwrittenByOperationDetector untrackedDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
                        rebaseCommandResult = this.callRebase(repository2, customMode, rebaseDetector, untrackedDetector, progressListener);
                        result2 = rebaseCommandResult.getCommandResult();
                        boolean bl = somethingRebased = customMode != null || progressListener.currentCommit > 1;
                        if (rebaseCommandResult.wasCancelledInCommitList()) {
                            GitRebaseStatus gitRebaseStatus = GitRebaseStatus.notStarted();
                            if (gitRebaseStatus == null) {
                                GitRebaseProcess.$$$reportNull$$$0(6);
                            }
                            return gitRebaseStatus;
                        }
                        if (rebaseCommandResult.wasCancelledInCommitMessage()) {
                            this.showStoppedForEditingMessage();
                            return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                        }
                        if (result2.success()) {
                            if (rebaseDetector.hasStoppedForEditing()) {
                                this.showStoppedForEditingMessage();
                                return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                            }
                            LOG.debug("Successfully rebased " + repoName);
                            this.hideStoppedForEditingMessage();
                            return new GitSuccessfulRebase();
                        }
                        if (rebaseDetector.isDirtyTree() && customMode == null && !retryWhenDirty) {
                            LOG.debug("Dirty tree detected in " + repoName);
                            String saveError = this.mySaver.saveLocalChangesOrError(Collections.singleton(repository2.getRoot()));
                            if (saveError == null) {
                                retryWhenDirty = true;
                                continue;
                            }
                            LOG.warn(String.format("Couldn't %s root %s: %s", this.mySaver.getSaveMethod() == GitSaveChangesPolicy.SHELVE ? "shelve" : "stash", repository2.getRoot(), saveError));
                            this.showFatalError(saveError, repository2, somethingRebased, alreadyRebased.keySet());
                            GitRebaseStatus.Type type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                            return new GitRebaseStatus(type);
                        }
                        if (untrackedDetector.isDetected()) {
                            LOG.info("Untracked files detected in " + repoName);
                            this.showUntrackedFilesError(untrackedDetector.getRelativeFilePaths(), repository2, somethingRebased, alreadyRebased.keySet());
                            GitRebaseStatus.Type type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                            return new GitRebaseStatus(type);
                        }
                        if (rebaseDetector.isNoChangeError()) {
                            LOG.info("'No changes' situation detected in " + repoName);
                            customMode = GitRebaseResumeMode.SKIP;
                            continue;
                        }
                        if (!rebaseDetector.isMergeConflict()) break block17;
                        LOG.info("Merge conflict in " + repoName);
                        ResolveConflictResult resolveResult = this.showConflictResolver(repository2, false);
                        if (resolveResult == ResolveConflictResult.ALL_RESOLVED) {
                            customMode = GitRebaseResumeMode.CONTINUE;
                            continue;
                        }
                        if (resolveResult != ResolveConflictResult.NOTHING_TO_MERGE) break block18;
                        if (customMode != GitRebaseResumeMode.CONTINUE) break block19;
                        if (!canRetryNothingToMerge || !GitRebaseStagingAreaHelper.tryStagePartiallyStaged(repository2)) break;
                        LOG.info("Updated staged state of modified previously staged files");
                        canRetryNothingToMerge = false;
                    }
                    this.showRebaseContinueHasUnstagedChangesError(repository2, somethingRebased, alreadyRebased.keySet());
                    return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
                }
                LOG.info("Unmerged changes while rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
                this.showFatalError(result2.getErrorOutputAsHtmlString(), repository2, somethingRebased, alreadyRebased.keySet());
                GitRebaseStatus.Type type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
                return new GitRebaseStatus(type);
            }
            this.notifyNotAllConflictsResolved(repository2);
            return new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
        }
        String error = GitRebaseProcess.getErrorMessage(rebaseCommandResult, result2, repoName);
        this.showFatalError(error, repository2, somethingRebased, alreadyRebased.keySet());
        GitRebaseStatus.Type type = somethingRebased ? GitRebaseStatus.Type.SUSPENDED : GitRebaseStatus.Type.ERROR;
        return new GitRebaseStatus(type);
    }

    @NotNull
    @Nls
    private static String getErrorMessage(GitRebaseCommandResult rebaseCommandResult, GitCommandResult result2, String repoName) {
        String error;
        Exception exception = rebaseCommandResult.getFailureCause();
        if (exception instanceof VcsException) {
            VcsException editingFailureCause = (VcsException)((Object)exception);
            error = editingFailureCause.getMessage();
        } else {
            error = result2.getErrorOutputAsHtmlString();
            LOG.info("Error rebasing root " + repoName + ": " + result2.getErrorOutputAsJoinedString());
        }
        String string = error;
        if (string == null) {
            GitRebaseProcess.$$$reportNull$$$0(7);
        }
        return string;
    }

    @NotNull
    private GitRebaseCommandResult callRebase(@NotNull GitRepository repository2, @Nullable GitRebaseResumeMode mode, GitLineHandlerListener ... listeners) {
        if (repository2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(8);
        }
        if (listeners == null) {
            GitRebaseProcess.$$$reportNull$$$0(9);
        }
        if (mode == null) {
            GitRebaseParams params = Objects.requireNonNull(this.myRebaseSpec.getParams());
            GitRebaseCommandResult gitRebaseCommandResult = this.myGit.rebase(repository2, params, listeners);
            if (gitRebaseCommandResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(10);
            }
            return gitRebaseCommandResult;
        }
        GitRebaseCommandResult gitRebaseCommandResult = switch (mode) {
            default -> throw new MatchException(null, null);
            case GitRebaseResumeMode.SKIP -> this.myGit.rebaseSkip(repository2, listeners);
            case GitRebaseResumeMode.CONTINUE -> this.myGit.rebaseContinue(repository2, listeners);
        };
        if (gitRebaseCommandResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(11);
        }
        return gitRebaseCommandResult;
    }

    @VisibleForTesting
    @NotNull
    protected Collection<GitRepository> getDirtyRoots(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(12);
        }
        Collection<GitRepository> collection = this.findRootsWithLocalChanges(repositories);
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(13);
        }
        return collection;
    }

    private boolean saveDirtyRootsInitially(@NotNull List<? extends GitRepository> repositories) {
        List repositoriesToSave;
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(14);
        }
        if ((repositoriesToSave = ContainerUtil.filter(repositories, repository2 -> !repository2.equals(this.myRebaseSpec.getOngoingRebase()))).isEmpty()) {
            return true;
        }
        Collection<VirtualFile> rootsToSave = GitUtil.getRootsFromRepositories(this.getDirtyRoots(repositoriesToSave));
        String error = this.mySaver.saveLocalChangesOrError(rootsToSave);
        if (error != null) {
            this.myNotifier.notifyError("git.rebase.not.started", GitBundle.message("rebase.notification.not.started.title", new Object[0]), error);
            return false;
        }
        return true;
    }

    private Collection<GitRepository> findRootsWithLocalChanges(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(15);
        }
        return ContainerUtil.filter(repositories, repository2 -> this.myChangeListManager.haveChangesUnder(repository2.getRoot()) != ThreeState.NO);
    }

    @RequiresBackgroundThread
    protected void notifySuccess() {
        GitRebaseParams.RebaseUpstream upstream;
        ThreadingAssertions.assertBackgroundThread();
        String rebasedBranch = GitRebaseProcess.getCommonCurrentBranchNameIfAllTheSame(this.myRebaseSpec.getAllRepositories());
        GitRebaseParams params = this.myRebaseSpec.getParams();
        String baseBranch = null;
        if (params != null && (baseBranch = params.getNewBase()) == null && (upstream = params.getUpstream()) instanceof GitRebaseParams.RebaseUpstream.Reference) {
            GitRebaseParams.RebaseUpstream.Reference upstreamRef = (GitRebaseParams.RebaseUpstream.Reference)upstream;
            baseBranch = upstreamRef.getRef();
        }
        if ("HEAD".equals(baseBranch)) {
            baseBranch = GitRebaseProcess.getItemIfAllTheSame(this.myRebaseSpec.getInitialBranchNames().values(), baseBranch);
        }
        String message = GitSuccessfulRebase.formatMessage(rebasedBranch, baseBranch, params != null && params.getBranch() != null);
        this.myNotifier.notifyMinorInfo("git.rebase.successful", GitBundle.message("rebase.notification.successful.title", new Object[0]), message);
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }

    @Nullable
    private static String getCommonCurrentBranchNameIfAllTheSame(@NotNull Collection<? extends GitRepository> repositories) {
        if (repositories == null) {
            GitRebaseProcess.$$$reportNull$$$0(16);
        }
        return GitRebaseProcess.getItemIfAllTheSame(ContainerUtil.map(repositories, Repository::getCurrentBranchName), null);
    }

    @Contract(value="_, !null -> !null")
    private static <T> T getItemIfAllTheSame(@NotNull Collection<? extends T> collection, @Nullable T defaultItem) {
        if (collection == null) {
            GitRebaseProcess.$$$reportNull$$$0(17);
        }
        return (T)(new HashSet<T>(collection).size() == 1 ? ContainerUtil.getFirstItem(collection) : defaultItem);
    }

    private void notifyNotAllConflictsResolved(@NotNull GitRepository conflictingRepository) {
        if (conflictingRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(18);
        }
        String description = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        Notification notification = VcsNotifier.importantNotification().createNotification(GitBundle.message("rebase.notification.conflict.title", new Object[0]), description, NotificationType.WARNING).setDisplayId("git.rebase.stopped.due.to.conflicts").addAction((AnAction)this.createResolveNotificationAction(conflictingRepository)).addAction((AnAction)this.CONTINUE_ACTION).addAction((AnAction)this.ABORT_ACTION);
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    @NotNull
    private ResolveConflictResult showConflictResolver(@NotNull GitRepository conflicting, boolean calledFromNotification) {
        if (conflicting == null) {
            GitRebaseProcess.$$$reportNull$$$0(19);
        }
        GitConflictResolver.Params params = new GitConflictResolver.Params(this.myProject).setMergeDialogCustomizer(GitRebaseMergeDialogCustomizerKt.createRebaseDialogCustomizer(conflicting, this.myRebaseSpec)).setReverse(true);
        RebaseConflictResolver conflictResolver = new RebaseConflictResolver(this.myProject, conflicting, params, calledFromNotification);
        boolean allResolved = conflictResolver.merge();
        if (conflictResolver.myWasNothingToMerge) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.NOTHING_TO_MERGE;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(20);
            }
            return resolveConflictResult;
        }
        if (allResolved) {
            ResolveConflictResult resolveConflictResult = ResolveConflictResult.ALL_RESOLVED;
            if (resolveConflictResult == null) {
                GitRebaseProcess.$$$reportNull$$$0(21);
            }
            return resolveConflictResult;
        }
        ResolveConflictResult resolveConflictResult = ResolveConflictResult.UNRESOLVED_REMAIN;
        if (resolveConflictResult == null) {
            GitRebaseProcess.$$$reportNull$$$0(22);
        }
        return resolveConflictResult;
    }

    private void showStoppedForEditingMessage() {
        Notification notification = VcsNotifier.importantNotification().createNotification(GitBundle.message("rebase.notification.editing.title", new Object[0]), "", NotificationType.INFORMATION).setDisplayId("git.rebase.stopped.for.editing").addAction((AnAction)this.CONTINUE_ACTION).addAction((AnAction)this.ABORT_ACTION);
        this.myNotifier.showNotificationAndHideExisting(notification);
    }

    private void hideStoppedForEditingMessage() {
        this.myNotifier.hideAllNotificationsById("git.rebase.stopped.for.editing");
    }

    private void showRebaseContinueHasUnstagedChangesError(@NotNull GitRepository repository2, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (repository2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(23);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(24);
        }
        this.myNotifier.notify(VcsNotifier.importantNotification().createNotification(GitBundle.message("rebase.notification.failed.continue.title", new Object[0]), GitBundle.message("rebase.notification.continue.failed.unstaged.changes.text", new Object[0]), NotificationType.ERROR).setDisplayId("git.rebase.failed").addAction((AnAction)NotificationAction.createSimpleExpiring((String)GitBundle.message("rebase.notification.action.stage.and.retry.text", new Object[0]), (String)GitActionIdsHolder.Id.STAGE_AND_RETRY.id, () -> GitRebaseStagingAreaHelper.tryStageChangesInTrackedFilesAndRetryInBackground(repository2, (Function0<Unit>)((Function0)() -> {
            this.showFatalError(GitBundle.message("rebase.notification.continue.failed.stage.changes.text", new Object[0]), repository2, somethingWasRebased, successful);
            return Unit.INSTANCE;
        })))).addAction((AnAction)NotificationAction.create((String)IdeBundle.message((String)"action.show.files", (Object[])new Object[0]), (event, notification) -> GitRebaseStagingAreaHelper.showUnstagedTrackedFilesDialog(repository2))).addAction((AnAction)this.ABORT_ACTION));
    }

    private void showFatalError(@NotNull @Nls String error, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (error == null) {
            GitRebaseProcess.$$$reportNull$$$0(25);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(26);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(27);
        }
        HtmlBuilder descriptionBuilder = new HtmlBuilder();
        if (this.myRepositoryManager.moreThanOneRoot()) {
            descriptionBuilder.append(DvcsUtil.getShortRepositoryName((Repository)currentRepository) + ": ");
        }
        descriptionBuilder.appendRaw(error).br();
        descriptionBuilder.appendRaw(GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver));
        String title = this.myRebaseSpec.getOngoingRebase() == null ? GitBundle.message("rebase.notification.failed.rebase.title", new Object[0]) : GitBundle.message("rebase.notification.failed.continue.title", new Object[0]);
        Notification notification = VcsNotifier.importantNotification().createNotification(title, descriptionBuilder.toString(), NotificationType.ERROR).setDisplayId("git.rebase.failed").addAction((AnAction)this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            notification.addAction((AnAction)this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            notification.addAction((AnAction)this.VIEW_STASH_ACTION);
        }
        this.myNotifier.notify(notification);
    }

    private void showUntrackedFilesError(@NotNull Set<String> untrackedPaths, @NotNull GitRepository currentRepository, boolean somethingWasRebased, @NotNull Collection<GitRepository> successful) {
        if (untrackedPaths == null) {
            GitRebaseProcess.$$$reportNull$$$0(28);
        }
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(29);
        }
        if (successful == null) {
            GitRebaseProcess.$$$reportNull$$$0(30);
        }
        String message = GitRebaseUtils.mentionLocalChangesRemainingInStash(this.mySaver);
        ArrayList<NotificationAction> actions2 = new ArrayList<NotificationAction>();
        actions2.add(this.RETRY_ACTION);
        if (somethingWasRebased || !successful.isEmpty()) {
            actions2.add(this.ABORT_ACTION);
        }
        if (this.mySaver.wereChangesSaved()) {
            actions2.add(this.VIEW_STASH_ACTION);
        }
        GitUntrackedFilesHelper.notifyUntrackedFilesOverwrittenBy(this.myProject, currentRepository.getRoot(), untrackedPaths, GitBundle.message("rebase.git.operation.name", new Object[0]), message, actions2.toArray(new NotificationAction[0]));
    }

    @NotNull
    private static Map<GitRepository, GitSuccessfulRebase> getSuccessfulRepositories(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseProcess.$$$reportNull$$$0(31);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> map2 = new LinkedHashMap<GitRepository, GitSuccessfulRebase>();
        for (GitRepository repository2 : statuses.keySet()) {
            GitRebaseStatus status = statuses.get(repository2);
            if (!(status instanceof GitSuccessfulRebase)) continue;
            map2.put(repository2, (GitSuccessfulRebase)status);
        }
        LinkedHashMap<GitRepository, GitSuccessfulRebase> linkedHashMap = map2;
        if (linkedHashMap == null) {
            GitRebaseProcess.$$$reportNull$$$0(32);
        }
        return linkedHashMap;
    }

    private boolean checkForRebasingPublishedCommits() {
        if (this.myCustomMode != null || this.myRebaseSpec.getOngoingRebase() != null) {
            return true;
        }
        if (this.myRebaseSpec.getParams() == null) {
            LOG.error("Shouldn't happen. Spec: " + String.valueOf(this.myRebaseSpec));
            return true;
        }
        GitRebaseParams.RebaseUpstream upstream = this.myRebaseSpec.getParams().getUpstream();
        for (GitRepository repository2 : this.myRebaseSpec.getAllRepositories()) {
            String currentBranchName = (String)ObjectUtils.chooseNotNull((Object)repository2.getCurrentBranchName(), (Object)repository2.getCurrentRevision());
            if (currentBranchName == null) {
                LOG.error("No current branch or revision in " + String.valueOf(repository2));
                return true;
            }
            String rebasingBranch = (String)ObjectUtils.notNull((Object)this.myRebaseSpec.getParams().getBranch(), (Object)currentBranchName);
            if (!GitRebaseProcess.isRebasingPublishedCommit(repository2, upstream, rebasingBranch)) continue;
            return GitRebaseProcess.askIfShouldRebasePublishedCommit();
        }
        return true;
    }

    public static boolean isRebasingPublishedCommit(@NotNull GitRepository repository2, @NotNull GitRebaseParams.RebaseUpstream baseBranch, @NotNull String rebasingBranch) {
        if (repository2 == null) {
            GitRebaseProcess.$$$reportNull$$$0(33);
        }
        if (baseBranch == null) {
            GitRebaseProcess.$$$reportNull$$$0(34);
        }
        if (rebasingBranch == null) {
            GitRebaseProcess.$$$reportNull$$$0(35);
        }
        try {
            String range = GitRebaseUtils.getCommitsRangeToRebase(baseBranch, rebasingBranch);
            List<? extends TimedVcsCommit> commits = GitHistoryUtils.collectTimedCommits(repository2.getProject(), repository2.getRoot(), range);
            return ContainerUtil.exists(commits, commit -> GitProtectedBranchesKt.isCommitPublished(repository2, (Hash)commit.getId()));
        }
        catch (VcsException e) {
            LOG.error("Couldn't collect commits", (Throwable)e);
            return true;
        }
    }

    public static boolean askIfShouldRebasePublishedCommit() {
        Ref rebaseAnyway = Ref.create((Object)false);
        String message = new HtmlBuilder().append(GitBundle.message("rebase.confirmation.dialog.published.commits.message.first", new Object[0])).br().append(GitBundle.message("rebase.confirmation.dialog.published.commits.message.second", new Object[0])).wrapWith(HtmlChunk.html()).toString();
        ApplicationManager.getApplication().invokeAndWait(() -> {
            int answer = DialogManager.showMessage(message, GitBundle.message("rebase.confirmation.dialog.published.commits.title", new Object[0]), new String[]{GitBundle.message("rebase.confirmation.dialog.published.commits.button.rebase.text", new Object[0]), GitBundle.message("rebase.confirmation.dialog.published.commits.button.cancel.text", new Object[0])}, 1, 1, Messages.getWarningIcon(), null);
            rebaseAnyway.set((Object)(answer == 0 ? 1 : 0));
        });
        return (Boolean)rebaseAnyway.get();
    }

    @NotNull
    private NotificationAction createResolveNotificationAction(final @NotNull GitRepository currentRepository) {
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(36);
        }
        NotificationAction notificationAction = NotificationAction.create((String)GitBundle.message("action.NotificationAction.text.resolve", new Object[0]), (String)GitActionIdsHolder.Id.RESOLVE.id, (e, notification) -> this.myProgressManager.run((Task)new Task.Backgroundable(this.myProject, GitBundle.message("rebase.progress.indicator.conflicts.collecting.title", new Object[0]), (Notification)notification){
            final /* synthetic */ Notification val$notification;
            {
                this.val$notification = notification;
                super(arg0, arg1);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                GitRebaseProcess.this.resolveConflicts(currentRepository, this.val$notification);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$1", "run"));
            }
        }));
        if (notificationAction == null) {
            GitRebaseProcess.$$$reportNull$$$0(37);
        }
        return notificationAction;
    }

    private void resolveConflicts(@NotNull GitRepository currentRepository, @NotNull Notification notification) {
        ResolveConflictResult result2;
        if (currentRepository == null) {
            GitRebaseProcess.$$$reportNull$$$0(38);
        }
        if (notification == null) {
            GitRebaseProcess.$$$reportNull$$$0(39);
        }
        if ((result2 = this.showConflictResolver(currentRepository, true)) == ResolveConflictResult.NOTHING_TO_MERGE) {
            ApplicationManager.getApplication().invokeLater(() -> {
                boolean continueRebase = ((MessageDialogBuilder.YesNo)((MessageDialogBuilder.YesNo)MessageDialogBuilder.yesNo((String)GitBundle.message("rebase.notification.all.conflicts.resolved.title", new Object[0]), (String)GitBundle.message("rebase.notification.all.conflicts.resolved.text", new Object[0])).yesText(GitBundle.message("rebase.notification.all.conflicts.resolved.continue.rebase.action.text", new Object[0]))).noText(CommonBundle.getCancelButtonText())).ask(this.myProject);
                if (continueRebase) {
                    this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0]));
                    notification.expire();
                }
            });
        }
    }

    private void abort() {
        this.myProgressManager.run((Task)new Task.Backgroundable(this, this.myProject, GitBundle.message("rebase.progress.indicator.aborting.title", new Object[0])){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.abort(this.myProject, indicator);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$2", "run"));
            }
        });
    }

    private void retry(@NotNull @Nls String processTitle) {
        if (processTitle == null) {
            GitRebaseProcess.$$$reportNull$$$0(40);
        }
        this.myProgressManager.run((Task)new Task.Backgroundable(this, this.myProject, processTitle, true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    3.$$$reportNull$$$0(0);
                }
                GitRebaseUtils.continueRebase(this.myProject);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/rebase/GitRebaseProcess$3", "run"));
            }
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 10, 11, 13, 20, 21, 22, 32, 37 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebaseSpec";
                break;
            }
            case 2: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 3: 
            case 8: 
            case 23: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyRebased";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 32: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 12: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflictingRepository";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conflicting";
                break;
            }
            case 24: 
            case 27: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "successful";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 26: 
            case 29: 
            case 36: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentRepository";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untrackedPaths";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseBranch";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rebasingBranch";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseProcess";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "rebaseSingleRoot";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "callRebase";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDirtyRoots";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "showConflictResolver";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuccessfulRepositories";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "createResolveNotificationAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "saveUpdatedSpec";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "rebaseSingleRoot";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 22: 
            case 32: 
            case 37: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "callRebase";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getDirtyRoots";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDirtyRootsInitially";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findRootsWithLocalChanges";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommonCurrentBranchNameIfAllTheSame";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getItemIfAllTheSame";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "notifyNotAllConflictsResolved";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "showConflictResolver";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "showRebaseContinueHasUnstagedChangesError";
                break;
            }
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "showFatalError";
                break;
            }
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "showUntrackedFilesError";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getSuccessfulRepositories";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "isRebasingPublishedCommit";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "createResolveNotificationAction";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "resolveConflicts";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "retry";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 10, 11, 13, 20, 21, 22, 32, 37 -> new IllegalStateException(string);
        };
    }

    private static class GitRebaseProgressListener
    implements GitLineHandlerListener {
        @NonNls
        private static final Pattern REBASING_PATTERN = Pattern.compile("^Rebasing \\((\\d+)/(\\d+)\\)$");
        @NonNls
        private static final String APPLYING_PREFIX = "Applying: ";
        private int currentCommit;
        private final int myCommitsToRebase;
        @NotNull
        private final ProgressIndicator myIndicator;

        GitRebaseProgressListener(int commitsToRebase, @NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(0);
            }
            this.currentCommit = 0;
            this.myCommitsToRebase = commitsToRebase;
            this.myIndicator = indicator;
        }

        @Override
        public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
            Matcher matcher;
            if (line == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                GitRebaseProgressListener.$$$reportNull$$$0(2);
            }
            if ((matcher = REBASING_PATTERN.matcher(line)).matches()) {
                this.currentCommit = Integer.parseInt(matcher.group(1));
            } else if (StringUtil.startsWith((CharSequence)line, (CharSequence)APPLYING_PREFIX)) {
                ++this.currentCommit;
            }
            if (this.myCommitsToRebase != 0) {
                this.myIndicator.setFraction((double)this.currentCommit / (double)this.myCommitsToRebase);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "git4idea/rebase/GitRebaseProcess$GitRebaseProgressListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLineAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static enum ResolveConflictResult {
        ALL_RESOLVED,
        NOTHING_TO_MERGE,
        UNRESOLVED_REMAIN;

    }

    private class RebaseConflictResolver
    extends GitConflictResolver {
        private final boolean myCalledFromNotification;
        private boolean myWasNothingToMerge;

        RebaseConflictResolver(@NotNull Project project, @NotNull GitRepository repository2, GitConflictResolver.Params params, boolean calledFromNotification) {
            if (project == null) {
                RebaseConflictResolver.$$$reportNull$$$0(0);
            }
            if (repository2 == null) {
                RebaseConflictResolver.$$$reportNull$$$0(1);
            }
            if (params == null) {
                RebaseConflictResolver.$$$reportNull$$$0(2);
            }
            super(project, Collections.singleton(repository2.getRoot()), params);
            this.myCalledFromNotification = calledFromNotification;
        }

        @Override
        protected void notifyUnresolvedRemain() {
        }

        @Override
        @RequiresBackgroundThread
        protected boolean proceedAfterAllMerged() {
            ThreadingAssertions.assertBackgroundThread();
            if (this.myCalledFromNotification) {
                GitRebaseProcess.this.retry(GitBundle.message("rebase.progress.indicator.continue.title", new Object[0]));
            }
            return true;
        }

        @Override
        protected boolean proceedIfNothingToMerge() {
            this.myWasNothingToMerge = true;
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "repository";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "params";
                    break;
                }
            }
            objectArray[1] = "git4idea/rebase/GitRebaseProcess$RebaseConflictResolver";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

