/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.labels;

import com.intellij.find.usages.api.SearchTarget;
import com.intellij.find.usages.api.UsageHandler;
import com.intellij.model.Pointer;
import com.intellij.openapi.util.TextRange;
import com.intellij.platform.backend.navigation.NavigationRequest;
import com.intellij.platform.backend.navigation.NavigationTarget;
import com.intellij.platform.backend.presentation.TargetPresentation;
import com.intellij.platform.backend.presentation.TargetPresentationBuilder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.rename.api.RenameTarget;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.intellij.plugins.markdown.MarkdownIcons;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkDefinition;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkLabel;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownShortReferenceLink;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolPresentationUtilsKt;
import org.intellij.plugins.markdown.model.psi.MarkdownSymbolWithUsages;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 22\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u00012B$\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0014\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\b\u0010&\u001a\u00020\u0017H\u0016J\t\u0010'\u001a\u00020\u0006H\u00c6\u0003J\t\u0010(\u001a\u00020\bH\u00c6\u0003J\u000e\u0010)\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0003J,\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b2\r\b\u0002\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bH\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010.H\u00d6\u0003J\t\u0010/\u001a\u000200H\u00d6\u0001J\t\u00101\u001a\u00020\nH\u00d6\u0001R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0007\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u001a\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0013R\u0014\u0010\u001c\u001a\u00020\u001d8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u0013\u00a8\u00063"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol;", "Lorg/intellij/plugins/markdown/model/psi/MarkdownSymbolWithUsages;", "Lcom/intellij/platform/backend/navigation/NavigationTarget;", "Lcom/intellij/find/usages/api/SearchTarget;", "Lcom/intellij/refactoring/rename/api/RenameTarget;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "", "Lcom/intellij/openapi/util/NlsSafe;", "<init>", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/util/TextRange;Ljava/lang/String;)V", "getFile", "()Lcom/intellij/psi/PsiFile;", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "getText", "()Ljava/lang/String;", "createPointer", "Lcom/intellij/model/Pointer;", "computePresentation", "Lcom/intellij/platform/backend/presentation/TargetPresentation;", "navigationRequest", "Lcom/intellij/platform/backend/navigation/NavigationRequest;", "targetName", "getTargetName", "maximalSearchScope", "Lcom/intellij/psi/search/SearchScope;", "getMaximalSearchScope", "()Lcom/intellij/psi/search/SearchScope;", "usageHandler", "Lcom/intellij/find/usages/api/UsageHandler;", "getUsageHandler", "()Lcom/intellij/find/usages/api/UsageHandler;", "searchText", "getSearchText", "presentation", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "intellij.markdown.model"})
@ApiStatus.Internal
public final class LinkLabelSymbol
implements MarkdownSymbolWithUsages,
NavigationTarget,
SearchTarget,
RenameTarget {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PsiFile file;
    @NotNull
    private final TextRange range;
    @NotNull
    private final String text;

    public LinkLabelSymbol(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        this.file = file;
        this.range = range;
        this.text = text2;
    }

    @Override
    @NotNull
    public PsiFile getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public TextRange getRange() {
        return this.range;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public Pointer<? extends LinkLabelSymbol> createPointer() {
        return Companion.createPointer(this.getFile(), this.getRange(), this.text);
    }

    @NotNull
    public TargetPresentation computePresentation() {
        return this.presentation();
    }

    @Nullable
    public NavigationRequest navigationRequest() {
        return NavigationRequest.Companion.sourceNavigationRequest(this.getFile(), this.getRange());
    }

    @NotNull
    public String getTargetName() {
        return this.text;
    }

    @NotNull
    public SearchScope getMaximalSearchScope() {
        GlobalSearchScope globalSearchScope = GlobalSearchScope.fileScope((PsiFile)this.getFile());
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"fileScope(...)");
        return (SearchScope)globalSearchScope;
    }

    @NotNull
    public UsageHandler getUsageHandler() {
        UsageHandler usageHandler = UsageHandler.createEmptyUsageHandler((String)this.text);
        Intrinsics.checkNotNullExpressionValue((Object)usageHandler, (String)"createEmptyUsageHandler(...)");
        return usageHandler;
    }

    @Override
    @NotNull
    public String getSearchText() {
        return this.text;
    }

    @NotNull
    public TargetPresentation presentation() {
        TargetPresentationBuilder targetPresentationBuilder = TargetPresentation.Companion.builder(this.text).icon(MarkdownIcons.EditorActions.Link);
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentationBuilder, (String)"icon(...)");
        TargetPresentationBuilder builder = targetPresentationBuilder;
        TargetPresentation targetPresentation = MarkdownSymbolPresentationUtilsKt.withLocationIn(builder, this.getFile()).presentation();
        Intrinsics.checkNotNullExpressionValue((Object)targetPresentation, (String)"presentation(...)");
        return targetPresentation;
    }

    @NotNull
    public final PsiFile component1() {
        return this.file;
    }

    @NotNull
    public final TextRange component2() {
        return this.range;
    }

    @NotNull
    public final String component3() {
        return this.text;
    }

    @NotNull
    public final LinkLabelSymbol copy(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        return new LinkLabelSymbol(file, range, text2);
    }

    public static /* synthetic */ LinkLabelSymbol copy$default(LinkLabelSymbol linkLabelSymbol, PsiFile psiFile, TextRange textRange, String string, int n, Object object) {
        if ((n & 1) != 0) {
            psiFile = linkLabelSymbol.file;
        }
        if ((n & 2) != 0) {
            textRange = linkLabelSymbol.range;
        }
        if ((n & 4) != 0) {
            string = linkLabelSymbol.text;
        }
        return linkLabelSymbol.copy(psiFile, textRange, string);
    }

    @NotNull
    public String toString() {
        return "LinkLabelSymbol(file=" + this.file + ", range=" + this.range + ", text=" + this.text + ")";
    }

    public int hashCode() {
        int result = this.file.hashCode();
        result = result * 31 + this.range.hashCode();
        result = result * 31 + this.text.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LinkLabelSymbol)) {
            return false;
        }
        LinkLabelSymbol linkLabelSymbol = (LinkLabelSymbol)other;
        if (!Intrinsics.areEqual((Object)this.file, (Object)linkLabelSymbol.file)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.range, (Object)linkLabelSymbol.range)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.text, (Object)linkLabelSymbol.text);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bJ$\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eR\u0015\u0010\u000f\u001a\u00020\u0010*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u0015\u0010\u0012\u001a\u00020\u0010*\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011\u00a8\u0006\u0013"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol$Companion;", "", "<init>", "()V", "createPointer", "Lcom/intellij/model/Pointer;", "Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol;", "label", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkLabel;", "file", "Lcom/intellij/psi/PsiFile;", "range", "Lcom/intellij/openapi/util/TextRange;", "text", "", "isDeclaration", "", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownLinkLabel;)Z", "isShortLink", "intellij.markdown.model"})
    @SourceDebugExtension(value={"SMAP\nLinkLabelSymbol.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LinkLabelSymbol.kt\norg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol$Companion\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,83:1\n66#2,2:84\n66#2,2:86\n*S KotlinDebug\n*F\n+ 1 LinkLabelSymbol.kt\norg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbol$Companion\n*L\n77#1:84,2\n80#1:86,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pointer<LinkLabelSymbol> createPointer(@NotNull MarkdownLinkLabel label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            String text2 = label.getText();
            TextRange rangeInElement = new TextRange(0, text2.length());
            TextRange textRange = rangeInElement.shiftRight(PsiTreeUtilKt.getStartOffset((PsiElement)((PsiElement)label)));
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"shiftRight(...)");
            TextRange absoluteRange = textRange;
            String string = rangeInElement.substring(text2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String textInElement = string;
            PsiFile file = label.getContainingFile();
            Intrinsics.checkNotNull((Object)file);
            return this.createPointer(file, absoluteRange, textInElement);
        }

        @NotNull
        public final Pointer<LinkLabelSymbol> createPointer(@NotNull PsiFile file, @NotNull TextRange range, @NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            Intrinsics.checkNotNullParameter((Object)range, (String)"range");
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Pointer pointer = Pointer.fileRangePointer((PsiFile)file, (TextRange)range, (arg_0, arg_1) -> Companion.createPointer$lambda$1((arg_0, arg_1) -> Companion.createPointer$lambda$0(text2, arg_0, arg_1), arg_0, arg_1));
            Intrinsics.checkNotNullExpressionValue((Object)pointer, (String)"fileRangePointer(...)");
            return pointer;
        }

        public final boolean isDeclaration(@NotNull MarkdownLinkLabel $this$isDeclaration) {
            Intrinsics.checkNotNullParameter((Object)$this$isDeclaration, (String)"<this>");
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$isDeclaration;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownLinkDefinition.class, (boolean)true) != null;
        }

        public final boolean isShortLink(@NotNull MarkdownLinkLabel $this$isShortLink) {
            Intrinsics.checkNotNullParameter((Object)$this$isShortLink, (String)"<this>");
            PsiElement $this$parentOfType_u24default$iv = (PsiElement)$this$isShortLink;
            boolean withSelf$iv = false;
            boolean $i$f$parentOfType = false;
            return PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, MarkdownShortReferenceLink.class, (boolean)true) != null;
        }

        private static final LinkLabelSymbol createPointer$lambda$0(String $text, PsiFile restoredFile, TextRange restoredRange) {
            Intrinsics.checkNotNullParameter((Object)restoredFile, (String)"restoredFile");
            Intrinsics.checkNotNullParameter((Object)restoredRange, (String)"restoredRange");
            return new LinkLabelSymbol(restoredFile, restoredRange, $text);
        }

        private static final LinkLabelSymbol createPointer$lambda$1(Function2 $tmp0, Object p0, Object p1) {
            return (LinkLabelSymbol)$tmp0.invoke(p0, p1);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

