/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.vulkan;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Pointer;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.vulkan.VkRectLayerKHR;

public class VkPresentRegionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int RECTANGLECOUNT;
    public static final int PRECTANGLES;

    public VkPresentRegionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), VkPresentRegionKHR.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="uint32_t")
    public int rectangleCount() {
        return VkPresentRegionKHR.nrectangleCount(this.address());
    }

    @Nullable
    @NativeType(value="VkRectLayerKHR const *")
    public VkRectLayerKHR.Buffer pRectangles() {
        return VkPresentRegionKHR.npRectangles(this.address());
    }

    public VkPresentRegionKHR rectangleCount(@NativeType(value="uint32_t") int value) {
        VkPresentRegionKHR.nrectangleCount(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
        VkPresentRegionKHR.npRectangles(this.address(), value);
        return this;
    }

    public VkPresentRegionKHR set(int rectangleCount, @Nullable VkRectLayerKHR.Buffer pRectangles) {
        this.rectangleCount(rectangleCount);
        this.pRectangles(pRectangles);
        return this;
    }

    public VkPresentRegionKHR set(VkPresentRegionKHR src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static VkPresentRegionKHR malloc() {
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static VkPresentRegionKHR calloc() {
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static VkPresentRegionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static VkPresentRegionKHR create(long address) {
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)address);
    }

    @Nullable
    public static VkPresentRegionKHR createSafe(long address) {
        return address == 0L ? null : (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)VkPresentRegionKHR.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = VkPresentRegionKHR.__create((int)capacity, (int)SIZEOF);
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Deprecated
    public static VkPresentRegionKHR mallocStack() {
        return VkPresentRegionKHR.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentRegionKHR callocStack() {
        return VkPresentRegionKHR.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static VkPresentRegionKHR mallocStack(MemoryStack stack) {
        return VkPresentRegionKHR.malloc(stack);
    }

    @Deprecated
    public static VkPresentRegionKHR callocStack(MemoryStack stack) {
        return VkPresentRegionKHR.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return VkPresentRegionKHR.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return VkPresentRegionKHR.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return VkPresentRegionKHR.calloc(capacity, stack);
    }

    public static VkPresentRegionKHR malloc(MemoryStack stack) {
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static VkPresentRegionKHR calloc(MemoryStack stack) {
        return (VkPresentRegionKHR)VkPresentRegionKHR.wrap(VkPresentRegionKHR.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)VkPresentRegionKHR.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nrectangleCount(long struct) {
        return UNSAFE.getInt(null, struct + (long)RECTANGLECOUNT);
    }

    @Nullable
    public static VkRectLayerKHR.Buffer npRectangles(long struct) {
        return VkRectLayerKHR.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)PRECTANGLES)), VkPresentRegionKHR.nrectangleCount(struct));
    }

    public static void nrectangleCount(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)RECTANGLECOUNT, value);
    }

    public static void npRectangles(long struct, @Nullable VkRectLayerKHR.Buffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)PRECTANGLES), (long)MemoryUtil.memAddressSafe((Pointer)value));
        if (value != null) {
            VkPresentRegionKHR.nrectangleCount(struct, value.remaining());
        }
    }

    static {
        Struct.Layout layout = VkPresentRegionKHR.__struct((Struct.Member[])new Struct.Member[]{VkPresentRegionKHR.__member((int)4), VkPresentRegionKHR.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        RECTANGLECOUNT = layout.offsetof(0);
        PRECTANGLES = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<VkPresentRegionKHR, Buffer>
    implements NativeResource {
        private static final VkPresentRegionKHR ELEMENT_FACTORY = VkPresentRegionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected VkPresentRegionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="uint32_t")
        public int rectangleCount() {
            return VkPresentRegionKHR.nrectangleCount(this.address());
        }

        @Nullable
        @NativeType(value="VkRectLayerKHR const *")
        public VkRectLayerKHR.Buffer pRectangles() {
            return VkPresentRegionKHR.npRectangles(this.address());
        }

        public Buffer rectangleCount(@NativeType(value="uint32_t") int value) {
            VkPresentRegionKHR.nrectangleCount(this.address(), value);
            return this;
        }

        public Buffer pRectangles(@Nullable @NativeType(value="VkRectLayerKHR const *") VkRectLayerKHR.Buffer value) {
            VkPresentRegionKHR.npRectangles(this.address(), value);
            return this;
        }
    }
}

