/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.cuda;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

public class CUmemLocation
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int TYPE;
    public static final int ID;

    public CUmemLocation(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), CUmemLocation.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="CUmemLocationType")
    public int type() {
        return CUmemLocation.ntype(this.address());
    }

    public int id() {
        return CUmemLocation.nid(this.address());
    }

    public CUmemLocation type(@NativeType(value="CUmemLocationType") int value) {
        CUmemLocation.ntype(this.address(), value);
        return this;
    }

    public CUmemLocation id(int value) {
        CUmemLocation.nid(this.address(), value);
        return this;
    }

    public CUmemLocation set(int type, int id) {
        this.type(type);
        this.id(id);
        return this;
    }

    public CUmemLocation set(CUmemLocation src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static CUmemLocation malloc() {
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static CUmemLocation calloc() {
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static CUmemLocation create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static CUmemLocation create(long address) {
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)address);
    }

    @Nullable
    public static CUmemLocation createSafe(long address) {
        return address == 0L ? null : (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)CUmemLocation.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CUmemLocation.__create((int)capacity, (int)SIZEOF);
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)CUmemLocation.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static CUmemLocation malloc(MemoryStack stack) {
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CUmemLocation calloc(MemoryStack stack) {
        return (CUmemLocation)CUmemLocation.wrap(CUmemLocation.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return (Buffer)CUmemLocation.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ntype(long struct) {
        return UNSAFE.getInt(null, struct + (long)TYPE);
    }

    public static int nid(long struct) {
        return UNSAFE.getInt(null, struct + (long)ID);
    }

    public static void ntype(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)TYPE, value);
    }

    public static void nid(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)ID, value);
    }

    static {
        Struct.Layout layout = CUmemLocation.__struct((Struct.Member[])new Struct.Member[]{CUmemLocation.__member((int)4), CUmemLocation.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        TYPE = layout.offsetof(0);
        ID = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CUmemLocation, Buffer>
    implements NativeResource {
        private static final CUmemLocation ELEMENT_FACTORY = CUmemLocation.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected CUmemLocation getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="CUmemLocationType")
        public int type() {
            return CUmemLocation.ntype(this.address());
        }

        public int id() {
            return CUmemLocation.nid(this.address());
        }

        public Buffer type(@NativeType(value="CUmemLocationType") int value) {
            CUmemLocation.ntype(this.address(), value);
            return this;
        }

        public Buffer id(int value) {
            CUmemLocation.nid(this.address(), value);
            return this;
        }
    }
}

