/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute.rts;

import java.util.Enumeration;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.services.io.FormatableProperties;
import org.apache.derby.iapi.sql.execute.xplain.XPLAINVisitor;
import org.apache.derby.iapi.util.PropertyUtil;
import org.apache.derby.iapi.util.StringUtil;
import org.apache.derby.impl.sql.catalog.XPLAINResultSetDescriptor;
import org.apache.derby.impl.sql.catalog.XPLAINScanPropsDescriptor;
import org.apache.derby.impl.sql.execute.rts.RealNoPutResultSetStatistics;
import org.apache.derby.impl.sql.execute.xplain.XPLAINUtil;
import org.apache.derby.shared.common.i18n.MessageService;

public class RealTableScanStatistics
extends RealNoPutResultSetStatistics {
    public boolean isConstraint;
    public boolean coarserLock;
    public int fetchSize;
    public String isolationLevel;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    public String lockString;
    public String qualifiers;
    public String startPosition;
    public String stopPosition;
    public FormatableProperties scanProperties;

    public RealTableScanStatistics(int numOpens, int rowsSeen, int rowsFiltered, long constructorTime, long openTime, long nextTime, long closeTime, int resultSetNumber, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, String qualifiers, Properties scanProperties, String startPosition, String stopPosition, String isolationLevel, String lockString, int fetchSize, boolean coarserLock, double optimizerEstimatedRowCount, double optimizerEstimatedCost) {
        super(numOpens, rowsSeen, rowsFiltered, constructorTime, openTime, nextTime, closeTime, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = indexName;
        this.isConstraint = isConstraint;
        this.qualifiers = qualifiers;
        this.scanProperties = new FormatableProperties();
        Enumeration<Object> e = scanProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            this.scanProperties.put(key, scanProperties.get(key));
        }
        this.startPosition = startPosition;
        this.stopPosition = stopPosition;
        this.isolationLevel = isolationLevel;
        this.lockString = lockString;
        this.fetchSize = fetchSize;
        this.coarserLock = coarserLock;
    }

    @Override
    public String getStatementExecutionPlanText(int depth) {
        Object header = "";
        Object isolationString = null;
        this.initFormatInfo(depth);
        if (this.userSuppliedOptimizerOverrides != null) {
            header = this.indent + MessageService.getTextMessage((String)"43Y56.U", (Object[])new Object[]{this.tableName, this.userSuppliedOptimizerOverrides});
            header = (String)header + "\n";
        }
        header = this.indexName != null ? (String)header + this.indent + MessageService.getTextMessage((String)"43Y09.U", (Object[])new Object[]{this.tableName, this.isConstraint ? "constraint" : "index", this.indexName}) : (String)header + this.indent + MessageService.getTextMessage((String)"43Y10.U", (Object[])new Object[]{this.tableName});
        header = (String)header + " " + MessageService.getTextMessage((String)"43X72.U", (Object[])new Object[]{this.isolationLevel, this.lockString});
        if (this.coarserLock) {
            header = (String)header + " (" + MessageService.getTextMessage((String)"43Y11.U", (Object[])new Object[0]) + ")";
        }
        header = (String)header + "\n";
        String scanInfo = this.indent + MessageService.getTextMessage((String)"43X28.U", (Object[])new Object[0]) + ":\n" + PropertyUtil.sortProperties(this.scanProperties, this.subIndent);
        return (String)header + this.indent + MessageService.getTextMessage((String)"43X03.U", (Object[])new Object[0]) + " = " + this.numOpens + "\n" + this.indent + MessageService.getTextMessage((String)"43X04.U", (Object[])new Object[0]) + " = " + this.rowsSeen + "\n" + this.indent + MessageService.getTextMessage((String)"43X32.U", (Object[])new Object[0]) + " = " + this.rowsFiltered + "\n" + this.indent + MessageService.getTextMessage((String)"43Y12.U", (Object[])new Object[0]) + " = " + this.fetchSize + "\n" + this.dumpTimeStats(this.indent, this.subIndent) + "\n" + (String)(this.rowsSeen > 0 ? this.subIndent + MessageService.getTextMessage((String)"43X33.U", (Object[])new Object[0]) + " = " + this.nextTime / (long)this.rowsSeen + "\n" : "") + "\n" + scanInfo + this.subIndent + MessageService.getTextMessage((String)"43X34.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.startPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43X35.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.stopPosition, depth + 2) + "\n" + this.subIndent + MessageService.getTextMessage((String)"43Y13.U", (Object[])new Object[0]) + ":\n" + StringUtil.ensureIndent(this.qualifiers, depth + 2) + "\n" + this.dumpEstimatedCosts(this.subIndent);
    }

    @Override
    public String getScanStatisticsText(String tableName, int depth) {
        if (tableName == null || tableName.equals(this.tableName)) {
            return this.getStatementExecutionPlanText(depth);
        }
        return "";
    }

    public String toString() {
        return this.getStatementExecutionPlanText(0);
    }

    @Override
    public String getNodeName() {
        return MessageService.getTextMessage((String)(this.indexName == null ? "43X73.U" : "43X74.U"), (Object[])new Object[0]);
    }

    @Override
    public String getNodeOn() {
        if (this.indexName == null) {
            return MessageService.getTextMessage((String)"43X75.U", (Object[])new Object[]{this.tableName});
        }
        return MessageService.getTextMessage((String)"43X38.U", (Object[])new Object[]{this.tableName, this.indexName});
    }

    @Override
    public void accept(XPLAINVisitor visitor) {
        visitor.setNumberOfChildren(0);
        visitor.visit(this);
    }

    @Override
    public String getRSXplainType() {
        if (this.indexName != null) {
            return this.isConstraint ? "CONSTRAINTSCAN" : "INDEXSCAN";
        }
        return "TABLESCAN";
    }

    @Override
    public String getRSXplainDetails() {
        if (this.indexName != null) {
            return (this.isConstraint ? "C: " : "I: ") + this.indexName;
        }
        return "T: " + this.tableName;
    }

    @Override
    public Object getScanPropsDescriptor(Object scanPropsID) {
        String scanObjectName;
        String scanObjectType;
        if (this.indexName != null) {
            if (this.isConstraint) {
                scanObjectType = "C";
                scanObjectName = this.indexName;
            } else {
                scanObjectType = "I";
                scanObjectName = this.indexName;
            }
        } else {
            scanObjectType = "T";
            scanObjectName = this.tableName;
        }
        String isoLevel = XPLAINUtil.getIsolationLevelCode(this.isolationLevel);
        XPLAINScanPropsDescriptor scanRSDescriptor = new XPLAINScanPropsDescriptor((UUID)scanPropsID, scanObjectName, scanObjectType, null, isoLevel, null, null, null, null, null, null, null, this.fetchSize, this.startPosition, this.stopPosition, this.qualifiers, null, null, null);
        FormatableProperties props = this.scanProperties;
        return XPLAINUtil.extractScanProps(scanRSDescriptor, props);
    }

    @Override
    public Object getResultSetDescriptor(Object rsID, Object parentID, Object scanID, Object sortID, Object stmtID, Object timingID) {
        String lockMode = XPLAINUtil.getLockModeCode(this.lockString);
        String lockGran = XPLAINUtil.getLockGranularityCode(this.lockString);
        return new XPLAINResultSetDescriptor((UUID)rsID, this.getRSXplainType(), this.getRSXplainDetails(), this.numOpens, null, lockMode, lockGran, (UUID)parentID, this.optimizerEstimatedRowCount, this.optimizerEstimatedCost, null, null, null, this.rowsSeen, null, this.rowsFiltered, this.rowsSeen - this.rowsFiltered, null, null, (UUID)scanID, (UUID)sortID, (UUID)stmtID, (UUID)timingID);
    }
}

