/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.store.raw;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.CompressedNumber;
import org.apache.derby.iapi.store.raw.ContainerKey;

public final class PageKey {
    private final ContainerKey container;
    private final long pageNumber;

    public PageKey(ContainerKey key, long pageNumber) {
        this.container = key;
        this.pageNumber = pageNumber;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public ContainerKey getContainerId() {
        return this.container;
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        this.container.writeExternal(out);
        CompressedNumber.writeLong(out, this.pageNumber);
    }

    public static PageKey read(ObjectInput in) throws IOException {
        ContainerKey c = ContainerKey.read(in);
        long pn = CompressedNumber.readLong(in);
        return new PageKey(c, pn);
    }

    public boolean equals(Object other) {
        if (other instanceof PageKey) {
            PageKey otherKey = (PageKey)other;
            return this.pageNumber == otherKey.pageNumber && this.container.equals(otherKey.container);
        }
        return false;
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + this.container.hashCode();
        hash = 79 * hash + (int)(this.pageNumber ^ this.pageNumber >>> 32);
        return hash;
    }

    public String toString() {
        return "Page(" + this.pageNumber + "," + this.container.toString() + ")";
    }
}

