/*
 * Decompiled with CFR 0.152.
 */
package org.logstash.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;

public class SetOnceReference<T> {
    private static final VarHandle VALUE;
    private volatile T value;

    private SetOnceReference() {
    }

    public static <V> SetOnceReference<V> unset() {
        return new SetOnceReference();
    }

    private SetOnceReference(T value) {
        if (Objects.nonNull(value)) {
            VALUE.setRelease(this, value);
        }
    }

    public static <V> SetOnceReference<V> of(V value) {
        return new SetOnceReference<V>(Objects.requireNonNull(value));
    }

    public static <V> SetOnceReference<V> ofNullable(V value) {
        return new SetOnceReference<V>(value);
    }

    public boolean isSet() {
        return Objects.nonNull(this.getPreferPlain());
    }

    public T get() {
        T retrievedValue = this.getPreferPlain();
        if (Objects.nonNull(retrievedValue)) {
            return retrievedValue;
        }
        throw new NoSuchElementException("Value has not been set");
    }

    public T orElse(T other) {
        T retrievedValue = this.getPreferPlain();
        if (Objects.isNull(retrievedValue)) {
            return other;
        }
        return retrievedValue;
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.getPreferPlain());
    }

    public boolean offer(T proposedValue) {
        Objects.requireNonNull(proposedValue, "proposedValue");
        return this.offer(() -> proposedValue);
    }

    public boolean offer(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        if (Objects.isNull(this.getPreferPlain())) {
            T proposedValue = supplier.get();
            if (Objects.isNull(proposedValue)) {
                return false;
            }
            return this.setValue(proposedValue);
        }
        return false;
    }

    public T offerAndGet(T proposedValue) {
        Objects.requireNonNull(proposedValue, "proposedValue");
        return (T)this.offerAndGet(() -> proposedValue);
    }

    public T offerAndGet(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        T retrievedValue = this.getPreferPlain();
        if (Objects.nonNull(retrievedValue)) {
            return retrievedValue;
        }
        T proposedValue = Objects.requireNonNull(supplier.get());
        if (this.setValue(proposedValue)) {
            return proposedValue;
        }
        return Objects.requireNonNull(this.getAcquire());
    }

    public Optional<T> offerAndGetOptional(Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        T retrievedValue = this.getPreferPlain();
        if (Objects.nonNull(retrievedValue)) {
            return Optional.of(retrievedValue);
        }
        T proposedValue = supplier.get();
        if (Objects.isNull(proposedValue)) {
            return Optional.empty();
        }
        if (this.setValue(proposedValue)) {
            return Optional.of(proposedValue);
        }
        return Optional.of(this.getAcquire());
    }

    public boolean ifSetOrElseSupply(Consumer<T> consumer, Supplier<T> supplier) {
        Objects.requireNonNull(supplier, "supplier");
        Objects.requireNonNull(consumer, "consumer");
        T existingValue = this.getPreferPlain();
        if (Objects.isNull(existingValue)) {
            T proposedValue = Objects.requireNonNull(supplier.get());
            if (this.setValue(proposedValue)) {
                return true;
            }
            existingValue = this.getAcquire();
        }
        consumer.accept(existingValue);
        return false;
    }

    private T getPreferPlain() {
        Object existingValue = VALUE.get(this);
        if (Objects.nonNull(existingValue)) {
            return (T)existingValue;
        }
        return this.getAcquire();
    }

    private T getAcquire() {
        return (T)VALUE.getAcquire(this);
    }

    private boolean setValue(T proposedValue) {
        return VALUE.compareAndSet(this, null, proposedValue);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            VALUE = l.findVarHandle(SetOnceReference.class, "value", Object.class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

