/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.boot.model.naming.Identifier;
import org.hibernate.boot.model.naming.ImplicitForeignKeyNameSource;
import org.hibernate.boot.spi.MetadataBuildingContext;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;

public class ForeignKeyNameSource
implements ImplicitForeignKeyNameSource {
    private final List<Identifier> columnNames;
    private final ForeignKey foreignKey;
    private final Table table;
    private final MetadataBuildingContext buildingContext;
    private List<Identifier> referencedColumnNames;

    public ForeignKeyNameSource(ForeignKey foreignKey, Table table, MetadataBuildingContext buildingContext) {
        this.foreignKey = foreignKey;
        this.table = table;
        this.buildingContext = buildingContext;
        this.columnNames = this.extractColumnNames(foreignKey.getColumns());
        this.referencedColumnNames = null;
    }

    @Override
    public Identifier getTableName() {
        return this.table.getNameIdentifier();
    }

    @Override
    public List<Identifier> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public Identifier getReferencedTableName() {
        return this.foreignKey.getReferencedTable().getNameIdentifier();
    }

    @Override
    public List<Identifier> getReferencedColumnNames() {
        if (this.referencedColumnNames == null) {
            this.referencedColumnNames = this.extractColumnNames(this.foreignKey.getReferencedColumns());
        }
        return this.referencedColumnNames;
    }

    @Override
    public Identifier getUserProvidedIdentifier() {
        String name = this.foreignKey.getName();
        return name != null ? Identifier.toIdentifier(name) : null;
    }

    @Override
    public MetadataBuildingContext getBuildingContext() {
        return this.buildingContext;
    }

    private List<Identifier> extractColumnNames(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Identifier> columnNames = CollectionHelper.arrayList(columns.size());
        for (Column column : columns) {
            columnNames.add(column.getNameIdentifier(this.buildingContext));
        }
        return columnNames;
    }
}

