/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.reactive.publisher.impl.commands.batch;

import java.util.Collections;
import java.util.List;
import java.util.function.ObjIntConsumer;
import org.infinispan.commons.util.IntSet;
import org.infinispan.commons.util.Util;
import org.infinispan.reactive.publisher.impl.PublisherHandler;

public class PublisherResponse {
    final Object[] results;
    final IntSet completedSegments;
    final IntSet lostSegments;
    final int size;
    final boolean complete;
    final List<PublisherHandler.SegmentResult> segmentResults;

    public PublisherResponse(Object[] results, IntSet completedSegments, IntSet lostSegments, int size, boolean complete, List<PublisherHandler.SegmentResult> segmentResults) {
        this.results = results;
        this.completedSegments = completedSegments;
        this.lostSegments = lostSegments;
        this.size = size;
        this.complete = complete;
        this.segmentResults = segmentResults;
    }

    public static PublisherResponse emptyResponse(IntSet completedSegments, IntSet lostSegments) {
        return new PublisherResponse(Util.EMPTY_OBJECT_ARRAY, completedSegments, lostSegments, 0, true, Collections.emptyList());
    }

    public Object[] getResults() {
        return this.results;
    }

    public IntSet getCompletedSegments() {
        return this.completedSegments;
    }

    public IntSet getLostSegments() {
        return this.lostSegments;
    }

    public int getSize() {
        return this.size;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public List<PublisherHandler.SegmentResult> getSegmentResults() {
        return this.segmentResults;
    }

    public void keysForNonCompletedSegments(ObjIntConsumer consumer) {
        int segmentResultSize = this.segmentResults.size();
        if (segmentResultSize == 0) {
            return;
        }
        PublisherHandler.SegmentResult segmentResult = this.segmentResults.get(segmentResultSize - 1);
        int segment = segmentResult.getSegment();
        for (int i = segmentResult.getEntryCount(); i > 0; --i) {
            consumer.accept(this.results[this.size - i], segment);
        }
    }

    public String toString() {
        return "PublisherResponse{size=" + this.size + ", completedSegments=" + String.valueOf(this.completedSegments) + ", lostSegments=" + String.valueOf(this.lostSegments) + ", complete=" + this.complete + ", segmentResults=" + String.valueOf(this.segmentResults) + "}";
    }
}

