/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.MavenIcons;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenPlugin;
import org.jetbrains.idea.maven.navigator.structure.GoalsGroupNode;
import org.jetbrains.idea.maven.navigator.structure.MavenProjectsStructure;
import org.jetbrains.idea.maven.navigator.structure.PluginGoalNode;
import org.jetbrains.idea.maven.navigator.structure.PluginsNode;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;

@ApiStatus.Internal
public final class PluginNode
extends GoalsGroupNode {
    private final MavenPlugin myPlugin;
    private MavenPluginInfo myPluginInfo;

    PluginNode(MavenProjectsStructure structure, PluginsNode parent, MavenPlugin plugin, MavenPluginInfo pluginInfo) {
        super(structure, parent);
        this.myPlugin = plugin;
        this.getTemplatePresentation().setIcon(MavenIcons.MavenPlugin);
        this.updatePlugin(pluginInfo);
    }

    public MavenPlugin getPlugin() {
        return this.myPlugin;
    }

    public String getName() {
        return this.myPluginInfo == null ? this.myPlugin.getDisplayString() : this.myPluginInfo.getGoalPrefix();
    }

    @Override
    protected void doUpdate(@NotNull PresentationData presentation) {
        if (presentation == null) {
            PluginNode.$$$reportNull$$$0(0);
        }
        this.setNameAndTooltip(presentation, this.getName(), null, this.myPluginInfo != null ? this.myPlugin.getDisplayString() : null);
    }

    public void updatePlugin(@Nullable MavenPluginInfo newPluginInfo) {
        boolean hadPluginInfo = this.myPluginInfo != null;
        this.myPluginInfo = newPluginInfo;
        boolean hasPluginInfo = this.myPluginInfo != null;
        this.setErrorLevel(this.myPluginInfo == null ? MavenProjectsStructure.ErrorLevel.ERROR : MavenProjectsStructure.ErrorLevel.NONE);
        if (hadPluginInfo == hasPluginInfo) {
            return;
        }
        this.myGoalNodes.clear();
        if (this.myPluginInfo != null) {
            for (MavenPluginInfo.Mojo mojo : this.myPluginInfo.getMojos()) {
                this.myGoalNodes.add(new PluginGoalNode(this.myMavenProjectsStructure, this, mojo.getQualifiedGoal(), mojo.getGoal(), mojo.getDisplayName()));
            }
        }
        this.sort(this.myGoalNodes);
        this.myMavenProjectsStructure.updateFrom((SimpleNode)this);
        this.childrenChanged();
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() || this.getDisplayKind() != MavenProjectsStructure.DisplayKind.NEVER;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "org/jetbrains/idea/maven/navigator/structure/PluginNode", "doUpdate"));
    }
}

