/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.job;

import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.job.Job;

public class JobEntryJobRunner
implements Runnable {
    private Job job;
    private Result result;
    private LogWriter log;
    private int entryNr;
    private boolean finished;

    public JobEntryJobRunner(Job job, Result result, int entryNr) {
        this.job = job;
        this.result = result;
        this.log = LogWriter.getInstance();
        this.entryNr = entryNr;
        this.finished = false;
    }

    public void run() {
        try {
            if (this.job.isStopped() || this.job.getParentJob() != null && this.job.getParentJob().isStopped()) {
                return;
            }
            this.result = this.job.execute(this.entryNr + 1, this.result);
        }
        catch (KettleException e) {
            this.log.logError(this.toString(), "An error occurred executing this job entry : " + e.getMessage(), new Object[0]);
            this.result.setResult(false);
            this.result.setNrErrors(1L);
        }
        this.finished = true;
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Result getResult() {
        return this.result;
    }

    public LogWriter getLog() {
        return this.log;
    }

    public void setLog(LogWriter log) {
        this.log = log;
    }

    public Job getJob() {
        return this.job;
    }

    public void setJob(Job job) {
        this.job = job;
    }

    public int getEntryNr() {
        return this.entryNr;
    }

    public void setEntryNr(int entryNr) {
        this.entryNr = entryNr;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public void waitUntilFinished() {
        while (!this.isFinished() && !this.job.isStopped()) {
            try {
                Thread.sleep(0L, 1);
            }
            catch (InterruptedException interruptedException) {}
        }
    }
}

