/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.rtf.field;

import com.lowagie.text.Chunk;
import com.lowagie.text.Font;
import com.lowagie.text.rtf.RtfBasicElement;
import com.lowagie.text.rtf.document.RtfDocument;
import com.lowagie.text.rtf.style.RtfFont;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public abstract class RtfField
extends Chunk
implements RtfBasicElement {
    private static final byte[] FIELD = "\\field".getBytes();
    private static final byte[] FIELD_DIRTY = "\\flddirty".getBytes();
    private static final byte[] FIELD_PRIVATE = "\\fldpriv".getBytes();
    private static final byte[] FIELD_LOCKED = "\\fldlock".getBytes();
    private static final byte[] FIELD_EDIT = "\\fldedit".getBytes();
    private static final byte[] FIELD_ALT = "\\fldalt".getBytes();
    private static final byte[] FIELD_INSTRUCTIONS = "\\*\\fldinst".getBytes();
    private static final byte[] FIELD_RESULT = "\\fldrslt".getBytes();
    private boolean fieldDirty = false;
    private boolean fieldEdit = false;
    private boolean fieldLocked = false;
    private boolean fieldPrivate = false;
    private boolean fieldAlt = false;
    private boolean inTable = false;
    private boolean inHeader = false;
    protected RtfDocument document = null;
    private RtfFont font = null;

    protected RtfField(RtfDocument rtfDocument) {
        this(rtfDocument, new Font());
    }

    protected RtfField(RtfDocument rtfDocument, Font font) {
        super("", font);
        this.document = rtfDocument;
        this.font = new RtfFont(this.document, font);
    }

    public void setRtfDocument(RtfDocument rtfDocument) {
        this.document = rtfDocument;
        this.font.setRtfDocument(this.document);
    }

    private byte[] writeFieldBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldBegin(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldBegin(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(FIELD);
        if (this.fieldDirty) {
            outputStream.write(FIELD_DIRTY);
        }
        if (this.fieldEdit) {
            outputStream.write(FIELD_EDIT);
        }
        if (this.fieldLocked) {
            outputStream.write(FIELD_LOCKED);
        }
        if (this.fieldPrivate) {
            outputStream.write(FIELD_PRIVATE);
        }
    }

    private byte[] writeFieldInstBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldInstBegin(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldInstBegin(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(FIELD_INSTRUCTIONS);
        outputStream.write(DELIMITER);
    }

    protected abstract byte[] writeFieldInstContent() throws IOException;

    protected void writeFieldInstContent(OutputStream outputStream) throws IOException {
        byte[] byArray = this.writeFieldInstContent();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    private byte[] writeFieldInstEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldInstEnd(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldInstEnd(OutputStream outputStream) throws IOException {
        if (this.fieldAlt) {
            outputStream.write(DELIMITER);
            outputStream.write(FIELD_ALT);
        }
        outputStream.write(CLOSE_GROUP);
    }

    private byte[] writeFieldResultBegin() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldResultBegin(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldResultBegin(OutputStream outputStream) throws IOException {
        outputStream.write(OPEN_GROUP);
        outputStream.write(FIELD_RESULT);
        outputStream.write(DELIMITER);
    }

    protected abstract byte[] writeFieldResultContent() throws IOException;

    protected void writeFieldResultContent(OutputStream outputStream) throws IOException {
        byte[] byArray = this.writeFieldResultContent();
        if (byArray != null) {
            outputStream.write(byArray);
        }
    }

    private byte[] writeFieldResultEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldResultEnd(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldResultEnd(OutputStream outputStream) throws IOException {
        outputStream.write(DELIMITER);
        outputStream.write(CLOSE_GROUP);
    }

    private byte[] writeFieldEnd() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeFieldEnd(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    private void writeFieldEnd(OutputStream outputStream) throws IOException {
        outputStream.write(CLOSE_GROUP);
    }

    public byte[] write() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            this.writeContent(byteArrayOutputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return byteArrayOutputStream.toByteArray();
    }

    public void writeContent(OutputStream outputStream) throws IOException {
        outputStream.write(this.font.writeBegin());
        this.writeFieldBegin(outputStream);
        this.writeFieldInstBegin(outputStream);
        this.writeFieldInstContent(outputStream);
        this.writeFieldInstEnd(outputStream);
        this.writeFieldResultBegin(outputStream);
        this.writeFieldResultContent(outputStream);
        this.writeFieldResultEnd(outputStream);
        this.writeFieldEnd(outputStream);
        outputStream.write(this.font.writeEnd());
    }

    public boolean isFieldAlt() {
        return this.fieldAlt;
    }

    public void setFieldAlt(boolean bl) {
        this.fieldAlt = bl;
    }

    public boolean isFieldDirty() {
        return this.fieldDirty;
    }

    public void setFieldDirty(boolean bl) {
        this.fieldDirty = bl;
    }

    public boolean isFieldEdit() {
        return this.fieldEdit;
    }

    public void setFieldEdit(boolean bl) {
        this.fieldEdit = bl;
    }

    public boolean isFieldLocked() {
        return this.fieldLocked;
    }

    public void setFieldLocked(boolean bl) {
        this.fieldLocked = bl;
    }

    public boolean isFieldPrivate() {
        return this.fieldPrivate;
    }

    public void setFieldPrivate(boolean bl) {
        this.fieldPrivate = bl;
    }

    public void setInTable(boolean bl) {
        this.inTable = bl;
    }

    public void setInHeader(boolean bl) {
        this.inHeader = bl;
    }

    public boolean isEmpty() {
        return false;
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = new RtfFont(this.document, font);
    }
}

