/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.io;

import java.io.IOException;
import java.io.InputStream;
import nu.validator.io.StreamBoundException;

public final class BoundedInputStream
extends InputStream {
    private final InputStream delegate;
    private final String systemId;
    private long counter = 0L;
    private long limit;

    public BoundedInputStream(InputStream delegate, long limit, String systemId) {
        this.delegate = delegate;
        this.limit = limit;
        this.systemId = systemId;
    }

    private void checkLimit() throws IOException {
        if (this.counter > this.limit) {
            throw new StreamBoundException("Stream length exceeds limit.", this.systemId);
        }
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int arg0) {
        this.delegate.mark(arg0);
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }

    @Override
    public int read() throws IOException {
        this.checkLimit();
        ++this.counter;
        return this.delegate.read();
    }

    @Override
    public int read(byte[] arg0) throws IOException {
        this.checkLimit();
        int c = this.delegate.read(arg0);
        this.counter += (long)c;
        return c;
    }

    @Override
    public int read(byte[] arg0, int arg1, int arg2) throws IOException {
        this.checkLimit();
        int c = this.delegate.read(arg0, arg1, arg2);
        this.counter += (long)c;
        return c;
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public long skip(long arg0) throws IOException {
        return this.delegate.skip(arg0);
    }
}

