/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.web;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;

public class OverrideFileFilter
implements Filter {
    private Resource overrideBase;

    public void init(FilterConfig config) {
        String overridePath = config.getInitParameter("overridePath");
        ServletContextHandler context = ServletContextHandler.getServletContextHandler((ServletContext)config.getServletContext());
        this.overrideBase = ResourceFactory.of((Container)context).newResource(new File(overridePath).toPath());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        boolean appRoute;
        Resource candidate;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!"GET".equals(httpRequest.getMethod()) && !"HEAD".equals(httpRequest.getMethod())) {
            chain.doFilter(request, response);
            return;
        }
        String uri = httpRequest.getRequestURI();
        if (uri.startsWith("/api") || uri.startsWith("/console")) {
            chain.doFilter(request, response);
            return;
        }
        String path = uri.substring(httpRequest.getContextPath().length());
        if (path.isEmpty()) {
            path = "/";
        }
        if ((candidate = this.overrideBase.resolve(path)) != null && candidate.exists() && !candidate.isDirectory()) {
            request.getRequestDispatcher("/override" + path).forward(request, response);
            return;
        }
        String accept = httpRequest.getHeader("Accept");
        boolean acceptHtml = accept != null && accept.contains("text/html");
        String last = path.endsWith("/") ? "" : path.substring(path.lastIndexOf(47) + 1);
        boolean bl = appRoute = path.endsWith("/") || !last.contains(".");
        if (acceptHtml && appRoute) {
            request.getRequestDispatcher("/index.html").forward(request, response);
            return;
        }
        chain.doFilter(request, response);
    }
}

