/*
 * Decompiled with CFR 0.152.
 */
package com.igormaznitsa.jbbp.mapper;

import com.igormaznitsa.jbbp.model.JBBPAbstractField;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBit;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayDouble;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayFloat;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayLong;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayShort;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayString;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUInt;
import com.igormaznitsa.jbbp.model.JBBPFieldArrayUShort;
import com.igormaznitsa.jbbp.model.JBBPFieldBit;
import com.igormaznitsa.jbbp.model.JBBPFieldBoolean;
import com.igormaznitsa.jbbp.model.JBBPFieldByte;
import com.igormaznitsa.jbbp.model.JBBPFieldDouble;
import com.igormaznitsa.jbbp.model.JBBPFieldFloat;
import com.igormaznitsa.jbbp.model.JBBPFieldInt;
import com.igormaznitsa.jbbp.model.JBBPFieldLong;
import com.igormaznitsa.jbbp.model.JBBPFieldShort;
import com.igormaznitsa.jbbp.model.JBBPFieldString;
import com.igormaznitsa.jbbp.model.JBBPFieldStruct;
import com.igormaznitsa.jbbp.model.JBBPFieldUByte;
import com.igormaznitsa.jbbp.model.JBBPFieldUInt;
import com.igormaznitsa.jbbp.model.JBBPFieldUShort;

public enum BinType {
    UNDEFINED(null, false),
    BIT(JBBPFieldBit.class, false),
    BOOL(JBBPFieldBoolean.class, false),
    BYTE(JBBPFieldByte.class, false),
    UBYTE(JBBPFieldUByte.class, false),
    SHORT(JBBPFieldShort.class, false),
    USHORT(JBBPFieldUShort.class, false),
    INT(JBBPFieldInt.class, false),
    UINT(JBBPFieldUInt.class, false),
    DOUBLE(JBBPFieldDouble.class, false),
    FLOAT(JBBPFieldFloat.class, false),
    STRING(JBBPFieldString.class, false),
    LONG(JBBPFieldLong.class, false),
    BIT_ARRAY(JBBPFieldArrayBit.class, true),
    BOOL_ARRAY(JBBPFieldArrayBoolean.class, true),
    BYTE_ARRAY(JBBPFieldArrayByte.class, true),
    UBYTE_ARRAY(JBBPFieldArrayUByte.class, true),
    SHORT_ARRAY(JBBPFieldArrayShort.class, true),
    USHORT_ARRAY(JBBPFieldArrayUShort.class, true),
    INT_ARRAY(JBBPFieldArrayInt.class, true),
    UINT_ARRAY(JBBPFieldArrayUInt.class, true),
    LONG_ARRAY(JBBPFieldArrayLong.class, true),
    FLOAT_ARRAY(JBBPFieldArrayFloat.class, true),
    STRING_ARRAY(JBBPFieldArrayString.class, true),
    DOUBLE_ARRAY(JBBPFieldArrayDouble.class, true),
    STRUCT(JBBPFieldStruct.class, false),
    STRUCT_ARRAY(JBBPFieldArrayStruct.class, true);

    private final Class<? extends JBBPAbstractField> fieldClass;
    private final boolean arrayFlag;

    private BinType(Class<? extends JBBPAbstractField> fieldClass, boolean array) {
        this.fieldClass = fieldClass;
        this.arrayFlag = array;
    }

    public static BinType findCompatible(Class<?> fieldClazz) {
        Class<?> type;
        BinType result = fieldClazz.isArray() ? ((type = fieldClazz.getComponentType()).isPrimitive() ? (type == Byte.TYPE ? BYTE_ARRAY : (type == Character.TYPE ? USHORT_ARRAY : (type == Boolean.TYPE ? BOOL_ARRAY : (type == Short.TYPE ? SHORT_ARRAY : (type == Integer.TYPE ? INT_ARRAY : (type == Long.TYPE ? LONG_ARRAY : (type == Float.TYPE ? FLOAT_ARRAY : (type == Double.TYPE ? DOUBLE_ARRAY : null)))))))) : (type == String.class ? STRING_ARRAY : STRUCT_ARRAY)) : (fieldClazz.isPrimitive() ? (fieldClazz == Byte.TYPE ? BYTE : (fieldClazz == Character.TYPE ? USHORT : (fieldClazz == Boolean.TYPE ? BOOL : (fieldClazz == Short.TYPE ? SHORT : (fieldClazz == Integer.TYPE ? INT : (fieldClazz == Long.TYPE ? LONG : (fieldClazz == Float.TYPE ? FLOAT : (fieldClazz == Double.TYPE ? DOUBLE : null)))))))) : (fieldClazz == String.class ? STRING : STRUCT));
        return result;
    }

    public boolean isArray() {
        return this.arrayFlag;
    }

    public Class<? extends JBBPAbstractField> getFieldClass() {
        return this.fieldClass;
    }
}

