/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate;

import jakarta.persistence.FindOption;
import jakarta.persistence.LockModeType;
import jakarta.persistence.RefreshOption;
import java.util.Locale;
import org.hibernate.LockOptions;
import org.hibernate.Locking;
import org.hibernate.jpa.internal.util.LockModeTypeHelper;

public enum LockMode implements FindOption,
RefreshOption
{
    NONE,
    READ,
    OPTIMISTIC,
    OPTIMISTIC_FORCE_INCREMENT,
    WRITE,
    PESSIMISTIC_READ,
    PESSIMISTIC_WRITE,
    PESSIMISTIC_FORCE_INCREMENT,
    UPGRADE_NOWAIT,
    UPGRADE_SKIPLOCKED;


    public static LockMode fromJpaLockMode(LockModeType lockMode) {
        return LockModeTypeHelper.getLockMode(lockMode);
    }

    public static LockModeType toJpaLockMode(LockMode lockMode) {
        return LockModeTypeHelper.getLockModeType(lockMode);
    }

    public LockModeType toJpaLockMode() {
        return LockModeTypeHelper.getLockModeType(this);
    }

    public boolean greaterThan(LockMode mode) {
        return this.level() > mode.level();
    }

    public boolean lessThan(LockMode mode) {
        return this.level() < mode.level();
    }

    public boolean requiresVersion() {
        return this == OPTIMISTIC || this == OPTIMISTIC_FORCE_INCREMENT || this == PESSIMISTIC_FORCE_INCREMENT;
    }

    public String toExternalForm() {
        String externalForm = this.toString().toLowerCase(Locale.ROOT);
        return this == UPGRADE_NOWAIT || this == UPGRADE_SKIPLOCKED ? externalForm.replace('_', '-') : externalForm;
    }

    private int level() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> 0;
            case 1 -> 1;
            case 2 -> 2;
            case 3 -> 3;
            case 5 -> 4;
            case 6, 8, 9 -> 5;
            case 4, 7 -> 6;
        };
    }

    public static LockMode fromExternalForm(String externalForm) {
        if (externalForm == null) {
            return NONE;
        }
        for (LockMode lockMode : LockMode.values()) {
            if (!lockMode.toExternalForm().equalsIgnoreCase(externalForm)) continue;
            return lockMode;
        }
        if (externalForm.equalsIgnoreCase("upgrade")) {
            return PESSIMISTIC_WRITE;
        }
        throw new IllegalArgumentException("Unable to interpret LockMode reference from incoming external form: " + externalForm);
    }

    @Deprecated(since="7", forRemoval=true)
    public LockOptions toLockOptions() {
        return switch (this.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> new LockOptions();
            case 1 -> new LockOptions(READ);
            case 2 -> new LockOptions(OPTIMISTIC);
            case 3 -> new LockOptions(OPTIMISTIC_FORCE_INCREMENT);
            case 8 -> new LockOptions(PESSIMISTIC_WRITE, 0, Locking.Scope.ROOT_ONLY, Locking.FollowOn.ALLOW);
            case 9 -> new LockOptions(PESSIMISTIC_WRITE, -2, Locking.Scope.ROOT_ONLY, Locking.FollowOn.ALLOW);
            case 5 -> new LockOptions(PESSIMISTIC_READ);
            case 6 -> new LockOptions(PESSIMISTIC_WRITE);
            case 7 -> new LockOptions(PESSIMISTIC_FORCE_INCREMENT);
            case 4 -> throw new UnsupportedOperationException("WRITE is not a valid LockMode as an argument");
        };
    }

    public boolean isPessimistic() {
        return this == PESSIMISTIC_READ || this == PESSIMISTIC_WRITE || this == PESSIMISTIC_FORCE_INCREMENT || this == UPGRADE_NOWAIT || this == UPGRADE_SKIPLOCKED;
    }
}

