/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.builditem;

import io.quarkus.bootstrap.app.JarResult;
import io.quarkus.bootstrap.app.SbomResult;
import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.nio.file.Path;
import java.util.Collection;

public final class JarBuildItem
extends SimpleBuildItem {
    private final Path path;
    private final Path originalArtifact;
    private final Path libraryDir;
    private final PackageConfig.JarConfig.JarType type;
    private final String classifier;
    private final ApplicationManifestConfig manifestConfig;

    public JarBuildItem(Path path, Path originalArtifact, Path libraryDir, PackageConfig.JarConfig.JarType type, String classifier) {
        this(path, originalArtifact, libraryDir, type, classifier, null);
    }

    public JarBuildItem(Path path, Path originalArtifact, Path libraryDir, PackageConfig.JarConfig.JarType type, String classifier, ApplicationManifestConfig manifestConfig) {
        this.path = path;
        this.originalArtifact = originalArtifact;
        this.libraryDir = libraryDir;
        this.type = type;
        this.classifier = classifier;
        this.manifestConfig = manifestConfig;
    }

    public boolean isUberJar() {
        return this.libraryDir == null;
    }

    public Path getPath() {
        return this.path;
    }

    public Path getLibraryDir() {
        return this.libraryDir;
    }

    public Path getOriginalArtifact() {
        return this.originalArtifact;
    }

    public PackageConfig.JarConfig.JarType getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public ApplicationManifestConfig getManifestConfig() {
        return this.manifestConfig;
    }

    public JarResult toJarResult() {
        return this.toJarResult(null);
    }

    public JarResult toJarResult(Collection<SbomResult> sboms) {
        return new JarResult(this.path, this.originalArtifact, this.libraryDir, this.type == PackageConfig.JarConfig.JarType.MUTABLE_JAR, this.classifier, sboms);
    }
}

