/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.multimap.impl.function.sortedset;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.commons.marshall.MarshallUtil;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.multimap.impl.ExternalizerIds;
import org.infinispan.multimap.impl.SortedSetBucket;
import org.infinispan.multimap.impl.function.sortedset.SortedSetBucketBaseFunction;
import org.infinispan.multimap.impl.function.sortedset.SortedSetOperationType;

public final class RemoveManyFunction<K, V, T>
implements SortedSetBucketBaseFunction<K, V, Long> {
    public static final AdvancedExternalizer<RemoveManyFunction> EXTERNALIZER = new Externalizer();
    private final List<T> values;
    private final boolean includeMin;
    private final boolean includeMax;
    private final SortedSetOperationType type;

    public RemoveManyFunction(List<T> values, SortedSetOperationType type) {
        this.values = values;
        this.includeMin = false;
        this.includeMax = false;
        this.type = type;
    }

    public RemoveManyFunction(List<T> values, boolean includeMin, boolean includeMax, SortedSetOperationType type) {
        this.values = values;
        this.includeMin = includeMin;
        this.includeMax = includeMax;
        this.type = type;
    }

    public Long apply(EntryView.ReadWriteEntryView<K, SortedSetBucket<V>> entryView) {
        Optional existing = entryView.peek();
        if (existing.isPresent()) {
            SortedSetBucket bucket = (SortedSetBucket)existing.get();
            SortedSetBucket.SortedSetResult result = switch (this.type) {
                case SortedSetOperationType.LEX -> {
                    Object first = RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(first, this.includeMin, RemoveManyFunction.element(this.values, 1), this.includeMax);
                }
                case SortedSetOperationType.SCORE -> {
                    Double d = (Double)RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(d, this.includeMin, (Double)RemoveManyFunction.element(this.values, 1), this.includeMax);
                }
                case SortedSetOperationType.INDEX -> {
                    Long l = (Long)RemoveManyFunction.element(this.values, 0);
                    yield bucket.removeAll(l, (Long)RemoveManyFunction.element(this.values, 1));
                }
                default -> bucket.removeAll(RemoveManyFunction.unchecked(this.values));
            };
            SortedSetBucket next = result.bucket();
            if (next.size() == 0L) {
                entryView.remove();
            } else {
                entryView.set(next, new MetaParam.Writable[0]);
            }
            return result.result();
        }
        return 0L;
    }

    private static <E> Collection<E> unchecked(List<?> list) {
        return list;
    }

    private static <E> E element(List<?> list, int index) {
        return (E)list.get(index);
    }

    private static class Externalizer
    implements AdvancedExternalizer<RemoveManyFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends RemoveManyFunction>> getTypeClasses() {
            return Collections.singleton(RemoveManyFunction.class);
        }

        public Integer getId() {
            return ExternalizerIds.SORTED_SET_REMOVE_MANY_FUNCTION;
        }

        public void writeObject(ObjectOutput output, RemoveManyFunction object) throws IOException {
            MarshallUtil.marshallCollection(object.values, (ObjectOutput)output);
            output.writeBoolean(object.includeMin);
            output.writeBoolean(object.includeMax);
            MarshallUtil.marshallEnum((Enum)object.type, (ObjectOutput)output);
        }

        public RemoveManyFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new RemoveManyFunction((List)MarshallUtil.unmarshallCollection((ObjectInput)input, ArrayList::new), input.readBoolean(), input.readBoolean(), (SortedSetOperationType)MarshallUtil.unmarshallEnum((ObjectInput)input, SortedSetOperationType::valueOf));
        }
    }
}

