/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;
import org.keycloak.provider.KeycloakDeploymentInfo;
import org.keycloak.provider.ProviderFactory;
import org.keycloak.provider.ProviderLoader;
import org.keycloak.provider.Spi;
import org.keycloak.theme.ClasspathThemeProviderFactory;
import org.keycloak.theme.ClasspathThemeResourceProviderFactory;
import org.keycloak.theme.ThemeResourceSpi;
import org.keycloak.theme.ThemeSpi;

public class DefaultProviderLoader
implements ProviderLoader {
    private KeycloakDeploymentInfo info;
    private ClassLoader classLoader;

    public DefaultProviderLoader(KeycloakDeploymentInfo info, ClassLoader classLoader) {
        this.info = info;
        this.classLoader = classLoader;
    }

    public List<Spi> loadSpis() {
        if (this.info.hasServices()) {
            LinkedList<Spi> list = new LinkedList<Spi>();
            for (Spi spi : ServiceLoader.load(Spi.class, this.classLoader)) {
                list.add(spi);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public List<ProviderFactory> load(Spi spi) {
        LinkedList<ProviderFactory> list = new LinkedList<ProviderFactory>();
        if (this.info.hasServices()) {
            for (ProviderFactory f : ServiceLoader.load(spi.getProviderFactoryClass(), this.classLoader)) {
                list.add(f);
            }
        }
        if (spi.getClass().equals(ThemeResourceSpi.class) && this.info.hasThemeResources()) {
            ClasspathThemeResourceProviderFactory resourceProviderFactory = new ClasspathThemeResourceProviderFactory(this.info.getName(), this.classLoader);
            list.add((ProviderFactory)resourceProviderFactory);
        }
        if (spi.getClass().equals(ThemeSpi.class) && this.info.hasThemes()) {
            ClasspathThemeProviderFactory themeProviderFactory = new ClasspathThemeProviderFactory(this.info.getName(), this.classLoader);
            list.add((ProviderFactory)themeProviderFactory);
        }
        return list;
    }
}

