/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import jakarta.persistence.PersistenceException;
import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.JdbcLogging;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.jboss.logging.Logger;

public class JdbcConnectionAccessProvidedConnectionImpl
implements JdbcConnectionAccess {
    private static final Logger log = Logger.getLogger(JdbcConnectionAccessProvidedConnectionImpl.class);
    private final Connection jdbcConnection;
    private final boolean wasInitiallyAutoCommit;

    public JdbcConnectionAccessProvidedConnectionImpl(Connection jdbcConnection) {
        boolean wasInitiallyAutoCommit;
        block4: {
            this.jdbcConnection = jdbcConnection;
            try {
                wasInitiallyAutoCommit = jdbcConnection.getAutoCommit();
                if (wasInitiallyAutoCommit) break block4;
                try {
                    jdbcConnection.setAutoCommit(true);
                }
                catch (SQLException exception) {
                    throw new PersistenceException(String.format("Could not set provided connection [%s] to auto-commit mode (needed for schema generation)", jdbcConnection), (Throwable)exception);
                }
            }
            catch (SQLException ignore) {
                wasInitiallyAutoCommit = false;
            }
        }
        log.tracef("wasInitiallyAutoCommit=%s", (Object)wasInitiallyAutoCommit);
        this.wasInitiallyAutoCommit = wasInitiallyAutoCommit;
    }

    @Override
    public Connection obtainConnection() throws SQLException {
        return this.jdbcConnection;
    }

    @Override
    public void releaseConnection(Connection connection) throws SQLException {
        if (!this.wasInitiallyAutoCommit) {
            try {
                if (this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.setAutoCommit(false);
                }
            }
            catch (SQLException exception) {
                JdbcLogging.JDBC_MESSAGE_LOGGER.unableToResetAutoCommitDisabled(exception);
            }
        }
    }

    @Override
    public boolean supportsAggressiveRelease() {
        return false;
    }
}

