/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.ion.impl.bin;

import com.amazon.ion.Decimal;
import com.amazon.ion.IonDatagram;
import com.amazon.ion.IonReader;
import com.amazon.ion.IonType;
import com.amazon.ion.IonValue;
import com.amazon.ion.SymbolToken;
import com.amazon.ion.Timestamp;
import com.amazon.ion.impl._Private_ByteTransferReader;
import com.amazon.ion.impl._Private_ByteTransferSink;
import com.amazon.ion.impl._Private_IonWriter;
import com.amazon.ion.impl._Private_SymtabExtendsCache;
import com.amazon.ion.impl._Private_Utils;
import com.amazon.ion.impl.bin._Private_IonManagedWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;

abstract class AbstractIonWriter
implements _Private_ByteTransferSink,
_Private_IonWriter {
    private final _Private_SymtabExtendsCache symtabExtendsCache;

    AbstractIonWriter(WriteValueOptimization optimization) {
        this.symtabExtendsCache = optimization == WriteValueOptimization.COPY_OPTIMIZED ? new _Private_SymtabExtendsCache() : null;
    }

    @Override
    public final void writeValue(IonValue value) throws IOException {
        if (value != null) {
            if (value instanceof IonDatagram) {
                this.finish();
            }
            value.writeTo(this);
        }
    }

    @Override
    public final void writeValue(IonReader reader) throws IOException {
        _Private_ByteTransferReader transferReader;
        IonType type = reader.getType();
        if (this.isStreamCopyOptimized() && (transferReader = reader.asFacet(_Private_ByteTransferReader.class)) != null && (_Private_Utils.isNonSymbolScalar(type) || this.symtabExtendsCache.symtabsCompat(this.getSymbolTable(), reader.getSymbolTable()))) {
            transferReader.transferCurrentValue(this);
            return;
        }
        this.writeValueRecursive(reader);
    }

    public final void writeValueRecursive(IonReader reader) throws IOException {
        block25: {
            IonType type;
            int startingDepth = this.getDepth();
            boolean alreadyProcessedTheStartingValue = false;
            block17: while (true) {
                SymbolToken[] annotations;
                if (this.getDepth() == startingDepth) {
                    if (alreadyProcessedTheStartingValue) break block25;
                    type = reader.getType();
                    alreadyProcessedTheStartingValue = true;
                } else {
                    type = reader.next();
                }
                if (type == null) {
                    if (this.getDepth() != startingDepth) {
                        reader.stepOut();
                        this.stepOut();
                        continue;
                    }
                    break block25;
                }
                SymbolToken fieldName = reader.getFieldNameSymbol();
                if (fieldName != null && !this.isFieldNameSet() && this.isInStruct()) {
                    this.setFieldNameSymbol(fieldName);
                }
                if ((annotations = reader.getTypeAnnotationSymbols()).length > 0) {
                    this.setTypeAnnotationSymbols(annotations);
                }
                if (reader.isNullValue()) {
                    this.writeNull(type);
                    continue;
                }
                switch (type) {
                    case BOOL: {
                        boolean booleanValue = reader.booleanValue();
                        this.writeBool(booleanValue);
                        continue block17;
                    }
                    case INT: {
                        switch (reader.getIntegerSize()) {
                            case INT: {
                                int intValue = reader.intValue();
                                this.writeInt(intValue);
                                continue block17;
                            }
                            case LONG: {
                                long longValue = reader.longValue();
                                this.writeInt(longValue);
                                continue block17;
                            }
                            case BIG_INTEGER: {
                                BigInteger bigIntegerValue = reader.bigIntegerValue();
                                this.writeInt(bigIntegerValue);
                                continue block17;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    case FLOAT: {
                        double doubleValue = reader.doubleValue();
                        this.writeFloat(doubleValue);
                        continue block17;
                    }
                    case DECIMAL: {
                        Decimal decimalValue = reader.decimalValue();
                        this.writeDecimal(decimalValue);
                        continue block17;
                    }
                    case TIMESTAMP: {
                        Timestamp timestampValue = reader.timestampValue();
                        this.writeTimestamp(timestampValue);
                        continue block17;
                    }
                    case SYMBOL: {
                        SymbolToken symbolToken = reader.symbolValue();
                        this.writeSymbolToken(symbolToken);
                        continue block17;
                    }
                    case STRING: {
                        String stringValue = reader.stringValue();
                        this.writeString(stringValue);
                        continue block17;
                    }
                    case CLOB: {
                        byte[] clobValue = reader.newBytes();
                        this.writeClob(clobValue);
                        continue block17;
                    }
                    case BLOB: {
                        byte[] blobValue = reader.newBytes();
                        this.writeBlob(blobValue);
                        continue block17;
                    }
                    case LIST: 
                    case SEXP: 
                    case STRUCT: {
                        reader.stepIn();
                        this.stepIn(type);
                        continue block17;
                    }
                }
                break;
            }
            throw new IllegalStateException("Unexpected type: " + (Object)((Object)type));
        }
    }

    @Override
    public final void writeValues(IonReader reader) throws IOException {
        if (reader.getType() != null) {
            this.writeValue(reader);
        }
        while (reader.next() != null) {
            this.writeValue(reader);
        }
    }

    @Override
    public final void writeTimestampUTC(Date value) throws IOException {
        this.writeTimestamp(Timestamp.forDateZ(value));
    }

    @Override
    public final boolean isStreamCopyOptimized() {
        return this.symtabExtendsCache != null;
    }

    @Override
    public <T> T asFacet(Class<T> facetType) {
        if (facetType == _Private_IonManagedWriter.class) {
            return facetType.cast(this);
        }
        return null;
    }

    public abstract void writeString(byte[] var1, int var2, int var3) throws IOException;

    static enum WriteValueOptimization {
        NONE,
        COPY_OPTIMIZED;

    }
}

