/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.janino;

import java.math.BigDecimal;
import java.util.Date;
import org.codehaus.janino.ExpressionEvaluator;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.janino.JaninoData;
import org.pentaho.di.trans.steps.janino.JaninoMeta;
import org.pentaho.di.trans.steps.janino.JaninoMetaFunction;

public class Janino
extends BaseStep
implements StepInterface {
    private JaninoMeta meta;
    private JaninoData data;

    public Janino(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            this.data.outputRowMeta = this.getInputRowMeta().clone();
            this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
            this.data.replaceIndex = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                JaninoMetaFunction fn = this.meta.getFormula()[i];
                if (!Const.isEmpty((String)fn.getReplaceField())) {
                    this.data.replaceIndex[i] = this.getInputRowMeta().indexOfValue(fn.getReplaceField());
                    if (this.data.replaceIndex[i] >= 0) continue;
                    throw new KettleException("Unknown field specified to replace with a formula result: [" + fn.getReplaceField() + "]");
                }
                this.data.replaceIndex[i] = -1;
            }
        }
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), "Read row #" + this.getLinesRead() + " : " + r, new Object[0]);
        }
        Object[] outputRowData = this.calcFields(this.getInputRowMeta(), r);
        this.putRow(this.data.outputRowMeta, outputRowData);
        if (this.log.isRowLevel()) {
            this.log.logRowlevel(this.toString(), "Wrote row #" + this.getLinesWritten() + " : " + r, new Object[0]);
        }
        if (this.checkFeedback(this.getLinesRead())) {
            this.logBasic("Linenr " + this.getLinesRead());
        }
        return true;
    }

    private Object[] calcFields(RowMetaInterface rowMeta, Object[] r) throws KettleValueException {
        try {
            Object[] outputRowData = RowDataUtil.createResizedCopy((Object[])r, (int)this.data.outputRowMeta.size());
            int tempIndex = rowMeta.size();
            if (this.data.expressionEvaluators == null) {
                int i;
                this.data.expressionEvaluators = new ExpressionEvaluator[this.meta.getFormula().length];
                String[] parameterNames = new String[this.data.outputRowMeta.size()];
                Class[] parameterTypes = new Class[this.data.outputRowMeta.size()];
                for (i = 0; i < this.data.outputRowMeta.size(); ++i) {
                    switch (this.data.outputRowMeta.getValueMeta(i).getType()) {
                        case 2: {
                            parameterTypes[i] = String.class;
                            break;
                        }
                        case 1: {
                            parameterTypes[i] = Double.class;
                            break;
                        }
                        case 5: {
                            parameterTypes[i] = Long.class;
                            break;
                        }
                        case 3: {
                            parameterTypes[i] = Date.class;
                            break;
                        }
                        case 6: {
                            parameterTypes[i] = BigDecimal.class;
                            break;
                        }
                        case 4: {
                            parameterTypes[i] = Boolean.class;
                            break;
                        }
                        case 8: {
                            parameterTypes[i] = byte[].class;
                            break;
                        }
                        default: {
                            parameterTypes[i] = String.class;
                        }
                    }
                    parameterNames[i] = this.data.outputRowMeta.getValueMeta(i).getName();
                }
                for (i = 0; i < this.meta.getFormula().length; ++i) {
                    JaninoMetaFunction fn = this.meta.getFormula()[i];
                    if (Const.isEmpty((String)fn.getFieldName())) {
                        throw new KettleException("Unable to find field name for formula [" + Const.NVL((String)fn.getFormula(), (String)"") + "]");
                    }
                    this.data.expressionEvaluators[i] = new ExpressionEvaluator();
                    this.data.expressionEvaluators[i].setParameters(parameterNames, parameterTypes);
                    this.data.expressionEvaluators[i].setReturnType(Object.class);
                    this.data.expressionEvaluators[i].setThrownExceptions(new Class[]{Exception.class});
                    this.data.expressionEvaluators[i].cook(fn.getFormula());
                }
            }
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                Object value;
                JaninoMetaFunction fn = this.meta.getFormula()[i];
                Object[] rowData = new Object[this.data.outputRowMeta.size()];
                System.arraycopy(outputRowData, 0, rowData, 0, rowData.length);
                Object formulaResult = this.data.expressionEvaluators[i].evaluate(rowData);
                if (this.data.returnType[i] < 0) {
                    if (formulaResult instanceof String) {
                        this.data.returnType[i] = 0;
                        if (fn.getValueType() != 2) {
                            throw new KettleValueException("Please specify a String type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Integer) {
                        this.data.returnType[i] = 2;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Long) {
                        this.data.returnType[i] = 3;
                        if (fn.getValueType() != 5) {
                            throw new KettleValueException("Please specify an Integer type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Number) {
                        this.data.returnType[i] = 1;
                        if (fn.getValueType() != 1) {
                            throw new KettleValueException("Please specify a Number type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Date) {
                        this.data.returnType[i] = 4;
                        if (fn.getValueType() != 3) {
                            throw new KettleValueException("Please specify a Date type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof BigDecimal) {
                        this.data.returnType[i] = 5;
                        if (fn.getValueType() != 6) {
                            throw new KettleValueException("Please specify a BigNumber type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof byte[]) {
                        this.data.returnType[i] = 6;
                        if (fn.getValueType() != 8) {
                            throw new KettleValueException("Please specify a Binary type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else if (formulaResult instanceof Boolean) {
                        this.data.returnType[i] = 7;
                        if (fn.getValueType() != 4) {
                            throw new KettleValueException("Please specify a Boolean type to parse [" + formulaResult.getClass().getName() + "] for field [" + fn.getFieldName() + "] as a result of formula [" + fn.getFormula() + "]");
                        }
                    } else {
                        this.data.returnType[i] = 0;
                    }
                }
                if (formulaResult == null) {
                    value = null;
                } else {
                    switch (this.data.returnType[i]) {
                        case 0: {
                            value = formulaResult.toString();
                            break;
                        }
                        case 1: {
                            value = new Double(((Number)formulaResult).doubleValue());
                            break;
                        }
                        case 2: {
                            value = new Long(((Integer)formulaResult).intValue());
                            break;
                        }
                        case 3: {
                            value = (Long)formulaResult;
                            break;
                        }
                        case 4: {
                            value = (Date)formulaResult;
                            break;
                        }
                        case 5: {
                            value = (BigDecimal)formulaResult;
                            break;
                        }
                        case 6: {
                            value = (byte[])formulaResult;
                            break;
                        }
                        case 7: {
                            value = (Boolean)formulaResult;
                            break;
                        }
                        default: {
                            value = null;
                        }
                    }
                }
                if (this.data.replaceIndex[i] < 0) {
                    outputRowData[tempIndex++] = value;
                    continue;
                }
                outputRowData[this.data.replaceIndex[i]] = value;
            }
            return outputRowData;
        }
        catch (Exception e) {
            throw new KettleValueException((Throwable)e);
        }
    }

    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (JaninoMeta)smi;
        this.data = (JaninoData)sdi;
        if (super.init(smi, sdi)) {
            this.data.returnType = new int[this.meta.getFormula().length];
            for (int i = 0; i < this.meta.getFormula().length; ++i) {
                this.data.returnType[i] = -1;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.logBasic("Starting to run...");
                while (this.processRow(this.meta, this.data) && !this.isStopped()) {
                }
                Object var3_1 = null;
            }
            catch (Exception e) {
                this.logError("Unexpected error in  : " + e.toString());
                this.logError(Const.getStackTracker((Throwable)e));
                this.setErrors(1L);
                this.stopAll();
                Object var3_2 = null;
                this.dispose(this.meta, this.data);
                this.logSummary();
                this.markStop();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.dispose(this.meta, this.data);
            this.logSummary();
            this.markStop();
            throw throwable;
        }
        this.dispose(this.meta, this.data);
        this.logSummary();
        this.markStop();
    }
}

