/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.util;

import ca.sqlpower.util.UnknownFreqCodeException;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;

public class Frequency
implements Comparable,
Serializable {
    public static final int YEARLY = 1;
    public static final int QUARTERLY = 2;
    public static final int MONTHLY = 3;
    public static final int WEEKLY = 4;
    public static final int DAILY = 5;
    public static final int HOURLY = 6;
    public static final int MIN_FREQ = 1;
    public static final int MAX_FREQ = 5;
    protected int freq;

    public static int freqCodeToFreq(String fc) throws UnknownFreqCodeException {
        if (fc == null) {
            fc = "";
        }
        if ((fc = fc.toUpperCase()).equals("YEARLY") || fc.equals("YEAR")) {
            return 1;
        }
        if (fc.equals("QUARTERLY") || fc.equals("QUARTER")) {
            return 2;
        }
        if (fc.equals("MONTHLY") || fc.equals("MONTH")) {
            return 3;
        }
        if (fc.equals("WEEKLY") || fc.equals("WEEK")) {
            return 4;
        }
        if (fc.equals("DAILY") || fc.equals("DAY")) {
            return 5;
        }
        if (fc.equals("HOURLY") || fc.equals("HOUR")) {
            return 6;
        }
        throw new UnknownFreqCodeException("unknown freq code: " + fc);
    }

    public static String freqToFreqCode(int freq) throws UnknownFreqCodeException {
        if (freq == 1) {
            return "YEARLY";
        }
        if (freq == 2) {
            return "QUARTERLY";
        }
        if (freq == 3) {
            return "MONTHLY";
        }
        if (freq == 4) {
            return "WEEKLY";
        }
        if (freq == 5) {
            return "DAILY";
        }
        if (freq == 6) {
            return "HOURLY";
        }
        throw new UnknownFreqCodeException("unknown freq: " + freq);
    }

    public static List getListOfFreqsLessThan(Frequency maxFreq) {
        int freqCode = maxFreq.getFreq();
        LinkedList<Frequency> freqList = new LinkedList<Frequency>();
        do {
            freqList.add(new Frequency(freqCode));
        } while (--freqCode >= 1);
        return freqList;
    }

    public Frequency(int freqCode) {
        this.freq = freqCode;
    }

    public int getFreq() {
        return this.freq;
    }

    public void setFreq(int argFreq) {
        this.freq = argFreq;
    }

    public String toString() {
        if (this.freq == 1) {
            return "YEARLY";
        }
        if (this.freq == 2) {
            return "QUARTERLY";
        }
        if (this.freq == 3) {
            return "MONTHLY";
        }
        if (this.freq == 4) {
            return "WEEKLY";
        }
        if (this.freq == 5) {
            return "DAILY";
        }
        if (this.freq == 6) {
            return "HOURLY";
        }
        throw new IllegalStateException("[Frequency: Invalid frequency code " + this.freq + "]");
    }

    public boolean equals(Object other) throws ClassCastException {
        return other != null && ((Frequency)other).freq == this.freq;
    }

    public int hashCode() {
        int result = 17;
        result = 527 + this.freq;
        return result;
    }

    public int compareTo(Object other) throws ClassCastException {
        return this.freq - ((Frequency)other).freq;
    }
}

