/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel.report;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.panel.MigPanel;
import net.sf.freecol.client.gui.panel.report.ReportPanel;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TypeCountMap;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;

public final class ReportLabourPanel
extends ReportPanel {
    private final Map<UnitType, Map<Location, Integer>> data;
    private final TypeCountMap<UnitType> unitCount;
    private final List<Colony> colonies;
    private JList<LabourUnitPanel> panelList = null;

    public ReportLabourPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportLabourAction");
        Player player = this.getMyPlayer();
        this.data = new HashMap<UnitType, Map<Location, Integer>>();
        this.unitCount = new TypeCountMap();
        for (Unit unit : player.getUnitSet()) {
            Location location;
            UnitType type = unit.getType();
            this.unitCount.incrementCount(type, 1);
            Map<Location, Integer> unitMap = this.data.get(type);
            if (unitMap == null) {
                unitMap = new HashMap<Location, Integer>();
                this.data.put(type, unitMap);
            }
            if ((location = unit.getLocation()) == null) {
                logger.warning("Unit has null location: " + unit);
            } else if (location.getSettlement() != null) {
                location = location.getSettlement();
            } else if (unit.isInEurope()) {
                location = player.getEurope();
            } else if (location.getTile() != null) {
                location = location.getTile();
            }
            Integer count = unitMap.get(location);
            if (count == null) {
                unitMap.put(location, 1);
                continue;
            }
            unitMap.put(location, count + 1);
        }
        this.colonies = player.getColonyList();
        DefaultListModel<LabourUnitPanel> model = new DefaultListModel<LabourUnitPanel>();
        for (UnitType unitType : this.getSpecification().getUnitTypeList()) {
            if (!unitType.isPerson() || !unitType.isAvailableTo(player)) continue;
            int count = this.unitCount.getCount(unitType);
            model.addElement(new LabourUnitPanel(freeColClient, unitType, count));
        }
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportLabourPanel.this.showDetails();
            }
        };
        AbstractAction quitAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                ReportLabourPanel.this.getGUI().removeComponent(ReportLabourPanel.this);
            }
        };
        this.panelList = new JList(model);
        this.panelList.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "select");
        this.panelList.getActionMap().put("select", abstractAction);
        this.panelList.getInputMap().put(KeyStroke.getKeyStroke("ESCAPE"), "quit");
        this.panelList.getActionMap().put("quit", quitAction);
        this.panelList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ReportLabourPanel.this.showDetails();
            }
        });
        this.panelList.setOpaque(false);
        this.panelList.setSelectionMode(0);
        this.panelList.setLayoutOrientation(2);
        this.panelList.setCellRenderer(new LabourUnitPanelRenderer());
        this.scrollPane.setViewportView(this.panelList);
    }

    private void showDetails() {
        UnitType unitType = this.panelList.getSelectedValue().unitType;
        if (this.unitCount.getCount(unitType) == 0) {
            return;
        }
        this.getGUI().showReportLabourDetailPanel(unitType, this.data, this.unitCount, this.colonies);
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("OK".equals(command)) {
            super.actionPerformed(ae);
        } else {
            UnitType unitType = this.getSpecification().getUnitType(command);
            this.getGUI().showReportLabourDetailPanel(unitType, this.data, this.unitCount, this.colonies);
        }
    }

    private static class LabourUnitPanelRenderer
    implements ListCellRenderer<LabourUnitPanel> {
        private LabourUnitPanelRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends LabourUnitPanel> list, LabourUnitPanel value, int index, boolean isSelected, boolean cellHasFocus) {
            value.selected = isSelected;
            return value;
        }
    }

    private static class LabourUnitPanel
    extends MigPanel {
        public boolean selected;
        public final UnitType unitType;

        public LabourUnitPanel(FreeColClient freeColClient, UnitType unitType, int count) {
            super(new MigLayout("wrap 2", "[60, right][left]"));
            this.unitType = unitType;
            this.setOpaque(false);
            this.add((Component)new JLabel(new ImageIcon(freeColClient.getGUI().getFixedImageLibrary().getSmallUnitTypeImage(unitType, count == 0))), "spany 2");
            this.add(new JLabel(Messages.getName(unitType)));
            this.add(new JLabel(Integer.toString(count)));
            this.setPreferredSize(this.getPreferredSize());
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.selected) {
                Graphics2D g2d = (Graphics2D)g;
                Composite oldComposite = g2d.getComposite();
                Color oldColor = g2d.getColor();
                g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
                g2d.setColor(Color.BLACK);
                g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
                g2d.setComposite(oldComposite);
                g2d.setColor(oldColor);
            }
            super.paintComponent(g);
        }
    }
}

