/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.maven.tasks;

import java.io.File;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.publish.maven.MavenPom;
import org.gradle.api.publish.maven.internal.dependencies.MavenDependencyInternal;
import org.gradle.api.publish.maven.internal.dependencies.VersionRangeMapper;
import org.gradle.api.publish.maven.internal.publication.MavenPomDependencies;
import org.gradle.api.publish.maven.internal.publication.MavenPomInternal;
import org.gradle.api.publish.maven.internal.tasks.MavenPomFileGenerator;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.UntrackedTask;
import org.gradle.internal.serialization.Cached;
import org.gradle.internal.serialization.Transient;

@UntrackedTask(because="Gradle doesn't understand the data structures used to configure this task")
public abstract class GenerateMavenPom
extends DefaultTask {
    private final Transient.Var<MavenPom> pom = Transient.varOf();
    private final Transient.Var<ImmutableAttributes> compileScopeAttributes = Transient.varOf((Object)ImmutableAttributes.EMPTY);
    private final Transient.Var<ImmutableAttributes> runtimeScopeAttributes = Transient.varOf((Object)ImmutableAttributes.EMPTY);
    private Object destination;
    private final Cached<MavenPomFileGenerator.MavenPomSpec> mavenPomSpec = Cached.of(this::computeMavenPomSpec);

    @Inject
    protected FileResolver getFileResolver() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected VersionRangeMapper getVersionRangeMapper() {
        throw new UnsupportedOperationException();
    }

    public GenerateMavenPom withCompileScopeAttributes(ImmutableAttributes compileScopeAttributes) {
        this.compileScopeAttributes.set((Object)compileScopeAttributes);
        return this;
    }

    public GenerateMavenPom withRuntimeScopeAttributes(ImmutableAttributes runtimeScopeAttributes) {
        this.runtimeScopeAttributes.set((Object)runtimeScopeAttributes);
        return this;
    }

    @Internal
    public MavenPom getPom() {
        return (MavenPom)this.pom.get();
    }

    public void setPom(MavenPom pom) {
        this.pom.set((Object)pom);
    }

    @OutputFile
    public File getDestination() {
        return this.destination == null ? null : this.getFileResolver().resolve(this.destination);
    }

    public void setDestination(File destination) {
        this.destination = destination;
    }

    public void setDestination(Object destination) {
        this.destination = destination;
    }

    @TaskAction
    public void doGenerate() {
        this.mavenPomSpec().writeTo(this.getDestination());
    }

    private MavenPomFileGenerator.MavenPomSpec mavenPomSpec() {
        return (MavenPomFileGenerator.MavenPomSpec)this.mavenPomSpec.get();
    }

    private MavenPomFileGenerator.MavenPomSpec computeMavenPomSpec() {
        MavenPomInternal pomInternal = (MavenPomInternal)this.getPom();
        MavenPomFileGenerator pomGenerator = new MavenPomFileGenerator(pomInternal.getProjectIdentity(), this.getVersionRangeMapper(), pomInternal.getVersionMappingStrategy(), (ImmutableAttributes)this.compileScopeAttributes.get(), (ImmutableAttributes)this.runtimeScopeAttributes.get(), pomInternal.writeGradleMetadataMarker());
        pomGenerator.configureFrom(pomInternal);
        MavenPomDependencies dependencies = (MavenPomDependencies)pomInternal.getDependencies().get();
        for (MavenDependencyInternal mavenDependency : dependencies.getApiDependencyManagement()) {
            pomGenerator.addCompileDependencyManagement(mavenDependency);
        }
        for (MavenDependencyInternal mavenDependency : dependencies.getRuntimeDependencyManagement()) {
            pomGenerator.addRuntimeDependencyManagement(mavenDependency);
        }
        for (MavenDependencyInternal mavenDependency : dependencies.getImportDependencyManagement()) {
            pomGenerator.addImportDependencyManagement(mavenDependency);
        }
        for (MavenDependencyInternal apiDependency : dependencies.getApiDependencies()) {
            pomGenerator.addCompileDependency(apiDependency);
        }
        for (MavenDependencyInternal runtimeDependency : dependencies.getRuntimeDependencies()) {
            pomGenerator.addRuntimeDependency(runtimeDependency);
        }
        for (MavenDependencyInternal optionalApiDependency : dependencies.getOptionalApiDependencies()) {
            pomGenerator.addOptionalCompileDependency(optionalApiDependency);
        }
        for (MavenDependencyInternal optionalRuntimeDependency : dependencies.getOptionalRuntimeDependencies()) {
            pomGenerator.addOptionalRuntimeDependency(optionalRuntimeDependency);
        }
        pomGenerator.withXml(pomInternal.getXmlAction());
        return pomGenerator.toSpec();
    }
}

