/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.collections.MinimalFileTree;
import org.gradle.api.internal.file.collections.SingleIncludePatternFileTree;
import org.gradle.internal.FileUtils;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.DefaultLocallyAvailableResource;
import org.gradle.internal.resource.local.FileStoreAddActionException;
import org.gradle.internal.resource.local.FileStoreException;
import org.gradle.internal.resource.local.LocallyAvailableResource;
import org.gradle.internal.resource.local.PathKeyFileStore;
import org.gradle.util.internal.GFileUtils;
import org.gradle.util.internal.PathTraversalChecker;
import org.gradle.util.internal.RelativePathUtil;

@NonNullApi
public class DefaultPathKeyFileStore
implements PathKeyFileStore {
    private final ChecksumService checksumService;
    public static final String IN_PROGRESS_MARKER_FILE_SUFFIX = ".fslck";
    private File baseDir;

    public DefaultPathKeyFileStore(ChecksumService checksumService, File baseDir) {
        this.checksumService = checksumService;
        this.baseDir = baseDir;
    }

    protected File getBaseDir() {
        return this.baseDir;
    }

    private File getFile(String ... path) {
        String composedPath = path.length == 1 ? path[0] : Arrays.stream(path).filter(((Predicate<String>)String::isEmpty).negate()).collect(Collectors.joining(File.separator));
        return new File(this.baseDir, PathTraversalChecker.safePathName((String)DefaultPathKeyFileStore.trimLeadingSlash(composedPath)));
    }

    private File getFileWhileCleaningInProgress(String ... path) {
        File file = this.getFile(path);
        File markerFile = this.getInProgressMarkerFile(file);
        if (markerFile.exists()) {
            DefaultPathKeyFileStore.deleteFileQuietly(file);
            DefaultPathKeyFileStore.deleteFileQuietly(markerFile);
        }
        return file;
    }

    public LocallyAvailableResource add(final String path, final Action<File> addAction) {
        try {
            return this.doAdd(path, new Action<File>(){

                public void execute(File file) {
                    try {
                        addAction.execute((Object)file);
                    }
                    catch (Throwable e) {
                        throw new FileStoreAddActionException(String.format("Failed to add into filestore '%s' at '%s' ", DefaultPathKeyFileStore.this.getBaseDir().getAbsolutePath(), path), e);
                    }
                }
            });
        }
        catch (FileStoreAddActionException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to add into filestore '%s' at '%s' ", this.getBaseDir().getAbsolutePath(), path), e);
        }
    }

    public LocallyAvailableResource move(String path, final File source) {
        if (!source.exists()) {
            throw new FileStoreException(String.format("Cannot move '%s' into filestore @ '%s' as it does not exist", source, path));
        }
        try {
            return this.doAdd(path, new Action<File>(){

                public void execute(File file) {
                    if (source.isDirectory()) {
                        GFileUtils.moveExistingDirectory((File)source, (File)file);
                    } else {
                        GFileUtils.moveExistingFile((File)source, (File)file);
                    }
                }
            });
        }
        catch (Throwable e) {
            throw new FileStoreException(String.format("Failed to move file '%s' into filestore at '%s' ", source, path), e);
        }
    }

    private LocallyAvailableResource doAdd(String path, Action<File> action) {
        File destination = this.getFile(path);
        this.doAdd(destination, action);
        return this.entryAt(path);
    }

    protected void doAdd(File destination, Action<File> action) {
        GFileUtils.parentMkdirs((File)destination);
        File inProgressMarkerFile = this.getInProgressMarkerFile(destination);
        GFileUtils.touch((File)inProgressMarkerFile);
        try {
            org.apache.commons.io.FileUtils.deleteQuietly((File)destination);
            action.execute((Object)destination);
        }
        catch (Throwable t) {
            org.apache.commons.io.FileUtils.deleteQuietly((File)destination);
            throw UncheckedException.throwAsUncheckedException((Throwable)t);
        }
        finally {
            DefaultPathKeyFileStore.deleteFileQuietly(inProgressMarkerFile);
        }
    }

    public Set<? extends LocallyAvailableResource> search(String pattern) {
        if (!this.getBaseDir().exists()) {
            return Collections.emptySet();
        }
        final HashSet entries = new HashSet();
        this.findFiles(pattern).visit((FileVisitor)new EmptyFileVisitor(){

            public void visitFile(FileVisitDetails fileDetails) {
                File file = fileDetails.getFile();
                if (!DefaultPathKeyFileStore.this.isInProgressMarkerFile(file) && !DefaultPathKeyFileStore.this.isInProgressFile(file)) {
                    entries.add(DefaultPathKeyFileStore.this.entryAt(file));
                }
            }
        });
        return entries;
    }

    private File getInProgressMarkerFile(File file) {
        return new File(file.getParent(), file.getName() + IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressMarkerFile(File file) {
        return FileUtils.hasExtension((File)file, (String)IN_PROGRESS_MARKER_FILE_SUFFIX);
    }

    private boolean isInProgressFile(File file) {
        return this.getInProgressMarkerFile(file).exists();
    }

    private MinimalFileTree findFiles(String pattern) {
        return new SingleIncludePatternFileTree(this.baseDir, pattern);
    }

    protected LocallyAvailableResource entryAt(File file) {
        return this.entryAt(RelativePathUtil.relativePath(this.baseDir, file));
    }

    protected LocallyAvailableResource entryAt(String path) {
        return new DefaultLocallyAvailableResource(this.getFile(path), this.checksumService);
    }

    public LocallyAvailableResource get(String ... path) {
        File file = this.getFileWhileCleaningInProgress(path);
        if (file.exists()) {
            return new DefaultLocallyAvailableResource(this.getFile(path), this.checksumService);
        }
        return null;
    }

    private static void deleteFileQuietly(File file) {
        file.delete();
    }

    private static String trimLeadingSlash(String composedPath) {
        if (!composedPath.isEmpty() && composedPath.charAt(0) == '/') {
            return composedPath.substring(1);
        }
        return composedPath;
    }
}

