### deutsch.tcl:
#  German language support for Scid.
#  Contributors: Bernhard Bialas, Jrgen Clos et al.
#  Untranslated messages are marked with a "***" comment.
#
#  Hinweis (aus tcl/lang/english.tcl):
#
# (4) [...]
#
#     A menu command has the format:
#         menuText L tag "Name..." underline {HelpMessage...}
#
#     [...]
#
#     where "L" is the language letter, "tag" is the name of the menu entry
#     or the button widget name, and "underline" is the index of the letter
#     to underline, counting from zero as the first letter. Two menu entries
#     that appear in the same menu should have a different underlined letter.

proc setLanguage_D {} {

# File menu:
menuText D File "Datei" 0
menuText D FileNew "Neu..." 0 {Neue Scid-Datenbank anlegen}
menuText D FileOpen "ffnen..." 0 {Existierende Scid-Datenbank ffnen}
menuText D FileClose "Schlieen" 0 {Aktive Scid-Datenbank schlieen}
menuText D FileFinder "Dateisuche" 0 {Dateisuchfenster ffnen}
menuText D FileBookmarks "Lesezeichen" 0 {Lesezeichenmen}
menuText D FileBookmarksAdd "Lesezeichen zur Liste hinzufgen" 0 \
  {Lesezeichen fr die aktuelle Partie und Datenbank}
menuText D FileBookmarksFile "Lesezeichen hinzufgen in Verzeichnis" 26 \
  {Lesezeichen fr die aktuelle Stellung und Partie zum Verzeichnis hinzufgen}
menuText D FileBookmarksEdit "Lesezeichen editieren..." 12 \
  {Lesezeichen bearbeiten}
menuText D FileBookmarksList "Listenansicht" 1 \
  {Lesezeichen als Liste zeigen, ohne Unterverzeichnisse}
menuText D FileBookmarksSub "Verzeichnisansicht" 3 \
  {Lesezeichen in Verzeichnissen zeigen, nicht als Gesamtliste}
menuText D FileMaint "Wartung" 0 {Das Scid-Datenbankwartungsfenster}
menuText D FileMaintWin "Wartungfenster" 0 \
  {Datenbank-Wartungsfenster ffnen/schlieen}
menuText D FileMaintCompact "Datenbank komprimieren..." 10 \
  {Datenbank komprimieren, gelschte Spiele und unbenutzte Namen entfernen}
menuText D FileMaintClass "Partien ECO-klassifizieren..." 8 \
{Neuklassifizierung aller Partien nach dem ECO-Code}
menuText D FileMaintSort "Sortieren..." 0 \
  {Alle Partien in der aktuellen Datenbank sortieren}
menuText D FileMaintDelete "Dubletten lschen..." 0 \
  {Dubletten finden und Lschkennzeichen setzen}
menuText D FileMaintTwin "Dubletten prfen" 10 \
  {Dublettenfenster ffnen/erneuern}
menuText D FileMaintName "Namen" 0 \
  {Namenseditor und Rechtschreibprfung}
menuText D FileMaintNameEditor "Namenseditor" 0 \
  {Namenseditorfenster ffnen/schlieen}
menuText D FileMaintNamePlayer "Schreibkorrektur Spieler..." 17 \
  {Schreibkorrektur der Spielernamen mit Hilfe der .ssp-Datei}
menuText D FileMaintNameEvent "Schreibkorrektur Ereignis..." 17 \
  {Schreibkorrektur der Ereignisse mit Hilfe der .ssp-Datei}
menuText D FileMaintNameSite "Schreibkorrektur Ort..." 17 \
  {Schreibkorrektur der Orte mit Hilfe der .ssp-Datei}
menuText D FileMaintNameRound "Schreibkorrektur Runde..." 17 \
  {Schreibkorrektur der Runden mit Hilfe der .ssp-Datei}
menuText D FileReadOnly "Schreibschutz..." 3 \
  {Datenbank als schreibgeschtzt behandeln, nderungen verhindern}
menuText D FileSwitch "Datenbank wechseln" 0 \
  {Zu einer anderen geffneten Datenbank umschalten}
menuText D FileExit "Ende" 0 {Scid beenden}
menuText D FileMaintFixBase "Inkonsistenzen beseitigen" 0 {Versuche eine inkonsistente Datenbank zu reparieren}

# Edit menu:
menuText D Edit "Bearbeiten" 0
menuText D EditAdd "Variante hinzufgen" 0 \
  {Fge zu diesem Zug eine Variante hinzu}
menuText D EditDelete "Variante lschen" 9 \
  {Lsche eine Variante zu diesen Zug}
menuText D EditFirst "Als erste Variante setzen" 4 \
  {Variante an erste Stelle in der Liste setzten}
menuText D EditMain "Variante als Partiefortsetzung" 13 \
  {Variante zur Partiefolge machen (und umgekehrt)}
menuText D EditTrial "Variante testen" 9 \
  {Testmodus starten/stoppen, um eine Idee am Brett auszuprobieren}
menuText D EditStrip "Entfernen" 1 \
   {Kommentare oder Varianten aus der Partie entfernen}
menuText D EditUndo "Rckgngig" 0 {Macht die letzte nderung rckgngig}
menuText D EditRedo "Wiederherstellen" 0 {Redo last game change}
menuText D EditStripComments "Kommentare" 0 \
  {Alle Kommentare und Kommentarzeichen aus dieser Partie entfernen}
menuText D EditStripVars "Varianten" 0 \
  {Alle Varianten aus der Partie entfernen}
menuText D EditStripBegin "Zge ab Anfang" 8 \
  {Entferne Zge ab Partieanfang}
menuText D EditStripEnd "Zge bis Ende" 9 \
  {Entferne Zge bis Partieende}
menuText D EditReset "Ablage leeren" 0 \
   {Inhalt der Ablage-Datenbank lschen}
menuText D EditCopy "Partie in Ablage kopieren" 17 \
  {Diese Partie in die Ablage-Datenbank kopieren}
menuText D EditPaste "Partie aus Ablage einfgen" 19 \
  {Die aktuele Partie aus der Ablagedatenbank hier einfgen}
menuText D EditPastePGN "PGN-Partie aus Ablage einfgen..." 1 \
  {Interpretiere den Inhalt der Zwischenablage als PGN-Notation und fge ihn hier ein}
menuText D EditSetup "Stellungseingabe..." 0 \
  {Neue Stellung eingeben (FEN oder manuell)}
menuText D EditCopyBoard "Stellung kopieren" 10 \
  {Aktuelle Brettposition in die Zwischenablage kopieren (im FEN-Format)}
menuText D EditPasteBoard "Stellung einfgen" 12 \
  {Stellung aus der Zwischenablage (im FEN-Format) einfgen}
menuText D ConfigureScid "Einstellungen..." 0 {Alle Optionen fr SCID einstellen}

# Game menu:
menuText D Game "Partie" 0
menuText D GameNew "Neue Partie" 5 {Neue Partie beginnen}
menuText D GameFirst "Erste Partie laden" 0 {Erste Partie im Filter laden}
menuText D GamePrev "Vorherige Partie laden" 0 \
  {Vorherige Partie im Filter laden}
menuText D GameReload "Partie wiederladen" 7 \
  {Diese Partie erneut laden, dabei alle nderungen verwerfen}
menuText D GameNext "Nchste Partie laden" 0 {Nchste Partie im Filter laden}
menuText D GameLast "Letzte Partie laden" 0 {Letzte Partie im Filter laden}
menuText D GameRandom "Zufllige Partie laden" 1 \
  {Zufllig ausgewhlte Partie im Filter laden}
menuText D GameNumber "Lade Partie Nummer..." 14 \
  {Partie durch Angabe der Nummer laden}
menuText D GameReplace "Partie ersetzen..." 8 \
  {Diese Partie sichern, dabei alte Version berschreiben}
menuText D GameAdd "Partie speichern..." 7 \
  {Diese Partie als neue Partie in der Datenbank sichern}
menuText D GameDeepest "Erffnung identifizieren" 10 \
  {Zur Position der lngstmglichen Zugfolge nach ECO-Klassifikation gehen}
menuText D GameGotoMove "Zugnummer..." 0 \
  {Zur angegebenen Zugnummer in der aktuellen Partie gehen}
menuText D GameNovelty "Finde Neuerung..." 0 \
  {Ersten Zug dieser Partie finden, der vorher noch nie gespielt wurde}

# Search menu:
menuText D Search "Suchen" 0
menuText D SearchReset "Filter zurcksetzen" 0 \
  {Alle Partien in den Filter einschlieen}
menuText D SearchNegate "Filter invertieren" 7 \
  {Alle ausgeschlossenen Partien in den Filter nehmen}
menuText D SearchCurrent "Brett..." 0 \
  {Aktuelle Brettposition suchen}
menuText D SearchHeader "Partiedaten..." 0 \
  {Partiedaten (Spieler, Turnier etc.) suchen}
menuText D SearchMaterial "Material/Muster..." 0 \
  {Nach Material- oder Stellungsmustern suchen}
menuText D SearchUsing "Mit Suchoptionsdatei..." 4 \
  {Mit Suchoptionsdatei suchen}

# Windows menu:
menuText D Windows "Fenster" 0
menuText D WindowsComment "Kommentareditor" 0 {Kommentareditor ffnen/schlieen}
menuText D WindowsGList "Partieliste" 6 {Partieliste ffnen/schlieen}
menuText D WindowsPGN "PGN-Fenster" 0 {PGN-Fenster (Partienotation) ffnen/schlieen}
menuText D WindowsPList "Spielersuche" 0 {Spielersuche ffnen/schlieen}
menuText D WindowsTmt "Turniersuche" 0 {Turniersuche ffnen/schlieen}
menuText D WindowsSwitcher "Datenbank-Umschalter" 0 \
  {Datenbank-Umschalter ffnen/schlieen}
menuText D WindowsMaint "Wartungsfenster" 0 {(Datenbank-)Wartungsfenster ffnen/schlieen}
menuText D WindowsECO "ECO-Auswertung" 0 {ECO-Auswertung ffnen/schlieen}
menuText D WindowsStats "Statistik" 4 {Filterstatistik ffnen/schlieen}
menuText D WindowsTree "Zugbaum" 0 {Zugbaum ffnen/schlieen}
menuText D WindowsTB "Endspieltabellen..." 1 {Endspieltabellen ffnen/schlieen}
menuText D WindowsBook "Buchfenster" 0 {Buchfenster ffnen/schlieen}
menuText D WindowsCorrChess "Fernschachfenster" 0 {ffnet/schliet das Fernschachfenster}

# Tools menu:
menuText D Tools "Werkzeuge" 0
menuText D ToolsConfigureEngines "Engine konfigurieren" 10 {Manage engines' configuration}
menuText D ToolsAnalysis "Analyse-Engine..." 0 \
  {Schachanalyse-Programm starten/beenden}
menuText D ToolsAnalysis2 "Analyse-Engine #2..." 16 \
  {Schachanalyse-Programm Nr.2 starten/beenden}
menuText D ToolsCross "Turniertabelle" 0 {Turniertabelle fr diese Partie anzeigen}
menuText D ToolsFilterGraph "Rel. Filtergrafik" 0 \
  {Filtergrafik mit relativen Werten ffnen/schlieen}
menuText D ToolsAbsFilterGraph "Abs. Filtergrafik" 11 \
  {Filtergrafik mit absoluten Werten ffnen/schlieen}
menuText D ToolsOpReport "Erffnungsbericht" 0 \
  {Ausfhrliche Erffnungsbersicht fr die aktuelle Position erstellen}
menuText D ToolsOpenBaseAsTree "ffne DB als Baum" 0   {ffne DB und verwende sie im Zugbaum-Fenster}
menuText D ToolsOpenRecentBaseAsTree "Letzte DB als Baum" 0   {ffne zuletzt verwendete DB im Zugbaum-Fenster}
menuText D ToolsTracker "Figurenverteilung"  7 \
  {Figurenverteilungsfenster ffnen}
menuText D ToolsTraining "Training"  0 {Trainingswerkzeuge (Taktik, Erffnungen,...) }
menuText D ToolsTacticalGame "Trainingspartie"  0 {Trainingspartie spielen}
menuText D ToolsSeriousGame "Ernste Partie"  0 {Ernste Partie spielen}
menuText D ToolsTrainOpenings "Erffnungen"  0 {Erffnungsrepertoire trainieren}
menuText D ToolsTrainReviewGame "Partie nachspielen"  0 {Finden von Zgen wie in vorgegebener Partie}
menuText D ToolsTrainTactics "Taktik"  0 {Taktische Stellungen lsen}
menuText D ToolsTrainCalvar "Varianten berechnen"  0 {Training zum Berechnen von Varianten}
menuText D ToolsTrainFindBestMove "Besten Zug finden"  0 {Find best move}
menuText D ToolsTrainFics "Internetpartie (FICS)"  0 {Internetpartie auf freechess.org}
menuText D ToolsEngineTournament "Engine Turnier"  0 {Start a tournament between chess engines}
menuText D ToolsBookTuning "Buch abstimmen" 0 {Buch abstimmen}
menuText D ToolsConnectHardware "Hardware verbinden" 0 {Externe Hardware mit Scid verbinden}
menuText D ToolsConnectHardwareConfigure "Konfigurieren..." 0 {Hardware und Verbindung konfigurieren}
menuText D ToolsConnectHardwareNovagCitrineConnect "Novag Citrine verbinden" 0 {Novag Citrine mit Scid verbinden}
menuText D ToolsConnectHardwareInputEngineConnect "Input Engine verbinden" 0 {Input Engine (z.B. DGT Brett) mit Scid verbinden}
menuText D ToolsPInfo "Spielerinformation"  0 \
  {Spielerinformation ffnen/schlieen}
menuText D ToolsPlayerReport "Spielerbericht..." 7 \
  {Erzeuge einen Spielerbericht}
menuText D ToolsRating "ELO-Zahl-Verlauf" 4 \
  {Wertungsverlauf beider Spieler grafisch darstellen}
menuText D ToolsScore "Partiebewertung" 0 {Partie-Bewertung und Zeitverbrauch anzeigen}
menuText D ToolsExpCurrent "Partie exportieren" 8 \
  {Aktuelle Partie in eine Textdatei schreiben}
menuText D ToolsExpCurrentPGN "Partie in PGN-Datei exportieren..." 10 \
  {Aktuelle Partie in eine PGN-Datei schreiben}
menuText D ToolsExpCurrentHTML "Partie in HTML-Datei exportieren..." 10 \
  {Aktuelle Partie in eine HTML-Datei schreiben}
menuText D ToolsExpCurrentHTMLJS "Partie in HTML/JavaScript-Datei exportieren..." 15 {Aktuelle Partie wird in eine HTML und JavaScript Datei exportiert.}  
menuText D ToolsExpCurrentLaTeX "Partie in LaTeX-Datei exportieren..." 10 \
  {Aktuelle Partie in eine LaTeX-Datei schreiben}
menuText D ToolsExpFilter "Alles im Filter exportieren" 16 \
  {Alle Partien im Filter in eine Textdatei schreiben}
menuText D ToolsExpFilterPGN "Filter in PGN-Datei exportieren..." 10 \
  {Alle Partien im Filter in eine PGN-Datei schreiben}
menuText D ToolsExpFilterHTML "Filter in HTML-Datei exportieren..." 10 \
  {Alle Partien im Filter in eine HTML-Datei schreiben}
menuText D ToolsExpFilterHTMLJS "Filter in HTML/JavaScript exportieren..." 17 {Alle Partien im Filter werden in eine HTML und JavaScript Datei exportiert.}  
menuText D ToolsExpFilterLaTeX "Filter in LaTeX-Datei exportieren..." 10 \
  {Alle Partien im Filter in eine LaTeX-Datei schreiben}
menuText D ToolsImportOne "Eine PGN-Partie importieren..." 16 \
  {Eine Partie im PGN-Format eingeben oder einfgen}
menuText D ToolsImportFile "PGN-Partien importieren..." 0 \
  {Partien aus einer PGN-Datei lesen}
menuText D ToolsStartEngine1 "Starte Engine1" 0  {Starte Analyse von Analyse-Engine1}
menuText D ToolsStartEngine2 "Starte Engine2" 0  {Starte Analyse von Analyse-Engine2}
menuText D ToolsCaptureBoard "Brettfoto..." 0  {Aktuelles Brett als Bild speichern.}
#-----AW------
###  BC   GHIJKL  O Q  TUV XY 
menuText D Play "Spielen" 0 {Partien spielen}
menuText D CCResign "Aufgeben" 0 {Partie aufgeben (funktioniert nicht via eMail)}
menuText D CCClaimDraw "Remis erklren" 1 {Zug senden und Partie Remis erklren (funktioniert nicht via eMail)}
#-----AW------

# Options menu:
menuText D Options "Optionen" 0
menuText D OptionsBoardGraphics "Brettfelder..." 3 {Grafik fr Brettfelder auswhlen}
translate D OptionsBGW {Grafikdatei fr Felder auswhlen}
translate D OptionsBoardGraphicsText {Grafikdateien fr helle und dunkle Felder auswhlen:}
menuText D OptionsBoardNames "Meine Spielernamen..." 0 {Editiere meine Spielernamen}
menuText D OptionsExport "Export" 1 {Textausgabeoptionen ndern}
menuText D OptionsFonts "Schriftarten" 3 {Schriftarten auswhlen}
menuText D OptionsFontsRegular "Normal" 0 {Standardzeichensatz}
menuText D OptionsFontsMenu "Men" 0 {Schriftart fr Mens}
menuText D OptionsFontsSmall "Klein" 0 {Kleine Zeichen}
menuText D OptionsFontsTiny "Winzig" 0 {Kleinster Font}
menuText D OptionsFontsFixed "Fest" 0 {Schriftart mit fester Breite (nicht-proportional)}
menuText D OptionsGInfo "Partieinformation" 0 {Optionen fr Informationsbereich}
menuText D OptionsLanguage "Sprache" 0 {Sprache whlen}
menuText D OptionsMovesTranslatePieces "Figurennamen bersetzen" 0 {bersetze den ersten Buchstaben der Figurenbezeichnung}
menuText D OptionsMovesHighlightLastMove "Letzen Zug hervorheben" 0 {Rahmt Start- und Zielfeld des letzten Zuges farbig ein}
menuText D OptionsMovesHighlightLastMoveDisplay "Anzeigen" 0 {Hervorhebung des letzen Zuges anzeigen}
menuText D OptionsMovesHighlightLastMoveWidth "Dicke" 0 {Dicke der Linie}
menuText D OptionsMovesHighlightLastMoveColor "Farbe" 0 {Farbe der Linie}
menuText D OptionsMovesHighlightLastMoveArrow "inklusive Pfeil" 0 {Pfeil ebenfalls hervorheben}
menuText D OptionsMoves "Zge" 0 {Zugeingabeoptionen}
menuText D OptionsMovesAnimate "Animation" 0 \
  {Zeit fr Zuganimation einstellen}
menuText D OptionsMovesDelay "Autom. Vorspielen..." 7 \
  {Zeit fr automatisches Vorspielen einstellen}
menuText D OptionsMovesCoord "Tastatureingabe" 0 \
  {Zugeingabe ber Koordinaten ("g1f3") akzeptieren}
menuText D OptionsMovesSuggest "Zugvorschlag zeigen" 0 \
  {Zugvorschlag ein-/ausschalten}
menuText D OptionsShowVarPopup "Variantenfenster zeigen" 0 { Anzeige des Variantenauswahlfensters ein/ausschalten}  
menuText D OptionsMovesSpace "Leerzeichen nach Zugnummer einfgen" 0 {Leerzeichen nach Zugnummer einfgen}  
menuText D OptionsMovesKey "Autom. Zugergnzung" 10 \
  {Automatische Zugergnzung ein-/ausschalten}
menuText D OptionsMovesShowVarArrows "Pfeile fr Varianten anzeigen" 0 {Zeige Pfeile in Varianten an: ja/nein}
menuText D OptionsMovesGlossOfDanger "Bedrohte Figuren einfrben" 0 {Markieren von gefrdeten Figuren ein/ausschalten}
menuText D OptionsNumbers "Zahlenformat" 5 {Zahlenformat whlen}
menuText D OptionsTheme "Design" 0 {Verndert das Aussehen der Oberflche}
menuText D OptionsWindows "Fenster" 6 {Fenster-Optionen}
menuText D OptionsSounds "Sprachausgabe" 0 {Sprachausgabe fr Zugankndigung einstellen}
menuText D OptionsResources "Ressourcen..." 0 {Standard Dateien und Verzeichnisse einstellen}
menuText D OptionsWindowsDock "Fenster anheften" 0 {Fenster in der Hauptanwendung ffnen}
menuText D OptionsWindowsSaveLayout "Layout speichern" 0 {Speichern des aktuellen Fensterlayout}
menuText D OptionsWindowsRestoreLayout "Layout laden" 0 {Gespeichertes Fensterlayout wieder herstellen}
menuText D OptionsWindowsShowGameInfo "Partieinformationen" 0 {Partieinformation anzeigen}
menuText D OptionsWindowsAutoLoadLayout "Automatisch laden: 1. Layout" 0 {Ldt das erste definierte Layout automatisch beim Programmstart}
menuText D OptionsECO "ECO-Datei" 0 {ECO-Klassifikationsdatei laden}
menuText D OptionsSpell "Schreibkorrekturdatei" 7 \
  {Datei fr Scid-Rechtschreibprfung laden}
menuText D OptionsTable "Verzeichnisse der Endspieltabellen" 16 \
  {Eine Endspieltabellendatei whlen (und damit alle Tabellen in diesem Verzeichnis)}
menuText D OptionsRecent "Letzte Dateien" 9 \
   {Anzahl der aktuellen Dateien im Dateimen ndern}
menuText D OptionsBooksDir "Verzeichnis fr Erffnungsbcher" 0 {Erffnungsbuchverzeichnis einstellen}
menuText D OptionsTacticsBasesDir "Verzeichnis fr Taktikdatenbanken" 0 {Verzeichnis fr taktische Trainingsdatenbanken einstellen}
menuText D OptionsPhotosDir "Verzeichnis fr Spielerbilder" 0 {Verzeichnis fr Bilder einstellen}
menuText D OptionsThemeDir "Datei mit Design(s)"  0 { Packetdatei fr GUI Design Themen einstellen }
menuText D OptionsSave "Optionen speichern" 0 \
  "Alle einstellbaren Optionen in der Datei $::optionsFile sichern"
menuText D OptionsAutoSave "Speichern beim Beenden" 0 \
  {Alle Optionen beim Beenden von Scid automatisch speichern}

# Help menu:
menuText D Help "Hilfe" 0
menuText D HelpContents "Inhalt" 0 {Gehe zum Inhaltsverzeichnis}
menuText D HelpIndex "Index" 4 {Gehe zum Hilfeindex}
menuText D HelpGuide "Kurzanleitung" 4 {Ein Scid-Schnelldurchgang}
menuText D HelpHints "Hinweise" 0 {Die Scid-Kurztips}
menuText D HelpContact "Kontaktinformation" 0 {Hilfe zur Kontaktinformation}
menuText D HelpTip "Tagestip" 0 {Zeigt einen ntzlichen Tip an}
menuText D HelpStartup "Startfenster" 0 {Startfenster zeigen}
menuText D HelpAbout "ber Scid" 0 {Informationen zu Scid}

# Game info box popup menu:
menuText D GInfoHideNext "Nchsten Zug verbegen" 13
menuText D GInfoMaterial "Materialwerte zeigen" 0
menuText D GInfoFEN "FEN zeigen" 0
menuText D GInfoMarks "Gefrbte Felder und Pfeile zeigen" 0
menuText D GInfoWrap "Umbruch bei langen Zeilen" 0
menuText D GInfoFullComment "Vollstndigen Kommentar zeigen" 14
menuText D GInfoPhotos "Fotos zeigen" 1
menuText D GInfoTBNothing "Endspieltabellen: nichts" 18
menuText D GInfoTBResult "Endspieltabellen: nur Ergebnis" 22
menuText D GInfoTBAll "Endspieltabellen: Ergebnis und bester Zug" 31
menuText D GInfoDelete "(Ent)Lsche diese Partie" 5
menuText D GInfoMark "(Un)Markiere diese Partie" 4
menuText D GInfoInformant "Informatorwerte konfigurieren" 0

# General buttons:
translate D Back {Zurck}
translate D Browse {Auswhlen}
translate D Cancel {Abbrechen}
translate D Continue {Weiter}
translate D Clear {Leeren}
translate D Close {Schlieen}
translate D Contents {Inhalt}
translate D Defaults {Standard}
translate D Delete {Lsche}
translate D Graph {Grafik}
translate D Help {Hilfe}
translate D Hide {Verbergen}
translate D Import {Importieren}
translate D Index {Index}
translate D LoadGame {Partie laden}
translate D BrowseGame {Partie betrachten}
translate D MergeGame {Partie zusammenfgen}
translate D MergeGames {Partien kombinieren}
translate D Preview {Vorschau} ;# Voransicht!? (KDE)
translate D Revert {Umkehren}
translate D Save {Speichern}
translate D Search {Suchen}
translate D Stop {Halt}
translate D Store {Speichern}
translate D Update {Aktualisieren}
translate D ChangeOrient {Fensterausrichtung ndern}
translate D ShowIcons {Symbole anzeigen}
translate D None {Keine}
translate D First {Erste}
translate D Current {Aktuelle}
translate D Last {Letzte}

# General messages:
translate D game {Partie}
translate D games {Partien}
translate D move {Zug}
translate D moves {Zge}
translate D all {Alle}
translate D Yes {Ja}
translate D No {Nein}
translate D Both {Beide}
translate D King {Knig}
translate D Queen {Dame}
translate D Rook {Turm}
translate D Bishop {Lufer}
translate D Knight {Springer}
translate D Pawn {Bauer}
translate D White {Wei}
translate D Black {Schwarz}
translate D Player {Spieler}
translate D Rating {Elo}
translate D RatingDiff {Elo-Differenz (Wei - Schwarz)}
translate D AverageRating {Elo-Durchschnitt}
translate D Event {Turnier}
translate D Site {Ort}
translate D Country {Land}
translate D IgnoreColors {Farben ignorieren}
translate D Date {Datum}
translate D EventDate {Turnierdatum}
translate D Decade {Dekade}
translate D Year {Jahr}
translate D Month {Monat}
translate D Months {Januar Februar Mrz April Mai Juni Juli August September Oktober November Dezember}
translate D Days {Son Mon Die Mit Don Fre Sam}
translate D YearToToday {-1J}
translate D YearToTodayTooltip {Setze das Datum 1 Jahr zurck bis heute}
translate D Result {Ergebnis}
translate D Round {Runde}
translate D Length {Lnge}
translate D ECOCode {ECO-Code}
translate D ECO {ECO}
translate D Deleted {Gelscht}
translate D SearchResults {Suchergebnisse}
translate D OpeningTheDatabase {Datenbank ffnen}
translate D Database {Datenbank}
translate D Filter {Filter}
translate D noGames {keine Partien}
translate D allGames {alle Partien}
translate D empty {leer}
translate D clipbase {Ablage}
translate D score {Punkte}
translate D StartPos {Stellung}
translate D Total {Summe}
translate D readonly {schreibgeschtzt}

# Standard error messages:
translate D ErrNotOpen {Dies ist keine geffnete Datenbank.}
translate D ErrReadOnly \
  {Diese Datenbank ist schreibgeschtzt; sie kann nicht gendert werden.}
translate D ErrSearchInterrupted \
  {Suche wurde unterbrochen; Ergebnisse sind unvollstndig.}

# Game information:
translate D twin {Dublette}
translate D deleted {gelscht}
translate D comment {Kommentar}
translate D hidden {versteckt}
translate D LastMove {letzter Zug}
translate D NextMove {nchster Zug}
translate D GameStart {Partieanfang}
translate D LineStart {Beginn der Zugfolge}
translate D GameEnd {Partieende}
translate D LineEnd {Ende der Zugfolge}

# Player information:
translate D PInfoAll {Ergebnisse fr <b>alle</b> Spiele}
translate D PInfoFilter {Ergebnisse fr <b>Filter</b>-Spiele}
translate D PInfoAgainst {Ergebnisse gegen}
translate D PInfoMostWhite {Hufigste Erffnungen als Weier}
translate D PInfoMostBlack {Hufigste Erffnungen als Schwarzer}
translate D PInfoRating {ELO-Historie}
translate D PInfoBio {Biographie}
translate D PInfoEditRatings {Editiere Ratings}
translate D PInfoEloFile {Datei}

# Tablebase information:
translate D Draw {Remis}
translate D stalemate {Patt}
translate D withAllMoves {mit allen Zgen}
translate D withAllButOneMove {mit allen auer einem Zug}
translate D with {mit}
translate D only {nur}
translate D lose {verlieren}
translate D loses {verliert}
translate D allOthersLose {alle anderen verlieren}
translate D matesIn {setzt Matt in}
translate D hasCheckmated {hat Matt gesetzt}
translate D longest {lngste}
translate D WinningMoves {Gewinnzge}
translate D DrawingMoves {Remiszge}
translate D LosingMoves {Verlustzge}
translate D UnknownMoves {Zge mit unbekanntem Resultat}
translate D SideLongest {Seite   Lngstes  %     %     %\n}
translate D toNoveMate  {am Zug    Matt   Gew. Remis Verlust\n}
translate D NoSummary {\nKeine Zusammenfassung fr diese Tablebase.}
translate D MutualZugzwang {Gegenseitiger Zugzwang: }
translate D SelectetZugzwang {\nAusgewhlte Zugzwangpositionen:}
translate D WdrawBloss {Wei remis,Schwarz verliert:}
translate D BdrawWloss {Schwarz remis, Wei verliert: }
translate D AllLoss {" Wer zieht verliert:     " }

# Tip of the day:
translate D Tip {Tip}
translate D TipAtStartup {Tip beim Starten}
translate D TipConvertPGN {Sie knnen eine bessere Leistung erreichen, wenn die PGN-Dateien konvertiert werden.}

# Tree window menus:
menuText D TreeFile "Datei" 0
menuText D TreeFileFillWithBase "Cache mit Datenbank fllen" 0 {Die Cache-Datei wird mit allen Partien der aktuellen Datenbank befllt.}
menuText D TreeFileFillWithGame "Cache mit Partie fllen" 0 {Die Cache-Datei wird mit der aktuellen Partien befllt.}
menuText D TreeFileSetCacheSize "Cache Gre" 0 {Cachegre auswhlen.}
menuText D TreeFileCacheInfo "Cache info" 0 {Info ber Cachenutzung anzeigen.}
menuText D TreeFileSave "Cache-Datei sichern" 12 \
  {Speichere die Zugbaum-Cache-Datei (.stc)}
menuText D TreeFileFill "Cache-Datei fllen" 12 \
  {Flle die Cache-Datei mit hufigen Erffnungspositionen}
menuText D TreeFileBest "Beste Partien" 0 \
  {Zeige die Liste bester Partien im Baum}
menuText D TreeFileGraph "Grafikfenster" 0 \
  {Zeige die Grafik fr diesen Ast}
menuText D TreeFileCopy "Kopiere Baumfenster in Zwischenablage" 0 \
  {Kopiere die Zugbaum-Statistik in die Zwischenablage}
menuText D TreeFileClose "Baumfenster schlieen" 12 {Schliee Zugbaum}
menuText D TreeMask "Maskieren" 0
menuText D TreeMaskNew "Neu" 0 {Neue Maske anlegen}
menuText D TreeMaskOpen "ffnen" 0 {Maske ffnen}
menuText D TreeMaskOpenRecent "Aktuelle Masken" 0 {Zuletzt geffnete Masken erneut laden}
menuText D TreeMaskSave "Speichern" 0 {Maske speichern}
menuText D TreeMaskClose "Schlieen" 0 {Maske schlieen}
menuText D TreeMaskFillWithGame "Mit aktueller Partie fllen" 0 {Maske mit der aktuellen Partie fllen}
menuText D TreeMaskFillWithBase "Mit Datenbank fllen" 0 {Maske mit Datenbankpartien fllen}
menuText D TreeMaskInfo "Info" 0 {Statistik fr die aktuelle Maske anzeigen}
menuText D TreeMaskDisplay "Maske als Baum" 0 {Zeigt den Inhalt der aktuellen Maske als Zugbaum}
menuText D TreeMaskSearch "Suchen" 0 {Suchen innerhalb der aktuellen Maske}
menuText D TreeSort "Sortieren" 0
menuText D TreeSortAlpha "Alphabetisch" 0
menuText D TreeSortECO "ECO-Code" 0
menuText D TreeSortFreq "Hufigkeit" 0
menuText D TreeSortScore "Punkte" 0
menuText D TreeOpt "Optionen" 0
menuText D TreeOptSlowmode "Grndliche Suche" 0 {Update mit hoher Genauigkeit, langsamer}
menuText D TreeOptFastmode "Schneller Modus" 0 {Schnelles Update (ignoriert Zugumstellungen)}
menuText D TreeOptFastAndSlowmode "Grndlicher und Schneller Modus" 0 {Zunchst schneller Updatemodus, dann nacharbeit im grndlichen Modus}
menuText D TreeOptStartStop "Automatisch aktualisieren" 0 {Schaltet das automatische aktualisieren ein/aus}
menuText D TreeOptLock "Anbinden" 0 \
  {Zugbaum an aktive Datenbank anbinden(/lsen)}
menuText D TreeOptTraining "Training" 0 {Trainingsmodus ein-/ausschalten}
menuText D TreeOptAutosave "Autom. Cache-Datei sichern" 4 \
  {Beim Schlieen des Zugbaums automatisch Cache-Datei sichern}
menuText D TreeHelp "Hilfe" 0
menuText D TreeHelpTree "Zugbaumhilfe" 0
menuText D TreeHelpIndex "Index" 0
translate D SaveCache {Cache sichern}
translate D Training {Training}
translate D LockTree {Anbinden}
translate D TreeLocked {angebunden}
translate D TreeBest {Beste}
translate D TreeBestGames {Beste Zugbaumpartien}
# Note: the next message is the tree window title row. After editing it,
# check the tree window to make sure it lines up with the actual columns.
translate D TreeTitleRow \
  {    Zug    ECO       Hufigkeit    Pkte   Elo  Erflg Jahr %Remis}
translate D TreeTotal {SUMME}
translate D DoYouWantToSaveFirst {Soll zuerst gespeichert werden}
translate D AddToMask {Zur Maske hinzufgen}
translate D RemoveFromMask {Entferne von Maske}
translate D AddThisMoveToMask {Diesen Zug zur Maske hinzufgen}
translate D SearchMask {Suche in einer Maske}
translate D DisplayMask {Maske als Zugbaum}
translate D Nag {NAG Code}
translate D Marker {Marker}
translate D Include {Enthalten}
translate D Exclude {Ausgeschlossen}
translate D MainLine {Hauptvariante}
translate D Bookmark {Lesezeichen}
translate D NewLine {Neue Variante}
translate D ToBeVerified {berprfen}
translate D ToTrain {Trainieren}
translate D Dubious {Zweifelhaft}
translate D ToRemove {Entfernen}
translate D NoMarker {Keine Kennzeichen}
translate D ColorMarker {Farbe}
translate D WhiteMark {Wei}
translate D GreenMark {Grn}
translate D YellowMark {Gelb}
translate D BlueMark {Blau}
translate D RedMark {Rot}
translate D CommentMove {Zug kommentieren}
translate D CommentPosition {Position kommentieren}
translate D AddMoveToMaskFirst {Zug zuerst zur Maske hinzufngen}
translate D OpenAMaskFileFirst {Zunchst Maske ffnen}
translate D Positions {Positionen}
translate D Moves {Zge}

# Finder window:
menuText D FinderFile "Datei" 0
menuText D FinderFileSubdirs "mit Unterverzeichnissen" 0
menuText D FinderFileClose "Dateisuche schlieen" 0
menuText D FinderSort "Sortieren" 0
menuText D FinderSortType "Typ" 0
menuText D FinderSortSize "Gre" 0
menuText D FinderSortMod "Modifiziert" 0
menuText D FinderSortName "Namen" 0
menuText D FinderSortPath "Pfad" 0
menuText D FinderTypes "Typen" 0
menuText D FinderTypesScid "Scid-Datenbanken" 0
menuText D FinderTypesOld "Datenbanken im alten Format" 0
menuText D FinderTypesPGN "PGN-Dateien" 0
menuText D FinderTypesEPD "EPD-Dateien" 0
menuText D FinderTypesRep "Repertoire-Dateien" 0
menuText D FinderHelp "Hilfe" 0
menuText D FinderHelpFinder "Hilfe fr Dateisuche" 0
menuText D FinderHelpIndex "Index" 0
translate D FileFinder {Dateisuche}
translate D FinderDir {Verzeichnis}
translate D FinderDirs {Verzeichnisse}
translate D FinderFiles {Dateien}
translate D FinderUpDir {hoch}
translate D FinderCtxOpen {ffnen}
translate D FinderCtxBackup {Sicherungskopie}
translate D FinderCtxCopy {Kopieren}
translate D FinderCtxMove {Verschieben}
translate D FinderCtxDelete {Lschen}

# Player finder:
menuText D PListFile "Datei" 0
menuText D PListFileUpdate "Aktualisieren" 0
menuText D PListFileClose "Spielersuche schlieen" 7
menuText D PListSort "Sortieren" 0
menuText D PListSortName "Name" 0
menuText D PListSortElo "Elo" 0
menuText D PListSortGames "Partien" 0
menuText D PListSortOldest "lteste" 0
menuText D PListSortNewest "Neueste" 0

# Tournament finder:
menuText D TmtFile "Datei" 0
menuText D TmtFileUpdate "Aktualisieren" 0
menuText D TmtFileClose "Turniersuche schlieen" 0
menuText D TmtSort "Sortieren" 0
menuText D TmtSortDate "Datum" 0
menuText D TmtSortPlayers "Spieler" 0
menuText D TmtSortGames "Partien" 0
menuText D TmtSortElo "Elo" 0
menuText D TmtSortSite "Ort" 0
menuText D TmtSortEvent "Turnier" 1
menuText D TmtSortWinner "Gewinner" 0
translate D TmtLimit "Anzeigelimit"
translate D TmtMeanElo "Elo-Durchschnitt"
translate D TmtNone "Keine zutreffenden Turniere gefunden."

# Graph windows:
menuText D GraphFile "Datei" 0
menuText D GraphFileColor "Als Farb-Postscript speichern..." 4
menuText D GraphFileGrey "Als Graustufen-Postscript speichern..." 4
menuText D GraphFileClose "Fenster schlieen" 0
menuText D GraphOptions "Optionen" 0
menuText D GraphOptionsWhite "Wei" 0
menuText D GraphOptionsBlack "Schwarz" 0
menuText D GraphOptionsBoth "Beide" 0
menuText D GraphOptionsPInfo "Spielerinfo Spieler" 1
menuText D GraphOptionsEloFile "Elo von Rating-Datei" 0
menuText D GraphOptionsEloDB "Elo von Datenbank" 0
translate D GraphFilterTitle "Filtergrafik: Hufigkeit pro 1000 Partien"
translate D GraphAbsFilterTitle "Filtergrafik: Hufigkeit der Partien"
translate D ConfigureFilter "X-Achse fr Jahr, Elo und Zge konfigurieren"
translate D FilterEstimate "Schtzen"
translate D TitleFilterGraph "Scid: Filtergrafik"

# Analysis window:
translate D AddVariation {Variante hinzufgen}
translate D AddAllVariations {Alle Varianten hinzufgen}
translate D AddMove {Zug hinzufgen}
translate D Annotate {Autom. kommentieren}
translate D ShowAnalysisBoard {Analysebrett anzeigen}
translate D ShowInfo {Engine-Information anzeigen}
translate D FinishGame {Partie beenden}
translate D StopEngine {Engine anhalten}
translate D StartEngine {Engine starten}
translate D LockEngine {Anbinden an aktuelle Position}
translate D AnalysisCommand {Analysebefehl}
translate D PreviousChoices {Vorherige Wahl}
translate D AnnotateTime {Zeit pro Zug in Sek.}
translate D AnnotateWhich {Varianten hinzufgen}
translate D AnnotateAll {Fr Zge beider Seiten}
translate D AnnotateAllMoves {Alle Zge kommentieren}
translate D AnnotateWhite {Nur fr Zge von Wei}
translate D AnnotateBlack {Nur fr Zge von Schwarz}
translate D AnnotateBlundersOnly {Wenn der Partiezug ein Fehler ist}
translate D AnnotateBlundersOnlyScoreChange {Analyse berichtet Fehler, Bewertungsnderung von/nach: }
translate D BlundersThreshold {Schwelle}
translate D ScoreAllMoves {Alle Zge bewerten}
translate D LowPriority {Niedrige CPU-Prioritt}
translate D ClickHereToSeeMoves {Hier klicken um Zge anzuzeigen}
translate D ConfigureInformant {Informatorwerte}
translate D Informant!? {Interessanter Zug}
translate D Informant? {Schwacher Zug}
translate D Informant?? {Fehler}
translate D Informant?! {Zweifelhafter Zug}
translate D Informant+= {Wei hat leichten Vorteil}
translate D Informant+/- {Wei hat klaren Vorteil}
translate D Informant+- {Wei hat groen Vorteil}
translate D Informant+-- {Wei hat erdrckenden Vorteil}
translate D Book {Buch}
translate D OtherBookMoves {Erffnungsbuch des Gegners}
translate D OtherBookMovesTooltip {Zge, fr die der Gegner eine Antwort kennt}

# Analysis Engine open dialog:
translate D EngineList {Analyse-Engines}
translate D EngineName {Name}
translate D EngineCmd {Befehl}
translate D EngineArgs {Parameter}
translate D EngineDir {Verzeichnis}
translate D EngineElo {Elo}
translate D EngineTime {Datum}
translate D EngineNew {Neu}
translate D EngineEdit {Bearbeiten}
translate D EngineRequired {Fettgedruckte Parameter obligatorisch, andere optional}
# ====== TODO To be translated ======
translate D EngineProtocol {Communication protocol}
# ====== TODO To be translated ======
translate D EngineNotation {Notation of the moves}
# ====== TODO To be translated ======
translate D EngineFlipEvaluation {Flip evaluation perspective}
# ====== TODO To be translated ======
translate D EngineShowLog {Show communication log}
# ====== TODO To be translated ======
translate D EngineNetworkd {Accept remote connections}
# ====== TODO To be translated ======
translate D EngineSelect {Select the current engine}
# ====== TODO To be translated ======
translate D EngineAddLocal {Add a local engine}
# ====== TODO To be translated ======
translate D EngineAddRemote {Add a remote engine}
# ====== TODO To be translated ======
translate D EngineReload {Reload the current engine}
# ====== TODO To be translated ======
translate D EngineClone {Create a copy of the current engine}
# ====== TODO To be translated ======
translate D EngineDelete {Delete the current engine}

# PGN window menus:
menuText D PgnFile "Datei" 0
menuText D PgnFileCopy "Kopiere Spiel in Zwischenablage" 0
menuText D PgnFilePrint "Drucken in Datei..." 0
menuText D PgnFileClose "PGN-Fenster schlieen" 0
menuText D PgnOpt "Ausgabe" 0
menuText D PgnOptColor "Farbige Darstellung" 0
menuText D PgnOptShort "Kurzer (3-Zeilen) Vorspann (Header)" 8
menuText D PgnOptSymbols "Symbolische Darstellung" 0
menuText D PgnOptIndentC "Kommentare einrcken" 0
menuText D PgnOptIndentV "Varianten einrcken" 0
menuText D PgnOptColumn "Tabellarisch (ein Zug pro Zeile)" 0
menuText D PgnOptSpace "Leerzeichen nach Zugnummer" 0
menuText D PgnOptStripMarks "Farbfelder-/Pfeile-Zeichen entfernen" 27
menuText D PgnOptBoldMainLine "Partiezge in Fettdruck" 0
menuText D PgnColor "Farben" 0
menuText D PgnColorHeader "Vorspann..." 0
menuText D PgnColorAnno "Anmerkungen..." 0
menuText D PgnColorComments "Kommentare..." 0
menuText D PgnColorVars "Varianten..." 0
menuText D PgnColorBackground "Hintergrund..." 0
menuText D PgnColorMain "Partieverlauf..." 0
menuText D PgnColorCurrent "Hintergrund aktueller Zug..." 1
menuText D PgnHelp "Hilfe" 0
menuText D PgnHelpPgn "PGN-Hilfe" 0
menuText D PgnHelpIndex "Index" 0
translate D PgnWindowTitle {Partienotation - Partie %u}

# Crosstable window menus:
menuText D CrosstabFile "Datei" 0
menuText D CrosstabFileText "Ausgabe in Textdatei..." 11
menuText D CrosstabFileHtml "Ausgabe in HTML-Datei..." 11
menuText D CrosstabFileLaTeX "Ausgabe in LaTeX-Datei..." 11
menuText D CrosstabFileClose "Turniertabelle schlieen" 0
menuText D CrosstabEdit "Bearbeiten" 0
menuText D CrosstabEditEvent "Ereignis" 0
menuText D CrosstabEditSite "Ort" 0
menuText D CrosstabEditDate "Datum" 0
menuText D CrosstabOpt "Ausgabe" 0
menuText D CrosstabOptAll "Jeder gegen jeden" 0
menuText D CrosstabOptSwiss "Schweizer System" 0
menuText D CrosstabOptKnockout "K.o.-System" 0
menuText D CrosstabOptAuto "Automatisch" 1
menuText D CrosstabOptAges "Alter in Jahren" 0
menuText D CrosstabOptNats "Nationalitt" 0
menuText D CrosstabOptRatings "Elo" 0
menuText D CrosstabOptTitles "Titel" 0
menuText D CrosstabOptBreaks "Stichkampfpunkte" 10
menuText D CrosstabOptDeleted "Inklusive gelschte Partien" 10
menuText D CrosstabOptColors "Farben (nur Schweizer System)" 0
menuText D CrosstabOptColumnNumbers "Numerierte Spalten (Nur jeder-gegen-jeden-Tabelle)" 2
menuText D CrosstabOptGroup "Punktgruppen" 5
menuText D CrosstabSort "Sortieren" 0
menuText D CrosstabSortName "Name" 0
menuText D CrosstabSortRating "Elo" 0
menuText D CrosstabSortScore "Punkte" 0
menuText D CrosstabColor "Farben" 0
menuText D CrosstabColorPlain "Text" 0
menuText D CrosstabColorHyper "Hypertext" 0
menuText D CrosstabHelp "Hilfe" 0
menuText D CrosstabHelpCross "Turniertabelle-Hilfe" 0
menuText D CrosstabHelpIndex "Index" 0
translate D SetFilter {Filter setzen}
translate D AddToFilter {Zum Filter hinzufgen}
translate D Swiss {Schweizer}
translate D Category {Kategorie}

# Opening report window menus:
menuText D OprepFile "Datei" 0
menuText D OprepFileText "Ausgabe in Textdatei..." 11
menuText D OprepFileHtml "Ausgabe in HTML-Datei..." 11
menuText D OprepFileLaTeX "Ausgabe in LaTeX-Datei..." 11
menuText D OprepFileOptions "Optionen..." 0
menuText D OprepFileClose "Berichtsfenster schlieen" 0
menuText D OprepFavorites "Favoriten" 0
menuText D OprepFavoritesAdd "Bericht hinzufgen..." 8
menuText D OprepFavoritesEdit "Favoritenbericht editieren..." 0
menuText D OprepFavoritesGenerate "Berichte erzeugen..." 9

menuText D OprepHelp "Hilfe" 0
menuText D OprepHelpReport "Erffnungsbericht-Hilfe" 0
menuText D OprepHelpIndex "Index" 0

# Header search:
translate D HeaderSearch {Partiedaten suchen}
translate D EndSideToMove {Wer ist beim Partieende am Zug?}
translate D GamesWithNoECO {Partien ohne ECO}
translate D GameLength {Partielnge}
translate D FindGamesWith {Finde Partien mit Kennzeichen}
translate D StdStart {Grundstellung}
translate D Promotions {Umwandlung}
translate D Comments {Kommentare}
translate D Variations {Varianten}
translate D Annotations {Anmerkungen}
translate D DeleteFlag {Lschkennzeichen}
translate D WhiteOpFlag {Erffnung Wei}
translate D BlackOpFlag {Erffnung Schwarz}
translate D MiddlegameFlag {Mittelspiel}
translate D EndgameFlag {Endspiel}
translate D NoveltyFlag {Neuerung}
translate D PawnFlag {Bauernstruktur}
translate D TacticsFlag {Taktik}
translate D QsideFlag {Damenflgel}
translate D KsideFlag {Knigsflgel}
translate D BrilliancyFlag {Glnzend}
translate D BlunderFlag {Grober Fehler}
translate D UserFlag {Benutzer}
translate D PgnContains {PGN enthlt Text}
translate D Annotator {Kommentator}
translate D Cmnts {Nur kommentierte Partien}

# Game list window:
translate D GlistNumber {Nummer}
translate D GlistWhite {Wei}
translate D GlistBlack {Schwarz}
translate D GlistWElo {W-Elo}
translate D GlistBElo {S-Elo}
translate D GlistEvent {Turnier}
translate D GlistSite {Ort}
translate D GlistRound {Runde}
translate D GlistDate {Datum}
translate D GlistYear {Jahr}
translate D GlistEDate {Turnierdatum}
translate D GlistResult {Ergebnis}
translate D GlistLength {Lnge}
translate D GlistCountry {Land}
translate D GlistECO {ECO}
translate D GlistOpening {Erffnung}
translate D GlistEndMaterial {Endmaterial}
translate D GlistDeleted {Gelscht}
translate D GlistFlags {Kennzeichen}
translate D GlistVars {Varianten}
translate D GlistComments {Kommentare}
translate D GlistAnnos {Anmerkungen}
translate D GlistStart {Stellung}
translate D GlistGameNumber {Partie Nummer}
translate D GlistAverageElo {ELO Durchschnitt}
translate D GlistRating {Wertungszahl}
translate D GlistFindText {Text finden}
translate D GlistMoveField {Zge}
translate D GlistEditField {Konfigurieren}
translate D GlistAddField {Hinzufgen}
translate D GlistDeleteField {Lschen}
translate D GlistWidth {Breite}
translate D GlistAlign {Ausrichtung}
translate D GlistAlignL {Ausrichtung: links}
translate D GlistAlignR {Ausrichtung: rechts}
translate D GlistAlignC {Ausrichtung: zentriert}
translate D GlistColor {Farbe}
translate D GlistSep {Trennlinie}
translate D GlistCurrentSep {-- Aktuell --}
translate D GlistNewSort {Neu}
translate D GlistAddToSort {Hinzufgen}

# base sorting
translate D GsortSort {Sortieren...}
translate D GsortDate {Datum}
translate D GsortYear {Jahr}
translate D GsortEvent {Event}
translate D GsortSite {Ort}
translate D GsortRound {Runde}
translate D GsortWhiteName {Name Wei}
translate D GsortBlackName {Name Schwarz}
translate D GsortECO {ECO}
translate D GsortResult {Ergebnis}
translate D GsortMoveCount {Zahl der Zge}
translate D GsortAverageElo {Eloschnitt}
translate D GsortCountry {Land}
translate D GsortDeleted {Gelscht}
translate D GsortEventDate {Event Datum}
translate D GsortWhiteElo {ELO Wei}
translate D GsortBlackElo {ELO Schwarz}
translate D GsortComments {Kommentare}
translate D GsortVariations {Varianten}
translate D GsortNAGs {NAGs}
translate D GsortAscending {Aufsteigend}
translate D GsortDescending {Fallend}
translate D GsortAdd {Hinzufgen}
translate D GsortStore {Speichern}
translate D GsortLoad {Laden}

# menu shown with right mouse button down on game list.
translate D GlistRemoveThisGameFromFilter  {Partie aus Filter entfernen}
translate D GlistRemoveGameAndAboveFromFilter  {Partie (und alle oberhalb) aus Filter entfernen}
translate D GlistRemoveGameAndBelowFromFilter  {Partie (und alle darunter) aus Filter entfernen}
translate D GlistDeleteGame {(Ent)Loesche Partie}
translate D GlistDeleteAllGames {Lsche alle Partien im Filter} 
translate D GlistUndeleteAllGames {Alle Partien im Filter wiederherstellen}
translate D GlistMergeGameInBase {Mit Partie in anderer Datebank zusammenfhren} 

# Maintenance window:
translate D DatabaseName {Datenbankname:}
translate D TypeIcon {Symbol:}
translate D NumOfGames {Partien:}
translate D NumDeletedGames {Gelschte Partien:}
translate D NumFilterGames {Partien im Filter:}
translate D YearRange {Jahr-Spanne:}
translate D RatingRange {Elo-Spanne:}
translate D Description {Beschreibung}
translate D Flag {Kennzeichen}
translate D CustomFlags {Benutzerdefinierte Kennzeichen}
translate D DeleteCurrent {Lsche aktuelle Partie}
translate D DeleteFilter {Lsche Partien im Filter}
translate D DeleteAll {Lsche alle Partien}
translate D UndeleteCurrent {Aktuelle Partie wiederherstellen}
translate D UndeleteFilter {Partien im Filter wiederherstellen}
translate D UndeleteAll {Alle Partien wiederherstellen}
translate D DeleteTwins {Lsche Dubletten}
translate D MarkCurrent {Markiere aktuelle Partie}
translate D MarkFilter {Markiere Partien im Filter}
translate D MarkAll {Markiere alle Partien}
translate D UnmarkCurrent {Entmarkiere aktuelle Partie}
translate D UnmarkFilter {Entmarkiere Partien im Filter}
translate D UnmarkAll {Entmarkiere alle Partien}
translate D Spellchecking {Schreibkorrektur}
translate D Players {Spieler}
translate D Events {Ereignis}
translate D Sites {Ort}
translate D Rounds {Runde}
translate D DatabaseOps {Datenbankoperationen}
translate D ReclassifyGames {Partien ECO-klassifizieren}
translate D CompactDatabase {Datenbank komprimieren}
translate D SortDatabase {Datenbank sortieren}
translate D AddEloRatings {ELO-Zahlen hinzufgen}
translate D AutoloadGame {Lade automatisch Partie Nr.}
translate D StripTags {PGN-Kennungen entfernen}
translate D StripTag {Kennungen entfernen}
translate D Cleaner {Bereiniger}
translate D CleanerHelp {
Der Scid-Bereiniger wird fr die aktuelle Datenbank alle Wartungsarbeiten ausfhren, welche aus der unten stehenden Liste ausgewhlt werden.
Aktuelle Einstellungen in den Mens "ECO-Klassifikation" und "Dubletten lschen" werden bei Auswahl dieser Funktionen verwendet.}
translate D CleanerConfirm {
Ist der Bereiniger einmal gestartet, kann er nicht mehr unterbrochen werden!

Dies kann lange dauern, speziell bei groen Datenbanken, abhngig von den
ausgewhlten Funktionen und deren Einstellungen.

Sind Sie sicher, da Sie die ausgewhlten Wartungsarbeiten starten mchten?
}
# Twinchecker
translate D TwinCheckUndelete { umdrehen; "u" beide wiederherstellen)}
translate D TwinCheckprevPair {Vorheriges Paar}
translate D TwinChecknextPair {Nchstes Paar}
translate D TwinChecker {Scid: Dublettenprfer}
translate D TwinCheckTournament {Partien im Turnier:}
translate D TwinCheckNoTwin {Keine Dublette}
translate D TwinCheckNoTwinfound {Kein Dublette fr diese Partie gefunden.

Um Dubletten anzuzeigen, bitte zuerst die Funktion "Lsche Dubletten" benutzen.}
translate D TwinCheckTag {Nutze Tag...}
translate D TwinCheckFound1 {Scid hat $result Dubletten gefunden}
translate D TwinCheckFound2 { und das Gelscht-Flag gesetzt}
translate D TwinCheckNoDelete {In dieser Datenbank sind keine Partien zu lschen.}
translate D TwinCriteria1 {Ihre Auswahlkriterien der Dublettensuche haben eine hohe Wahrscheinlichkeit auch Partien mit hnlichen Zgen als Dubletten zu erkennen.
}
translate D TwinCriteria2 {Es wird empfohlen, dass bei der Auswahl "Nein" fr "gleiche Zge" die Auswahl "Ja" fr Farbe, Ereignis, Ort, Runde, Jahr und Monat ausgewhlt wird.

Wollen Sie fortsetzen und mit dieser Auswahl die Dubletten lschen? }
translate D TwinCriteria3 {Es wird empfohlen, dass bei der Auswahl "Ja" fr mindestens 2 der Parameter "gleicher Ort", "gleiche Runde" und "gleiches Jahr" gesetzt werden.
    
Wollen Sie fortsetzen und mit dieser Auswahl die Dubletten lschen?}
translate D TwinCriteriaConfirm {Scid: Besttigen der Dublettensuchparameter}
translate D TwinChangeTag "ndern der folgenden Partie-Tags:\n\n"
translate D AllocRatingDescription "Es werden die ELO-Werte aus der Schreibkorrekturdatei den Partien hinzugefgt, wenn der/die Spieler/in keinen aktuellen Wert in der Partie besitzt, aber in der Korrekturdatei ein Wert fr den Zeitraum der Partie vorhanden ist."
translate D RatingOverride "Existierende ELO-Werte berschreiben"
translate D AddRatings "Elo-Werte hinzufgen"
translate D AddedRatings {Scid hat $r Elo-Werte in $g Partien hinzugefgt.}

#Bookmark editor
translate D NewSubmenu "Neues Untermen"

# Comment editor:
translate D AnnotationSymbols  {Kommentarzeichen:}
translate D Comment {Kommentar:}
translate D InsertMark {Markierung einfgen}
translate D InsertMarkHelp {
Markierung einfgen/lschen: Farbe, Typ, Feld whlen.
Pfeil einfgen/lschen: Rechtsklick auf zwei Felder.
}

# Nag buttons in comment editor:
translate D GoodMove {Guter Zug}
translate D PoorMove {Schwacher Zug}
translate D ExcellentMove {Ausgezeichneter Zug}
translate D Blunder {Grober Fehler}
translate D InterestingMove {Interessanter Zug}
translate D DubiousMove {Zweifelhafter Zug}
translate D WhiteDecisiveAdvantage {Wei hat groen Vorteil}
translate D BlackDecisiveAdvantage {Schwarz hat groen Vorteil}
translate D WhiteClearAdvantage {Wei hat klaren Vorteil}
translate D BlackClearAdvantage {Schwarz hat klaren Vorteil}
translate D WhiteSlightAdvantage {Wei hat leichten Vorteil}
translate D BlackSlightAdvantage {Schwarz hat leichten Vorteil}
translate D WhiteCrushing {Wei hat erdrckenden Vorteil}
translate D BlackCrushing {Schwarz hat erdrckenden Vorteil}
translate D Equality {Gleiche Chancen}
translate D Unclear {Unklar}
translate D Diagram {Diagramm}

# Board search:
translate D BoardSearch {Brettsuche}
translate D FilterOperation {Suche im aktuellen Filter:}
translate D FilterAnd {UND\nBeschrnke Filter}
translate D FilterOr {ODER\nZum Filter hinzufgen}
translate D FilterIgnore {IGNORIEREN\nFilter zurcksetzen}
translate D SearchType {Suche nach Typ:}
translate D SearchBoardExact {Exakte Position (alle Steine auf gleichen Feldern)}
translate D SearchBoardPawns {Bauern (gleiche Figuren, alle Bauern auf gleichen Feldern)}
translate D SearchBoardFiles {Linien (gleiches Material, alle Bauern auf gleichen Linien)}
translate D SearchBoardAny {Material (gleiches Material, Bauern und Figuren beliebig)}
translate D SearchInRefDatabase { In folgender Datenbank suchen }
translate D LookInVars {Schaue in Varianten}

# Material search:
translate D MaterialSearch {Materialsuche}
translate D Material {Material}
translate D Patterns {Muster}
translate D Zero {Null}
translate D Any {Irgendeine}
translate D CurrentBoard {Aktuelle Stellung}
translate D CommonEndings {Endspiele}
translate D CommonPatterns {Hufige Muster}
translate D MaterialDiff {Materialdifferenz}
translate D squares {Felder}
translate D SameColor {Gleichfarbige}
translate D OppColor {Ungleichfarbige}
translate D Either {Beides}
translate D MoveNumberRange {Zugnummernbereich}
translate D MatchForAtLeast {Zutreffend fr mindestens}
translate D HalfMoves {Halbzge}

# Common endings in material search:
translate D EndingPawns {Bauernendspiele}
translate D EndingRookVsPawns {Turm gegen Bauer(n)}
translate D EndingRookPawnVsRook {Turm und 1 Bauer gegen Turm}
translate D EndingRookPawnsVsRook {Turm und Bauer(n) gegen Turm}
translate D EndingRooks {Turm gegen Turm}
translate D EndingRooksPassedA {Turm gegen Turm mit Freibauer}
translate D EndingRooksDouble {Doppelturm-Endspiele}
translate D EndingBishops {Lufer gegen Lufer}
translate D EndingBishopVsKnight {Lufer gegen Springer}
translate D EndingKnights {Springer gegen Springer}
translate D EndingQueens {Dame gegen Dame} ;# *** Damenendspiele !?
translate D EndingQueenPawnVsQueen {Dame und 1 Bauer gegen Dame}
translate D BishopPairVsKnightPair {Zwei Lufer gegen zwei Springer im Mittelspiel}

# Common patterns in material search:
translate D PatternWhiteIQP {Weier isolierter Damenbauer}
translate D PatternWhiteIQPBreakE6 {Weier Isolani: Durchbruch d4-d5 gegen e6}
translate D PatternWhiteIQPBreakC6 {Weier Isolani: Durchbruch d4-d5 gegen c6}
translate D PatternBlackIQP {Schwarzer isolierter Damenbauer}
translate D PatternWhiteBlackIQP {Weier gegen schwarzer Damenbauerisolani}
translate D PatternCoupleC3D4 {Isoliertes Bauernpaar c3+d4}
translate D PatternHangingC5D5 {Hngende Bauern c5 und d5 von Schwarz}
translate D PatternMaroczy {Maroczy-Zentrum (mit Bauern auf c4 und e4)}
translate D PatternRookSacC3 {Turmopfer auf c3}
translate D PatternKc1Kg8 {0-0-0 gegen 0-0 (Kc1 gegen Kg8)}
translate D PatternKg1Kc8 {0-0 gegen 0-0-0 (Kg1 gegen Kc8)}
translate D PatternLightFian {Weifeldrige Fianchettos (Lufer g2 gegen Lufer b7)}
translate D PatternDarkFian {Schwarzfeldrige Fianchettos (Lufer b2 gegen Lufer g7)}
translate D PatternFourFian {Beiderseitiges Doppelfianchetto (Lufer auf b2,g2,b7,g7)}

# Game saving:
translate D Today {Heute}
translate D ClassifyGame {Partie klassifizieren}

# Setup position:
translate D EmptyBoard {Brett leeren}
translate D InitialBoard {Initialisiere Brett}
translate D SideToMove {Zugrecht}
translate D MoveNumber {Zugnummer}
translate D Castling {Rochade}
translate D EnPassantFile {EnPassant-Linie}
translate D ClearFen {FEN lschen}
translate D PasteFen {FEN einfgen}
translate D SaveAndContinue {Speichern und weiter}
translate D DiscardChangesAndContinue {Verwerfen und weiter}
translate D GoBack {Zurck}

# Replace move dialog:
translate D ReplaceMove {Zug ersetzen}
translate D AddNewVar {Neue Variante}
translate D NewMainLine {Neue Hauptvariante}
translate D ReplaceMoveMessage {Hier existiert bereits ein Zug.

Sie knnen diesen Zug ersetzen - unter Verlust aller nachfolgender Zge - oder mit dem Zug eine neue Variante hinzufgen.

(Sie knnen diese Anzeige vermeiden, indem Sie die Option "Fragen vor Ersetzen" im Men Optionen:Zge deaktivieren)}

# Make database read-only dialog:
translate D ReadOnlyDialog {Wenn Sie diese Datenbank mit Schreibschutz
versehen, sind keine nderungen mglich. Es knnen keine Partien gespeichert
oder ersetzt und keine Lschkennzeichen gendert werden. Alle Sortierungen oder
ECO-Klassifikationsergebnisse sind nur temporr.

Sie knnen den Schreibschutz einfach entfernen, indem Sie die Datenbank
schlieen und wieder ffnen.
Wollen Sie diese Datenbank wirklich schreibschtzen?}

# Clear game dialog:
translate D ClearGameDialog {Diese Partie wurde gendert.

Wollen Sie wirklich fortsetzen und die nderungen verwerfen?
}

# Exit dialog:
translate D ExitDialog {Mchten Sie Scid beenden?}
translate D ExitUnsaved {Die folgenden Datenbanken haben ungesicherte Partienderungen. Wenn Sie jetzt beenden, gehen diese nderungen verloren.}

# Import window:
translate D PasteCurrentGame {Aktuelle Partie einfgen}
translate D ImportHelp1 {Eingeben oder Einfgen einer Partie im PGN-Format in den oberen Rahmen.}
translate D ImportHelp2 {Hier werden Fehler beim Importieren angezeigt.}
translate D OverwriteExistingMoves {Bestehende Zge berschreiben?}

# ECO Browser:
translate D ECOAllSections {alle ECO-Gruppen}
translate D ECOSection {ECO-Gruppe}
translate D ECOSummary {Zusammenfassung fr}
translate D ECOFrequency {Hufigkeit der Untercodes fr}

# Opening Report:
translate D OprepTitle {Erffnungsbericht}
translate D OprepReport {Bericht}
translate D OprepGenerated {Erzeugt durch}
translate D OprepStatsHist {Statistiken und Geschichte}
translate D OprepStats {Statistiken}
translate D OprepStatAll {Alle Berichtspartien}
translate D OprepStatBoth {Beide Spieler}
translate D OprepStatSince {Nach}
translate D OprepOldest {lteste Partien}
translate D OprepNewest {Neuste Partien}
translate D OprepPopular {Popularitt}
translate D OprepFreqAll {Hufigkeit in allen Jahren: }
translate D OprepFreq1   {im letzten Jahr:            }
translate D OprepFreq5   {der letzten  5 Jahre:       }
translate D OprepFreq10  {der letzten 10 Jahre:       }
translate D OprepEvery {Eine pro %u Partien}
translate D OprepUp {mehr als %u%s von allen Jahren}
translate D OprepDown {weniger als %u%s von allen Jahren}
translate D OprepSame {keine nderung in allen Jahren}
translate D OprepMostFrequent {Hufigste Spieler}
translate D OprepMostFrequentOpponents {Hufigste Gegner}
translate D OprepRatingsPerf {ELO und Performance}
translate D OprepAvgPerf {Durchschnitts-ELO und Performance}
translate D OprepWRating {ELO Wei}
translate D OprepBRating {ELO Schwarz}
translate D OprepWPerf {Performance Wei}
translate D OprepBPerf {Performance Schwarz}
translate D OprepHighRating {Spiele mit hchstem ELO-Durchschnitt}
translate D OprepTrends {Ergebnistrend}
translate D OprepResults {Ergebnis nach Lngen und Hufigkeiten}
translate D OprepLength {Partielnge}
translate D OprepFrequency {Hufigkeit}
translate D OprepWWins {Weisiege:    }
translate D OprepBWins {Schwarzsiege: }
translate D OprepDraws {Remis:        }
translate D OprepWholeDB {ganze Datenbank}
translate D OprepShortest {Krzester Sieg}
translate D OprepMovesThemes {Zge und Themen}
translate D OprepMoveOrders {Zugfolgen zum Erreichen\nder Berichtsposition}
translate D OprepMoveOrdersOne \
  {Es gab nur eine Zugfolge zur erreichten Position:}
translate D OprepMoveOrdersAll \
  {Es gab %u Zugfolgen zur erreichten Position:}
translate D OprepMoveOrdersMany \
  {Es gab  %u Zugfolgen zur erreichten Position. Die ersten %u sind:}
translate D OprepMovesFrom {Zge ab der Berichtsposition}
translate D OprepMostFrequentEcoCodes {Hufigste ECO-Codes}
translate D OprepThemes {Themen}
translate D OprepThemeDescription {Hufigkeit der Themen in den ersten %u Zgen jeder Partie}
translate D OprepThemeSameCastling {Gleichseitige Rochaden}
translate D OprepThemeOppCastling {Verschiedenseitige Rochaden}
translate D OprepThemeNoCastling {Beide Seiten unrochiert}
translate D OprepThemeKPawnStorm {Bauernsturm auf Knig}
translate D OprepThemeQueenswap {Damen getauscht}
translate D OprepThemeWIQP {Weier isolierter Damenbauer}
translate D OprepThemeBIQP {Schwarzer isolierter Damenbauer}
translate D OprepThemeWP567 {Weier Bauer auf Reihe 5/6/7}
translate D OprepThemeBP234 {Schwarzer Bauer auf Reihe 2/3/4}
translate D OprepThemeOpenCDE {Offene c/d/e-Linie}
translate D OprepTheme1BishopPair {Eine Seite hat Luferpaar}
translate D OprepEndgames {Endspiele}
translate D OprepReportGames {Berichtspartien}
translate D OprepAllGames {Alle Partien}
translate D OprepEndClass {Materialklassifikation von Endspielstellungen}
translate D OprepTheoryTable {Theorietabelle}
translate D OprepTableComment {Erzeugt aus %u Partien mit hchster ELO-Zahl.}
translate D OprepExtraMoves {Zustzliche Zge in der Theorietabelle}
translate D OprepMaxGames {Maximale Partien in der Theorietabelle}
translate D OprepViewHTML {Zeige HTML}
translate D OprepViewLaTeX {Zeige LaTeX}

# Player Report:
translate D PReportTitle {Spielerbericht}
translate D PReportColorWhite {mit den weien Steinen}
translate D PReportColorBlack {mit den schwarzen Steinen}
translate D PReportMoves {nach %s}
translate D PReportOpenings {Erffnungen}
translate D PReportClipbase {Leere Zwischenablage und kopiere gefundene Spiele}

# Piece Tracker window:
translate D TrackerSelectSingle {Linke Maustaste whlt diese Figur.}
translate D TrackerSelectPair \
  {Linke Maustaste whlt diese Figur; rechte Maustaste whlt das Figurenpaar.}
translate D TrackerSelectPawn \
  {Linke Maustaste whlt diesen Bauern; rechte Maustaste whlt alle 8 Bauern.}
translate D TrackerStat {Statistik}
translate D TrackerGames {% der Partien mit Zug auf das Feld}
translate D TrackerTime {% der Zeit auf jedem Feld}
translate D TrackerMoves {Zge}
translate D TrackerMovesStart \
  {Zugnummer, ab der die Verteilungsberechnung beginnen soll.}
translate D TrackerMovesStop \
  {Zugnummer, wo die Verteilungsberechnung enden soll.}

# Game selection dialogs:
translate D SelectAllGames {Alle Partien in der Datenbank}
translate D SelectFilterGames {Nur Partien im Filter}
translate D SelectTournamentGames {Nur Partien des aktuellen Turniers}
translate D SelectOlderGames {Nur ltere Partien}

# Delete Twins window:
translate D TwinsNote {Damit zwei Spiele Dubletten sind, mssen diese mindestens die beiden selben Spieler haben und die folgenden Kriterien, die Sie auswhlen knnen, erfllen. Wenn zwei Dubletten gefunden werden, so wird die krzere der beiden Spiele gelscht. Tip: am besten fhrt man erst eine Schreibkorrektur durch, da dadurch das Finden von Dubletten verbessert wird.}
translate D TwinsCriteria {Kriterium: Dubletten mssen haben ...}
translate D TwinsWhich {berprfe Partien}
translate D TwinsColors {gleiche Spielerfarbe}
translate D TwinsEvent {gleiches Ereignis}
translate D TwinsSite {gleichen Ort}
translate D TwinsRound {gleiche Runde}
translate D TwinsYear {gleiches Jahr}
translate D TwinsMonth {gleichen Monat}
translate D TwinsDay {gleichen Tag}
translate D TwinsResult {gleiches Ergebnis}
translate D TwinsECO {gleichen ECO-Code}
translate D TwinsMoves {gleiche Zge}
translate D TwinsPlayers {Vergleiche Spielernamen}
translate D TwinsPlayersExact {Exakte Treffer}
translate D TwinsPlayersPrefix {Nur erste 4 Buchstaben}
translate D TwinsWhen {Beim Lschen der Dubletten}
translate D TwinsSkipShort {Partien unter 5 Zgen ignorieren}
translate D TwinsUndelete {Zuerst alle Partien entlschen}
translate D TwinsSetFilter {Filter auf Dubletten setzen}
translate D TwinsComments {Spiele mit Kommentar immer behalten}
translate D TwinsVars {Spiele mit Varianten immer behalten}
translate D TwinsDeleteWhich {Lsche Partie}
translate D TwinsDeleteShorter {Krzere Partie}
translate D TwinsDeleteOlder {Kleinere Partienummer}
translate D TwinsDeleteNewer {Grere Partienummer}
translate D TwinsDelete {Lsche Spiele}

# Name editor window:
translate D NameEditType {Namen ndern von}
translate D NameEditSelect {Welche Spiele sollen gendert werden?}
translate D NameEditReplace {Ersetze}
translate D NameEditWith {durch}
translate D NameEditMatches {Vorschlag mit Strg+1 - Strg+9 auswhlen}
translate D CheckGames {Konsistenzprfung}
translate D CheckGamesWhich {Konsistenzprfung}
translate D CheckAll {Alle Partien}
translate D CheckSelectFilterGames {Partien im Filter}

# Classify window:
translate D Classify {Klassifiziere}
translate D ClassifyWhich {Partien ECO-klassifizieren}
translate D ClassifyAll {Alle Spiele (berschreibe alte ECO-Codes)}
translate D ClassifyYear {Alle Spiele  aus dem letzten Jahr}
translate D ClassifyMonth {Alle Spiele aus dem letzten Monat}
translate D ClassifyNew {Nur Spiele ohne ECO-Code}
translate D ClassifyCodes {ECO-Codes verwenden}
translate D ClassifyBasic {Standard Codes ("B12", ...)}
translate D ClassifyExtended {mit Scid-Erweiterung ("B12j", ...)}

# Compaction:
translate D NameFile {Namendatenbank}
translate D GameFile {Partiendatenbank}
translate D Names {Namen}
translate D Unused {Unbenutzt}
translate D SizeKb {Gre (kB)}
translate D CurrentState {Momentaner Stand}
translate D AfterCompaction {nach Kompression}
translate D CompactNames {Komprimiere Namen}
translate D CompactGames {Komprimiere Partien}
translate D NoUnusedNames "Es gibt keine unbenutzen Namen, die Namensdatei ist vollstndig komprimiert."
translate D NoUnusedGames "Die Partiedatei ist vollstndig komprimiert."
translate D GameFileCompacted {Die Partiedatei der Datenbank wurde komprimiert.}

# Sorting:
translate D SortCriteria {Kriterium}
translate D AddCriteria {Fge Sortierkriterium hinzu}
translate D CommonSorts {bliche Sortierkriterien}
translate D Sort {Sortiere}

# Exporting:
translate D AddToExistingFile {Anhngen an eine bestehende Datei}
translate D ExportComments {Kommentare exportieren}
translate D ExportVariations {Varianten exportieren}
translate D IndentComments {Kommentare einrcken}
translate D IndentVariations {Varianten einrcken}
translate D ExportColumnStyle {Tabellarisch: ein Zug pro Zeile}
translate D ExportSymbolStyle {Symbolische Notation }
translate D ExportStripMarks \
  {Felder-/Pfeilemarkierzeichen\naus den Kommentaren entfernen}

# Goto game/move dialogs:
translate D LoadGameNumber {Geben Sie die zu ladende Spielnr. ein:}
translate D GotoMoveNumber {Gehe zu Zugnr.:}
translate D CopyAllGames {Kopiere alle Spiele nach}

# Copy games dialog:
translate D CopyGames {Kopiere Spiele}
translate D CopyConfirm {
 Mchten sie wirklich die [::utils::thousands $nGamesToCopy]
 Spiele aus dem Filter
 in der Datenbank "$fromName"
 in die Datenbank "$targetName"
 kopieren?
}
translate D CopyErr {Kann Spiele nicht kopieren}
translate D CopyErrSource {Die Quelldatenbank}
translate D CopyErrTarget {Die Zieldatenbank}
translate D CopyErrNoGames {hat keine Spiele im Filter}
translate D CopyErrReadOnly {ist schreibgeschtzt}
translate D CopyErrNotOpen {ist nicht geffnet}

# Colors:
translate D LightSquares {Helle Felder}
translate D DarkSquares {Dunkle Felder}
translate D SelectedSquares {Ausgewhlte Felder}
translate D SuggestedSquares {Zugvorschlagsfelder}
translate D WhitePieces {Weie Steine}
translate D BlackPieces {Schwarze Steine}
translate D WhiteBorder {Weie Umrandung}
translate D BlackBorder {Schwarze Umrandung}

# Novelty window:
translate D FindNovelty {Finde Neuerung}
translate D Novelty {Neuerung}
translate D NoveltyInterrupt {Neuerungensuche abgebrochen}
translate D NoveltyNone {In dieser Partie wurde keine Neuerung gefunden}
translate D NoveltyHelp {Scid wird den ersten Zug aus der aktuellen Partie finden, welcher zu einer Position fhrt, die nicht in der gewhlten Datenbank oder in dem ECO-Erffnungsbuch enthalten ist.}

# Sounds configuration:
translate D SoundsFolder {Verzeichnis fr Sprachausgabedateien}
translate D SoundsFolderHelp {Das Verzeichnis sollte enthalten: King.wav, a.wav, 1.wav etc.}
translate D SoundsAnnounceOptions {Optionen fr Zugankndigung}
translate D SoundsAnnounceNew {Kndige neue Zge an, wenn sie ausgefhrt werden}
translate D SoundsAnnounceForward {Knde Zug an beim Vorwrtspielen}
translate D SoundsAnnounceBack {Kndige Zug an beim Zurckgehen}
translate D SoundsSoundDisabled {Scid hat das Snack Audio Paket beim Start nicht gefunden.\nTon ist abgeschaltet.}

# Upgrading databases:
translate D Upgrading {Upgrading}
translate D ConfirmOpenNew {
Dies ist eine Datenbank im alten (Scid 3.x) Format, die nicht in Scid 4.x
geffnet werden kann. Aber eine Version im neuen Format wurde schon erstellt.

Wollen Sie die Version der Datenbank im neuen Format ffnen?
}
translate D ConfirmUpgrade {
Dies ist eine Datenbank im alten (Scid 3.x) Format. Vor der Verwendung in
Scid 4 mu eine Version im neuen Format der Datenbank erstellt werden.

Beim Erstellen der neuen Version der Datenbank bleiben die Dateien der alten Version erhalten.

Dieser Vorgang kann eine Zeitlang dauern, mu aber nur einmal durchgefhrt
werden. Sie knnen jederzeit abbrechen, wenn es Ihnen zu lange dauert.

Soll das Erstellen der Datenbank im neuen Format jetzt durchgefhrt werden?
}

# Recent files options:
translate D RecentFilesMenu {Anzahl letzter Dateien im Dateimen}
translate D RecentFilesExtra {Anzahl letzter Dateien im Untermen}

# My Player Names options:
translate D MyPlayerNamesDescription {
Geben Sie unten eine Liste der bevorzugten Spielernamen ein, ein Name pro Zeile. Platzhalterzeichen (z.B. "?" fr ein beliebiges einzelnes Zeichen, "*" fr jede beliebige Folge von Zeichen) sind erlaubt.

Jedesmal, wenn ein Spiel mit einem aufgelisteten Spielernamen geladen wird, wird das Schachbrett im Hauptfenster erforderlichenfalls gedreht, um das Spiel aus der Sicht des betreffenden Spielers zu zeigen.
}
translate D showblunderexists {Enginefehler anzeigen}
translate D showblundervalue {Fehlerbewertung anzeigen}
translate D showscore {Bewertung anzeigen}
translate D coachgame {Coach Partie}
translate D configurecoachgame {Trainingspartie konfigurieren}
translate D configuregame {Spiel konfigurieren}
translate D Phalanxengine {Phalanx engine}
translate D Coachengine {Coach Engine}
translate D difficulty {Schwierigkeit}
translate D hard {schwer}
translate D easy {leicht}
translate D Playwith {Spiel mit}
translate D white {Wei}
translate D black {Schwarz}
translate D both {beide}
translate D Play {Spielen}
translate D Noblunder {Kein Fehler}
translate D blunder {Fehler}
translate D Noinfo {-- Keine Info --}
translate D PhalanxOrTogaMissing {Phalanx oder Toga nicht gefunden!}
translate D moveblunderthreshold {fehlerhafter Zug, wenn Verlust grer als}
translate D limitanalysis {Analysezeit der Engine begrenzen}
translate D seconds {Sekunden}
translate D Abort {Abbrechen}
translate D Resume {Fortfahren}
translate D OutOfOpening {Ende der Erffnung}
translate D NotFollowedLine {You did not follow the line}
translate D DoYouWantContinue {Mchten sie fortfahren?}
translate D CoachIsWatching {Coach schaut zu}
translate D Ponder {Berechnen im Hintergrund}
translate D LimitELO {Strke begrenzen (ELO)}
translate D DubiousMovePlayedTakeBack {Zweifelhafter Zug gespielt, wollen Sie ihn zurcknehmen?}
translate D WeakMovePlayedTakeBack {Dies ist kein guter Zug, wollen Sie ihn zurcknehmen?}
translate D BadMovePlayedTakeBack {Dies ist ein schlechter Zug, wollen Sie ihn zurcknehmen?}
translate D Iresign {Ich gebe auf}
translate D yourmoveisnotgood {Ihr Zug ist nicht gut}
translate D EndOfVar {Variantenende}
translate D Openingtrainer {Erffnungstrainer}
translate D DisplayCM {Kandidatenzge anzeigen}
translate D DisplayCMValue {Wert der Kandidatenzge anzeigen}
translate D DisplayOpeningStats {Statistik anzeigen}
translate D ShowReport {Bericht anzeigen}
translate D NumberOfGoodMovesPlayed {gute Zge gespielt}
translate D NumberOfDubiousMovesPlayed {zweischneidige Zge gespielt}
translate D NumberOfMovesPlayedNotInRepertoire {Zge auerhalb des Repertoirs gespielt}
translate D NumberOfTimesPositionEncountered {Wiederholungen der Position}
translate D PlayerBestMove  {Nur beste Zge erlauben}
translate D OpponentBestMove {Gegner spielt besten Zug}
translate D OnlyFlaggedLines {Nur markierte Linien}
translate D resetStats {Statistik zurcksetzen}
translate D Repertoiretrainingconfiguration {Konfiguration Trainingsrepertoire}
translate D Loadingrepertoire {Lade Repertoire}
translate D Movesloaded {Zge geladen}
translate D Repertoirenotfound {Repertoire nicht gefunden}
translate D Openfirstrepertoirewithtype {Zuerst eine Erffnungsdatenbank mit entsprechendem Type/Icon ffnen.}
translate D Movenotinrepertoire {Zug nicht im Repertoire}
translate D PositionsInRepertoire {Positionen im Repertoire}
translate D PositionsNotPlayed {nicht gespielte Positionen}
translate D PositionsPlayed {gespielte Positionen}
translate D Success {Erfolgreich}
translate D DubiousMoves {Zweifelhafte Zge}
translate D OutOfRepertoire {Nicht im Repertoire}
translate D ConfigureTactics {Taktik konfigurieren}
translate D ResetScores {"Gelst" zurcksetzten}
translate D LoadingBase {Lade Datenbank}
translate D Tactics {Taktik}
translate D ShowSolution {Lsung zeigen}
translate D NextExercise {Nchste Aufgabe}
translate D PrevExercise {Vorherige Aufgabe}
translate D StopTraining {Training beenden}
translate D Next {Nchste}
translate D ResettingScore {"Gelst" zurcksetzen}
translate D LoadingGame {Lade Partie}
translate D MateFound {Matt gefunden}
translate D BestSolutionNotFound {Beste Lsung NICHT gefunden!}
translate D MateNotFound {Matt nicht gefunden}
translate D ShorterMateExists {Krzeres Matt existiert}
translate D ScorePlayed {Bewertung gepielt}
translate D Expected {erwarted}
translate D ChooseTrainingBase {Trainingsdatenbank auswhlen}
translate D Thinking {Denke...}
translate D AnalyzeDone {Analyse beendet}
translate D WinWonGame {Gewinne gewonnene Partie}
translate D Lines {Variantenzahl}
translate D ConfigureUCIengine {UCI Engine konfigurieren}
translate D SpecificOpening {Ausgewhlte Erffnung}
translate D StartNewGame {Neue Partie}
translate D FixedLevel {Feste Strke}
translate D Opening {Erffnung}
translate D RandomLevel {Zufallsstrke}
translate D StartFromCurrentPosition {Von aktueller Position starten}
translate D FixedDepth {Feste Tiefe}
translate D Nodes {Knoten} 
translate D Depth {Tiefe}
translate D Time {Zeit} 
translate D SecondsPerMove {Sekunden pro Zug}
translate D Engine {Engine}
translate D TimeMode {Zeitmodus}
translate D TimeBonus {Zeit+\nBonus}
translate D TimeMin {min}
translate D TimeSec {s}
translate D AllExercisesDone {Alle bungen gemacht}
translate D MoveOutOfBook {Zug nicht mehr im Buch}
translate D LastBookMove {Letzter Buchzug}
translate D AnnotateSeveralGames {Von aktueller Partie bis Partie:}
translate D FindOpeningErrors {Erffnungsfehler finden}
translate D MarkTacticalExercises {Taktische bungen markieren}
translate D UseBook {Buch benutzen}
translate D MultiPV {Multivariantenmodus}
translate D Hash {Hash Speicher}
translate D OwnBook {Engine Buch verwenden}
translate D BookFile {Erffnungsbuch}
translate D AnnotateVariations {Varianten kommentieren}
translate D ShortAnnotations {Kurze Kommentare}
translate D addAnnotatorTag {Kommentar Tag hinzufgen}
translate D AddScoreToShortAnnotations {Bewertung hinzufgen}
translate D Export {Export}
translate D BookPartiallyLoaded {Buch teilweise geladen}
translate D Calvar {Training: Variantenberechnung}
translate D ConfigureCalvar {Konfiguration}
translate D Reti {Reti}
translate D English {Englische Erffnung}
translate D d4Nf6Miscellaneous {1.d4 Nf6 Verschiedene}
translate D Trompowsky {Trompowsky}
translate D Budapest {Budapest}
translate D OldIndian {Altindische Verteidigung}
translate D BenkoGambit {Benko Gambit}
translate D ModernBenoni {Moderne/Benoni-Verteidigung}
translate D DutchDefence {Hollndische Verteidigung}
translate D Scandinavian {Skandinavische Verteidigung}
translate D AlekhineDefence {Aljechin Verteidigung}
translate D Pirc {Pirc-Verteidigung}
translate D CaroKann {Caro-Kann}
translate D CaroKannAdvance {Caro-Kann Vorstovariante}
translate D Sicilian {Sizilianisch}
translate D SicilianAlapin {Sizilianisch, Alapin Variante}
translate D SicilianClosed {Geschlossene Sizilianische Verteidigung}
translate D SicilianRauzer {Sizilianisch, Rauzer Angriff}
translate D SicilianDragon {Sizilianisch, Drachenvariante}
translate D SicilianScheveningen {Sizilianisch, Scheveningen}
translate D SicilianNajdorf {Sizilianisch, Najdorf}
translate D OpenGame {Offene Spiele}
translate D Vienna {Wiener Verteidigung}
translate D KingsGambit {Knigsgambit}
translate D RussianGame {Russische Verteidigung}
translate D ItalianTwoKnights {Italienische Erffnung}
translate D Spanish {Spanisch Partie}
translate D SpanishExchange {Spanisch, Abtauschvariante}
translate D SpanishOpen {Spanisch, offene Systeme}
translate D SpanishClosed {Spanisch, geschlossene Systeme}
translate D FrenchDefence {Franzsische Verteidigung}
translate D FrenchAdvance {Franzsisch, Vorstovariante}
translate D FrenchTarrasch {Franzsisch, Tarrasch}
translate D FrenchWinawer {Franzsisch, Winawer}
translate D FrenchExchange {Franzsisch, Abtauschvariante}
translate D QueensPawn {Damenbauernspiel}
translate D Slav {Slavisch}
translate D QGA {Angenommenes Damengambit}
translate D QGD {Abgelehntes Damengambit}
translate D QGDExchange {Abgelehntes Damengambit, Abtauschvariante}
translate D SemiSlav {Semi-Slawisch}
translate D QGDwithBg5 {Abgelehntes Damengambit mit Lg5}
translate D QGDOrthodox {Abgelehntes Damengambit, Orthodoxe Variante}
translate D Grunfeld {Grnfeld-Verteidigung}
translate D GrunfeldExchange {Grnfeld, Abtauschvariante}
translate D GrunfeldRussian {Grnfeld-Verteidigung, Russische Variante}
translate D Catalan {Katalanische Verteidigung}
translate D CatalanOpen {Katalanisch, offen}
translate D CatalanClosed {Katalanisch, geschlossen}
translate D QueensIndian {Dameninsche Verteidigung}
translate D NimzoIndian {Nimzoindische Verteidigung}
translate D NimzoIndianClassical {Nimzoindisch, Klassische Variante}
translate D NimzoIndianRubinstein {Nimzoinsisch, Rubinstein}
translate D KingsIndian {Knigsindische Verteidigung}
translate D KingsIndianSamisch {Knigsindisch, Smisch}
translate D KingsIndianMainLine {Knigsindisch, Hauptvariante}
translate D ConfigureFics {FICS Konfigurieren}
translate D FICSGuest {Gastlogin}
translate D FICSServerPort {Serverport}
translate D FICSServerAddress {IP Adresse}
translate D FICSRefresh {Aktualisieren}
translate D FICSTimesealPort {Timeseal Port}
translate D FICSSilence {Konsolenfilter}
translate D FICSOffers {Herausforderungen}
translate D FICSConsole {Konsole}
translate D FICSGames {laufende Partien}
translate D FICSUnobserve {Beobachtung abbrechen}
translate D FICSProfile {Eigenes Profil ausgeben}
translate D FICSRelayedGames {bertragene Partien}
translate D FICSFindOpponent {Gegner suchen}
translate D FICSTakeback {Zurcknehmen}
translate D FICSTakeback2 {2 zurcknehmen}
translate D FICSInitTime {Zeit (min)}
translate D FICSIncrement {Inkrement (s)}
translate D FICSRatedGame {Wertungspartie}
translate D FICSAutoColour {automatisch}
translate D FICSManualConfirm {manuell besttigen}
translate D FICSFilterFormula {Filterformel anwenden}
translate D FICSIssueSeek {Partie anbieten}
translate D FICSChallenge {Herausfordern}
translate D FICSAccept {Nehmen Sie an?}
translate D FICSDecline {Ablehnen}
translate D FICSColour {Farbe auswhlen}
translate D FICSSend {senden}
translate D FICSConnect {Verbinden}
translate D FICSdefaultuservars {Standardvariablen verwenden}
translate D FICSObserveconfirm {Besttige Beobachtung der Partie}
translate D FICSpremove {Premoves aktivieren}
translate D FICSObserve {Beobachten}
translate D FICSRatedGames {Bewertete Partien}
translate D FICSUnratedGames {Unbewertete Partien}
translate D FICSRated {Bewertet}
translate D FICSUnrated {Unbewertet}
translate D FICSRegisteredPlayer {Nur registrierte Spieler}
translate D FICSFreePlayer {Nur freie Spieler}
translate D FICSNetError {Netzwerkfehler\nKeine Verbindung zu }

translate D GameReview {Partieanalyse}
translate D GameReviewTimeExtended {Lange Bedenkzeit}
translate D GameReviewMargin {Fehlergrenze}
translate D GameReviewAutoContinue {Bei korrektem Zug Automatisch weiter}
translate D GameReviewReCalculate {Verwende lange Bedenkzeit}
translate D GameReviewAnalyzingMovePlayedDuringTheGame {Analysiere den Partiezug}
translate D GameReviewAnalyzingThePosition {Analysiere Stellung}
translate D GameReviewEnterYourMove {Zug eingeben}
translate D GameReviewCheckingYourMove {berprfe Antwort}
translate D GameReviewYourMoveWasAnalyzed {Antwort wurde analysiert}
translate D GameReviewYouPlayedSameMove {Identischer Zug zur Partie}
translate D GameReviewScoreOfYourMove {Wertung des Antwortzuges}
translate D GameReviewGameMoveScore {Wertung des Partiezuges}
translate D GameReviewEngineScore {Bewertung der Engine}
translate D GameReviewYouPlayedLikeTheEngine {Antworzug wie Engine}
translate D GameReviewNotEngineMoveButGoodMove {Nicht der Computerzug, aber ebenfalls ein guter Zug!}
translate D GameReviewMoveNotGood {Dieser Zug ist nicht gut. Bewertung:}
translate D GameReviewMovesPlayedLike {Zge gespielt wie Partie}
translate D GameReviewMovesPlayedEngine {Zge wie Computer gespielt}

# Correspondence Chess Dialogs:
translate D CCDlgCGeneraloptions {Allgemeine Einstellungen}

translate D CCDlgLoginName  {Login Name:}
translate D CCDlgPassword   {Passwort:}
translate D CCDlgShowPassword {Passwort anzeigen}
translate D ExtHWConfigConnection {Hardware Konfigurieren}
translate D ExtHWPort {Schnittstelle}
translate D ExtHWEngineCmd {Engine Kommando}
translate D ExtHWEngineParam {Engine Parameter}
translate D ExtHWShowButton {Knopf in Werkzeugleiste anzeigen}
translate D ExtHWHardware {Hardware}
translate D ExtHWNovag {Novag Citrine}
translate D ExtHWInputEngine {Input Engine}
translate D ExtHWNoBoard {Kein Brett verbunden}
translate D NovagReferee {Nur Zge aufzeichnen}
translate D IEConsole {Input Engine Konsole}
translate D IESending {Sende Zge fr}
translate D IESynchronise {Synchronisieren}
translate D IERotate  {Brett drehen}
translate D IEUnableToStart {Input Engine konnte nicht gestartet werden:}
translate D DoneWithPosition {Positionsbearbeitung beendet}
translate D Board {Brett}
translate D showGameInfo {Partieinformation anzeigen}
translate D autoResizeBoard {Brettgre automatisch berechnen}
translate D DockTop {Nach oben}
translate D DockBottom {Nach unten}
translate D DockLeft {Nach links}
translate D DockRight {Nach rechts}
translate D Undock {Fenster lsen}
#Gamelist
translate D ChangeIcon {Datenbank Icon ndern...}
translate D NewGameListWindow {Neue Partieliste}
translate D LoadatStartup {Beim Starten laden}
translate D ShowHideDB {Datenbank anzeigen/verbergen}
translate D ChangeFilter {Filter ndern}
translate D ChangeLayout {Sortierkriterien und Spaltenlayout laden/speichern/ndern }
translate D ShowHideStatistic {Statistik anzeigen/verbergen}
translate D BoardFilter {Nur Partien, die gleich der aktuellen Brettstellung sind, anzeigen}
translate D CopyGameTo {Kopiere Partie nach}
translate D FindBar {Suchleiste}
translate D FindCurrentGame {Aktuelle Partie finden}
translate D DeleteGame {Partie lschen}
translate D UndeleteGame {Partie wiederherstellen}
translate D ResetSort {Sortierung zurcksetzten}

translate D ConvertNullMove {Null-Zge in Kommentare umwandeln}
translate D SetupBoard {Stellung eingeben}
translate D Rotate {Drehen}
translate D SwitchColors {Farbe wechseln}
translate D FlipBoard {Brett drehen}
translate D ImportPGN {Importiere PGN Partieen}
translate D ImportingFiles {Importiere PGN Dateien nach}
translate D ImportingFrom {Importiere von}
translate D ImportingIn {Importiere Partien nach}
translate D UseLastTag {Letzte Tags\nverwenden}
translate D Random {Zufllig}
translate D BackToMainline {Zurck zur Hauptvariante}
translate D LeaveVariant {Variante verlassen}
translate D Autoplay {Vorspielen}
translate D ShowHideCoords {Beschriftung ein/aus}
translate D ShowHideMaterial {Material ein/aus}
translate D FullScreen {Vollbild}
translate D FilterStatistic {Filter Statistik}
translate D MakeCorrections {Korrigieren}
translate D Surnames {Nachnamen}
translate D Ambiguous {Mehrdeutig}
}
#Preferences Dialog
translate D OptionsToolbar "Werkzeugleiste"
translate D OptionsBoard "Schachbrett"
translate D OptionsMenuColor "Menfarben"
translate D OptionsBoardSize "Brettgre"
translate D OptionsBoardPieces "Figurensatz"
translate D OptionsInternationalization "Sprachumgebung"
translate D MenuColorForeground "Text"
translate D MenuColorBackground "Hintergrund"
translate D MenuColorSelect "Auswahl"
translate D OptionsTablebaseDir "Bis zu 4 Verzeichnisse der Endspieltabellen auswhlen:"
translate D BestMoveArrow "Besten Zug anzeigen"
translate D NewLocalEngine "+ Neue Engine ..."

##########
#
# ECO Opening name translations:

translateECO D {
  Accelerated {, Beschleunigt}
  {: Accelerated} Beschleunigt
  Accepted {, Angenommen}
  {: Accepted} Angenommen
  Advance Vorsto
  {as Black} {mit Schwarz}
  Attack Angriff
  Bishop Lufer
  Bishop's Lufer
  Classical Klassisch
  Closed Geschlossen
  {Closed System} {Geschlossenes System}
  Counterattack Gegenangriff
  Countergambit Gegengambit
  Declined {, Abgelehnt}
  Defence Verteidigung
  deferred verzgert
  Deferred {, verzgert}
  Early Frhe
  Exchange Abtausch
  Game Partie
  Improved verbessert
  King's Knigs
  Knight Springer
  Line Variante
  {Main Line} Hauptvariante
  Open Offen
  Opening Erffnung
  Queen's Damen
  Queenswap Damentausch
  Symmetrical Symmetrisch
  Variation Variante
  Wing Flgel
  with mit
  without ohne

  Alekhine Aljechin
  Averbakh Awerbach
  Botvinnik Botwinnik
  Chigorin Tschigorin
  Polugaevsky Polugajewski
  Rauzer Rauser
  Sveshnikov Sweschnikow

  Austrian sterreichisch
  Berlin Berliner
  Bremen Bremer
  Catalan Katalanisch
  Czech Tschechisch
  Dutch Hollndisch
  English Englisch
  French Franzsisch
  Hungarian Ungarisch
  Indian Indisch
  Italian Italienisch
  Latvian Lettisch
  Meran Meraner
  Moscow Moskau
  Polish Polnisch
  Prague Prager
  Russian Russisch
  Scandinavian Skandinavisch
  Scheveningen Scheveninger
  Scotch Schottisch
  Sicilian Sizilianisch
  Slav Slawisch
  Spanish Spanisch
  Swedish Schwedisch
  Swiss Schweizer
  Vienna Wiener
  Yugoslav Jugoslawisch

  {Accelerated Fianchetto} {Beschleunigtes Fianchetto}
  {Accelerated Pterodactyl} {Beschleunigter Pterodactylus}
  {Alekhine Defence} Aljechin-Verteidigung
  {Alekhine Variation} Aljechin-Variante
  {Alekhine: Smisch Attack} {Aljechin: Wiener System (Smisch-Angriff)}
  {Anderssen Opening} Anderssen-Erffnung
  {Anti-King's Indian} Anti-Knigsindisch
  {Austrian Attack} {sterreichischer Angriff}
  {Benko Gambit} Wolga-Gambit
  {Benko Opening} Benk-Erffnung
  {Berlin Defence} {Berliner Verteidigung}
  Chameleon Chamleon
  Chelyabinsk Tscheljabinsk
  {Classical Defence} {Klassische Verteidigung}
  {Spanish: Classical Defence} {Spanisch: Klassische (Cordel-) Verteidigung}
  {Classical Exchange} {Klassischer Abtausch}
  {Classical Variation} {Klassische Variante}
  {Closed Berlin} {Geschlossener Berliner}
  {Open Berlin} {Offener Berliner}
  {Bird's,} {Bird,}
  {Bird's Defence} Bird-Verteidigung
  {Bird's Deferred} {Verzgerte Bird}
  {Bishop's Opening} Luferspiel
  {Botvinnik System} Botwinnik-System
  {Central Variation} Zentralvariante
  {Centre Attack} Zentrumsangriff
  {Centre Game} Mittelgambit
  {Danish Gambit} {Nordisches Gambit}
  Dragon Drachen
  {Dutch Variation} {Hollndische Variante}
  {Early Exchange} {Frher Abtausch}
  {Early Queenswap} {Frher Damentausch}
  {English Attack} {Englischer Angriff}
  {English: King's} {Englisch: Knigsbauer}
  {English Variation} {Englische Variante}
  {Englund Gambit} Englund-Gambit
  {Exchange Variation} Abtauschvariante
  {Fianchetto Variation} Fianchettovariante
  {Flohr Variation} Flohr-Variante
  {Four Knights} Vierspringer
  {Four Knights Game} Vierspringerspiel
  {Four Pawns} Vierbauern
  {Four Pawns Attack} Vierbauernangriff
  {French Variation} {Franzsische Variante}
  {From Gambit} {Froms Gambit}
  {Goring Gambit} {Gring-Gambit}
  {Grob Gambit} {Grobs Gambit}
  {Hungarian Defence} {Ungarische Verteidigung}
  {Indian Variation} {Indische Variante}
  {Italian Game} {Italienische Partie}
  KGD {Abgel. Knigsgambit}
  {Classical KGD} {Klassisches abgelehntes Knigsgambit}
  {Keres Variation} Keres-Variante
  KGA {Angen. Knigsgambit}
  {KGA: Bishop's Gambit} Knigslufergambit
  {KGA: King's Knight Gambit} Knigsspringergambit
  {King's Gambit} Knigsgambit
  {King's Gambit Accepted} {Angen. Knigsgambit}
  {King's Gambit Accepted (KGA)} {Angen. Knigsgambit}
  {King's Indian} Knigsindisch
  KIA {Knigsindischer Angriff}
  {King's Knight Gambit} Knigsspringergambit
  {King's Pawn} Knigsbauer
  {Lasker Variation} {Lasker-Variante}
  {Latvian Gambit} {Lettisches Gambit}
  {Maroczy Bind} {Maroczy-Aufbau}
  {Marshall Variation} Marshall-Variante
  {Modern Attack} {Moderner Angriff}
  {Modern Steinitz} {Moderne Steinitz}
  {Modern Variation} {Moderne Variante}
  {Moscow Variation} {Moskauer Variante}
  Nimzo-Indian Nimzoindisch
  {Old Benoni} {Klassisches Benoni}
  {Old Indian} Altindisch
  {Old Indian Attack} {Altindisch i.A.}
  {Old Steinitz} Steinitz-Verteidigung
  {Open Game} {Offene Partie}
  {Poisoned Pawn} {Vergifteter Bauer}
  {Polish Variation} {Polnische Variante}
  {Polugaevsky Variation} {Polugajewski-Variante}
  {Queen's Gambit} Damengambit
  {Queen's Gambit Accepted} {Angen. Damengambit}
  QGA {Angen. Damengambit}
  {Queen's Gambit Accepted (QGA)} {Angenommenes Damengambit}
  {Reversed QGA} {Angen. Damengambit i.A.}
  QGD {Abgel. Damengambit}
  {Queen's Gambit Declined (QGD)} {Abgelehntes Damengambit}
  {Reversed QGD} {Abgel. Damengambit i.A.}
  {Queen's Indian} Damenindisch
  {Queen's Pawn} Damenbauer
  {Queen's Pawn Game} Damenbauerspiel
  {Reversed Slav} {Slawisch i.A.}
  {Rubinstein Variation} Rubinstein-Variante
  {Russian Game} {Russische Partie}
  {Russian Game (Petroff Defence)} {Russische Partie}
  {Russian-Three Knights Game} {Russisches Dreispringerspiel}
  {Scandinavian (Centre Counter)} Skandinavisch
  Schliemann Jnisch
  {Schliemann (Jnisch)} {Jnisch-Gambit (Schliemann)}
  {Scotch Opening} {Schottische Erffnung}
  {Sicilian Defence} {Sizilianische Verteidigung}
  {Sicilian Variation} {Sizilianische Variante}
  {Slav Defence} {Slawische Verteidigung}
  Smith-Morra Morra
  {Smith-Morra Accepted} {Angenommenes Morra-Gambit}
  {Smith-Morra Gambit} Morra-Gambit
  {Spanish (Ruy Lopez)} {Spanische Partie}
  {Start position} Ausgangsstellung
  {Steinitz Deferred} Rubinstein-Aufbau
  {Swedish Variation} {Schwedische Variante}
  {Swiss Variation} {Schweizer Variante}
  {Tarrasch's Gambit} {Tarrasch-Gambit}
  {Three Knights} Dreispringer
  {3 Knights} Dreispringer
  {Three Knights Game} Dreispringerspiel
  {Three Pawns Attack} Dreibauernangriff
  {Two Knights} Zweispringer
  {Two Knights Defence} Zweispringer-Verteidigung
  {Two Knights Variation} Zweispringer-Variante
  {Two Pawns} Zweibauern
  {Two Pawns Attack} Zweibauernangriff
  {Wing Gambit} Flgel-Gambit
  {Yugoslav Attack} {Jugoslawischer Angriff}
}


############################################################
#
# German help pages:


##########
# Contents
#
set helpTitle(D,Contents) "Inhaltsverzeichnis"
set helpText(D,Contents) {<h1>Inhaltsverzeichnis Scid-Hilfe</h1>


<h4>Start und allgemeine Hilfe</h4>
<ul>
<li><a Guide><b>Kurzanleitung</b> Benutzung von Scid</a> <red>(Zuerst lesen!)</red></li>
<li><a Hints><b>Hinweise</b> zum effizienteren Arbeiten mit Scid</a></li>
<li><a MainWindow>Das Scid-<b>Hauptfenster</b></a></li>
<li><a Menus>Die Scid-<b>Mens</b></a></li>
<li><a Moves><b>Zge</b> eingeben</a></li>
<li><a Searches><b>Suchen</b> in Scid</a></li>
<li><a Clipbase>Die <b>Ablage</b>-Datenbank</a></li>
<li><a Annotating>Partien <b>kommentieren</b></a> </li>
</ul>

<h4>Andere Scid-Fenster</h4>
<ul>
<li><a Analysis><b>Analyse</b>-Fenster</a></li>
<li><a Reports><b>Berichte</b></a> </li>
<li><a Book><b>Buch</b>-Fenster</a></li>
<li><a Finder><b>Dateisuche</b>-Fenster</a></li>
<li><a Switcher><b>Datenbank-Umschalter</b></a></li>
<li><a TB><b>Endspieltabellen</b> in Scid verwenden</a> </li>
<li><a PTracker><b>Figurenverteilung</b></a></li>
<li><a Graphs><b>Grafik</b>-Fenster</a></li>
<li><a Comment><b>Kommentareditor</b></a></li>
<li><a Crosstable><b>Turniertabellen</b>-Fenster</a></li>
<li><a GameList><b>Partieliste</b>-Fenster</a></li>
<li><a Import><b>Partie-Import</b>-Fenster</a></li>
<li><a PGN><b>PGN</b> (Partietext)-Fenster</a></li>
<li><a Repertoire><b>Repertoire-Editor</b></a></li>
<li><a PList><b>Spielersuche</b></a></li>
<li><a PInfo><b>Spieler-Information</b></a></li>
<li><a TacticalGame><b>Trainingspartie</b>-Fenster</a></li>
<li><a SeriousGame><b>Ernste Partie</b></a></li>
<li><a CalVar><b>Training Varianten berechnen</b>-Fenster</a></li>
<li><a OpeningTrainer><b>Erffnungstrainer</b>-Fenster</a></li>
<li><a Tmt><b>Turniersuche</b></a></li>
<li><a Tree><b>Zugbaum</b>-Fenster</a></red></li>
</ul>

<h4>Weitere Hilfsprogramme und Informationen</h4>
<ul>
<li><a Maintenance><b>Datenbank-Wartung</b></a></li>
<li><a Sorting>Datenbank<b> sortieren</b></a></li>
<li><a Compact>Datenbank<b> komprimieren</b></a></li>
<li><a ECO><b>ECO</b>-Erffnungsklassifikation</a></li>
<li><a EPD><b>EPD</b>-Dateien</a></li>
<li><a Export>Partien in Textdateien <b>exportieren</b></a></li>
<li><a Cmdline><b>Kommandozeilen</b>-Optionen</a></li>
<li><a LaTeX>Scid und <b>LaTeX</b></a> </li>
<li><a Bookmarks><b>Lesezeichen</b></a></li>
<li><a Flags>Partie-<b>Kennzeichen</b> (Flags)</a></red></li>
<li><a Options><b>Optionen</b> und Prferenzen</a></li>
<li><a Pgnscid><b>Pgnscid</b>: PGN-Dateien konvertieren</a></li>
<li><a NAGs><b>NAG</b>-Standard-Kommentarwerte</a></li>
<li><a Formats>Scids Datenbank-<b>Dateiformate</b></a></li>
<li><a Author>Kontakt-Information</a></li>
</ul>

<p><footer>(Aktualisiert: Scid 4.7, August 2018)</footer></p>
}


###############
### Topic Index

set helpTitle(D,Index) "Hilfe-Index"
set helpText(D,Index) {<h1>Scid: Hilfe-Index</h1>

<h3>A</h3>
<ul>
<li><a Clipbase>Ablage-Datenbank</a></li>
<li><a Analysis List>Analyse-Engines, Liste der</a></li>
<li><a Analysis>Analysefenster</a></li>
<li><a MainWindow Autoplay>Automatisches Vorspielen</a></li>
<li><a Author>Autor, Kontaktaufnahme</a></li>
</ul>

<h3>B</h3>
<ul>
<li><a Menus Edit>Bearbeiten-Men</a></li>
<li><a Maintenance Cleaner>Bereiniger</a></li>
<li><a Tree Best>Beste Partien</a></li>
<li><a Graphs Rating>Bewertungsgraph</a></li>
<li><a GameList Browsing>Blttern in Partien</a></li>
<li><a Searches Board>Brettsuche</a></li>
</ul>

<h3>D</h3>
<ul>
<li><a Finder>Dateisuche</a></li>
<li><a Formats>Dateiformate</a></li>
<li><a Menus File>Datei-Men</a></li>
<li><a Formats>Datenbank-Dateiformate</a></li>
<li><a Compact>Datenbank-Komprimierung</a></li>
<li><a Sorting>Datenbank sortieren</a></li>
<li><a Switcher>Datenbank-Umschalter</a></li>
<li><a Maintenance>Datenbank-Wartung</a></li>
<li><a Maintenance Twins>Dubletten (doppelte Partien)</a></li>
</ul>

<h3>E</h3>
<ul>
<li><a ECO Browser>ECO-Auswertung</a></li>
<li><a ECO Codes>ECO-Codesystem</a></li>
<li><a ECO>ECO-Erffnungsklassifikation</a></li>
<li><a TB>Endspieltabellen</a></li>
<li><a EPD>EPD-Dateien</a></li>
<li><a SeriousGame>Ernste Partie spielen</a></li>
<li><a Reports Opening>Erffnungsbericht</a></li>
<li><a ECO>Erffnungsklassifizierung (ECO)</a></li>
<li><a Repertoire>Erffnungsrepertoire</a></li>
<li><a Export>Exportieren, Partien in Textdateien</a></li>
</ul>

<h3>F</h3>
<ul>
<li><a Menus Windows>Fenster-Men</a></li>
<li><a PTracker>Figurenverteilungs-Fenster</a></li>
<li><a Searches Filter>Filter</a></li>
<li><a Export>Filter, exportieren</a></li>
<li><a Graphs Filter>Filtergrafik</a></li>
</ul>

<h3>G</h3>
<ul>
<li><a Graphs>Grafikfenster</a></li>
</ul>

<h3>H</h3>
<ul>
<li><a MainWindow>Hauptfenster</a></li>
<li><a Menus Help>Hilfe-Men</a></li>
<li><a Hints>Hinweise</a></li>
</ul>

<h3>I</h3>
<ul>
<li><a Import>Importieren</a></li>
<li><a Contents>Inhaltsverzeichnis</a></li>
</ul>

<h3>K</h3>
<ul>
<li><a Cmdline>Kommandozeilen-Optionen</a></li>
<li><a Comment>Kommentareditor</a></li>
<li><a NAGs>Kommentarzeichen</a></li>
<li><a Annotating>Kommentieren</a></li>
<li><a Compact>Komprimieren (Datenbank)</a></li>
<li><a Author>Kontaktinformation</a></li>
<li><a Crosstable>Turniertabellen</a></li>
<li><a Guide>Kurzanleitung fr Scid</a></li>
</ul>

<h3>L</h3>
<ul>
<li><a LaTeX>LaTeX</a>-Ausgabeformat</li>
<li><a Bookmarks>Lesezeichen</a></li>
<li><a Maintenance Twins>Lschen, Dubletten</a></li>
</ul>

<h3>M</h3>
<ul>
<li><a Flags>Kennzeichen</a></li>
<li><a Searches Material>Material-/Muster-Suche</a></li>
<li><a Menus>Mens</a></li>
</ul>

<h3>N</h3>
<ul>
<li><a NAGs>NAG-Kommentarwerte</a></li>
<li><a Maintenance Editing>Namen bearbeiten</a></li>
<li><a Maintenance Spellcheck>Namen, Schreibweisen</a></li>
<li><a Annotating Null>Nullzge</a></li>
</ul>

<h3>O</h3>
<ul>
<li><a Options>Optionen</a></li>
<li><a Appearance>Oberflche anpassen</a></li>
</ul>

<h3>P</h3>
<ul>
<li><a Searches Header>Partiedaten-Suche</a></li>
<li><a GameList>Partielisten</a></li>
<li><a Flags>Partie-Kennzeichen</a></li>
<li><a Menus Game>Partie-Men</a></li>
<li><a PGN>PGN-Fenster</a></li>
<li><a Pgnscid>Pgnscid</a></li>
</ul>

<h3>R</h3>
<ul>
<li><a Repertoire>Repertoire-Editor</a></li>
</ul>

<h3>S</h3>
<ul>
<li><a Moves>Schachzge eingeben</a></li>
<li><a Maintenance Spellcheck>Schreibkorrektur von Namen</a></li>
<li><a Sorting>Sortieren einer Datenbank</a></li>
<li><a Reports Player>Spielerbericht</a></li>
<li><a PInfo>Spielerinformation</a></li>
<li><a PList>Spielersuche</a></li>
<li><a CCIcons><b>Statusanzeigen im Fernschachfenster</b></a></li>
<li><a Searches>Suchen</a></li>
<li><a Menus Search>Suchen-Men</a></li>
<li><a Searches Filter>Such-Filter</a></li>
</ul>

<h3>T</h3>
<ul>
<li><a Moves Trial>Testmodus</a></li>
<li><a Tmt>Turniersuche</a></li>
<li>Training</li>
<ul>
<li><a OpeningTrainer>Erffnungstrainer</a></li>
<li><a CalVar>Varianten berechnen</a></li>
</ul>
</ul>

<h3>V</h3>
<ul>
<li><a Annotating Vars>Varianten</a></li>
</ul>

<h3>W</h3>
<ul>
<li><a Maintenance>Wartung</a></li>
<li><a Menus Tools>Werkzeug-Men</a></li>
</ul>

<h3>X</h3>
<ul>
<li><a CCXfcc>Xfcc-Untersttzung</a></li>
</ul>

<h3>Z</h3>
<ul>
<li><a Options Fonts>Zeichenstze</a></li>
<li><a Tree>Zugbaumfenster</a></li>
<li><a Moves>Zge eingeben</a></li>
<li><a GameList Browsing>Zusammenfhren, Partien</a></li>
</ul>

<p><footer>(Aktualisiert: Scid 3.6.23, Mrz 2008)</footer></p>
}


###############
### Quick guide

set helpTitle(D,Guide) "Kurzanleitung zur Benutzung von Scid"
set helpText(D,Guide) {<h1>Kurzanleitung zur Benutzung von Scid</h1>
<p>
Scid ist eine Schachdatenbank, mit welcher man Partiesammlungen
nach einer Vielzahl von Kriterien durchsuchen kann, Partien editieren
und mit Hilfe von Winboard- und UCI-kompatiblen Schachprogrammen
analysieren kann.
</p>
<p>
Scid benutzt ein eigenes, spezielles Drei-Dateien-Datenbankformat,
welches sehr schnell und kompakt ist, aber es kann auch das PGN-
(Portable Game Notation) Format lesen und schreiben. Scids
<a PGN>PGN-Fenster</a> zeigt die Notation der aktuellen Partie im
PGN-Format.
</p>
<p>
Man kann in Scid Partien zur Datenbank hinzufgen, mit Hilfe
der Tastatur oder der Maus. Mehr Details unter der Hilfeseite fr
<a Moves>Zugeingabe</a>.
</p>
<p>
Man kann mit Scid auch <a PGN>PGN</a> - Partiesammlungen bearbeiten:
durch Import der PGN-Datei in Scids - <a Import>Import</a> Fenster
oder direkt durch ffnen von PGN-Dateien in Scid. Jedoch: PGN-Dateien
benntigen mehr Speicher und werden langsamer geladen. Fr groe PGN - Partiesammlungen
wird empfohlen, sie mit Hilfe des Scid-Programms <a Pgnscid>pgnscid</a>
in eine Scid-Datenbank umzuwandeln (dabei bleibt die PGN-Datei erhalten).
Die Bearbeitung von PGN-Datei ist eingeschrnkt. Man kann Partien hinzufgen
und lschen, aber keine Partien berschreiben.
</p>
<p>
Das <a MainWindow>Hauptfenster</a> von Scid (mit dem grafischen
Schachbrett) zeigt Details der aktuellen Partie und Datenbank. Man
kann zu gleicher Zeit bis zu vier Datenbanken geffnet haben (fnf
inklusive der <a Clipbase>Ablage-Datenbank</a>), und jede hat eine
eigene aktuelle Partie. (Die Partie mit der Nr. 0 dient zu Eingabe
einer neuen Partie und ist nicht Bestandteil der Datenbank).
Man kann zwischen den offenen Datenbanken im
<a Menus File>Datei-Men</a> umschalten.
</p>
<p>
Fr zustzliche Information lesen Sie bitte die anderen
Hilfe-Seiten, die im <a Index>Index</a> aufgefhrt sind.
</p>
<p>
<a Author>Kontaktinformationen ber den Autor von Scid</a> findet man in
der entsprechenden Hilfeseite.
</p>

<p><footer>(Aktualisiert: Scid 4.7, August 2018)</footer></p>
}


###############
### Hints page:

set helpTitle(D,Hints) "Scid Hinweise"
set helpText(D,Hints) {<h1>Scid Hinweise</h1>
<p>
Diese Seite enthlt einige ntzliche Hinweise in Form von Fragen und
Antworten, um Ihnen zu helfen, Scids Fhigkeiten besser zu nutzen.
Wenn Sie das erste Mal mit Scid arbeiten, lesen Sie bitte zuerst die
<a Guide>Kurzanleitung</a> zur Benutzung von Scid.
Die meisten Informationen auf dieser Seite finden Sie detailliert auf
den anderen Hilfeseiten, die im <a Index>Hilfe-Index</a>
aufgefhrt sind.
Falls Sie einen ntzlichen Hinweis haben, der dieser Seite hinzugefgt
werden sollte, senden Sie ihn bitte (in Englisch) an den
<a Author>Autor von Scid</a>.
</p>

<h4>Kann Scid eine Datenbank automatisch beim Start laden?</h4>
<p>
Ja, Sie knnen Datenbanken, PGN-Dateien oder <a EPD>EPD-Dateien</a>
in der Kommandozeile angeben. Beispiel:
<ul>
<li> <b>scid  datenbank  partien.pgn.gz</b></li>
</ul>
ldt die Scid-Datenbank <b>datenbank</b> und gleichzeitig
die mit gzip komprimierte PGN-Datei <b>partien.pgn.gz</b>.
</p>

<h4>Gibt es eine leichtere Mglichkeit, die Brettgre
zu ndern, als ber das Optionen-Men?</h4>
<p>
Ja, Sie knnen mit den Tastenkombinationen <b>Control+Shift+LeftArrow</b>
und <b>Control+Shift+RightArrow</b> das Brett verkleinern bzw. vergrern.
</p>

<h4>Wenn ich trainiere, indem ich eine Partie nachspiele, mchte ich
nicht, da Scid den nchsten Zug im Informationsbereich anzeigt.
Kann ich ihn verstecken?</h4>
<p>
Sie knnen den nchsten Zug verstecken, indem Sie die <b>rechte</b>
Maustaste im Informationsbereich drcken und im darauf erscheinenden
Men <b>Verstecke nchsten Zug</b> auswhlen.
</p>

<h4>Wie kann ich den ECO-Erffnungsschlssel der aktuellen Position
ermitteln?</h4>
<p>
Der ECO-Schlssel wird in der letzten Zeile des Informationsbereichs
angezeigt, unterhalb des Schachbretts im <a MainWindow>Hauptfenster</a>,
wenn Sie die ECO-Datei (<b>scid.eco</b>) geladen haben.<br>
Auf der <a ECO>ECO-Code</a> Hilfeseite wird erklrt, wie man die ECO-Datei
ldt und die Optionen so einstellt, da sie jedesmal beim Programmstart
geladen wird.
</p>

<h4>Beim Eingeben einer Partie bin ich gerade beim 30. Zug, als ich
bemerke, da der 10. Zug falsch eingegeben wurde. Wie kann ich ihn
korrigieren und dabei alle nachfolgenden Zge erhalten?</h4>
<p>
Sie knnen das im <a Import>Import</a>-Fenster tun; siehe die Hilfeseite
<a Moves Mistakes>Zugeingabe</a> fr weitere Informationen.
</p>

<h4>Wie kopiere ich Partien von einer Datenbank in die andere?</h4>
<p>
Im <a Switcher>Datenbank-Umschalterfenster</a>: kopieren Sie alle
Dateien im Datenbank-<a Searches Filter>Filter</a>, indem Sie sie mit
der Maus von einer Datenbank in die andere ziehen.
</p>

<h4>Jedesmal, wenn ich einen bereits vorhandenen Zug eingebe, erhalte
ich ein "Zug ersetzen?"-Dialogfenster. Wie kann ich das verhindern?</h4>
<p>
Schalten Sie es aus mit der Option <b>Fragen vor Ersetzen</b> im Men
<menu>Optionen: Zge</menu>.
Oder gewhnen Sie sich an, Zge mit der rechten Maustaste zurckzunehmen,
die jeweils den letzen Zug der Partie entfernt, wenn Sie sich
am Partiende befinden.
</p>

<h4>Wie ndere ich die Spaltenbreite im Partielistenfenster?</h4>
<p>
Klicken Sie die jeweilige Spaltenberschrift mit der linken oder
rechten Maustaste an und whlen Sie <b>Konfigurieren</b>.
</p>

<h4>Wie kann ich das Zugbaumfenster statt fr die ganze Datenbank nur
fr eine Auswahl von Partien nutzen?</h4>
<p>
Nutzen Sie die <a Clipbase>Ablage-Datenbank</a>. Whlen Sie den
Datenbank-Filter so, da er die von Ihnen gewnschten Partien enthlt,
dann kopieren Sie diese ber den <a Switcher>Datenbank-Umschalter</a>
in die Ablage-Datenbank. Danach brauchen Sie nur noch das Zugbaumfenster
in der Ablage-Datenbank zu ffnen.
</p>

<h4>Der Zugbaum ist bei groen Datenbanken zu langsam. Wie kann ich
ihn beschleunigen?</h4>
<p>
Sichern Sie die Cache-Datei hufig, um die Zugbaum-Resultate zum
spteren Gebrauch zu bewahren. Zu den Details siehe den Abschnitt
<b>Caching</b> auf der <a Tree>Zugbaum</a>-Hilfeseite.
</p>

<h4>Wie kann ich direkt die PGN-Notation der Datei bearbeiten?</h4>
<p>
Im <a PGN>PGN</a>-Fenster knnen sie die aktuelle Partie nicht bearbeiten,
aber Sie knnen immer noch die PGN-Notation editieren, indem Sie das
Fenster <a Import>Partie importieren</a> verwenden.
ffnen Sie es (mit <b>Control+Shift+I</b>) und whlen Sie
<b>Aktuelle Partie einfgen</b>, dann bearbeiten Sie die Partie
und klicken danach <b>Importieren</b> an.

</p>

<h4>In meiner Datenbank sind einige Spielernamen unterschiedlich
geschrieben. Wie kann ich sie korrigieren?</h4>
<p>
Mit den Kommandos im Men <menu>Datei: Wartung</menu> knnen Sie einzelne
Namen editieren oder auch Schreibweisen aller Namen berprfen.
Siehe die Seite <a Maintenance Editing>Wartung</a>.
</p>

<h4>Ich habe zwei Datenbanken geffnet: eine mit meinen eigenen Partien
und eine groe Datenbank mit Gromeisterpartien. Wie kann ich eine
meiner Partien mit denen in der groen Datenbank vergleichen?</h4>
<p>
ffnen Sie das <a Tree>Zugbaumfenster</a> in der groen Datenbank und
und wechseln Sie mit Hilfe des Datenbankwechslers in die zu
vergleichende Datenbank.
</p>

<p><footer>(Aktualisiert: Scid 3.6.28, August 2008)</footer></p>
}


###############
### Main window

set helpTitle(D,MainWindow) "Scid Hauptfenster"
set helpText(D,MainWindow) {<h1>Scid Hauptfenster</h1>
<p>
Das Hauptfenster in Scid zeigt die aktuelle Stellung der jeweiligen
Partie und Information ber diese Partie und die Datenbank.
Separate Hilfeseiten beschreiben die <a Menus>Mens</a> und die
<a Moves>Zugeingabe</a>.
</p>

<h3>Symbolleiste: Navigieren durch die Partie</h3>
<p>
Die direkt ber dem Schachbrett angebracht Symbole haben die
folgende Bedeutung (von links nach rechts):
<ul>
<li> <button tb_start> Gehe zum Beginn der Partie. </li>
<li> <button tb_prev> Gehe einen Zug zurck. </li>
<li> <button tb_next> Gehe einen Zug vor. </li>
<li> <button tb_end> Gehe zum Ende der Partie. </li>
<li> <button tb_invar> Gehe in Variante. </li>
<li> <button tb_outvar> Verlasse die Variante. </li>
<li> <button tb_addvar> Neue Variante hinzufgen. </li>
<li> <button tb_play> Starte/beende automatisches Vorspielen (siehe unten). </li>
<li> <button tb_trial> Starte/beende <a Moves Trial>Testmodus</a>. </li>
<li> <button tb_flip> Brett drehen. </li>
<li> <button tb_coords> Zeige/Verdecke/Zeige unten und links/ die Brettkoordinaten. </li>
</ul>

<h4><name Autoplay>Automatisches Vorspielen</name></h4>
<p>
Im diesem Modus spielt Scid automatisch die Zge in der
aktuellen Partie vor, bis zum Spielende. Die Zeit zwischen den Zgen
kann im Men <menu>Optionen: Zge</menu> eingestellt werden und wird
mit "Optionen speichern" gesichert.
</p>
<p>
Die Tastenkombination <b>Strg+Z</b> startet oder stoppt das autom.
Vorspielen, zustzlich kann das autom. Vorpielen auch durch
Drcken der <b>Esc</b>-Taste beendet werden.
</p>
<p>
Wenn der Modus "Automatisches Vorspielen" beim geffneten
<a Analysis>Analysefenster</a> (Engine 1) gestartet wird, so wird
die von der Engine berechnte jeweilige Fortsetzung als Variante jedem Zug
hinzugefgt <term>Autom. Kommentieren</term>. Siehe auch die
Hilfeseite zum <a Analysis>Analysefenster</a>.
</p>

<h3>Der Informationsbereich</h3>
<p>
Der Bereich unter dem Schachbrett, mit Informationen ber die
Partie, wird <term>Informationsbereich</term> genannt. Die ersten 3
Zeilen zeigen Information zu den Spielern, Ergebnis, ECO-Code, Datum,
Ort und Ereignis. Die vierte Zeile zeigt die Informationen zur
aktuellen Stellung sowie den nchsten Zug.
</p>
<p>
Die fnfte Zeile zeigt den <a ECO>ECO-Code</a> der aktuelle Stellung,
falls enthalten in der gerade benutzen ECO-Datei.
</p>
<p>
Der Informationsbereich hat ein Men, welches man mit der
rechten Maustaste aktivieren kann. Hierber kann man bestimmte
Informationen zum Spiel zeigen oder verstecken sowie Kennzeichen
fr die aktuelle Partie setzten und lschen. Man kann das
Men auch ber die <b>[F9]</b> Funktionstaste erreichen.
</p>

<h4>Endspieltabellen</h4>
<p>
Der Informationsbereich zeigt auch Ergebnisse aus den
Endspieltabellen zur aktuellen Stellung, wenn diese darin enthalten
ist. Mehr dazu in den Hilfeseiten zu <a TB>Endspieltabellen</a>.
</p>

<h3>Die Statusanzeige</h3>
<p>
Die Statusanzeige zeigt Information ber die aktuelle
Datenbank. Das erste Feld zeigt den Partiestatus an: <b>XX</b>
bedeutet, die Partie wurde gendert, aber noch nicht
gespeichert, whrend <b>--</b> bedeutet, es gibt keine
nderungen, und <b>%%</b> zeigt an, da die Datenbank
schreibgeschtzt geffnet wurde.
</p>
<p>
Wenn man eine Datenbank immer schreibgeschtzt ffen will,
kann man auch die Rechte fr die entsprechenden Scid-Dateien
setzen, oder zumindestens die der Indexdatei; z.B. (unter Linux) durch
den Befehl: <b>chmod a-w datenbank1.si3</b>.
Danach ffnet Scid die entsprechende Datenbank immer
schreibgeschtzt.
</p>
<p>
Die Statusanzeige zeigt auch, wieviel Spiele im aktuellen
<a Searches Filter>Filter</a>
sind.
</p>

<p><footer>(Aktualisiert: Scid 3.1, Dezember 2001)</footer></p>
}


######################
### Menus help screen:

set helpTitle(D,Menus) "Mens"
set helpText(D,Menus) {<h1>Die Scid-Mens</h1>

<h3><name File>Datei</name></h3>
<ul>
<li><menu>Neu</menu>: Legt eine neue, leere Scid-Datenbank an.</li>
<li><menu>ffnen</menu>: ffnet eine existierende Scid-Datenbank.</li>
<li><menu>Schlieen</menu>: Schliet die aktive Scid-Datenbank.</li>
<li><menu>Finder</menu>: ffnet das <a Finder>Dateisuche</a>-Fenster.</li>
<li><menu>Lesezeichen</menu>: Das <a Bookmarks>Lesezeichen</a>-Men mit
     einigen Lesezeichen-Funktionen.</li>
<li><menu>Wartung</menu>: Datenbank-<a Maintenance>Wartungs</a>-Funktionen.
    </li>
<ul>
  <li><menu>Wartungsfenster</menu>: ffnet/schliet das
      Datenbank-Wartungsfenster.</li>
  <li><menu>Partien ECO-klassifizieren</menu>: Bestimmt den
      <a ECO>ECO-Code</a> fr alle Partien der Datenbank neu.</li>
  <li><menu>Dubletten lschen</menu>: Findet <a Maintenance Twins>Dubletten</a>
      in der Datenbank.</li>
  <li><menu>Namen</menu>: Ersetzt alle Vorkommen eines Spieler-,
      Ereignis-, Ort- oder Rundeneintrags.</li>
</ul>
<li><menu>Schreibschutz</menu>: Markiert die aktive Datenbank als schreibgeschtzt.</li>
<li><menu>Datenbank 1/2/3/4/5</menu>: Mit diesen Kommandos knnen Sie
    zwischen den vier verfgbaren Datenbanken und der
    <a Clipbase>Ablage-Datenbank</a> wechseln.</li>
<li><menu>Ende</menu>: Beendet Scid. </li>
</ul>

<h3><name Edit>Bearbeiten</name></h3>
<ul>
<li><menu>Variante hinzufgen</menu>: Fgt eine neue, leere Variante zum nchsten
    Zug hinzu bzw. zum vorherigen, falls es noch keinen nchsten Zug gibt.</li>
<li><menu>Variante lschen</menu>: ffnet ein Varianten-Untermen fr
    den aktuellen Zug, um eine Variante zu lschen.</li>
<li><menu>Als erste Variante setzen</menu>: Macht eine Variante zur
    ersten Variante des aktuellen Zuges.</li>
<li><menu>Variante als Hauptvariante setzen</menu>: Tauscht eine Variante
    mit der Partiefolge aus.</li>
<li><menu>Variante testen</menu>: Schaltet in den <a Moves Trial>Testmodus</a>,
    um eine Variante auszuprobieren, ohne die aktuelle Partie zu verndern.</li>
<li><menu>Entfernen</menu>: Entfernt alle Kommentare oder Varianten
    aus der aktuellen Partie.</li>
<br>
<li><menu>Ablage leeren</menu>: Leert die
    <a Clipbase>Ablage</a>-Datenbank.</li>
<li><menu>Partie in Ablage kopieren</menu>: Kopiert die aktuelle Partie
    in die <a Clipbase>Ablage</a>-Datenbank.</li>
<li><menu>Partie aus Ablage einfgen</menu>: Fgt die aktive Partie der
    <a Clipbase>Ablage</a> als aktive Partie in die aktuelle Datenbank
    ein.</li>
<br>
<li><menu>Stellungseingabe</menu>: Legt die Ausgangsstellung fr die
    aktuelle Partie fest.</li>
<li><menu>Stellung einfgen</menu>: Fgt den markierten Text
    (Zwischenablage) als Ausgangsstellung ein.</li>
</ul>

<h3><name Game>Partie</name></h3>
<ul>
<li><menu>Neue Partie</menu>: Verwirft alle nicht gesicherten nderungen
     und beginnt eine neue Partie ab der Grundstellung.</li>
<li><menu>Lade Erste/Vorherige/Nchste/Letzte Partie</menu>: Diese Menpunkte
    laden die erste, vorherige, nchste bzw. letzte Partie im <a Searches Filter>Filter</a>.</li>
<li><menu>Partie wiederladen</menu>: Ldt die aktuelle Partie erneut, wobei
    alle bisherigen nderungen verworfen werden.</li>
<li><menu>Lade Partie Nummer</menu>: Ldt die Partie mit der angegebenen
    Nummer in die aktuelle Datenbank.</li>
<br>
<li><menu>Partie ersetzen</menu>: Sichert die aktuelle Partie, wobei sie
    die Originalversion in der Datenbank ersetzt.</li>
<li><menu>Partie speichern</menu>: Sichert die aktuelle Partie als neue
    Partie, die ans Ende der Datenbank angehngt wird.</li>
<br>
<li><menu>Erffnung identifizieren</menu>: Findet die letztmgliche
    Position der aktuellen Partie in der ECO-Datei.</li>
<li><menu>Zugnummer</menu>: Geht zu der angegebenen Zugnummer in
    der aktuellen Partie.</li>
<li><menu>Finde Neuerung</menu>: Findet den ersten Zug der aktuellen Partie,
    der vorher noch nie gespielt wurde.</li>
</ul>

<h3><name Search>Suchen</name></h3>
<ul>
<li><menu>Filter zurcksetzen</menu>: Setzt den <a Searches Filter>Filter</a>
    zurck, so da er alle Partien enthlt.</li>
<li><menu>Filter negieren</menu>: Invertiert den Filter, so da er alle
    vorher ausgeschlossenen Partien enthlt.</li>
<br>
<li><menu>Brett</menu>: Sucht die
    <a Searches Board>aktuelle Brettposition</a>.</li>
<li><menu>Partiedaten</menu>: Sucht nach <a Searches Header>Partiedaten</a>
    wie z.B. Spielernamen.</li>
<li><menu>Material/Muster</menu>: Sucht nach
    <a Searches Material>Material</a> oder Stellungsmustern</a>.</li>
<br>
<li><menu>Mit Suchoptionsdatei</menu>: Sucht mit Hilfe von
    <a Searches Settings>Einstellungen</a> aus einer Suchoptionsdatei.</li>
</ul>

<h3><name Windows>Fenster</name></h3>
<ul>
<li><menu>Kommentareditor</menu>: ffnet/schliet das
    <a Comment>Kommentareditor</a>-Fenster.</li>
<li><menu>Partieliste</menu>: ffnet/schliet das
    <a GameList>Partielistenfenster</a>.</li>
<li><menu>PGN-Fenster</menu>: ffnet/schliet das
    <a PGN>PGN-Fenster</a>.</li>
<li><menu>Turniersuche</menu>: ffnet/schliet den
    <a Tmt>Turniersuche</a>.</li>
<br>
<li><menu>Datenbank-Umschalter</menu>: ffnet/schliet den
    <a Switcher>Datenbank-Umschalter</a>, mit dem man auf einfache Weise zu einer
    anderen Datenbank wechseln oder Partien zwischen Datenbanken kopieren kann.</li>
<li><menu>Wartungsfenster</menu>: ffnet/schliet das
    Datenbank-<a Maintenance>Wartungs</a>-Fenster.</li>
<br>
<li><menu>ECO-Auswertung</menu>: ffnet/schliet das Fenster
    <a ECO browser>ECO-Auswertung</a>.</li>
<li><menu>Repertoire-Editor</menu>: ffnet/schliet den
    <a Repertoire>Repertoire-Editor</a>.</li>
<li><menu>Statistik</menu>: ffnet/schliet das
    <term>Filter-Statistikfenster</term>, welches eine Gewinn/Verlust-Zusammenstellung
    aller Partien im <a Searches Filter>Filter</a> liefert.</li>
<li><menu>Zugbaum</menu>: ffnet/schliet das <a Tree>Zugbaumfenster</a>.</li>
<li><menu>Endspieltabellen</menu>: ffnet/schliet das Fenster, das
    die <a TB>Endspieltabellen</a>-Informationen ausgibt.</li>
</ul>

<h3><name Tools>Werkzeuge</name></h3>
<ul>
<li><menu>Analyse-Engine</menu>: Startet/beendet die "Schachanalyse-Engine",
    die die Auswertung der aktuellen Position
    im <a Analysis>Analysefenster</a> darstellt.</li>
<li><menu>Analyse-Engine #2</menu>: Startet/beendet eine zweite
    "Schachanlyse-Engine".</li>
<li><menu>Turniertabelle</menu>: Erstellt eine
    Turnier-<a Crosstable>Turniertabelle</a> fr die aktuelle Partie. </li>
<li><menu>E-Mail-Manager</menu>: ffnet/schliet den <a Email>E-Mail-Manager</a>
    fr Fernschachpartien.</li>
<br>
<li><menu>Rel. Filtergrafik</menu>: ffnet das <a Graphs>Fenster fr die Relative Filtergrafik</a></li>
<li><menu>Abs. Filtergrafik</menu>: ffnet das <a Graphs>Fenster fr die Absolute Filtergrafik</a></li>
<li><menu>Erffnungsbericht</menu>: Erstellt einen <a Reports Opening>Erffnungsbericht</a>
    zur aktuellen Position.</li>
<li><menu>Figurenverteilung</menu>: ffnet das Fenster <a PTracker>Figurenverteilung</a>.
    </li>
<li><menu>Spieler-Information</menu>: Gibt <a PInfo>Spieler-Informationen</a>
    fr einen Spieler der aktuellen Partie aus.</li>
<li><menu>ELO-Zahl-Verlauf</menu>: gibt den
    <a Graphs Rating>ELO-Zahl-Verlauf</a> aus.</li>
<li><menu>Partie-Bewertungsgraph</menu>: Gibt den
    <a Graphs Score>Partie-Bewertungsgraph</a> aus.</li>
<br>
<li><menu>Partie exportieren</menu>: Schreibt die aktuelle Partie in eine
    Textdatei im PGN-, HTML- oder LaTeX-Format. Siehe die
    <a Export>Export</a>-Hilfeseite.</li>
<li><menu>Alle Partien im Filter exportieren</menu>: Schreibt alle Partien
    im Such-<a Searches Filter>Filter</a> in eine Textdatei im PGN-, HTML-
    oder LaTeX-Format. Siehe die <a Export>Export</a>-Hilfeseite.</li>
<br>
<li><menu>Eine PGN-Partie importieren</menu>: ffnet das <a Import>Importfenster</a>,
    um den Inhalt einer Partie im <a PGN>PGN-Format</a> direkt
    einzutippen oder einzufgen.</li>
<li><menu>Datei mit PGN-Partien importieren</menu>: Importiert eine ganze
    Datei mit Partien im PGN-Format in die aktuelle Datenbank.</li>
<br>    
<li><menu>Starte Engine1</menu>: Starte direkt die letzte ausgewhlte Engine1 im Analysemodus</li>  
<li><menu>Starte Engine2</menu>: Starte direkt die letzte ausgewhlte Engine2 im Analysemodus</li>  
</ul>

<h3><name Options>Optionen</name></h3>
<p>
Dieses Men stellt einige Eintrge bereit, um die meisten konfigurierbaren
Optionen von Scid einzustellen.
Der Menpunkt <menu>Autom. speichern bei Beenden</menu> sichert die aktuellen
Optionen  in der Datei "<b>~/.scid/scidrc</b>" (bzw.
<b>scid.opt</b> im Verzeichnis des ausfhrbaren Scid-Programms fr Windows-User);
diese Datei wird bei jedem Programmstart von Scid geladen.
</p>

<h3>Hilfe</h3>
<p>
Dieses Men enthlt die Hilfe-Funktionen sowie Zugriff auf das
"Tip-des-Tages"-Fenster oder das Startfenster, welches Informationen
ber die Dateien liefert, die Scid beim Programmstart geladen hat.
</p>

<p><footer>(Aktualisiert: Scid 3.6.21, Dezember 2007)</footer></p>
}


########################
### Entering moves help:

set helpTitle(D,Moves) "Zge eingeben"
set helpText(D,Moves) {<h1>Schachzge eingeben</h1>
<p>
In Scid knnen Sie die Partiezge mit der Maus oder ber die
Tastatur eingeben. Wenn Sie den Mauszeiger auf ein Feld bewegen,
wird dieses und ein weiteres Feld seine Farbe ndern, falls es
einen legalen Zug auf dieses bzw. von diesem Feld gibt. Das ist
der <term>Zugvorschlag</term>. Sie knnen diesen Zug einfach durch
Klicken der <term>linken</term> Maustaste ausfhren. Falls Sie der
Zugvorschlag strt, knnen Sie ihn im Optionsmen abschalten.
</p>
<p>
Um einen anderen als den vorgeschlagenen Zug auszufhren, knnen Sie
die <term>linke</term> Maustaste verwenden: Drcken Sie einfach die
Taste ber einem Feld und lassen Sie sie ber einem anderen Feld los.
</p>
<p>
Wenn Sie es vorziehen, Zge mit zwei Mausklicks auszufhren statt mit
gedrckter Maustaste, knnen Sie die <term>mittlere</term> Taste
verwenden: Klicken Sie erst das eine Feld an, danach das andere.
</p>

<h4>Einen Zug zurcknehmen</h4>
<p>
Um einen Zug zurckzunehmen, drcken Sie die rechte Maustaste. Damit gehen
Sie einen Zug zurck; gleichzeitig lschen Sie diesen Zug, falls es der
letzte Zug der Partie oder einer Variante war.
</p>

<h4>Alte Zge ersetzen</h4>
<p>
Wenn Sie einen Zug an einer Stelle in der Partie eingeben, wo bereits
ein Zug existiert, wird Scid Sie in einem Dialogfenster fragen, ob Sie
wirklich den alten Zug ersetzen wollen (der alte Zug und alle nachfolgenden
sind dann verloren) oder statt dessen den neuen Zug als Variante eingeben
wollen. Manche Leute mgen dieses Dialogfenster als strend empfinden
und wollen alte Zge immer ersetzen. Sie knnen es daher im Men
<menu>Optionen: Zge</menu> mit der Option "<i>Vor Ersetzen nachfragen</i>"
abschalten.
</p>

<h4><name Trial>Der Testmodus</name></h4>
<p>
Wenn Sie eine Partie nachspielen und eine Position erreichen, wo Sie
eine alternative Variante am Brett ausprobieren wollen, ohne die Partie
zu verndern, whlen Sie <b>Variante testen</b> im Men <menu>Bearbeiten</menu>,
um den Testmodus einzuschalten. In diesem Modus knnen Sie Zge eingeben
und die Partie zeitweilig verndern; sobald Sie den Testmodus verlassen,
kehren Sie zur Ausgangsposition zurck.
</p>

<h3><name Mistakes>Fehler korrigieren</name></h3>
<p>
Wenn Sie eine Partie eingeben und pltzlich einige Zge vorher einen
falschen Zug bemerken, knnen Sie diesen korrigieren, ohne die
nachfolgenden Zge zu verlieren. Der einzige Weg besteht darin, die
PGN-Darstellung der Datei zu bearbeiten: ffnen Sie das
<a Import>Import</a>-Fenster, whlen Sie "Aktuelle Partie einfgen",
korrigieren Sie den falschen Zug, und whlen Sie dann "Importieren".
</p>

<h3>Zugeingabe ber die Tastatur</h3>
<p>
Um Zge ber die Tastatur einzugeben, drcken Sie einfach die jeweiligen
Buchstaben- und Zahlentasten. Die Zge sollten in <term>SAN-Notation</term>
<i>ohne</i> die Symbole fr Schlagen (x) oder Umwandeln (=) eingegeben
werden. Gro- und Kleinschreibung wird ignoriert, Sie knnen also
beispielsweise [n][f][3] anstelle von Nf3 eingeben  -- beachten Sie
aber die Anmerkung weiter unten zu den Konflikten bei Bauernzgen.
</p>
<p>
Um sicherzustellen, da kein Zug in einem anderen enthalten ist,
lautet die Eingabe fr die kurze und lange Rochade [0][K] resp. [0][Q]
anstelle der blichen Notation 0-0 bzw. 0-0-0.
</p>
<p>
Wenn Sie einen Zug eingeben, zeigt die Statusleiste die Liste der
mglichen Zge an. Sie knnen jederzeit die [Leertaste] drcken, um
den ersten mglichen Zug der Liste als Eingabe auszuwhlen.
Um ein Zeichen zu lschen, drcken Sie [Rck] oder [Entf].
</p>
<p>
<b>Beachten</b> Sie, da ein Kleinbuchstabe zuerst als Bauer
interpretiert wird; mit [b] kann also ein Bauer oder Lufer ("Bishop")
gemeint sein, im Zweifelsfall mssen Sie daher ein groes [B] fr den
Lufer verwenden.
</p>

<h4>Automatische Zugergnzung</h4>
<p>
Im Options-Men knnen Sie die <term>Automatische Zugergnzung</term>
ein- oder ausschalten.
Mit Zugergnzung wird ein Zug ausgefhrt, sobald er durch Ihre Eingabe
von jedem anderen mglichen Zug unterschieden werden kann. Beispielsweise
mten Sie mit automatischer Zugergnzung in der Ausgangsstellung nur
[n][f] statt <b>Nf3</b> eintippen.
</p>

<h3><name Null>Nullzge eingeben</name></h3>
<p>
<a Annotating Null>Null</a>- (leere) Zge knnen in Varianten ntzlich
sein, wenn Sie den Zug einer Seite auslassen wollen. Sie knnen einen
Nullzug mit der Maus eingeben, indem Sie einen Knig mit dem anderen
schlagen, oder mit der Tastatur, indem Sie "<b>--</b>" eingeben (d.h.
die Minustaste zweimal drcken).
</p>

<h3>Standard-Kommentarzeichen eingeben</h3>
<p>
Sie knnen die blichen <a NAGs>Kommentarzeichen</a> im Hauptfenster auch
ber die Tastatur ohne den <a Comment>Kommentar-Editor</a> hinzufgen.
Die folgende Liste zeigt Ihnen, welche Zeichen Sie mit welchen Tasten
eingeben knnen:
<ul>
<li> !  : [!][Eingabe] </li>
<li> ?  : [?][Eingabe] </li>
<li> !? : [!][?][Eingabe] </li>
<li> ?! : [?][!][Eingabe] </li>
<li> !! : [!][!][Eingabe] </li>
<li> ?? : [?][?][Eingabe] </li>
<li> </li>
<li> +- : [+][-] </li>
<li> +/-: [+][/] </li>
<li> += : [+][=] </li>
<li> =  : [=][Eingabe] </li>
<li> -+ : [-][+] </li>
<li> -/+: [-][/] </li>
<li> =+ : [=][+] </li>
</ul>

<p><footer>(Aktualisiert: Scid 3.4, Juli 2002)</footer></p>
}


#########################
### Searches help screen:

set helpTitle(D,Searches) "Suchen"
set helpText(D,Searches) {<h1>Suchen in Scid</h1>
<p>
Scid kann auf viele verschiedene Weisen in einer Datenbank suchen.
Die drei wichtigsten Arten zu suchen sind:
<ul>
<li><b>1)</b> nach der aktuellen Brettposition, </li>
<li><b>2)</b> nach angegebenem Material und Stellungsmustern, </li>
<li><b>3)</b> nach Partiedaten-Informationen wie Spieler, Ergebnis, Datum. </li>
</ul>
<p>
Auerdem gibt es noch einen automatischen Suchmodus, den sog.
<a Tree>Zugbaum</a>, der an anderer Stelle erklrt wird.
</p>

<h3><name Filter>Der Such-Filter</name></h3>
<p>
Suchen basiert bei Scid auf dem Konzept eines <term>Filters</term>.
Der Filter reprsentiert eine Teilmenge der aktuellen Datenbank;
eine Partie ist immer entweder im Filter enthalten oder vom
Filter ausgeschlossen.
</p>
<p>
Bei jeder Art der Suche knnen Sie whlen, den vorhandenen Filter
weiter einzugrenzen, zu diesem hinzuzufgen oder ihn zu ignorieren
und die gesamte Datenbank zu durchsuchen. Diese Auswahl erlaubt es,
komplexe Suchvorgnge nacheinander aufzubauen.
</p>
<p>
Sie knnen auch mit dem <a Switcher>Datenbank-Umschalter</a> alle Partien
im Filter einer Datenbank in eine andere Datenbank kopieren.
</p>
<p>
Bei der Suche nach einer exakten Postion, der <a Tree>Zugbaum</a>- oder
Material/Muster-Suche wird die Zugnummer der ersten passenden Position
jeder passenden Partie gespeichert; wenn Sie also jede dieser Partien
laden, wird automatisch die passende Stellung angezeigt.
</p>
<p>
<b>Beachten</b> Sie, da beim Suchen nur mit den Partiezgen
verglichen wird, nicht mit den Zgen der Varianten.
</p>

<h3><name Board>Suchen: Brett...</name></h3>
<p>
Hier finden Sie Partien, die die gerade dargestellte Position enthalten,
ohne Bercksichtigung der Rochade- und <i>en-passant</i>-Rechte.
</p>
<p>
Vier Suchtypen stehen zur Verfgung. Alle vier verlangen von einer
passenden Stellung exakt gleiches Material und die gleiche Seite am Zug.
Die Typen sind:
<ul>
<li> [1] exakt (die beiden Stellungen mssen auf jedem Feld bereinstimmen),
     </li>
<li> [2] Bauern (die Bauernstruktur mu bereinstimmen, aber andere Figuren
     knnen irgenwo stehen), </li>
<li> [3] Linien (die Anzahl weier und schwarzer Bauern auf jeder Linie mu
     bereinstimmen, aber andere Figuren knnen irgendwo stehen), and </li>
<li> [4] Material (Bauern und Figuren knnen irgendwo stehen). </li>
</ul>
<p>
Die Bauernsuche ist hilfreich, um Erffnungen nach Bauernstrukuren zu
studieren, und Linien- und Materialsuche helfen beim Auffinden hnlicher
Endspielstellungen.
</p>
<p>
Um nach einer beliebigen Stellung zu suchen, knnen Sie zuerst
die Position aufbauen (im Men <menu>Bearbeiten: Stellungseingabe</menu>)
und dann die Suche starten.
</p>
<p>
Sie knnen Varianten (statt nur die jeweiligen Partiezge) durchsuchen,
indem Sie den Schalter <b>Schaue in Varianten</b> whlen; das kann
aber die Suche stark verlangsamen, falls die Datenbank sehr gro ist
und viele Partien mit Varianten enthlt.
</p>

<h3><name Material>Suchen: Material/Muster</name></h3>
<p>
Diese Suche ist ntzlich, um End- oder Mittelspielthemen zu finden. Sie
knnen eine minimale und maximale Anzahl von Figuren jeden Typs angeben,
und Sie knnen Stellungsmuster wie Lufer auf f7 oder f-Bauer finden.
</p>
<p>
Eine Reihe von hufigen Materialkonstellationen und Stellungsmustern
sind schon bereitgestellt, wie etwa "Endspiel Turm gegen Bauern" oder
"isolierter Damenbauer".
</p>
<p>
<b>Hinweise:</b><br>
Die Geschwindigkeit der Suche nach Stellungsmustern kann stark variieren.
Sie knnen aber durch eine geschickte Wahl der Bedingungen die bentigte
Zeit reduzieren. Wenn Sie beispielsweise fr ein Endspiel die Mindestzahl
von Zgen auf 20 setzen, werden alle Partien, die vor dem 20. Zug enden,
bersprungen.
</p>

<h3><name Header>Suchen: Partiedaten</name></h3>
<p>
Mit dieser Suche knnen Sie Partiedaten finden, die im Vorspann ("Header")
gespeichert sind (wie z.B. Datum, Ergebnis, Namen und Wertungszahlen),
es mssen daher keine Partiezge dekodiert werden.
</p>
<p>
Um bei der Suche nach Partiedaten eine passende Partie zu finden,
mssen <b>alle</b> von Ihnen angegebenen Felder bereinstimmen.
</p>
<p>
Die Namensfelder (Wei, Schwarz, Turnier, Ort und Runde) passen auf
jeden Text im Namen, ohne Bercksichtigung von Gro- und Kleinschreibung
oder Leerzeichen.
</p>
<p>
Sie knnen fr das Wei-, Schwarz-, Turnier-, Ort- und Rundenfeld mit
Unterscheidung von Gro- und Kleinschreibung und mit "Wildcards" suchen
(mit <b>?</b> fr ein und <b>*</b> fr null oder mehr Zeichen), indem
Sie den Suchtext in Anfhrungszeichen setzen. Eine Suche mit der Ortsangabe
<b>USA</b> wird beispielsweise amerikanische Stdte finden, aber auch
<b>Lausanne SUI</b>, was vermutlich nicht von Ihnen beabsichtigt war! Eine
Suche mit dem Ort <b>"*USA"</b> (denken Sie an die Anfhrungszeichen)
liefert dagegen nur Stdte in den USA.
</p>
<p>
Wenn Sie einen bestimmten Spieler (oder zwei bestimmte Kontrahenten) als
Wei oder Schwarz suchen und die jeweilige Farbe keine Rolle spielt,
whlen Sie die Option <b>Farben ignorieren</b>.
</p>
<p>
Schlielich kann die Suche nach Partiedaten auch verwendet werden, um
irgendeinen Text (mit Bercksichtigung von Gro- und Kleinschreibung,
ohne "Wildcards") in der PGN-Darstellung dieser Partie zu finden. Sie
knnen bis zu drei Textteile eingeben, und sie mssen alle in einer
passenden Partie vorkommen.
Diese Methode ist sehr hilfreich, um in den Kommentaren oder zustzlichen
Daten einer Partie zu suchen (wie <b>Zeitberschreitung</b> oder
<b>Kommentator</b>), oder nach einer Zugfolge wie <b>Bxh7+</b> und
<b>Kxh7</b> fr ein angenommenes Luferopfer auf h7.
Allerdings kann diese Art zu suchen <i>sehr</i> langsam sein, da alle
Partien, auf die andere Kriterien zutreffen, dekodiert und auf diese
Texte durchsucht werden mssen.
Es ist daher eine gute Idee, diese Suchen so weit wie mglich einzugrenzen.
Hier sind einige Beispiele:
Um Partien mit einer Unterverwandlung in einen Turm zu finden,
suchen Sie nach <b>=R</b> und setzen gleichzeitig die Kennung
<b>Umwandlung</b> auf Ja.
Wenn Sie nach Text in Kommentaren suchen, setzen Sie die Kennung
<b>Kommentare</b> auf Ja.
Falls Sie nach den Zgen <b>Bxh7+</b> und <b>Kxh7</b> suchen, mchten
Sie z.B. die Suche mglicherweise auf Partien mit dem Ergebnis 1-0 und
mit mindestens 40 Halbzgen beschrnken, oder Sie suchen zuerst nach
Material oder Stellungsmustern, um Partien mit einem weien Luferzug
nach h7 zu finden.
</p>

<h3><name Settings>Sucheinstellungen sichern</name></h3>
<p>
Die Suchfenster Material/Mustern und Partiedaten besitzen einen Schalter
zum <term>Speichern</term>. Das ermglicht Ihnen, die aktuellen
Sucheinstellungen zur spteren Verwendung in einer
<term>Suchoptions</term>-Datei zu speichern (Endung .sso).
Um mit Hilfe einer vorher gespeicherten Suchoptionsdatei (.sso) zu
suchen, whlen Sie <menu>ffnen</menu> im Men <menu>Suchen</menu>.
</p>

<h3>Suchdauer und bergangene Dateien</h3>
<p>
Die meisten Suchen liefern eine Nachricht, die die bentigte Zeit und
die Anzahl der <term>bergangenen</term> Partien angibt. Eine bergangene
Partie ist eine, die aufgrund der im Index gespeicherten Informationen
von der Suche ausgeschlossen werden kann, ohne da ihre Zge dekodiert
werden mssen. Siehe die Hilfeseite ber
<a Formats>Dateiformate</a> fr weitergehende Informationen.
</p>

<p><footer>(Aktualisiert: Scid 3.0, November 2001)</footer></p>
}


############
### Clipbase

set helpTitle(D,Clipbase) "Die Ablage-Datenbank"
set helpText(D,Clipbase) {<h1>Die Ablage-Datenbank</h1>
<p>
Zustzlich zu den geffneten Datenbanken stellt Scid eine
<term>Ablage-Datenbank</term> (als Datenbank 5) zur Verfgung, welche
sich wie eine normale Datenbank verhlt, mit der Ausnahme, da sie
nur im RAM-Speicher existiert und keine Dateien zur Speicherung auf
der Festplatte besitzt.
</p>
<p>
Die Ablage-Datenbank (kurz: Ablage) ist ntzlich als eine temporre
Datenbank, zum Zusammenfhren von Suchergebnissen aus Suche in
mehreren Datenbanken oder zur Behandlung der Suchergebnisse als eine
eigenstndige Datenbank.
</p>
<p>
Angenommen, zum Beispiel, man will sich auf einen Gegner vorbereiten, und
hat eine Datenbank auf alle Partien des Gegners mit Wei durchsucht,
so da diese Partien im <a Searches Filter>Filter</a> sind.
Man kann nun diese Partien in die Ablage kopieren (durch Ziehen mit der
rechten Maustaste von der Originaldatenbank zur Ablage, im Fenster
<a Switcher>Datenbank-Umschalter</a>), danach im Datei-Men die Ablage
als aktive Datenbank auswhlen, und dann kann man sich im
<a Tree>Zugbaumfenster</a> das Erffnungsrepertoire des Gegners
ansehen.
</p>
<p>
Sind 2 Datenbanken geffnet, und hat man im Filter Partien, die man
von der einen Datenbank in die andere kopieren mchte, kann man dies
direkt (ohne Umweg ber die Ablage) tun. Dazu benutzt man wiederum das
Fenster <a Switcher>Datenbank-Umschalter</a>.
</p>
<p>
Die Ablage kann nicht geschlossen werden: mit dem Befehl
<menu>Ablage leeren</menu> aus dem Men <menu>Bearbeiten</menu> wird
der Inhalt der Ablage gelscht.
</p>
<p>
Die Ablage-Datenbank ist begrenzt auf 10.000 Partien zur gleichen Zeit,
da sie nur im Speicher existiert.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


#################################
### Variations and comments help:

set helpTitle(D,Annotating) "Partien kommentieren"
set helpText(D,Annotating) {<h1>Partien kommentieren</h1>
<p>
Mit Scid knnen Sie den Partien Anmerkungen hinzufgen. Es gibt
drei Arten von Anmerkungen, die Sie nach einem Zug eingeben knnen:
Symbole, ein Kommentar und Varianten.
</p>

<h3>Symbole und Kommentare</h3>
<p>
Symbole verwendet man, um eine Stellungsbeurteilung anzuzeigen
(etwa "+-" or "=") oder um auf gute ("!") und schlechte ("?")
Zge hinzuweisen, whrend ein Kommentar ein beliebiger Text sein
kann. Zur Eingabe von Symbolen und Kommentaren benutzen Sie den
<a Comment>Kommentar-Editor</a>. Es gibt auch eine Hilfeseite, in
der die <a NAGs>Standard-Symbolwerte</a> aufgelistet sind.
</p>
<p>
Beachten Sie, da jeder Zug mehr als ein Anmerkungssymbol haben kann,
aber nur einen Kommentar. Ein Kommentar vor dem ersten Partiezug wird
als Text vor dem Beginn der Partie ausgegeben.
</p>

<h3><name Vars>Varianten</name></h3>
<p>
Eine <term>Variante</term> eines Zuges ist eine alternative Zugfolge
an einem bestimmten Punkt der Partie. Varianten knnen Kommentare
enthalten und sogar rekursiv Untervarianten. Mit den Schaltern oberhalb
des Schachbretts mit einem "<b>V</b>"-Symbol sowie den Kommandos im
Men <menu>Bearbeiten</menu> kann man Varianten erstellen, editieren
und sich darin bewegen.
</p>

<h4>Tastatureingaben</h4>
<p>
Wenn es zu einem Zug Varianten gibt, werden sie im Informationsbereich
angezeigt. Die erste wird mit <b>v1</b> bezeichnet, die zweite mit
<b>v2</b> etc. Um in eine Variante zu gehen, knnen Sie sie anklicken
oder "<b>v</b>" gefolgt von der Variantennummer eingeben. (Falls es
nur eine Variante gibt, gengt die Eingabe von <b>v</b>.)
Mit der Taste "<b>z</b>" verlassen Sie die Variante wieder.
</p>

<h3><name Null>Nullzge</name></h3>
<p>
Gelegentlich kann es in einer Variante ntzlich sein, den Zug einer
Seite auszulassen. Beispiel: Sie wollen den Zug 14.Ld3 als Variante
hinzufgen und mchten darauf hinweisen, da er 15.Lxh7+ Kxh7 16.Sg5+
mit Angriff droht. Das knnen Sie erreichen, indem Sie im obigen
Beispiel einen <term>Nullzug</term> zwischen 14.Ld3 und 15.Bxh7+
ausfhren. Ein Nullzug wird als "<b>--</b>" dargestellt und kann
eingefgt werden, indem Sie mit der Maus den illegalen Zug "Knig
schlgt Knig" ausfhren oder mit der Tastatur "<b>--</b>" (zwei
Minuszeichen) eingeben.
</p>
<p>
Beachten Sie, da Nullzge nicht zum PGN-Standard gehren, wenn Sie
also Partien mit Nullzgen in eine PGN-Datei exportieren, wird Scid
(neben einigen anderen Exportoptionen) eine Option anbieten,
Nullzge zu erhalten oder sie in Kommentare umzuwandeln, damit
Kompatibilitt zu anderen Programmen gewahrt bleibt.
Siehe auch die <a Export>Export</a>-Hilfeseite.
</p>

<p><footer>(Aktualisiert: Scid 3.4, Juli 2002)</footer></p>
}


####################
### Analysis window:

set helpTitle(D,Analysis) "Analysefenster"
set helpText(D,Analysis) {<h1>Das Analysefenster</h1>
<p>
Scids Analysefenster zeigt die Analyse der aktuellen Brettstellung
durch ein Schachprogramm (eine sog. <term>Engine</term>).
Immer, wenn sich die Brettstellung ndert, bermittelt Scid die neue
Position an die Engine, und die zeigt ihre Einschtzung dieser Stellung.
</p>
<p>
Die Bewertung im Analysefenster erfolgt immer aus der Perspektive
von Wei, eine negative Bewertung heit also, da Schwarz besser steht.
Der untere Fensterbereich (mit dem Rollbalken) zeigt den Verlauf der
Auswertungen der aktuellen Stellung durch die Engine, Sie knnen also
sehen, wie sich die Einschtzung verndert hat.
</p>
<p>
Um den von der Engine ausgewhlten besten Zug als neuen Zug der
aktuellen Partie zu nehmen, klicken Sie einfach auf den Schalter
<b>Zug hinzufgen</b>.
</p>
<p>
Tip: ber die Tasten F2 und F3 knnen direkt die letzten beiden Analyse-Engines gestartet werden, ohne dies nochmal auswhlen zu mssen.
</p>

<h3><name List>Die Liste der Analyse-Engines</name></h3>
<p>
Scid behlt eine Liste der von Ihnen benutzen Engines mit einer
geschtzten Elo-Zahl (wenn Sie eine Schtzung machen) und dem Datum
der letzten Benutzung. Sie knnen diese Liste nach Namen, Elo-Zahl
oder Datum sortieren.
Whlen Sie <b>Neu</b> oder <b>Bearbeiten</b>, um eine neue Engine
zur Liste hinzuzufgen oder Details eines bestehenden Eintrags zu
bearbeiten.
</p>

<h3><name Start>Engine-Kommandos und Verzeichnisse</name></h3>
<p>
Fr jede Engine mssen Sie die aufzurufende Programmdatei angeben
und das Verzeichnis, in dem Scid sie starten soll.
</p>
<p>
Die hufigste Ursache von Problemen beim Start einer Engine ist die Wahl
des Verzeichnisses, in dem die Engine laufen soll. Einige Engines
bentigen eine Initialisierung oder eine Erffnungsbuchdatei in ihrem
Startverzeichnis, um ordnungsgem zu laufen.
Andere Engines (so wie Crafty) schreiben Logdateien in dem Verzeichnis,
in dem sie gestartet wurden, Sie mssen sie also in einem Verzeichnis
aufrufen, fr das Sie Schreibrecht haben.
Wenn fr das Verzeichnis einer Engine "." angegeben ist, wird Scid sie
einfach im aktuellen Verzeichnis starten.
</p>
<p>
Wenn also eine Engine, die in Scid laufen sollte, nicht startet,
versuchen Sie es mit anderen Verzeichniseinstellungen. Um zu vermeiden,
da Engines Logdateien in vielen verschiedenen Verzeichnissen erstellen,
empfehle ich, Engines im Verzeichnis der Scid-Benutzerdateien zu starten
(da, wo sich die Datei <b>scid.exe</b> bei Windows befindet bzw.
<b>~/.scid/</b> bei Unix); in der Dialogbox fr die Engine-Einstellungen
gibt es einen Schalter <b>scid.exe dir</b> fr Windows bzw. <b>~/.scid</b>
fr Unix, mit dem Sie die Engine in diesem Verzeichnis starten lassen
knnen.
</p>

<h3>Training</h3>
<p>
Mit dem Schalter <b>Training</b> knnen Sie gegen die Analyse-Engine
spielen. Die Bedenkzeit fr jeden Zug ist fest vorgegeben und die
Analyse-Ergebnisse werden nicht angezeigt, wenn der Trainingsmodus
eingeschaltet ist.
</p>

<h3>Partie kommentieren</h3>
<p>
Der Schalter <b>Variante hinzufgen</b> im Analysefenster fgt die
laufende Bewertung und beste Variante als neue Variante der Partie hinzu.
</p>
<p>
Man kann das fr mehrere Zge mit dem Schalter <b>Kommentieren</b>
automatisieren. Sie werden zur Eingabe einiger Kommentar-Optionen
aufgefordert, dann wird in den Autoplay-Modus geschaltet.
Wenn der Autoplay-Modus aktiviert und das Analysefenster geffnet ist,
wird die beste Variante mit Stellungsbewertung zu jeder Position
hinzugefgt, da sich der Autoplay-Modus durch die Partie bewegt.
Nur Stellungen von der aktuellen Stellung bis zum Partieende (oder bis
zum Abbruch des Autoplay-Modus) werden kommentiert, so da Sie Kommentare
zu Erffungszgen unterdrcken knnen, indem Sie vor Aktivierung des
Autoplay-Modus zu einer Mittelspielstellung gehen.
</p>
<p>
Die automatische Kommentierung kann jederzeit durch Ausschalten des
Autoplayer-Modus abgebrochen werden, z.B. durch Drcken der
<b>Esc</b>-Taste im Hauptfenster.
</p>
<p>
Zur Vereinfachung steht der <b>Kommentar</b>-Schalter nur in dem Fenster
zur Verfgung, das als erste Analyse-Engine geffnet wurde. Wenn Sie
eine Engine als Analyse-Engine Nr.2 ffnen, knnen Sie sie nicht zur
Partiekommentierung nutzen.
</p>

<h3>Das Analysebrett</h3>
<p>
Anklicken des Schachbrett-Icons in einem Analysefenster zeigt oder
versteckt das Analysebrett, welches die Position nach der aktuell
besten Variante der Engine zeigt. Das funktioniert fr die meisten
Scid-kompatiblen Engines, aber nicht unbedingt fr alle; es hngt
ganz davon ab, welche Zugnotation eine Engine verwendet.
</p>

<h3>Engine-Prioritt</h3>
<p>
Falls eine Engine zu viel CPU-Zeit verbraucht und die Benutzung von
Scid oder anderen Applikationen beeintrchtigt, kann das Einschalten
der Checkbox <b>Niedrige CPU-Prioritt</b> helfen; es weist der
Engine eine geringe Prioritt frs Proze-Scheduling zu.
</p>

<h3>Schnittstellen-Details</h3>
<p>
Fr die Benutzung des Analysefensters bentigen Sie ein Schachprogramm,
welches das <term>UCI</term> oder <term>WinBoard/Xboard</term>-Protokoll untersttzt.
</p>
<p>
Bei Winboard-Engines sendet Scid beim Programmstart die Befehle <b>xboard</b>, <b>post</b> und
<b>protover 2</b> zur Engine, und nutzt die Befehle <b>setboard</b>
und <b>analyze</b> zur effizienteren Kommunikation, wenn die Engine in
ihrer Antwort anzeigt, da sie diese untersttzt.
Wenn die Engine den Befehl <b>setboard</b> nicht untersttzt, wird sie
fr Partien, die nicht mit der Standard-Ausgangsstellung beginnen, keine
Analysen liefern knnen.
</p>
<p>
Programmen, die den Befehl <b>analyze</b> nicht untersttzen, sendet
Scid nach jeder nderung der Stellung folgende Kommandos: <b>new</b>
und <b>force</b>, dann die Partiezge zur aktuellen Position, danach
<b>go</b>.
</p>
<p>
Bob Hyatt's exzellentes frei verfgbares Schachprogramm <term>Crafty</term>
benutze und empfehle ich zur Analyse mit Scid. Aber auch andere WinBoard-
oder XBoard-kompatible Programme sind erfolgreich getestet worden.
Ein paar Websites zum Herunterladen einiger Engines sind nachfolgend
aufgefhrt.
</p>
<p>
Crafty:
<url ftp://ftp.cis.uab.edu/pub/hyatt/>ftp://ftp.cis.uab.edu/pub/hyatt/</url>
</p>
<p>
wbec-ridderkerk.nl (mit vielen Links auf aktuelle Schach-Engines):
<url http://wbec-ridderkerk.nl/html/lastupdates.htm>http://wbec-ridderkerk.nl/html/lastupdates.htm</url>
</p>
<p>
Gnuchess:
<url http://www.gnu.org/software/chess/chess.html>http://www.gnu.org/software/chess/chess.html</url>
</p>
<p>
The Crazy Bishop:
<url http://remi.coulom.free.fr/>http://remi.coulom.free.fr/</url>
</p>

<p><footer>(Aktualisiert: Scid 3.6.21, Dezember 2007)</footer></p>
}


###############################
### Comment editor window help:

set helpTitle(D,Comment) "Kommentareditor"
set helpText(D,Comment) {<h1>Der Kommentareditor</h1>
<p>
Mit dem Kommentareditor knnen Sie den Zgen der aktuellen Partie
Kommentare und symbolische Kommentarzeichen hinzufgen.
</p>

<h3>Kommentarzeichen</h3>
<p>
Scid verwendet den <a Author Related>PGN-Standard</a> fr
Kommentarzeichen und akzeptiert <a NAGs>NAG</a>-Werte fr Anmerkungen
(NAG = numeric annotation glyph, "numerisches Anmerkungszeichen").
Einige der meistgebruchlichen Symbole (wie "!" oder "+-") werden als
solche ausgegeben und haben zur schnelleren Eingabe einen Schalter im
Kommentareditor. Fr andere Symbole knnen Sie den jeweiligen numerischen
NAG-Wert, eine Zahl von 1 bis 255, eingeben. Zum Beispiel bedeutet
der NAG-Wert 36 "Wei besitzt die Initiative" und wird im
<a PGN>PGN-Text</a> der Partie als "$36" ausgegeben.
</p>
<p>
Zu den NAG-Werten, die durch den PGN-Standard definiert werden,
siehe auch die Hilfeseite <a NAGs>NAG-Werte</a>.
</p>
<p>
<b>Hinweis:</b> Sie knnen die blichen Bewertungssymbole fr Schachzge
(!, ?, !!, ??, !? und ?!) direkt im Haupfenster eingeben, ohne den
Kommentareditor zu verwenden, indem Sie das jeweilige Symbol gefolgt
von der [Eingabe]-Taste eintippen.
Das ist besonders ntzlich beim <a Moves>Schachzge eingeben</a>
ber die Tastatur.
</p>

<h3>Kommentare</h3>
<p>
Sie knnen Kommentare im bereitgestellten Textbereich editieren und
dabei die Leeren-, Umkehren- und Speichern-Schalter verwenden.
Sie brauchen den Schalter "Speichern" nicht anzuklicken, um einen Kommentar
zu aktualisieren; dies geschieht automatisch, wann immer Sie zu einer
anderen Partiestellung gehen.
</p>

<h3>Felder einfrben</h3>
<p>
Sie knnen jedes Feld mit einer beliebigen Farbe einfrben, indem Sie
ein besonderes, an irgendeiner Stelle im Kommentar eingebettetes
Kommando verwenden. Das Format dieses Kommandos ist:
</p>
<ul>
<li><b>[%mark feld farbe]</b> ,<li>
</ul>
<p>
wobei <b>feld</b> ein Feldname wie d4 ist und <b>farbe</b> irgendeine
bekannte Farbbezeichnung (wie etwa red, blue4, darkGreen,
lightSteelBlue, etc.) oder ein RGB-Code (ein <b>#</b> gefolgt von 6
Hexadezimalziffern, wie z.B. #a0b0c8). Die Standardfarbe,
falls die Farbangabe weggelassen wird, ist <red>Rot</red>.
</p>
<p>
Ein Kommentar kann eine beliebige Anzahl von Farbkommandos enthalten,
aber jedes mu ein eigenes <b>[%mark ...]</b>-Tag-Feld haben.
Beispielsweise wird der Kommentartext</p>
<p>
  "Jetzt ist d6 [%mark d6] geschwcht und kann vom Springer auf
  b5 [%mark b5 #000070] angegriffen werden."
</p>
<p>
das Feld d6 <red>rot</red> und das Feld b5 in der dunkelblauen Farbe
<darkblue>#000070</darkblue> einfrben.
</p>

<h3>Pfeile einzeichnen</h3>
<p>
Sie knnen mit einem speziellen Kommentar-Kommando, hnlich dem oben
beschriebenen zum Frben von Feldern, einen Pfeil von einem Feld zum
anderen zeichnen.
Das Format ist:
</p>
<ul>
<li><b>[%arrow vonFeld nachFeld farbe]</b><li>
</ul>
<p>
wobei <b>vonFeld</b> und <b>nachFeld</b> Feldbezeichnungen wie d4
sind und <b>farbe</b> ein bekannter Farbname (wie z.B. red, blue4, etc.)
oder RGB-Code (wie #a0b0c0) ist.
Ohne Farbangabe wird standardmig <red>Rot</red> genommen.
</p>
<p>
Beispiel: Der Kommentartext
</p>
<p>
"Springer auf c3 und Lufer auf c4 kontrollieren das schwache Feld d5.
 [%arrow c3 d5 red] [%arrow c4 d5 blue]"
</p>
<p>
zeichnet einen roten Pfeil von c3 nach d5 und einen blauen von c4 nach d5.
</p>

<p><footer>(Aktualisiert: Scid 3.2, Februar 2002)</footer></p>
}


###########################
### Crosstable window help:

set helpTitle(D,Crosstable) "Turniertabelle"
set helpText(D,Crosstable) {<h1>Das Turniertabellen-Fenster</h1>
<p>
Das Turniertabellen-Fenster zeigt die Turniertabelle zur aktuellen
Partie. Jedesmal, wenn sie das Fenster aktualisieren (indem Sie den
"Aktualisieren"-Schalter anklicken, im Turniertabellen-Fenster die
[Eingabe]-Taste drcken oder im <a MainWindow>Haupt</a>- oder
<a GameList>Partielisten</a>-Fenster die Tastenkombination
<b>[Strg]-[Umschalt]-X</b> bettigen), sucht Scid alle Partien
vom selben Turnier wie die aktuelle Partie.
</p>
<p>
Jede Partie, die bis zu <b>drei Monate vor oder nach</b> der aktuellen
Partie gespielt wurde und <b>exakt dieselben Turnier- und Ortsangaben</b>
enthlt, wird als Partie dieses Turniers betrachtet.
</p>
<p>
Ein Einfachklick mit der linken Maustaste auf irgendein Ergebnis in der
Turniertabelle ldt die entsprechende Partie.
Sie knnen alle Partien des Turniers mit dem Schalter
<b>Zum Filter addieren</b> des Turniertabellen-Fensters zum
<a Searches Filter>Filter</a> hinzufgen.
</p>

<h4>Mens des Turniertabellen-Fensters</h4>
<p>
Im <menu>Datei</menu>-Men knnen Sie die aktuelle Tabelle im Text-,
LaTeX- oder HTML-Format in eine Datei ausgeben.
</p>
<p>
Das <menu>Ausgabe</menu>-Men erlaubt Ihnen, das Tabellenformat
auszuwhlen: <b>Jeder gegen jeden</b>, <b>Schweizer System</b>,
<b>K.o.-System</b> oder <b>Automatisch</b>.
</p>
<p>
Das Format "Jeder gegen jeden" (fr Rundenturniere) ist auf 30 Spieler
limitiert, aber "Schweizer System" (fr Turniere mit vielen Spielern)
kann bis zu 200 Spieler und 20 Runden ausgeben. Die Standardeinstellung
ist <b>Automatisch</b>, was fr jedes Turnier das beste Format auswhlt.
</p>
<p>
Beachten Sie, da Scid den <b>Runden</b>-Eintrag jeder Partie verwendet,
um eine Turniertabelle nach Schweizer System zu erstellen, Sie werden daher
keine Partien in der Schweizer-System-Tabelle sehen, wenn sie keine
numerischen Runden-Angaben haben:  1, 2, 3, etc.
</p>
<p>
Im Ausgabe-Men knnen Sie auch das Format der Datenausgabe nach Ihren
Wnschen einstellen, um Wertungszahlen, Lnder oder Titel ein- oder
auzublenden. Sie knnen auch whlen, ob beim Schweizer System die
Farbzuteilung angezeigt werden soll.
</p>
<p>
Die Option <b>Punktgruppen</b> wirkt sich nur dann auf das Aussehen der
Tabelle aus, wenn die Spieler nach Punkten sortiert werden: sie bewirkt
das Einfgen einer Leerzeile zwischen Spielergruppen mit gleicher Punktzahl.
</p>
<p>
Das Men <menu>Sortieren</menu> erlaubt es Ihnen, die Spieler nach
Namen, Elo-Zahlen oder Punkten zu sortieren; Standardeinstellung ist
nach Punkten.
</p>
<p>
Das <menu>Farben</menu>-Men ermglicht es Ihnen, Farbausgabe (Hypertext)
ein- oder auszuschalten. Da es sehr zeitaufwendig ist, groe Turniertabellen
in HTML zu formatieren und auszugeben, wird Ihnen die Option <b>Text</b>
bei groen Turnieren eine Menge Zeit einsparen.
Allerdings knnen Sie im Text-Modus keine Spieler oder Partien anklicken.
</p>

<h4>Dubletten in Turniertabellen</h4>
<p>
Um sinnvolle Resultate mit der Turniertabelle zu erzielen, sollten Sie
Dubletten zum Lschen markieren, und Ihre Partien sollten eine
einheitliche Schreibweise fr Spieler-, Orts- und Turniernamen haben.
Zu Hilfen beim Lschen der Dubletten und Editieren (oder berprfen
der Schreibweisen) von Spieler-, Turnier-, Ortsnamen siehe die Seite
<a Maintenance>Datenbank-Wartung</a>.
</p>

<p><footer>(Aktualisiert: Scid 4.7, Mai 2021)</footer></p>
}


###########################
### Database switcher help:

set helpTitle(D,Switcher) "Datenbank-Umschalter"
set helpText(D,Switcher) {<h1>Der Datenbank-Umschalter</h1>
<p>
Der Datenbank-Umschalter bietet eine Darstellung, die es besonders
einfach macht, zwischen Datenbanken zu wechseln oder Dateien zu kopieren.
Der Name, <a Searches Filter>Filter</a>-Status und Icon jeder Datenbank
werden angezeigt, und die aktive Datenbank ist durch einen gelben
Hintergrund hervorgehoben.
</p>
<p>
Sie knnen den Datenbank-Umschalter aus dem <menu>Fenster</menu>-Men
starten oder durch die Tastenkombination <b>Strg+D</b>.
</p>
<p>
Um alle ausgewhlten (gefilterten) Dateien einer Datenbank in eine andere
zu kopieren, ziehen Sie sie mit gedrckter linker Maustaste in das Zielfeld.
Sie sehen dann eine Nachfrage (falls die Zieldatenbank nicht die
<a Clipbase>Ablage</a> ist), ob die Dateien kopiert werden sollen, oder
eine Fehlermeldung, falls die Dateien nicht kopiert werden knnen
(z.B. wenn die gewhlte Datenbank nicht geffnet ist).
</p>
<p>
Drcken Sie die rechten Maustaste ber einer Datenbank, erscheint ein
Kontextmen zu dieser Datenbank, mit dem Sie das Datenbank-Icon ndern oder
den <a Searches Filter>Filter</a> zurcksetzen knnen.
In diesem Men knnen Sie auch die Fensterausrichtung ndern (um die
Datenbankfelder vertikal oder horizontal anzuordnen), was fr kleinere
Bildschirme recht ntzlich ist.
</p>

<p><footer>(Aktualisiert: Scid 3.1, Dezember 2001)</footer></p>
}

############################
### File Finder window help:

set helpTitle(D,Finder) "Dateisuche"
set helpText(D,Finder) {<h1>Die Dateisuche</h1>
<p>
Die <term>Dateisuche</term> hilft Ihnen, Dateien jedes von Scid
benutzten Typs zu finden:  Datenbanken, <a PGN>PGN</a>-Dateien,
<a EPD>EPD</a>-Dateien und <a Repertoire>Repertoire</a>-Dateien.
</p>
<p>
Die Dateisuche zeigt Ihnen ntzliche Informationen zu jeder Datei, wie
etwa ihre Gre (siehe unten) und Datum der letzten Modifikation.
Sie knnen jede angezeigte Datei durch einen linken Mausklick ffnen.
</p>

<h3>In Unterverzeichnissen nachsehen</h3>
<p>
Wenn Sie alle Dateien in allen Unterverzeichnissen des aktuellen
Verzeichnisses finden wollen, schalten Sie <b>Unterverzeichnisse
beachten</b> ein. Dann durchsucht Scid rekursiv jedes Unterverzeichnis
nach Dateien, die Scid ffnen kann. Wenn viele Unterverzeichnisse
vorhanden sind, kann dies eine Weile dauern, Sie sollten das also
nicht fr ein Verzeichnis nahe dem Hauptverzeichnis des Dateisystems
tun. Sie knnen die Dateisuche mit dem <b>Stop</b>-Schalter unterbrechen.
</p>

<h3>Dateigren</h3>
<p>
Die Bedeutung der angegebenen Dateigre hngt vom Typ der
Datei ab. Fr Scid-Datenbanken und -PGN-Dateien ist es die Anzahl der
Partien. Fr EPD-Dateien ist es die Anzahl der Positionen. Fr
Repertoiredateien ist es die Anzahl der (gewhlten oder ausgeschlossenen)
Varianten.
</p>
<p>
Fr Scid-Datenbanken entspricht die Gre der Anzahl gespeicherter Partien.
Fr alle anderern Datenbanken (z.B. pgn-Dateien) wird die Dateigre angegeben.
</p>

<p><footer>(Aktualisiert: Scid 4.7, September 2018)</footer></p>
}


#########################
### GameList window help:

set helpTitle(D,GameList) "Partieliste"
set helpText(D,GameList) {<h1>Das Partielistenfenster</h1>
<p>
Das Partielistenfenster gibt eine einzeilige Zusammenfassung jeder
Partie im aktuellen <term>Filter</term> aus.
</p>

<h3>Navigation in der Partieliste</h3>
<p>
Sie knnen in der Partieliste mit dem Schieberegler oder den vier
Schaltern unterhalb der Liste blttern.
Sie knnen auch die Tasten [Pos1], [End], [Bild auf], [Bild ab] sowie
die Cursortasten verwenden, um mit der Tastatur zu scrollen.
</p>
<p>
Sie knnen die nchste Partie in der Liste, die einen bestimmten
Text im Wei-, Schwarz-, Turnier- oder Ortsfeld enthlt, mit dem
<b>Text finden</b>-Eingabefeld finden.
</p>

<h3>Aktionen mit Partien in der Liste</h3>
<p>
Um eine Datei aus der Liste zu laden, klicken Sie sie doppelt mit
der linken Maustaste an.
Ein Klick mit der mittleren Maustaste zeigt die Anfangszge der Partie;
das ist ntzlich, wenn man vor dem Laden einer Partie die Erffnung
nachsehen will.
</p>
<p>
Die rechte Maustaste produziert ein Men fr die ausgewhlte Partie,
in dem Sie die Partie lschen (oder "entlschen") oder aus dem Filter
ausschlieen knnen. Beachten Sie, da das Lschen einer Datei lediglich
ihre Lschmarkierung setzt; sie verbleibt solange in der Datenbank,
bis Sie diese <a Compact>komprimieren</a>.
</p>

<h3>Die Partieliste konfigurieren</h3>
<p>
Um die Partieliste zu konfigurieren, klicken Sie mit der linken oder
rechten Maustaste auf eine Spaltenberschrift. Sie knnen die Breite
verndern, Spalten hinzufgen oder entfernen und die Farbe jeder
Spalte verndern.
</p>
<p>
Wenn Sie nur die Spaltenbreite ndern wollen, dafr gibt es eine
Tastenkombination: klicken Sie bei gedrckter <b>[Strg]</b>- (oder
<b>[Umschalt]</b>)-Taste mit der linken Maustaste auf die
Spaltenberschrift, wird die Spalte kleiner, mit der rechten
Maustaste, wird sie breiter.
</p>

<h3>Gre der Partieliste ndern</h3>
<p>
Die Gre der Partieliste wird jedesmal in der Optionsdatei gespeichert,
wenn Sie Ihre Einstellungen sichern.
Wenn Sie also wollen, da die Dateiliste standardmig 10 Partien anzeigt,
verndern Sie einfach die Gre des Partielistenfensters und whlen
dann <b>Optionen speichern</b> im <menu>Optionen</menu>-Men.
</p>

<h3><name Browsing>Partien betrachten und mischen</name></h3>
<p>
Das Kontextmen der Partieliste (und einiger andere Fenster, wie etwa
des <a Reports Opening>Erffnungsbericht</a>-Fensters und der Liste der
<a Tree Best>beste(n) Partien</a> des <a Tree>Zugbaum</a>-Fensters)
erlauben die Auswahl, eine Partie zu laden, zu betrachten oder zu
mischen.
</p>
<p>
Wenn <term>Partie betrachten</term> ausgewhlt wird, werden die Zge
der ausgewhlten Partie (ohne Kommentare oder Varianten) in einem
separaten Fenster ausgegeben. Das ist eine ntzliche Methode, um eine
andere Partie im voraus anzuschauen, ohne die aktuell geladene Partie
zu berhren.
</p>
<p>
Die Funktion <term>Partie mischen</term> ermglicht es, die ausgewhlte
Partie als Variante der aktuellen Partie einzufgen. Scid findet den
letztmglichen Zeitpunkt, wo die gewhlte Partie von der aktuellen
abweicht (unter Bercksichtigung von Zugumstellungen), und fgt an
dieser Position eine Variante ein. Sie knnen die Zahl der angezeigten
Zge der gewhlten Partie ndern, je nachdem, ob Sie die ganze Partie
oder nur die Erffnungsphase hinzufgen wollen.
</p>

<p><footer>(Aktualisiert: Scid 3.2, Februar 2002)</footer></p>
}


#######################
### Import window help:

set helpTitle(D,Import) "Importfenster"
set helpText(D,Import) {<h1>Das Importfenster</h1>
<p>
Scids Importfenster ermglicht es Ihnen, auf einfache Weise eine
Partie im <a PGN>PGN-Format</a> aus einer anderen Anwendung oder
einem anderen Fenster in Scid einzufgen.
</p>
<p>
In den groen Fensterbereich tippen oder fgen Sie den Partietext im
PGN-Format ein, und im grauen Bereich darunter erscheinen
Fehlermeldungen oder Warnungen.
</p>

<h3>Die aktuelle Partie im Importfenster bearbeiten</h3>
<p>
Das Importfenster bietet auch eine weitere, bequeme Mglichkeit fr
nderungen an der aktuellen Partie: Sie knnen die aktuelle Partie in
das Importfenster einfgen (mit dem Schalter <b>Aktuelle Partie
einfgen</b>), den Text editieren und danach auf <b>Import</b> klicken.
</p>

<h3>PGN-Tags im Importfenster</h3>
<p>
Scid erwartet PGN-Eintrge ("header tags") wie
<ul>
<li> <b>[Result "*"]</b> </li>
</ul>
vor den Zgen, aber Sie knnen auch ein Partiefragment wie
<ul>
<li> <b>1.e4 e5 2.Bc4 Bc5 3.Qh5?! Nf6?? 4.Qxf7# 1-0</b> </li>
</ul>
ohne PGN-Tags einfgen, und Scid wird es importieren.
</p>

<h3>PGN-Dateien in Scid verwenden</h3>
<p>
Wenn Sie eine PGN-Datei in Scid verwenden wollen, ohne sie vorher mit
<a Pgnscid>pgnscid</a> zu konvertieren, gibt es zwei Mglichkeiten.
</p>
<p>
Zum einen knnen Sie die Partien der Datei mit der Men-Option
<menu>Werkzeuge: Datei mit PGN-Partien importieren ...</menu> importieren.
</p>
<p>
Die Alternative wre, die PGN-Datei direkt in Scid zu ffnen. Allerdings
werden PGN-Dateien nur zum Lesen geffnet und bentigen mehr Speicher als
eine vergleichbare Scid-Datenbank, diese Mglichkeit ist also nur fr
relativ kleine PGN-Dateien zu empfehlen.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


########################
### Reports help:

set helpTitle(D,Reports) "Berichte"
set helpText(D,Reports) {<h1>Berichte</h1>
<p>
Bei Scid ist ein <term>Bericht</term> ein Dokument, das Informationen ber
eine bestimmte Position und/oder einen bestimmten Spieler enthlt. Scid
kann zwei Berichtstypen erstellen: Erffnungsberichte und Spielerberichte.
</p>

<h3><name Opening>Erffnungsberichte</name></h3>
<p>
Scid kann einen <term>Erffnungsbericht</term> erstellen, der interessante
Informationen ber die aktuelle Erffnungsposition ausgibt. Um den
Erffnungsbericht zu erstellen, vergewissern Sie sich als erstes, da die
dargestellte Position auch die ist, fr die Sie den Bericht haben wollen,
dann whlen Sie <b>Erffnungsbericht</b> im Men <menu>Werkzeuge</menu>.
</p>
<p>
Das <term>Erffnungsberichts</term>-Fenster gibt die Ergebnisse des von
Scid erstellten Berichts aus. Das <b>Datei</b>-Men enthlt Optionen,
um den Bericht in einer Datei zu speichern, im Text-, HTML- oder
<a LaTeX>LaTeX</a>-Format.
</p>
<p>
Die ersten Abschnitte des Berichts prsentieren Informationen zu den
Partien, die die Berichtsposition erreicht haben, und zu den Zgen, die
in dieser Stellung gespielt wurden. Sie knnen erkennen, ob die Erffnung
populrer wird, ob sie zu vielen Kurzremisen fhrt und mit welchen
Zugfolgen (Zugumstellungen) sie erreicht wird.
</p>
<p>
Der Abschnitt ber positionelle Themen informiert ber die Hufigkeit
bestimmter typischer Themen der Berichtspartien. Zu diesem Zweck werden
die ersten 20 Zge (also die ersten 40 Positionen ab Ausgangsstellung)
jeder Partie untersucht. Um als eine Partie eingestuft zu werden, die
ein bestimmtes Thema enthlt, mu dieses Thema mindestens viermal
innerhalb der ersten 20 Zge der Partie vorkommen. Damit wird vermieden,
da durch kurzzeitiges Auftreten eines Themas (wie etwa ein isolierter
Damenbauer, der sofort geschlagen wird) die Ergebnisse verflscht werden.
</p>
<p>
Der letzte und lngste Teil des Berichts ist die Theorie-Tabelle. Wenn Sie
den Bericht in einer Datei sichern, knnen Sie whlen, ob Sie nur die
Theorie-Tabelle, einen kompakten Bericht ohne die Theorie-Tabelle oder
den gesamten Bericht sichern wollen.
</p>
<p>
Fast alle Abschnitte des Berichts knnen mit den Erffnungsberichts-Optionen
eingestellt oder ein- und ausgeschaltet werden, Sie knnen also den
Bericht so anpassen, da er nur die fr Sie interesanten Informationen
enthlt.
</p>
<p>
Bei den meisten Informationen im Berichtsfenster, die farbig dargestellt
sind, fhrt ein linker Mausklick zu einer Aktion. Zum Beispiel knnen Sie
eine angefhrte Partie durch Anklicken laden oder den Filter durch
Klicken auf ein Positionsthema so einstellen, da er nur die
Berichtspartien mit diesem Thema enthlt.
</p>

<h4>Favoriten</h4>
<p>
Mit dem <menu>Favoriten</menu>-Men des Berichtsfensters haben Sie die
Mglichkeit, eine Liste bevorzugter Erffnungsbericht-Positionen zu
verwalten und sehr einfach Berichte fr genau diese Positionen zu
erstellen. Wenn Sie "Bericht hinzufgen..." im Favoriten-Men
whlen, wird die aktuelle Stellung als besondere Berichtsposition
aufgenommen. Sie werden aufgefordert, einen Namen anzugeben, der dann
als Dateiname verwendet wird, wenn Favoritenberichte erstellt werden.
</p>
<p>
Whlen Sie "Berichte erzeugen..." im Favoriten-Men, um einen Bericht
fr jede Ihrer bevorzugten Positionen aus der aktuellen Datenbank zu
erstellen. In einem Dialogfenster knnen Sie dann Typ und Format der
Berichte angeben sowie ein Verzeichnis, wo die Berichtsdateien
gespeichert werden sollen. Die passende Dateiendung fr das gewhlte
Ausgabeformat wird dann automatisch ergnzt (z.B. ".html" fr das
HTML-Format).
</p>

<h3><name Player>Spielerberichte</name></h3>
<p>
Ein <term>Spielerbericht</term> hnelt sehr stark einem Erffnungsbericht,
enthlt aber Informationen ber Partien eines einzelnen Spielers mit
Wei oder mit Schwarz. Sie knnen einen Spielerbericht ber das
Werkzeuge-Men oder aus dem <a PInfo>Spielerinformations</a>-Fenster
heraus erzeugen.
</p>
<p>
Ein Spielerbericht kann entweder fr alle Partien eines bestimmten Spielers
mit einer bestimmten Farbe erstellt werden oder nur fr die Partien, die
die aktuelle Stellung des Hauptfenster-Bretts erreicht haben.
</p>

<h3>Beschrnkungen</h3>
<p>
Fr die meisten Berichtsdaten gibt es eine Beschrnkung auf 2000 Partien,
wenn die Berichtsposition also mehr als 2000 Partien enthlt, knnen
einige Resultate etwas ungenau sein.
</p>
<p>
Auerdem gibt es ein Limit von 500 Partien fr die Theorie-Tabelle. Wenn
die Berichtsposition in mehr als 500 Partien vorkommt, werden zur
Erstellung der Theorie-Tabelle nur die 500 Partien mit den hchsten
durchschnittlichen Elo-Zahlen herangezogen. Die Anzahl der Partien zum
Aufbau der Theorie-Tabelle ist einstellbar.
</p>

<p><footer>(Aktualisiert: Scid 3.5, Februar 2003)</footer></p>
}


####################
### PGN window help:

set helpTitle(D,PGN) "PGN-Fenster"
set helpText(D,PGN) {<h1>Das PGN-Fenster</h1>
<p>
Scids PGN-Fenster gibt den Inhalt der aktuellen Partie in der
Standard-PGN-Darstellung aus. Im Partietext erscheinen Kommentare in
{geschweiften} und Varianten in (runden) Klammern.
</p>

<h3>PGN-Format</h3>
<p>
PGN (Portable Game Notation) ist ein verbreiteter Standard zum Transfer
von Schachpartien zwischen Computerprogrammen. Eine PGN-Partie besteht
aus zwei Abschnitten.
Der erste Teil ist der Vorspann ("Header"), der Eintragungen ("tags") wie
z.B.
<b>[White "Kasparov, Gary"]</b>
und
<b>[Result "1/2-1/2"]</b> enthlt.
</p>
<p>
Der zweite Abschnitt enthlt die eigentlichen Partiezge in
algebraischer Standardnotation (SAN) zusammen mit eventuellen Varianten,
<a NAGs>Kommentarsymbolen</a> und <a Comment>Kommentaren</a>.
</p>

<h3>Aktionen im PGN-Fenster</h3>
<p>
Sie knnen mit dem PGN-Fenster innerhalb der Partie navigieren: Mit
einem Linksklick auf einen Zug gehen Sie zu diesem Zug, mit einem
Linksklick auf einen Kommentar knnen Sie diesen editieren.
Die Cursortasten (sowie die Tasten <b>v</b> und <b>z</b> fr
Variante beginnen bzw. verlassen) funktionieren zum Navigieren in der
Partie genau wie im Hauptfenster.
</p>

<h3>Einstellungen fr PGN-Ausgabe</h3>
<p>
Das Men des PGN-Fensters enthlt Optionen, die die Ausgabe des Fensters
betreffen. Scid kann die Partie farbig oder als reinen Text darstellen
-- siehe das <menu>Ausgabe</menu>-Men im PGN-Fenster.
Die farbige Darstellung ist leichter zu lesen und erlaubt Ihnen, Zge und
Kommentare mit der Maus auszuwhlen, aber sie ist viel langsamer zu
aktualisieren. Fr sehr lange Partien sollten Sie vielleicht die
einfache Textausgabe whlen.
</p>
<p>
Auch das Format der Kommentare und Varianten knnen Sie verndern,
indem Sie sie zwecks besserer bersichtlichkeit eingerckt oder in
separaten Zeilen ausgeben lassen.
</p>
<p>
Die PGN-Ausgabe-Optionen und die Gre des PGN-Fensters werden, wann
immer Sie <b>Optionen speichern</b> im <menu>Optionen</menu>-Men whlen,
in der Konfigurationsdatei gesichert.
</p>

<p><footer>(Aktualisiert: Scid 3.1, Dezember 2001)</footer></p>
}


#######################
### Piece Tracker help:

set helpTitle(D,PTracker) "Figurenverteilung"
set helpText(D,PTracker) {<h1>Das Figurenverteilungsfenster</h1>
<p>
Die <term>Figurenverteilung </term> bzw. das Figurenverteilungsfenster
ist ein Werkzeug, um die Bewegungen bestimmter Figuren in allen Partien
des aktuellen Filters nachzuvollziehen und ein Bewegungsmuster (eine
"Fuspur") zu erstellen, das aufzeigt, wie oft jedes Feld von dieser
Figur besetzt wurde.
</p>
<p>
Um die Figurenverteilung zu benutzen, vergewissern Sie sich zuerst, da
der Filter die Partien enthlt, die Sie interessieren, z.B. Partien mit
einer bestimmten Erffnungsposition oder alle Wei-Partien eines
bestimmten Spielers. Dann whlen Sie die Figur, deren Bewegung Sie
nachvollziehen wollen, und whlen die unten im Text erluterten Optionen.
Danach klicken Sie auf den Schalter <b>Aktualisieren</b>.
</p>
<p>
Die Information ber die Figurenbewegungen wird auf zwei Arten dargestellt:
eine grafische "Fuspur" und eine Liste mit einer Textzeile pro Feld.
</p>

<h3>Auswahl der Figur</h3>
<p>
Die Schachfiguren sind unterhalb der "Karte" fr die "Fuspur" gem der
Ausgangsstellung angeordnet. Eine einzelne Figur (wie etwa der weie
Springer b1 oder der schwarze Bauer d7) kann mit der linken Maustaste
ausgewhlt werden, alle Figuren von gleichem Typ und gleicher Farbe
(wie z.B. alle weien Bauern oder beide schwarzen Trme) mit der
rechten Maustaste.
</p>

<h3>Weitere Einstellungen</h3>
<p>
Der Zugnummer-Bereich kontrolliert, wann die Figurenverfolgung anfangen
und enden soll. Die Standardeinstellung 1-20 (d.h. die Verfolgung endet
nach dem 20. Zug von Schwarz) ist gut geeignet zur Untersuchung von
Erffnungsthemen, aber (z.B.) ein Bereich von 15-35 wre besser, wenn
man Entwicklungen im Mittelspiel betrachten will.
</p>
<p>
Es knnen zwei Arten von Statistiken erstellt werden:
<ul>
<li> <b>% der Partien mit Zug auf das Feld</b>: zeigt, welcher Anteil
     an Filterpartien einen Zug der zu beobachtenden Figur auf jedes
     Feld enthlt. Das ist die Standardeinstellung und normalerweise
     die beste Wahl.
<li> <b>% der Zeit auf jedem Feld</b>: zeigt den Anteil der
     Verweildauer der zu beobachtenden Figur auf jedem Feld.
</ul>
</p>

<h3>Hinweise</h3>
<p>
Es gibt (mindestens) drei gute Verwendungsmglichkeiten fr die
Figurenverteilung: Erffnungsvorbereitung, Mittelspielthemen und
Spielervorbereitung.
</p>
<p>
Fr die Erffnungsvorbereitung verwenden Sie die Figurenverteilung
zusammen mit dem <a Tree>Zugbaum</a>. Indem Sie die Bewegungen von
Figuren nachvollziehen, knnen Sie Entwicklungen in der aktuellen
Erffnung erkennen, beispielsweise bliche Bauernvorste,
Springervorposten und die hufigsten Luferplazierungen. Dabei ist es
hilfreich, den Zugbereich nach dem aktuellen Partiezug beginnen zu
lassen, so da die Zge, die zur aktuellen Stellung fhrten, nicht in
die Statistik einflieen.
</p>
<p>
Fr Mittelspielthemen kann die Figurenverteilung ntzlich sein, wenn
der Filter einen bestimmten Elo-Bereich enthlt (mit der
<a Searches Header>Partiedaten-Suche</a>) oder vielleicht ein Muster
wie "Isolierter Damenbauer von Wei"
(mit der <a Searches Material>Material/Muster-Suche</a>).
Stellen Sie den Zugbereich auf einen sinnvollen Wert ein (z.B. 20-40)
und verfolgen Sie Figuren, um beispielsweise Bauernvorste im spten
Mittelspiel oder frhen Endspiel zu erkennen
</p>
<p>
Zur Spielervorbereitung verwenden Sie die
<a Searches Header>Partiedaten-Suche</a> oder die
<a PInfo>Spieler-Information</a>, um alle Partien einer Farbe eines
bestimmten Spielers zu finden. Die Figurenverteilung kann dann genutzt
werden um z.B. festzustellen, wie gern der Spieler Lufer fianchettiert,
lang rochiert oder einen Bauernkeil bis d5 oder e5 treibt.
</p>

<p><footer>(Aktualisiert: Scid 3.3, April 2002)</footer></p>
}

#####################
### Player List help:

set helpTitle(D,PList) "Spielersuche"
set helpText(D,PList) {<h1>Die Spielersuche</h1>
<p>
Die <term>Spielersuche</term> gibt eine Namensliste von Spielern
aus der aktuellen Datenbank aus. Die Auswahl eines Spielers ffnet
das <a PInfo>Spieler-Informations</a>-Fenster mit detaillierteren
Informationen ber diesen Spieler.
</p>
<p>
Es werden 5 Spalten ausgegeben, die jeweils den Namen, die hchste
Elo-Zahl, Anzahl der gespielten Partien sowie das Jahr der
ltesten und neueste Partie anzeigen.
Ein Klick auf eine Spalten-berschrift sortiert die Liste nach
dieser Spalte.
</p>
<p>
Die Kontrollschalter unterhalb der Liste ermglichen Ihnen, den
Inhalt der Liste zu filtern. Sie knnen die maximale Listengre
ndern, einen Spielernamen-Anfang eingeben (Gro-/Kleinschreibung
wird ignoriert, z.B. sucht "ada" nach "Adams") sowie den
Elozahlen-Bereich oder die Anzahl der gespielten Partien eingrenzen.
</p>

<p><footer>(Aktualisiert: Scid 4.7, September 2018)</footer></p>
}

#####################
### Player Info help:

set helpTitle(D,PInfo) "Spielerinformation"
set helpText(D,PInfo) {<h1>Die Spieler-Information</h1>
<p>
Das Fenster <term>Spieler-Information</term> wird jedesmal aufgebaut
oder aktualisiert, wenn Sie im Informationsbereich (unterhalb des
Schachbretts) oder im <a Crosstable>Turniertabellen</a>-Fenster mit der
linken Maustaste auf einen Spielernamen klicken.
</p>
<p>
Es gibt ntzliche Informationen ber die Spieler aus,
einschlielich ihrer Erfolgsrate mit Wei und Schwarz, ihrer bevorzugten
Erffnungen (nach <a ECO>ECO-Code</a>) und ihrer Elo-Entwicklung.<br>
Die Daten fr den Elo-Verlauf knnen wahlweise aus der aktuellen Datenbank
oder aus der Schreibkorrekturdatei/Ratingdatei gelesen werden. Wenn Sie ein
gepflegte Rating-Datei verwenden, knnen auch die Zeitrume dargestellt werden,
fr die in der Datenbank keine Spiele vorhanden sind.<br>
Eine Ratingdatei mit aktuellen ELO-Zahlen von ber 300.000 registrierten
FIDE-Spieler kann unter <url https://sourceforge.net/projects/scid/files/Player Data/>
https://sourceforge.net/projects/scid/files/Player Data/</url> heruntergeladen werden.
</p>
<p>
Jede Prozentangabe ist das Ergebnis, das man aus Sicht des Spielers
erwartet (Erfolgsrate) -- d.h. ein hherer Wert ist fr die Spieler
immer besser, ob als Wei oder Schwarz.
</p>
<p>
Sie knnen die ELO-Entwicklung des Spielers grafisch dargestellt
sehen, wenn Sie die Taste <a Graphs Rating>ELO-Zahl-Verlauf</a> anklicken.
</p>
<p>
Jede rot dargestellte Zahl knnen Sie mit der linken Maustaste anklicken,
um den <a Searches Filter>Filter</a> so einzustellen, da er die
entsprechenden Partien enthlt.
</p>

<p><footer>(Aktualisiert: Scid 4.7, November 2018)</footer></p>
}


###########################
### Repertoire editor help:

set helpTitle(D,Repertoire) "Repertoire-Editor"
set helpText(D,Repertoire) {<h1>Der Repertoire-Editor</h1>
<p>
Mit dem Repertoire-Editor knnen Sie <term>Repertoire</term>-Dateien
erstellen, lesen oder bearbeiten. Eine Repertoiredatei ist eine Liste
der Erffnungspositionen, die Sie erreichen wollen oder zu vermeiden
suchen; Sie knnen sie zur Organisation Ihrer Erffnungsprferenzen
und zur Datenbanksuche in Scid verwenden.
</p>

<h3>Repertoire-Gruppen und -Varianten</h3>
<p>
Ein Repertoire enthlt zwei Elementtypen: <term>Gruppen</term> und
<term>Varianten</term>. Gruppen sind nicht tatschlich Teil Ihres
Repertoires; sie werden nur zur Strukturierung verwendet, so wie
Verzeichnisse Dateien auf einem Datentrger strukturieren.
</p>
<p>
In einem Repertoire gibt es in zwei Arten von Varianten:
<term>eingeschlossene</term> Varianten reprsentieren Erffnungspositionen,
an denen Sie interessiert sind und die Sie erreichen wollen, und
<term>ausgeschlossene</term> Varianten, die Sie nicht spielen wollen
und zu vermeiden suchen.
Wenn Sie z.B. Angenommenes Damengambit (1.d4 d5 2.c4 dxc4) mit Schwarz
spielen und nach 3.e4 alle Zge <i>auer </i> 3...Sf6 spielen, htten
Sie 1.d4 d5 2.c4 dxc4 3.e4 als eingeschlossene Variante und 1.d4 d5 2.c4
dxc4 3.e4 Sf6 als ausgeschlossene Variante.
</p>

<h3>Kommentare und Anmerkungen</h3>
<p>
Jede Gruppe oder Variante kann Kommentare enthalten. Es gibt zwei Typen:
kurze (einzeilige) Kommentare erscheinen (in Rot) in der
Repertoire-Hierarchie neben den Zgen der Gruppe oder Variante, whrend
ein langer (mehrzeiliger) Kommentar nur angezeigt wird, wenn die Gruppe
oder Variante ausgewhlt wird.
</p>

<h3>Das Fenster des Repertoire-Editors</h3>
<p>
Die <b>linke</b> Seite des Fensters zeigt die Repertoire-Hierarchie.
Sie knnen die Gruppendarstellung mit einem Klick auf den Ordner auf-
bzw. zuklappen, und mit einem Klick auf die Zge der Gruppen oder
Varianten whlen Sie diese aus und sehen ihre Kommentare.
Eingeschlossene Varianten werden mit einem blauen Haken angezeigt,
ausgeschlossene Varianten haben ein rotes Kreuz.
</p>
<p>
Wenn eine Variante oder Gruppe einen Kurzkommentar hat, wird er hinter
den Zgen angezeigt. Wenn sie einen langen Kommentar hat, wird dies mit
<b><red>**</red></b> nach den Zgen angezeigt. Bei den Gruppen steht
nach den Zgen eine Zahl in Klammern, die die Anzahl der (ein- und
ausgeschlossenen) Varianten anzeigt, die sie jeweils enthalten.
</p>
<p>
Nach einem Rechtsklick auf eine Gruppe oder Variante erscheint ein Men
mit den verfgbaren Funktionen wie Lschen oder Statusnderung.
</p>
<p>
Die <b>rechte</b> Seite des Fensters besteht aus drei Bereichen. Der
erste enthlt die Zge der gerade ausgewhlten Variante oder Gruppe. Sie
knnen ihn mit der linken Maustaste anklicken, womit Sie die Zge in das
<a Import>Import</a>-Fenster einfgen, was recht ntzlich ist, um die
aktuelle Partie mit einer Variante des Repertoires beginnen zu lassen.
Der zweite Bereich enthlt den Kurzkommentar der Variante oder Gruppe,
der dritte Bereich ihren langen Kommentar.
</p>

<h3>Gruppen und Varianten dem Repertoire hinzufgen</h3>
<p>
Um eine Variante oder Gruppe hinzuzufgen, fhren Sie einfach ihre Zge
auf dem Schachbrett im Hauptfenster aus, whlen dann das Men
<menu>Bearbeiten</menu> im Repertoire-Editor und fgen sie als Gruppe,
eingeschlossene Variante oder ausgeschlossene Variante hinzu.
</p>
<p>
Um eine Gruppe oder Variante zu lschen, klicken Sie sie mit der rechten
Maustaste an und whlen im erschienenen Men das entsprechende Kommando.
</p>

<h3><name Search>Datenbanksuche mit Repertoire-Dateien</name></h3>
<p>
Das Men <menu>Suchen</menu> des Repertoire-Editors ermglicht es Ihnen,
mit dem Repertoire in der aktuellen Datenbank zu suchen. Jede Partie
wird mit den Positionen im Repertoire verglichen und nur dann erkannt,
wenn die <i>weitestverzweigte</i> Repertoire-Position fr eine
<i>eingeschlossene</i> Variante gefunden wurde.
</p>
<p>
Sie knnen whlen, ob Sie nach dem gesamten Repertoire oder nur nach den
ausgegebenen Varianten suchen wollen. Die Suche nach den ausgegebenen
Varianten ist nur dann sinnvoll, wenn Sie nur nach einigen Varianten
des Repertoires suchen. Beispiel: Ein Repertoire habe zwei Hauptgruppen
auf der obersten Ebene, eine fr 1.e4 und eine fr 1.d4. Wenn Sie nur
an den e4-Varianten interessiert sind, klappen Sie einfach die Gruppe
1.d4 zu und suchen dann nur nach den ausgegebenen Varianten.
</p>

<h3>Weitere Hinweise</h3>
<p>
Eine Repertoire-Datei eignet sich sehr gut zum Finden neuer Partien in
Ihrem Erffnungssystem. Beispiel: Jedesmal, wenn Sie eine PGN-Datei
erhalten und sie Ihrer Haupt-Datenbank hinzufgen (wie etwa
die ausgezeichneten wchentlichen PGN-Dateien von
<url http://www.chesscenter.com/twic/>The Week In Chess</url>),
ffnen Sie einfach die PGN-Datei in Scid und fhren eine Repertoire-Suche
durch. Dann knnen Sie die gefilterten Partien betrachten und haben
alle Partien, die in Ihrem Repertoire enthalten sind.
</p>
<p>
Sie sollten vielleicht zwei Repertoire-Dateien anlegen: eine fr Schwarz
und eine fr Wei, so da Sie mit jeder Datei getrennt suchen knnen.
</p>
<p>
Eine Repertoire-Datei kann von der Kommanozeile aus geffnet werden,
zum Beispiel:<br>
<b>scid datenbank weiss.sor</b>
</p>
<p>
Sie knnen eine Repertoire-Datei (.sor) mit jedem Editor bearbeiten,
aber passen Sie auf, da Sie nicht ihr Format verndern, sonst kann
sie von Scid nicht geladen oder gesucht werden.
</p>

<p><footer>(Aktualisiert: Scid 2.6, August 2001)</footer></p>
}


##################################
### Tournament Finder window help:

set helpTitle(D,Tmt) "Turniersuche"
set helpText(D,Tmt) {<h1>Die Turniersuche</h1>
<p>
Die <term>Turniersuche</term> ermglicht es, Turniere in der
aktuellen Datenbank zu finden. Es wird angenommen, da
zwei Partien zum selben Turnier gehren, wenn sie denselben Turnier-
und Ortseintrag haben und innerhalb von drei Monaten gespielt wurden.
</p>
<p>
Sie knnen die Liste der Turniere durch die Anzahl der Spieler und
Partien, das Datum, die durchschnittliche Elo-Zahl und das Land
einschrnken, wenn Sie die Felder unterhalb der Turnierliste ausfllen
und dann auf <b>Aktualisieren</b> klicken.
</p>
<p>
Die ausgegebene Liste kann nach Datum, Spielerzahl, Partienzahl,
durchschnittliche Elo-Zahl, Ort, Turnier oder Nachname des Gewinners
sortiert werden. Whlen Sie die Kategorie im
<menu>Sortieren</menu>-Men oder klicken Sie auf die Spaltenberschrift,
um das Sortierkriterium zu ndern.
</p>
<p>
Um die erste Partie eines der aufgefhrten Turniere zu laden, klicken
Sie einfach mit der linken Maustaste, wenn die entsprechende Zeile
hervorgehoben ist. Damit wird auch das
<a Crosstable>Turniertabellen</a>-Fenster aktualisiert, falls es geffnet
ist.
Wenn Sie statt dessen die rechte Maustaste drcken, wird die Partie
geladen und das Turniertabellen-Fenster geffnet, auch wenn es vorher
geschlossen war.
</p>
<p>
Es ist eine gute Idee, zur Beschleunigung des Suchprozesses den
Datenbereich angemessen einzuschrnken (z.B. hchstens einige Jahre)
oder ein einzelnes Land auszuwhlen (mit dem 3stelligen
Standard-Lndercode). Damit wird die Zahl der Partien, die Scid bei
der Konstruktion von Turnieren aus den Partien bercksichtigen mu,
auerordentlich verringert.
</p>

<p><footer>(Aktualisiert: Scid 4.7, September 2018)</footer></p>
}


####################
### Tree window help:

set helpTitle(D,Tree) "Zugbaum"
set helpText(D,Tree) {<h1>Das Zugbaumfenster</h1>
<p>
Das <term>Zugbaum</term>-Fenster liefert Informationen ber alle Zge,
die in der aktuellen Position in den Datenbankpartien gespielt wurden.
Im Zugbaum-Modus wird das Fenster automatisch aktualisiert, sowie sich
die Stellung im Hauptfenster ndert. Fr groe Datenbanken ist das
evtl. etwas langsam.
</p>
<p>
Jedesmal, wenn das Zugbaumfenster aktualisiert wird, wird der
<a Searches Filter>Filter</a> zurckgesetzt, und nur die Partien, die
die die aktuelle Position enthalten, sind erfat.
</p>
<p>
Ein Klick mit der linken Maustaste auf einen Zug im Zugbaumfenster
fgt diesen Zug der Partie hinzu.
</p>

<h3>Inhalt des Zugbaumfensters</h3>
<p>
Das Zugbaumfenster zeigt den <a ECO>ECO-Code</a> (falls vorhanden),
die Hufigkeit (als Anzahl der Partien und in Prozent) und die
Punkte jedes Zuges an. Die <term>Punkte</term> werden immer aus
der Sicht von <b>Wei</b> berechnet, 100% bedeutet also, alle
Weispieler gewinnen, und 0% heit nur Schwarzsiege.
</p>
<p>
Die Zge im Zugbaumfenster knnen nach Zgen (alphabetisch), ECO-Code,
Hufigkeit oder Punkten sortiert werden. Sie knnen die Sortiermethode
im Men <menu>Sortieren</menu> ndern.
</p>

<h3><name Best>Das Fenster "Beste Partien"</name></h3>
<p>
Das Zugbaumfenster besitzt ein Dateimen-Kommando und einen Schalter,
um das Fenster <term>Beste Partien</term> zu ffnen, welches eine Liste
der am hchsten bewerteten Partien des aktuell gezeigten Astes ausgibt.
Die Partien sind nach durchschnittlicher Elo-Zahl sortiert, und Sie
knnen die Liste auf Partien mit einem bestimmten Ergebnis beschrnken.
</p>

<h3><name Graph>Zugbaumgrafik</name></h3>
<p>
Das Zugbaumfenster enthlt einen mit <term>Grafik</term> bezeichneten
Schalter, der eine grafische Darstellung der relativen Erfolgsrate
jedes Zuges in der aktuellen Stellung liefert.
Alle Zge, die in mindestens 1% der Partien und mindestens 5mal
gespielt wurden, werden dargestellt.
Die prozentualen Ergebnisse werden immer aus der Perspektive von
Wei gesehen, auch wenn Schwarz am Zug ist.
</p>
<p>
In der Zugbaumgrafik ist eine rote Linie eingezeichnet, die den
Durchschnitt aller Partien in der aktuellen Position anzeigt, und der
Bereich zwischen 50 und 55% (wo der Erwartungswert der meisten
Standarderffnungen liegt) ist blau gefrbt. In Meisterpartien erreicht
Wei blicherweise etwa 55%.
</p>

<h3><name Lock>Das Zugbaumfenster anbinden</name></h3>
<p>
Jedes Zugbaumfenster ist mit einer geladenen Datenbank verbunden, so
dass, sollten mehre Datenbanken geffnet sein, auch mehrere
Zugbaumfenster parallel existieren knnen, je eines fr jede
Datenbank.
Mit dem Schalter <term>Anbinden</term> im Zugbaumfenster kann man nun
erreichen, dass eine Datenbank automatisch geschlossen wird, sobald
das zugehrige Zugbaumfenster geschlossen wird. Weiterhin werden dann
auch alle anderen, mit dem Zugbaumfenster verbundenen Fenster "Beste
Partien" oder eine Zugbaumgrafik automatisch mit geschlossen.
</p>

<h3><name Training>Training</name></h3>
<p>
Wenn der <term>Trainings</term>-Schalter im Zugbaumfenster aktiviert
ist, wird Scid jedesmal, wenn Sie einen Zug in der Partie ausfhren,
einen zufllig ausgewhlten Zug erwidern. Der Zug, den Scid auswhlt,
hngt von der Datenbankstatistik ab, d.h. ein Zug, der in 80% der
Datenbankpartien gespielt wurde, wird von Scid mit 80%iger
Wahrscheinlichkeit ausgewhlt. Diese Funktion einschalten und dann das
Zugbaumfenster verstecken (oder minimieren) und Erffnungen gegen eine
groe Datenbank spielen ist eine ausgezeichnete Methode, Ihre Kenntnisse
Ihres Erffnungsrepertoires zu testen.
</p>

<h3>Den Zugbaum in geffneten EPD-Dateien verwenden</h3>
<p>
Fr jede geffnete <a EPD>EPD-Datei</a> enthlt das Zugbaumfenster
eine weitere Spalte, die fr jede Position, die mit den angegebenen
Zgen erreicht wird, eine kurze (fnf Zeichen) Zusammenfassung des
Dateiinhalts anzeigt.
</p>
<p>
Die Zusammenfassung knnte eine Bewertung, ein Erffnungscode oder ein
Zugvorschlag sein; sie wird der Inhalt des ersten gefundenen EPD-Feldes
aus der folgenden Liste sein: <b>ce, eco, nic, pv, pm, bm, id</b>, oder
einfach des ersten EPD-Feldes, falls keines der obigen vorhanden ist.
</p>
<p>
Fr eine Beschreibung der EPD-Felder siehe die Hilfeseite
<a EPD>EPD-Dateien</a>. Wenn die Zusammenfassung das <b>ce</b>-Feld
ist, wird sie zur besseren Lesbarkeit als Bewertung in Bauern aus der
Sicht von Wei angezeigt (anstatt als Bewertung in Hundertstel Bauern
aus der Sicht der am Zug befindlichen Seite, wie sie in der EPD-Datei
gespeichert ist).
</p>

<h3>Masken zur Konfiguration der Darstellung</h3>
<p>
Benutzerdefinierte Maskendateien (.stm) knnen angelegt werden, um die
Anzeige der Statistik im Zugabaumfenster zu erweitern. Hiermit knnen
einerseits farbige Symbole, NAG-Codes oder Kommentare fr eine
bestimmte Stellung hinzugefgt werden, um beispielsweise kritische
Positionen zu markieren.
</p>
<p>
Um Markierungen anzulegen bewegt man sich zunchst in einer
bestehenden Partie zur entsprechenden Position und klickt dann mit der
Maus die entsprechene Variante mit der rechten Taste an. Sodann knnen
aus dem sich ffnenden Kontextmenue entsprechende Markierungen
ausgewhlt oder Kommentare eingegeben werden. Nach dem Hinzufgen
entsprechender Annotationen mu die Maske mit dem Punkt
<term>Speichern</term> gesichert werden.
</p>
<p>
Masken knnen auch aus bestehenden Partien, welche Kommentare und
Varianten enthalten gefllt werden. Hierzu dient der Punkt <term>Mit
aktueller Partie fllen</term> bzw. <term>Mit Datenbank Fllen</term>
</p>

<h3>Schnellere Ergebnisse durch Zwischenspeichern</h3>
<p>
Scid nutzt fr die am hufigsten vorkommenden Positionen einen
Cachespeicher fr die Ergebnisse der Zugbaumsuche. Wenn Sie sich im
Zugbaum-Modus in einer Partie vorwrts und rckwrts bewegen, werden
Sie bemerken, da das Zugbaumfenster praktisch sofort aktualisiert
wird, wenn die gesuchte Stellung im Cachespeicher ist.
</p>
<p>
Das Zugbaumfenster hat ein Dateimen-Kommando <term>Cache-Datei
sichern</term>. Wenn Sie das auswhlen, wird der aktuelle Inhalt des
Zugbaum-Zwischenspeichers in eine Datei geschrieben (mit der Endung
<b>.stc</b>), um sptere Anwendungen des Zugbaum-Modus mit dieser
Datenbank zu beschleunigen.
</p>
<p>
Die Option <term>Cache-Datei fllen</term> im Dateimen des
Zugbaumfensters fllt die Cache-Datei mit Daten fr viele
Erffnungspositionen. Es werden etwa 100 der hufigsten
Erffnungsstellungen gesucht, dann wird die Cache-Datei geschrieben.
</p>
<p>
Das neue aufbauen des Zugbaumfensters kann erheblich beschleunigt
werden, wenn eine Datenbank nach ECO-Codes sortiert abgespeichert
wird. (Zum sortieren von Datenbanken siehe das <a
Maintenance>Wartungsfenster</a>.) Dieses Sortieren kann allerdings
viele Stunden in Anspruch nehmen. Danach kann durch einschalten der
Option <term>Schneller Modus</term> die Suche um bis zu einen Faktor
20 beschleunigt werden, wobei allerdings kleinere Ungenauigkeiten in
Kauf genommen werden mssen. Um eine schnelle Voranzeige der Statistik
zu erreichen aber trotzdem ein genaues ergenbis zu erziehlen dient die
Option <term>Schneller und Grndlicher Modus</term>
</p>
<p>
Beachten Sie, da eine Zugbaum-Cache-Datei (.stc) vllig redundant ist;
Sie knnen sie ohne Auswirkungen auf die Datenbank lschen, und
tatschlich wird sie jedesmal von Scid gelscht, wenn sie nach
irgendeiner Aktion veraltet sein knnte -- zum Beispiel nach Hinzufgen
oder Ersetzen einer Partie, oder nach Sortieren der Datenbank.
</p>

<p><footer>(Aktualisiert: Scid 3.6.26, Oktober 2008)</footer></p>
}


################
### Graphs help:

set helpTitle(D,Graphs) "Grafikfenster"
set helpText(D,Graphs) {<h1>Grafikfenster</h1>
<p>
Scid hat einige Fenster, die Informationen grafisch darstellen.
Diese werden im nachfolgenden erklrt.
</p>

<h3><name Filter>Relative und absolute Filtergrafik</name></h3>
<p>
Das Fenster <term>relative Filtergrafik</term> zeigt Entwicklungen nach Datum
oder Elo-Zahl fr die aktuellen Filterpartien im Vergleich zur gesamten
Datenbank. Das ist beispielsweise im <a Tree>Zugbaum</a>-Fenster eine
ntzliche Hilfe um zu zeigen, wie sich die Popularitt der aktuellen
Erffnungsposition in den letzten Jahren oder Jahrzehnten gendert hat
oder ob sie bei hochrangigen Spielern, etwa bei Gromeistern, besonders
beliebt ist. Jeder Punkt in der Grafik reprsentiert fr ein bestimmtes
Datum oder einen bestimmten Elo-Bereich die Anzahl der Partien im Filter
pro 1000 Partien der gesamten Datenbank.
<br><br>
Neben der relative Filtergrafik gibt es eine <term>absolute Filtergrafik</term>, die die
Partien im Filter nach der absoluten Anzahl der Partien darstellt. Es kann nach
Jahr, Elo-Zahl und Zugzahl der Partie ausgewertet werden.<br>
Mit dem kleinen Grafik-Knopf kann ein Dialog geffnet werden. Hier kann fr jede der drei
Auswertungen der Bereich (von, bis) und die Intervallgre der X-Achse
eingestellt werden. Wird "Schtzen" ausgewhlt, so wird der ELO-Wert
geschtzt (s.u.), ansonst wird ein fehlender ELO-Wert eines Spielers
mit 0 bewertet. "Schtzen aus" entspricht dabei der
min. Elo-Auswertung im Statistik-Fenster. Die Decaden sind fest eingestellt, bitte hier die Jahres-Option benutzen.
Mit dem "Aktualisieren"-Knopf kann man sofort eine neue Auswertung erstellen, ohne den Dialog verlassen zu mssen.
<br>
Bitte beachten: Bei kleinen Intervallen und groem Bereich, kann die Auswertung etwas lnger dauern und die bersichtlichkeit geht verloren.
</p>
<p>

Wenn die Filtergrafik nach Elo-Zahl ausgegeben wird, verwendet Scid
fr jede Partie die durchschnittliche (mittlere) Wertung. Geschtzte
Elo-Zahlen (wie z.B. aus der Schreibkorrekturdatei) werden nicht verwendet.
Falls in einer Partie nur einer der beiden Spieler eine Elo-Zahl hat,
wird angenommen, da der Gegner die gleiche Elo-Zahl besitzt bis zu
einer Hchstgrenze von 2200. Wenn also beispielsweise ein Spieler eine
Elo-Zahl von 2500 hat und sein Gegner keine Elo-Zahl, ist die mittlere
Wertungszahl (2500+2200)/2 = 2350.
</p>

<h3><name Rating>ELO-Zahl-Verlauf</name></h3>
<p>
Das Fenster <term>ELO-Zahl-Verlauf</term> zeigt die Entwicklung der
Elo-Zahl(en) eines Spieler oder beider Spieler der aktuellen Partie.
Sie knnen den Graphen fr einen einzelnen Spieler mit dem Schalter
<term>ELO-Zahl-Verlauf</term> im Fenster <a PInfo>Spielerinformation</a>
erzeugen oder fr beide Spieler der aktuellen Partie, indem Sie
<term>ELO-Zahl-Verlauf</term> im <menu>Werkzeuge</menu>-Men auswhlen.
</p>

<h3><name Score>Partiebewertung</name></h3>
<p>
Das Fenster <term>Partiebewertung</term> zeigt die numerische
Bewertung (Stand) der aktuellen Partie, wie sie in den Kommentaren
gespeichert ist, als Grafik an.
Sie knnen mit der linken Maustaste irgendwo auf den Graphen klicken,
um zu der korrespondierenden Partiestellung zu gelangen.
</p>
  <p>
  Es werden zwei Arten von Bewertungskommentaren erkannt: 
  <ul>
  Alle Kommentare, die eine Vorzeichen behaftete Zahl enthalten, z.B. 
  <li><b>+1.23, -0.23</b></li>. Gibt es mehrere Zahlen im Kommentar wird nur die erste verwendet.
  </ul>
  <ul>
  Tags mit dem Namen [%eval .. ]
  <li><b>[%eval -6.64/23]</b></li>
  </ul>
  </p>
  <p>
    Einige Partien werden nur aus der Perspektive der Weien angezeigt. Sie knnen die Punktzahl fr Wei oder Schwarz invertieren.
    Um dies zu korrigieren knnen Sie im Optionsmen die zu intertierende Seite auswhlen: <b>Wei</b> und/oder <b>Schwarz</b>.
  </p>
  <p>
    In einem <term>Zeitdiagramm</term> kann die Zeit fr den Zeitverbrauch pro Zug oder die verbleibende Zeit auf der Uhr kann ebenfalls dargestellt werden. Fr die Auswertung der Zeit mssen im Kommentar die Tags [%clk 0:01:19] und [%emt 0:00:19] enthalten sein.
    Die Werte werden immer in Minuten angezeigt.
    ber das Men knnen Sie auswhlen, welche Kombination der Diagramme angezeigt werden soll:
    <li><b>Beide:</b> Die Partiebewertung und die Zeit werden angezeigt.
    <li><b>Zeit:</b> Nur die Zeit wird angezeigt ("Beide" muss abgewhlt werden!)</li>
    <li><b>Summe:</b> In der Zeitanzeige wird die Summe der verbrauchten Zeit angezeigt, wenn die Zeit als [%emt 00:12] zur Verfgung steht.
  </p>
<h3><name Tree>Zugbaumgrafik</name></h3>
<p>
Das Fenster <term>Zugbaumgrafik</term> ist aus dem Zugbaumfenster
zu erreichen. Es zeigt die Erfolgsrate der hufigsten Zge in der
aktuellen Position. Weitere Informationen finden Sie auf der
<a Tree Graph>Zugbaum</a>-Hilfeseite.
</p>

<p><footer>(Aktualisiert: Scid 4.7, Juni 2018)</footer></p>
}


####################
### Tablebases help:

set helpTitle(D,TB) "Endspieltabellen"
set helpText(D,TB) {<h1>Endspieltabellen</h1>

<p>
Eine <term>Endspieltabelle</term> ist eine Datei, die die vollstndige
Ergebnisinformation ber alle Positionen einer bestimmten
Materialkonstellation enthlt, wie z.B. Knig und Turm gegen Knig und
Bauer. Es gibt Endspieltabellen fr alle Materialkonstellation mit bis
zu 5 Steinen (inkl. Knige), und einige einfache 6-Steine-Tabellen
sind ebenfalls verfgbar.
</p>
<p>
Scid kann Endspieltabellen im Nalimov-Format verwenden, die von vielen
modernen Schachprogrammen genutzt werden. Sie haben oftmals die
Dateiendung <b>.nbw.emd</b>  oder <b>.nbb.emd</b>.
</p>

<h3>Endspieltabellen in Scid verwenden</h3>
<p>
Um die Endspieltabellendateien in Scid zu verwenden, bestimmen Sie
einfach ihre Verzeichnisse mit <b>Endspieltabellen-Verzeichnis...</b>
im <menu>Optionen</menu>-Men. Sie knnen bis zu 4 Verzeichnisse
angeben, wo Ihre Endspieltabellendateien gespeichert sind. Mit dem
Schalter <b>...</b> rechts nebem dem Datei-Eingabefeld knnen Sie
eine Datei suchen, deren Verzeichnis verwendet werden soll.
</p>
<p>
Wenn eine in der Endspieltabelle gefundene Stellung erreicht wurde, zeigt
der Informationsbereich (unterhalb des Schachbretts)
Endspieltabellen-Informationen an. Sie knnen den Umfang der angezeigten
Information konfigurieren, indem Sie mit der rechten Maustaste diesen
Bereich anklicken oder im <menu>Optionen</menu>-Men den Menpunkt
<b>Partieinformation</b> whlen. Die Option "Ergebnis und bester Zug"
liefert die ntzlichste Information, ist aber oftmals sehr viel
langsamer als die Option "nur Ergebnis".
</p>

<h3>Das Endspieltabellenfenster</h3>
<p>
Sie knnen sogar noch mehr Endspieltabellen-Informationen zur aktuellen
Position erhalten, indem Sie das <term>Endspieltabellenfenster</term>
ffnen (<menu>Fenster</menu>-Men, Tastenkombination Strg+Umschalt+[=]).
Dieses Fenster zeigt das Ergebnis jedes zulssigen Zuges in der aktuellen
Stellung bei perfektem Spiel.
</p>
<p>
Das Fenster enthlt zwei Bereiche. Der bersichtsbereich (links) zeigt
die Endspieltabellen, die Scid auf Ihrem Rechner gefunden hat, mit einer
Inhaltsangabe jeder Tabelle. Der Ergebnisbereich (rechts) zeigt die
optimalen Ergebnisse aller Zge in der aktuellen, im Haupfenster
dargestellten Position.
</p>

<h4>Der bersichtsbereich</h4>
<p>
Im oberen Teil des bersichtsbereichs knnen Sie eine bestimmte
Endspieltabelle auswhlen. Die verfgbaren Tabellen werden blau
angezeigt, die brigen grau, aber Sie knnen jede Tabelle auswhlen.
Der untere Teil des bersichtsbereichs zeigt eine Inhaltsangabe
der Informationen der ausgewhlten Endspieltabelle. (Noch haben nicht
alle Endspieltabellen einen entsprechenden Datensatz in Scid.)
</p>
<p>
Diese Inhaltsangabe enthlt die Hufigkeit (wie viele Partien von
einer Million haben eine Stellung mit diesem Material erreicht,
errechnet anhand einer Datenbank mit ber 600.000 Meisterpartien),
das spteste Matt einer Seite sowie Anzahl wechselseitiger ("umgekehrter")
Zugzwangpositionen. Eine wechselseitige Zugzwangposition liegt dann vor,
wenn Wei am Zug zum Remis fhrt und Schwarz am Zug verliert, wenn
Wei am Zug verliert und Schwarz am Zug Remis ergibt oder wenn derjenige
am Zug verliert.
</p>
<p>
Bei einigen Tabellen mit wechselseitigem Zugzwang enthlt die bersicht
eine Liste aller Zugzwangpositionen oder eine Auswahl davon. Eine
vollstndige Liste fr jede Endspieltabelle ist nicht machbar, da einige
Tabellen tausende von Zugzwangstellungen enthalten.
</p>
<p>
Mit dem Schalter <b>Random</b> knnen Sie eine zufllige Position aus
der ausgewhlten Endspieltabelle aufbauen.
</p>

<h4>Der Ergebnisbereich</h4>
<p>
Der Ergebnisbereich wird immer dann aktualisiert, wenn sich die
Brettstellung im Hauptfenster ndert. Die erste Zeile zeigt an, wie viele
Zge gewinnen (+), zum Remis fhren (=), verlieren (-) oder ein nicht
bekanntes Ergebnis (?) haben. Der brige Teil liefert Ihnen eine
detailliertere Ergebnisliste, mit der Reihenfolge krzeste bis lngste
Matts, danach Remis, dann lngste bis krzeste Verluste. Lnge jeweils
bis zum Matt.
</p>

<h4>Das Ergebnisbrett</h4>
<p>
In einer Endspieltabellenstellung ist es oft ntzlich zu wissen,
wie die Ergebnisse ausshen, wenn alle Steine in ihrer gegenwrtigen
blieben, aber ein bestimmter Stein woanders stnde. Zum Beispiel
wenn Sie feststellen mchten, wie nah ein Knig einem Freibauern sein
mu, um eine bestimmte Stellung zu gewinnen oder Remis zu machen.
In Endspielbchern wird diese Information oft die <i>Gewinnzone</i>
bzw. <i>Remiszone</i> eines Steins in einer bestimmten Stellung
genannt.
</p>
<p>
Mit Hilfe von Scid knnen Sie diese Information erhalten, wenn Sie
den Schalter mit dem Schachbrett anklicken, um das
<term>Ergebnisbrett</term> im Endspieltabellenfenster zu zeigen.
Wenn Sie mit der linken Maustaste irgendeinen Stein auf dem Brett
anklicken, erscheint auf jedem freien Feld ein Symbol mit dem Resultat
der Endspieltabelle, wenn der Stein auf diesem Feld stnde (mit derselben
Seite am Zug wie in der aktuellen Position des Hauptfensters).
</p>
<p>
Ein Feld kann fnf mgliche Symbole haben:
ein weies "<b>#</b>" bedeutet, Wei gewinnt;
ein schwarzes "<b>#</b>" bedeutet, Schwarz gewinnt;
ein blaues "<b>=</b>" bedeutet, die Stellung ist remis;
ein rotes "<b>X</b>" bedeutet, die Position ist illegal (weil die Knige
nebeneinander stehen oder die Seite am Zug Schach bietet); und
ein rotes "<b>?</b>" heit, das Result ist unbekannt, weil die ntige
Endspieltabellendatei nicht zur Verfgung steht.
</p>

<h3>Endspieltabellen-Quellen</h3>
<p>
Zur Hilfe beim Auffinden von Endspieltabellendateien im Internet
siehe die entsprechenden <a Author Related>Links</a>.
</p>

<p><footer>(Aktualisiert: Scid 3.4, September 2002)</footer></p>
}


###################
### Bookmarks help:

set helpTitle(D,Bookmarks) "Lesezeichen"
set helpText(D,Bookmarks) {<h1>Lesezeichen</h1>
<p>
Scid erlaubt Ihnen, wichtige Partien fr einen leichten spteren Zugriff
mit <term>Lesezeichen</term> zu markieren. Das Lesezeichen-Men ist aus
dem <menu>Datei</menu>-Men, der Werkzeugleiste oder mit der
Tastenkombination <B>Strg+B</b> zu erreichen.
</p>
<p>
Wenn Sie eine markierte Partie aus dem Lesezeichen-Men whlen, ffnet
Scid falls ntig die Datenbank, findet die Partie und geht zu der
Partiestellung, die mit dem Lesezeichen versehen wurde.
</p>
<p>
Nur Partien in Datenbanken im Scid-Format (keine PGN-Datei, nicht die
Ablage-Datenbank) knnen mit einem Lesezeichen markiert werden.
</p>
<p>
Wenn die Datenbank einer markierten Partie sortiert oder komprimiert
wurde, sind die Lesezeichendaten mglicherweise veraltet. Falls das
passiert, durchsucht Scid die Datenbank nach der passendsten Partie
(vergleicht Spielernamen, Ort etc.), wenn das Lesezeichen ausgewhlt
wird, die markierte Datei sollte also immer noch geladen werden. Wenn
sich allerdings Daten der markierten Partie ndern, ist es mglich,
da eine andere Partie besser auf die Lesezeichendaten pat und statt
dessen geladen wird. Es ist also eine gute Idee, eine Partie erneut zu
markieren, wenn Sie ihre Spieler-, Orts-, Ergebnis-, Runden- oder
Jahresdaten bearbeiten.
</p>

<h3>Lesezeichen bearbeiten</h3>
<p>
Mit dem Lesezeichen-Editor knnen Sie den fr jede markierte Partie
ausgegebenen Mentext ndern und Verzeichnisse erstellen, um die
Lesezeichen zu kategorisieren.
</p>

<h3>Hinweise</h3>
<p>
Sie knnen Lesezeichen zum schnellen Zugriff auf Datenbanken verwenden,
die Sie oft benutzen, indem Sie eine Partie jeder Datenbank markieren.
Eine weitere gute Verwendungsmglichkeit fr Lesezeichen ist es,
wichtige Partien hinzuzufgen, die Sie beim Studieren einer bestimmten
Schacherffnung finden.
</p>
<p>
Das Lesezeichen-Men enthlt einen Eintrag zur Kontrolle der
Verzeichnisdarstellung: sie knnen als Untermens angezeigt werden
(ntzlich bei sehr vielen Lesezeichen) oder als einzelne Liste.
</p>

<p><footer>(Aktualisiert: Scid 3.0, November 2001)</footer></p>
}


##############################
### Command-line options help:

set helpTitle(D,Cmdline) "Kommandozeilen-Optionen"
set helpText(D,Cmdline) {<h1>Kommandozeilen-Optionen</h1>
<p>
Wenn Sie Scid von der Shell oder Konsole starten, knnen Sie
Kommandozeilen-Optionen spezifizieren. Datenbanken im Scid-Format (mit
oder ohne Dateiendung wie z.B. ".si3") und PGN-Dateien, die geffnet
werden sollen, knnen angegeben werden. Beispiel:
<ul>
<li> <b> scid datenbank partien.pgn</b></li>
</ul>
startet Scid und und ffnet die Scid-Datenbank "datenbank" und die
PGN-Datei "partien.pgn".
</p>
<p>
Auerdem gibt es optionale Argumente, die kontrollieren, welche Dateien
Scid suchen und beim Start verwenden soll. Sie knnen die Benutzung
von <a TB>Endspieltabellen</a>  mit der Option <b>-xtb</b> (oder
<b>-xt</b>) ausschalten, das Laden der Datei zur
<a ECO>ECO-Erffnungsklassifikation</a> mit <b>-xeco</b> oder
<b>-xe</b> verhindern und mit <b>-xspell</b> oder <b>-xs</b> vermeiden,
da die Datei zur <a Maintenance Spellcheck>Schreibkorrektur</a>
geladen wird. Die Option <b>-fast</b> oder <b>-f</b> bewirkt das in
einem, d.h. <b>scid -f</b> ist quivalent zu
<b>scid -xeco -xspell -xtb</b>.
</p>

<p><footer>(Aktualisiert: Scid 3.1, November 2001)</footer></p>
}


####################
### Compaction help:

set helpTitle(D,Compact) "Datenbank komprimieren"
set helpText(D,Compact) {<h1>Datenbank komprimieren</h1>
<p>
Datenbank-<term>Komprimierung</term> ist ein besonderer Teil der
<a Maintenance>Wartung</a>, der die Datenbank so klein und effizient
wie mglich hlt.
Eine Datenbank komprimieren heit, jeden ungenutzten Bereich in ihren
Dateien zu lschen.
Es gibt zwei Arten: Namens- und Partiendatenbank-Komprimierung.
</p>

<h3>Namendatenbank-Komprimierung</h3>
<p>
Nach einer gewissen Zeit werden Sie evtl. feststellen, da die Datenbank
eine Reihe von Spieler-, Turnier- oder Rundennamen enthlt, die in keiner
Partie mehr verwendet werden. Das wird regelmig nach Namenskorrekturen
der Fall sein. Die unbenutzten Namen verschwenden Speicherplatz in der
Namendatei und knnen die Suche nach Namen verlangsamen.
Namendatenbank-Komprimierung lscht alle Namen, die nicht in irgendeiner
Partie verwendet werden.
</p>

<h3>Partiendatenbank-Komprimierung</h3>
<p>
Immer, wenn eine Partie ersetzt oder gelscht wird, verbleibt
ungenutzter Platz in der Partiendatei (die grte der drei Dateien
einer Scid-Datenbank). Partiendatenbank-Komprimierung lscht jeden
ungenutzten Speicher, keine gelschte Datei bleibt in der Datenbank.
Beachten Sie, da diese Operation unumkehrbar ist: nach der
Komprimierung sind die gelschten Dateien fr immer verschwunden!
</p>
<p>
Partiendatenbank-Komprimierung ist auch empfehlenswert nach dem
<a Sorting>Sortieren</a> einer Datenbank, um die Reihenfolge
innerhalb der Partiendatei mit der sortierten Indexdatei synchron
zu halten.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


####################################
### Database maintenance tools help:

set helpTitle(D,Maintenance) "Datenbank-Wartung"
set helpText(D,Maintenance) {<h1>Datenbank-Wartung</h1>
<p>
Scid stellt einige Funktionen zur Datenbank-Wartung zur Verfgung,
die aus dem <a Menus File>Datei</a>-Men zu erreichen sind. Die
Datenbank-<a Compact>Komprimierung</a> und -<a Sorting>Sortierung</a>
werden in separaten Hilfeseiten erklrt.
</p>

<h3>Das Wartungsfenster</h3>
<p>
Die meisten Datenbank-Wartungsarbeiten in Scid knnen aus dem
Wartungsfenster erledigt werden, welches man mit dem Men
<menu>Datei: Wartungsfenster</menu> oder <menu>Fenster</menu>
oder der Tastenkombination <b>Strg+M</b> ffnen kann.
</p>
<p>
Sie knnen in diesem Fenster <a Flags>Partie-Kennzeichen</a>
bearbeiten, Schreibkorrekturen durchfhren, eine Datenbank
<a Compact>komprimieren</a> oder <a Sorting>sortieren</a>.
Alle Operationen, die fr die aktuelle Datenbank nicht zur Verfgung
stehen (z.B., weil sie schreibgeschtzt oder eine PGN-Datei ist),
werden durch graue Schrift angezeigt.
</p>

<h3><name Twins>Dubletten lschen</name></h3>
<p>
Das Men <menu>Datei: Wartung</menu> hat ein Kommando <menu>Dubletten
lschen...</menu>, um Kopien von Partien (Dubletten) in der Datenbank
zu entdecken. Dieses Kommando findet alle Paare von doppelten Partien
und markiert die krzere Partie als gelscht, whrend die lngere Partie
erhalten bleibt. Zwei Partien werden als gleich angesehen, wenn ihre
Spieler (und alle anderen optionalen Partieeintrge) exakt bereinstimmen.
</p>
<p>
Wenn Sie die Option "gleiche Zge" angeben, mssen zwei Partien die
gleichen Partiezge bis zur Lnge der krzeren Partie haben (oder bis
zum 60. Zug, je nachdem, was zuerst eintritt), um Dubletten zu sein.
</p>
<p>
Wenn Sie Dubletten gelscht haben, ist es eine gute Idee zu berprfen,
ob jede gelschte Partie tatschlich Kopie einer anderen Partie ist.
Das knnen Sie ganz einfach machen, wenn Sie die Option "<b>Filter auf
Dubletten setzen</b>" im Dialogfenster "Dubletten lschen" gewhlt
haben. Der Filter wird dann alle gelschten Partien enthalten. Sie knnen
sie mit dem <term>Dublettenprfer</term> (erreichbar aus dem
Wartungsmen oder mit der Tastenkombination <b>Strg+Umsch+T</b>)
betrachten (blttern mit den Tasten <b>p</b> und <b>n</b>), um zu
verifizieren, da jede Partie deshalb gelscht wurde, weil sie
tatschlich die Dublette einer anderen Partie ist.
</p>

<h3><name Editing>Spieler, Turniere, Orte und Runden editieren</name></h3>
<p>
Sie haben vielleicht falsch geschriebene Namen in Iher Datenbank und
wollen sie korrigieren. Sie knnen das in Scid mit dem
<term>Namenseditor</term> (Tastenkombination: <b>Strg+Umsch+N</b>), den
Sie aus dem Untermen <menu>Datei: Wartung</menu> erreichen.
</p>
<p>
Jeder eindeutige Name ist nur einmal in der Namendatei gespeichert,
mit einer Namensnderung werden daher tatschlich alle Vorkommen
gendert.
</p>

<h3><name Spellcheck>Schreibkorrektur</name></h3>
<p>
Zu Scid gehrt eine <term>Schreibkorrektur</term>-Datei namens
<b>spelling.ssp</b>, um Namen von Spielern, Turnieren, Orten und Runden
zu korrigieren.
Scid versucht die Datei beim Programmstart zu laden; wenn Scid sie
nicht laden kann, knnen Sie sie aus dem <menu>Optionen</menu>-Men
laden.
</p>
<p>
Wenn die Korrekturdatei erst einmal geladen ist, knnen Sie sie mit
den Schreibkorrektur-Befehlen im Men <menu>Datei: Wartung</menu>  oder
aus dem Wartungsfenster auf eine Datenbank anwenden.
</p>
<p>
Wenn Sie fr eine Datenbank eine Schreibkorrektur durchfhren, erzeugt
Scid eine Liste mit Korrekturen, die Sie editieren knnen, bevor die
Korrekturen tatschlich ausgefhrt werden. Sie knnen also jede
nicht gewollte Korrektur lschen.
</p>
<p>
Schreibkorrekturen sind insbesondere ntzlich, um eine Datenbank zu
standardisieren, damit alle Vorkommen eines bestimmten Spielers gleich
geschrieben werden.
Beispielsweise wrden mit der Standarddatei die Namen"Kramnik,V.",
"Vladimir Kramnik" und "V. Kramnik" alle zu "Kramnik, Vladimir"
berichtigt.
</p>
<p>
Die Schreibkorrekturdatei hat einen weiteren Nutzen: wenn sie geladen
ist, werden ihre Spielerdaten genutzt, um die Fenster
<a PInfo>Spielerinformation</a> und <a Crosstable>Turniertabelle</a>
zu erweitern: Sie sehen dann die FIDE-Titel (<b>gm</b> = Internationaler
Gromeister, <b>im</b> = Internationaler Meister etc.) und
Lnderinformationen zu jedem Spieler, der in der Datei enthalten ist.
ber 6500 starke Spieler der Vergangenheit und Gegenwart sind in der
zu Scid gehrenden Datei <b>spelling.ssp</b> enthalten.
</p>

<h3><name Ratings>Elo-Zahlen zu den Partien hinzufgen</name></h3>
<p>
Der Schalter "Elo-Zahlen hinzufgen..." im Wartungsfenster veranlat
Scid, die aktuelle Datenbank nach Spielern, zu durchsuchen, die keine
Elo-Zahl haben, fr die die Schreibkorrekturdatei aber eine Elo-Zahl
des jeweiligen Spielers zum Zeitpunkt der Partie enthlt. Scid ergnzt
alle diese Elo-Zahlen automatisch. Das ist sehr ntzlich fr eine
Datenbank mit Meisterpartien, die nur wenige Elo-Angaben enthlt.
</p>
<p>
Die mit Scid gelieferte Datei "spelling.ssp" enthlt die fr diese
Funktion bentigten Elo-Zahlen nicht, aber eine grere Version von
ihr namens "ratings.ssp" steht auf der  <a Author>Scid-Website</a>
zur Verfgung.
</p>

<h3><name Cleaner>Der Bereiniger</name></h3>
<p>
Der <term>Bereiniger</term> von Scid (vom Wartungsfenster zu erreichen)
ist ein Werkzeug, um eine Reihe von Wartungsarbeiten fr eine Datenbank
in einem durchzufhren. Sie knnen whlen, welche Aufgaben Sie erledigen
wollen, und Scid fhrt sie fr die Datenbank aus, ohne weitere Eingaben
des Benutzers zu bentigen. Das ist besonders bei der Wartung sehr
groer Datenbanken hilfreich.
</p>

<h3>Partien automatisch laden</h3>
<p>
Der <term>Automatische Lader</term> ldt jedesmal, wenn Sie die
Datenbank ffnen, eine Partie automatisch. Um die Partie, die geladen
wird, zu ndern, whlen Sie den Schalter "Automatisch Partie Nr.
laden..." Wenn Sie jedesmal die letzte Partie der Datenbank geffnet
haben wollen (unabhngig von der Anzahl der Partien in der Datenbank),
whlen Sie einfach eine besonders groe Zahl wie 9999999.
</p>

<p><footer>(Aktualisiert: Scid 3.1, Dezember 2001)</footer></p>
}


##############
### ECO guide:

set helpTitle(D,ECO) "ECO-Fhrer"
set helpText(D,ECO) {<h1>ECO-Erffnungsklassifikation</h1>
<p>
Scid kann Schachpartien gem der <b>ECO</b>- (Enzyklopdie der
Schacherffnungen) -Erffnungsklassifikation einordnen. Ein
Standard-ECO-Code besteht aus einem Buchstaben (A..E) gefolgt von
zwei Ziffern, so da es 500 verschiedene Standard-ECO-Codes gibt.
</p>

<h3>Scids Erweiterung des ECO-Systems</h3>
<p>
Das ECO-System ist sehr limitiert und fr moderne Partien nicht
ausreichend: einige der 500 Codes sieht man praktisch berhaupt nicht
mehr, whrend einige andere sehr hufig vorkommen. Um diese Situation
zu verbessern, erlaubt Scid eine optionale Erweiterung der
ECO-Basiscodes: jeder Code kann um einen Buchstaben (a..z) erweitert
werden, wobei eine weitere Ergnzung (noch eine Ziffer, 1..4) mglich
ist, aber noch nicht in Scids Standard-ECO-Datei benutzt wird.
Ein erweiterter Scid-ECO-Code sieht also etwa aus wie "<b>A41e</b>"
oder "<b>E99b2</b>". Viele der in modernen Meisterpartien vorkommenden
blichen ECO-Codes haben eine in Scids ECO-Datei definierte
Erweiterung.
</p>

<h3><name Browser>Die ECO-Auswertung</name></h3>
<p>
Das Fenster <term>ECO-Auswertung</term> zeigt Ihnen die Positionen,
die zur Klassifizierung jedes ECO-Codes verwendet werden, sowie die
Hufigkeit und Erfolgsrate der ECO-Codes in der der aktuellen Datenbank.
</p>
<p>
Der obere Teil zeigt die Hufigkeit jedes ECO-Codes in der aktuellen
Datenbank. Die Balken in der Grafik haben drei Bereiche: der unterste
(hellste Farbe) steht fr die Anzahl der Weisiege, der mittlere fr
die Zahl der Remis und der oberste (dunkelste) fr die Anzahl der
Schwarzsiege. Damit knnen Sie auf einen Blick die Charakteristik einer
Erffnung erkennen: z.B., ob Wei sehr erfolgreich ist oder ob Remis
hufig vorkommen.
</p>
<p>
Um zu einem tieferen ECO-Niveau zu gehen, klicken Sie mit der linken
Maustaste auf einen Balken in der Grafik (oder tippen Sie den
korrespondierenden Buchstaben (bzw. Ziffer) ein). Um auf ein hheres
Niveau zurckzugehen, klicken Sie mit der rechten Maustaste irgendwo
auf die Grafik oder drcken Sie die linke Cursortaste (oder [Entf]
oder [Rck]).
</p>
<p>
Der untere Teil zeigt die Positionen, die ein bestimmter ECO-Code
enthlt, und zwar entsprechend der von Ihnen geladenen ECO-Datei.
</p>

<h3>Die ECO-Datei laden</h3>
<p>
Die zu Scid gehrende ECO-Datei heit <b>scid.eco</b>, und Scid
versucht sie beim Programmstart zu laden.
Falls Scid sie nicht findet, mssen Sie folgendes tun, um die
ECO-Klassifikation zu ermglichen:
<ul>
<li>(a) Mit dem Menpunkt <menu>Optionen: ECO-Datei laden</menu>
        whlen Sie die Datei <b>scid.eco</b>. </li>
<li>(b) Speichern Sie die Optionen (im <menu>Optionen</menu>-Men). </li>
</ul>
Nachdem Sie das getan haben, wird die ECO-Datei jedesmal geladen, wenn
Sie Scid starten.
</p>

<h3>Das ECO-Code-System</h3>
<p>
Die Basisstruktur des ECO-Systems ist folgende:
</p>
<p>
<b><blue><run ::windows::eco::Refresh A>A</run></blue></b>
    1.d4 Sf6 2...;  1.d4 ...;  1.c4;  1.Verschiedenes
<ul>
<li>  <b>A0</b>  1.<i>Verschiedenes</i>
      (<b>A02-A03</b> 1.f4: <i>Bird-Erffnung</i>,
      <b>A04-A09</b>  1.Sf3: <i>Reti, Knigsindischer Angriff</i>) </li>
<li>  <b>A1</b>  1.c4 ...: <i>Englisch</i> </li>
<li>  <b>A2</b>  1.c4 e5: <i>Englisch, Knigsbauer</i> </li>
<li>  <b>A3</b>  1.c4 c5: <i>Englisch, Symmetrisch</i> </li>
<li>  <b>A4</b>  1.d4 ...: <i>Damenbauer</i> </li>
<li>  <b>A5</b>  1.d4 Sf6 2.c4 ..: <i>Indische Verteidigung </i> </li>
<li>  <b>A6</b>  1.d4 Sf6 2.c4 c5 3.d5 e6: <i>Modernes Benoni </i> </li>
<li>  <b>A7</b>  A6 + 4.Sc3 exd5 5.cxd5 d6 6.e4 g6 7.Sf3 </li>
<li>  <b>A8</b>  1.d4 f5: <i>Hollndische Verteidigung</i> </li>
<li>  <b>A9</b>  1.d4 f5 2.c4 e6: <i>Hollndische Verteidigung</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh B>B</run></blue></b>   1.e4 c5;  1.e4 c6;  1.e4 d6;  1.e4 <i>Verschidenes</i>
<ul>
<li>  <b>B0</b>  1.e4 ...
      (<b>B02-B05</b>  1.e4 Sf6: <i>Aljechin-Verteidigung</i>;
      <b>B07-B09</b>  1.e4 d6: <i>Pirc</i>) </li>
<li>  <b>B1</b>  1.e4 c6: <i>Caro-Kann</i> </li>
<li>  <b>B2</b>  1.e4 c5: <i>Sizilianische Verteidigung</i> </li>
<li>  <b>B3</b>  1.e4 c5 2.Sf3 Nc6: <i>Sizilianisch</i> </li>
<li>  <b>B4</b>  1.e4 c5 2.Sf3 e6: <i>Sizilianisch</i> </li>
<li>  <b>B5</b>  1.e4 c5 2.Sf3 d6: <i>Sizilianisch</i> </li>
<li>  <b>B6</b>  B5 + 3.d4 cxd4 4.Sxd4 Sf6 5.Sc3 Sc6 </li>
<li>  <b>B7</b>  B5 + 4.Sxd4 Sf6 5.Sc3 g6: <i>Sizilianisch, Drachen</i> </li>
<li>  <b>B8</b>  B5 + 4.Sxd4 Sf6 5.Sc3 e6: <i>Sizilianisch, Scheveninger</i> </li>
<li>  <b>B9</b>  B5 + 4.Sxd4 Sf6 5.Sc3 a6: <i>Sizilianisch, Najdorf</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh C>C</run></blue></b>   1.e4 e5;  1.e4 e6
<ul>
<li>  <b>C0</b>  1.e4 e6: <i>Franzsische Verteidigung</i> </li>
<li>  <b>C1</b>  1.e4 e6 2.d4 d5 3.Sc3: <i>Franzsisch, Winawer/Klassisch</i> </li>
<li>  <b>C2</b>  1.e4 e5: <i>Offene Partie</i> </li>
<li>  <b>C3</b>  1.e4 e5 2.f4: <i>Knigsgambit</i> </li>
<li>  <b>C4</b>  1.e4 e5 2.Sf3: <i>Offene Partie</i> </li>
<li>  <b>C5</b>  1.e4 e5 2.Sf3 Sc6 3.Lc4: <i>Italienisch; Zweispringerspiel</i> </li>
<li>  <b>C6</b>  1.e4 e5 2.Sf3 Sc6 3.Lb5: <i>Spanische Partie</i> </li>
<li>  <b>C7</b>  1.e4 e5 2.Sf3 Sc6 3.Lb5 a6 4.La4: <i>Spanisch</i> </li>
<li>  <b>C8</b>  C7 + 4...Sf6 5.0-0: <i>Spanisch, Geschlossen und Offen</i>
      (<b>C80-C83</b>  5.0-0 Sxe4: <i>Spanisch, Offenes System</i>;
      <b>C84-C89</b>  5.0-0 Le7: <i>Spanisch, Geschlossenes System</i>) </li>
<li>  <b>C9</b>  C8 + 5...Le7 6.Te1 b5 7.Lb3 d6: <i>Spanisch, Geschlossen</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh D>D</run></blue></b>   1.d4 d5; 1.d4 Sf6 2.c4 g6 with 3...d5
<ul>
<li>  <b>D0</b>   1.d4 d5: <i>Damenbauernspiele</i> </li>
<li>  <b>D1</b>   1.d4 d5 2.c4 c6: <i>Slawisch</i> </li>
<li>  <b>D2</b>  1.d4 d5 2.c4 dxc4: <i>Angenommenes Damengambit</i> </li>
<li>  <b>D3</b>  1.d4 d5 2.c4 e6: <i>Abgelehntes Damengambit</i> </li>
<li>  <b>D4</b>  D3 + 3.Sc3 Sf6 4.Sf3 c5/c6: <i>Semi-Tarrasch; Semi-Slawisch</i> </li>
<li>  <b>D5</b>  D3 + 3.Sc3 Sf6 4.Lg5: <i>Klassisches Damengambit</i> </li>
<li>  <b>D6</b>  D5 + 4...Le7 5.e3 0-0 6.Sf3 Sbd7: <i>Orthodoxes Damengambit</i> </li>
<li>  <b>D7</b>  1.d4 Sf6 2.c4 g6 with 3...d5: <i>Grnfeld-Indisch</i> </li>
<li>  <b>D8</b>  1.d4 Sf6 2.c4 g6 3.Sc3 d5: <i>Grnfeld-Indisch</i> </li>
<li>  <b>D9</b>  1.d4 Sf6 2.c4 g6 3.Sc3 d5 4.Sf3: <i>Grnfeld-Indisch</i> </li>
</ul>

<p>
<b><blue><run ::windows::eco::Refresh E>E</run></blue></b>   1.d4 Sf6 2.c4 e6; 1.d4 Sf6 2.c4 g6 </li>
<ul>
<li>  <b>E0</b>  1.d4 Sf6 2.c4 e6: <i>Katalanisch etc.</i> </li>
<li>  <b>E1</b>  1.d4 Sf6 2.c4 e6 3.Sf3 (b6): <i>Damenindisch etc.</i> </li>
<li>  <b>E2</b>  1.d4 Sf6 2.c4 e6 3.Sc3 (Lb4): <i>Nimzo-Indisch etc.</i> </li>
<li>  <b>E3</b>  E2 + 4.Lg5 or 4.Dc2: <i>Nimzo-Indisch</i> </li>
<li>  <b>E4</b>  E2 + 4.e3: <i>Nimzo-Indisch, Rubinstein</i> </li>
<li>  <b>E5</b>  E4 + 4...0-0 5.Sf3: <i>Nimzo-Indisch, Hauptvariante</i> </li>
<li>  <b>E6</b>  1.d4 Sf6 2.c4 g6: <i>Knigsindisch</i> </li>
<li>  <b>E7</b>  1.d4 Sf6 2.c4 g6 3.Sc3 Lg7 4.e4: <i>Knigsindisch</i> </li>
<li>  <b>E8</b>  E7 + 4...d6 5.f3: <i>Knigsindisch, Smisch</i> </li>
<li>  <b>E9</b>  E7 + 4...d6 5.Sf3: <i>Knigsindisch, Hauptvarianten</i> </li>
</ul>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}

####################
### Calvar window help:

set helpTitle(D,CalVar) "Varianten berechnen"
set helpText(D,CalVar) {<h1>Das Varianten-berechnen-Fenster</h1>
  <p>
Dieses Training ist auch als Stoyko-bung bekannt. 
Das Ziel dieser bung ist die Analyse einer komplexen Stellung und daraus so viele wie mgliche plausible Varianten zu ermitteln. Jeder Variante wird mit einer Bewertung versehen. 
  </p> 
<p><h3>Konfiguration</h3></p>
Drei Parameter werden eingestellt:
<ul>
<li>Die zur Analyse der verschiedenen Varianten eingesetze UCI-Engine</li>
<li>Zeit, in Sekunden, die zur Analyse der Stellung von der Engine verwendet wird.</li>
<li>Zeit, in Sekunden, die zur Analyse der vom Anwender eingegebenen Variante durch die Engine verwendet wird.</li>
</ul>
<p><h3>Eingabe der Varianten</h3></p>
Die Zugeingabe erfolgt durch Mausklicks auf die Felder des Brettes, allerdings wird auf dem Brett nichts angezeigt. Die angeklickten Felder erscheinen im Varianten-berechnen-Fenster. Jeder Variante wird am Ende mit einer Bewertung abgeschlossen: Es wird einer der Knpfe mit den NAG-Codes gedrckt.
  <p><h3>Auswertung der Bewertung</h3></p>
Wurde eine Variante mit einer NAG-Code-Bewertung abgeschlossen, berechnet die Engine ihre Bewertung der Variante und hngt ihre Variante und Bewertung direkt an die Benutzer-Variante an. 
  <p><h3>Fertig mit der Stellung</h3></p>
Ist der Anwender der Meinung alle besten Varianten gefunden zu haben, drckt er <b>Fertig mit Stellung</b>. Es werden dann noch alle Varianten (mit dem Kommentar <b>Fehlende Varianten</b>) mit einer hheren Bewertung als die beste Variante des Anwenders hinzugefgt. 
  
  <p><footer>(Aktualisiert: Scid 3.6.21, Dezember 2007)</footer></p>
}

####################
### EPD files help:

set helpTitle(D,EPD) "EPD-Dateien"
set helpText(D,EPD) {<h1>EPD-Dateien</h1>
<p>
Eine EPD-Datei (extended position description = erweiterte
Stellungsbeschreibung) ist eine Sammlung von Positionen, wobei jeder
Position ein Text zugeordnet ist. Wie <a PGN>PGN</a> ist EPD ein
verbreiteter Standard fr Schachinformationen.
</p>
<p>
Eine EPD-Datei hat eine Reihe definierter "<term>Opcodes</term>"(-Felder),
die in der Datei durch Semikolons (<b>;</b>) getrennt gespeichert sind,
in einem EPD-Fenster von Scid aber in separaten Zeilen dargestellt
werden, um das Bearbeiten zu erleichtern. Ein Semikolon innerhalb eines
EPD-Feldes wird von Scid als "<b>\s</b>" gespeichert, um es von der
Feldende-Kennung zu unterscheiden.
Jede Position und ihre zugehriger Opcode wird in der EPD-Datei in
einer einzelnen Zeile gespeichert.
</p>
<p>
Standard-EPD-Opcodes sind u.a.:
<ul>
<li> <b>acd</b> Analyse-Zhler: Suchtiefe.</li>
<li> <b>acn</b> Analyse-Zhler: Anzahl der durchsuchten Knoten.</li>
<li> <b>acs</b> Analyse-Zhler: Suchzeit in Sekunden.</li>
<li> <b>bm</b> Beste Zge: aus irgendeinem Grund als beste
eingestufte Zge.</li>
<li> <b>ce</b> Stellungsbeurteilung: Beurteilung in Hundertstel Bauern
[ce = "centipawn evaluation"] aus Sicht der <b>am Zug</b>
befindlichen Seite -- beachten Sie, da sich dies vom Analysefenster
unterscheidet, welches die Einschtzung in Bauerneinheiten aus der
Sicht von Wei zeigt. </li>
<li> <b>cX</b> Kommentar (wobei <b>X</b> eine Ziffer ist, 0-9).</li>
<li> <b>eco</b> Erffnungscode des <a ECO>ECO</a>-Systems.</li>
<li> <b>id</b> Eindeutige Identifizierung dieser Stellung.</li>
<li> <b>nic</b> Erffnungscode des <i>New-In-Chess</i>-Systems.</li>
<li> <b>pm</b> Vorhergesagter Zug: der erste Zug der PV.</li>
<li> <b>pv</b> Vorhergesagte Variante: die beste Variante.</li>
</ul>
</p>
<p>
EPD-Dateien haben einen vielfachen Nutzen: Scid verwendet EPD-Dateien,
um Partien nach dem System der <a ECO>Enzyklopdie der
Schacherffnungen</a> (ECO) zu klassifizieren, und Sie knnen eine
EPD-Datei fr Ihr Erffnungsrepertoire erstellen, mit Kommentaren
zu Stellungen, die Sie regelmig auf dem Brett haben.
</p>
<p>
Mit den Optionen <menu>Neu</menu> und <menu>ffnen</menu>
im <menu>Datei</menu>-Men knnen Sie eine neue EPD-Datei erstellen
bzw. eine bestehende ffnen. Maximal vier EPD-Dateien knnen
gleichzeitig geffnet sein.
</p>

<h3>EPD-Fenster</h3>
<p>
Fr jede geffnete EPD-Datei sehen Sie ein Fenster, welches den Text zur
aktuellen Stellung zeigt. Sie mssen nicht den Schalter "Speichern"
bettigen, um nderungen des Textes zu sichern; der Text wird jedesmal
gespeichert, wenn Sie zu einer anderen Partiestellung gehen.
</p>

<h3>In EPD-Dateien navigieren</h3>
<p>
Um sich durch die Stellungen in einer EPD-Datei zu bewegen, verwenden
Sie die Kommandos <menu>Nchste Position</menu> und <menu>Vorherige
Position</menu> im <menu>Werkzeuge</menu>-Men des EPD-Fensters oder
die Tastenkombinationen <b>Strg+Ab</b> and <b>Strg+Auf</b>.
Diese Befehle gehen zur nchsten/vorherigen Position in der Datei,
wobei sie die aktuelle Partie lschen und die Ausgangsposition
herstellen.
</p>

<h3>EPD-Felder entfernen</h3>
<p>
EPD-Dateien, die Sie im Internet finden, enthalten mglicherweise
Felder, die Sie nicht interessieren und die eine Menge Speicherplatz
in der Datei verschwenden.
Beispielsweise knnte eine EPD-Datei mit Computerauswertungen die Felder
ce, acd, acn, pm, pv und id enthalten, Sie brauchen aber vielleicht
nur das ce- und pv-Feld.
</p>
<p>
Sie knnen einen EPD-Opcode mit dem Menpunkt <menu>EPD-Feld
entfernen</menu> im <menu>Werkzeuge</menu>-Men des EPD-Fensters
aus allen Stellungen in der EPD-Datei entfernen.
</p>

<h3>Die Statusanzeige des EPD-Fensters</h3>
<p>
Die Statuszeile jedes EPD-Fensters zeigt:
<ul>
<li>- den Dateistatus (<b>--</b> heit unverndert, <b>XX</b> heit
      verndert und <b>%%</b> heit schreibgeschtzt); </li>
<li>- den Dateinamen; </li>
<li>- die Anzahl der Positionen in der Datei; </li>
<li>- zulssige Zge in der aktuellen Stellung, die eine andere
Stellung in der EPD-Datei erreichen .</li>
</ul>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


###################
### Exporting help:

set helpTitle(D,Export) "Partien exportieren"
set helpText(D,Export) {<h1>Partien exportieren</h1>
<p>
Sie knnen die Kommandos im <menu>Werkzeuge</menu>-Men benutzen, um die
aktuelle Partie oder alle Partien im aktuellen Filter in eine Textdatei
zu exportieren.
</p>
<p>
Drei Textdatei-Formate stehen zur Verfgung: <a PGN>PGN</a> (portable
game notation), HTML (fr Webseiten) und LaTeX (ein populres
Textsatzsystem).
</p>
<p>
Beim Exportieren knnen Sie whlen, eine neue Datei zu erstellen
oder die Partien einer existierenden Partiendatei hinzuzufgen.
</p>

<h3>Diagramme</h3>
<p>
Wenn Sie im HTML- oder LaTeX-Format exportieren, fgt Scid automatisch
berall dort ein Diagramm ein, wo ein Diagramm-<a NAGs>NAG</a> ("D")
oder ein mit dem Zeichen "#" beginnender <a Comment>Kommentar</a>
in der Partie vorkommt.
</p>

<h3><name Null>Nullzge beim PGN-Export</name></h3>
<p>
Scid erlaubt es, in einer Partie <a Annotating Null>Null- (leere)
Zge</a> zu speichern, da diese beim Kommentieren mit Varianten
hilfreich sein knnen. Allerdings gibt es im PGN-Standard keine
Nullzge. Wenn Sie also Scid-Partien mit Nullzgen in eine PGN-Datei
exportieren, werden andere Programme zum PGN-Lesen nicht in der Lage
sein, die Nullzge zu lesen.
</p>
<p>
Um dieses Problem zu lsen, stellt Scid eine weitere Option bereit,
<b>Nullzge in Kommentare umwandeln</b>, wenn Partien in PGN-Format
exportiert werden. Wenn Sie eine PGN-Datei erstellen wollen, die von
anderer Software verwendet werden kann, schalten Sie diese Option ein,
und Varianten, die Nullzge enthalten, werden in Kommentare umgewandelt.
Wenn Sie jedoch eine PGN-Dateie erstellen wollen, die spter wieder
unter Beibehaltung der Nullzge von Scid importiert werden kann,
lassen Sie diese Option aus.
</p>

<h3>HTML-Export</h3>
<p>
Scid kann Partien in eine HTML-Datei exportieren. Um Diagramme einzufgen,
mssen die Diagrammbilder (im Verzeichnis "<b>bitmaps/</b>" mitgeliefert)
in einem Unterverzeichnis "<b>bitmaps/</b>" unterhalb des Verzeichnisses
sein, wo sich die HTML-Datei befindet.
</p>

<h3>LaTeX-Export</h3>
<p>
Scid kann Partien in eine LaTeX-Datei exportieren. Partien werden in
zwei Spalten pro Seite gedruckt und Zge in figuriner algebraischer
Notation.
</p>
<p>
Fr weitere Informationen siehe die Hilfeseite <a LaTeX>Scid und LaTeX</a>.
</p>

<p><footer>(Aktualisiert: Scid 3.4, Juli 2002)</footer></p>
}


####################
### Flags help:

set helpTitle(D,Flags) "Partie-Kennzeichen"
set helpText(D,Flags) {<h1>Partie-Kennzeichen</h1>

<p>
Eine <term>Kennzeichen</term> ("flag") ist ein Kennzeichen irgendeiner
Schach-Charakteristik, die fr jede Partie der Datenbank ein- oder
ausgeschaltet werden kann. Es gibt 13 vom Benutzer einstellbare
Kennzeichen, die Sie direkt fr jede Partie setzen knnen. Von diesen
hat nur die Lsch-Kennzeichen eine besondere Bedeutung: Partien, bei
denen die Lsch-Kennzeichen eingeschaltet ist, sind zur Lschung
vorgemerkt und werden entfernt, wenn die Datenbank
<a Compact>komprimiert</a> wird.
</p>
<p>
Die anderen 12 vom Benutzer einstellbaren Kennzeichen und ihre
Symbole sind:
</p>

<ul>
<li>Erffnung Wei (W)</li>
<li>Erffnung Schwarz (B)</li>
<li>Mittelspiel (M)</li>
<li>Endspiel (E)</li>
<li>Neuerung (N)</li>
<li>Bauernstruktur (P)</li>
<li>Taktik (T)</li>
<li>Spiel auf dem Damenflgel (Q)</li>
<li>Spiel auf dem Kngsflgel (K)</li>
<li>Brilliant (!)</li>
<li>Patzer (?)</li>
<li>Benutzer-definiert (U)</li>
</ul>

<p>
Eine Kennzeichen kann fr die aktuelle Partie, fr alle Partien im
Filter oder fr alle Partien der Datenbank im
<a Maintenance>Wartungs</a>-Fenster gesetzt werden.
</p>
<p>
Sie knnen die <a Searches Header>Suche nach Partiedaten</a> benutzen,
um alle Datenbankpartien zu finden, die ein bestimmtes Kennzeichen ein-
oder ausgeschaltet haben, oder die Kennzeichen als Teil einer
komplexeren Suche verwenden.
</p>
<p>
Da alle vom Benutzer einstellbaren Kennzeichen keine Bedeutung fr
Scid haben (mit Ausnahme der Lsch-Kennzeichen), knnen Sie diese fr
Ihre eigenen Bedrfnisse  verwenden. Zum Beispiel knnten Sie die
Kennzeichen "Spiel auf dem Kngsflgel" (K) fr Bauernstrme auf den
Knig verwenden, fr Figurenangriffe auf den Knig oder auch fr
Endspiele mit allen Bauern auf dem Knigsflgel.
</p>

<p><footer>(Aktualisiert: Scid 4.7, Juni 2018)</footer></p>
}


###############
### LaTeX help:

set helpTitle(D,LaTeX) "Scid und LaTeX"
set helpText(D,LaTeX) {<h1>Scid und LaTeX</h1>
<p>
Scid kann Partien und Erffnungsberichte im LaTeX-Format in Dateien
sichern. LaTeX ist eine Erweiterung von TeX, einem populren Textsatzsystem.
</p>
<p>
Um die von Scid erzeugten LaTeX-Dateien darzustellen, mssen Sie
(natrlich) LaTeX haben und das Schachzeichensatz-Paket "chess12"
installiert haben. Dieses Paket ist normalerweise nicht Teil der
LaTeX-Standardinstallation, d.h selbst wenn Sie LaTeX haben, haben
Sie vielleicht nicht den Schachzeichensatz.
</p>
<p>
Informationen zum Herunterladen und Installieren des
LaTeX-Schachzeichensatzes finden Sie auf der Seite
<url http://scid.sourceforge.net/latex.html>Using LaTeX with Scid</url>
der <url http://scid.sourceforge.net/>Scid-Website</url>.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


###########################
### Options and Fonts help:

set helpTitle(D,Options) "Options"
set helpText(D,Options) {<h1>Optionen und Prferenzen</h1>
<p>
Viele Optionen und Prferenzen in Scid (z.B. die Brettgre, Farben, Schachbrettmuster,
Zeichenstze und Standardwerte) kann man im <menu>Optionen</menu>-Men
verndern. Alle diese (und mehr, wie etwa das letzte Verzeichnis, aus
dem Sie eine Datenbank gelesen haben, und die Gre einiger Fenster)
werden in einer Optionendatei gesichert, wenn Sie im Optionen-Men
<b>Optionen speichern</b> whlen.
Jedesmal, wenn Sie Scid starten, wird die Optionendatei geladen.
</p>
<p>
Wenn Sie mit Windows arbeiten, ist die Optionendatei <b>options.dat</b>
im Unterverzeichnis "config" der Scids Programmdatei abgelegt. Fr Benutzer von
Unix-Betriebssystemen (wie Solaris oder Linux) ist die Datei
<b>~/.scid/scidrc</b>.
</p>

<h3><name MyPlayerNames>Ihre Spielernamen festlegen</name></h3>
<p>
Es kann sein, da Sie fr einen (oder mehrere) Spieler das Brett im
Haupfenster aus der Sicht dieses Spielers aufgestellt haben mchten,
wenn eine seiner Partien geladen wird. Sie knnen eine Liste solcher
Namen mit <b>Meine Spielernamen...</b> im Men <menu>Optionen/Schachbrett</menu>
anlegen. In dem Dialogfenster geben Sie dann einen Spielernamen pro Zeile
ein. Jokerzeichen ("<b>?</b>" fr genau ein beliebiges Zeichen, "<b>*</b>"
fr eine Zeichenkette von null oder mehr Zeichen) sind erlaubt.
</p>

<h3><name Fonts>Zeichenstze einstellen</name></h3>
<p>
Scid hat drei Basis-Zeichenstze, die in den meisten Fenstern verwendet
werden, und Sie knnen alle drei individuell anpassen. Sie heien
<b>normal</b>, <b>klein</b> und <b>fest</b>.
</p>
<p>
Der feste Zeichensatz sollte ein Zeichensatz mit fester Breite
(nicht-proportional) sein. Er wird fr den <a Tree>Zugbaum</a> und die
<a Crosstable>Turniertabelle</a> verwendet.
</p>

<p><footer>(Aktualisiert: Scid 4.7, Mai 2021)</footer></p>
}


####################
### Pgnscid help:

set helpTitle(D,Pgnscid) "Pgnscid"
set helpText(D,Pgnscid) {<h1>Pgnscid</h1>
<p>
<term>Pgnscid</term> ist ein separates Program, das Sie zur
Konvertierung von PGN-Dateien ("portable game notation") nach
Scid-Datenbanken bentigen.
</p>
<p>
Um eine Datei namens <i>partien.pgn</i> umzuwandeln, tippen Sie
einfach
<ul>
<li> <b>pgnscid partien.pgn</b> </li>
</ul>
ein, und die Scid-Datenbank (bestehend aus den Dateien
<i>partien.si3</i>, <i>partien.sg3</i> und <i>partien.sn3</i>) wird
erstellt.
Fehlermeldungen oder Warnungen werden in die Datei <i>partien.err</i>
geschrieben.
</p>
<p>
Wenn Sie wollen, da die Datenbank in einem anderen Verzeichnis oder
mit einem anderen Namen erstellt wird, knnen Sie den Datenbanknamen
in der Kommandozeile mit angeben, zum Beispiel erstellt
<ul>
<li> <b>pgnscid partien.pgn datenbank</b> </li>
</ul>
eine Datenbank bestehend aus den Dateien <i>datenbank.si3</i>,
<i>datenbank.sg3</i> und <i>datenbank.sn3</i>.
</p>
<p>
Beachten Sie, da pgnscid (und auch scid) mit gzip komprimierte
PGN-Dateien (z.B. <b>datenbank.pgn.gz</b>) direkt lesen kann, wenn Sie
also eine groe PGN-Datei mit gzip komprimiert haben, um Speicherplatz
zu sparen, mssen Sie sie nicht zuerst dekomprimieren.
</p>

<h3>Optionen</h3>
<p>
Pgnscid akzeptiert zwei optionale Argumente vor dem Dateinamen:
<b>-f</b> und <b>-x</b>.
</p>
<p>
Die Option <b>-f</b> erzwingt das berschreiben einer existierenden
Datenbank; standardmig wandelt pgnscid nicht in eine bereits
bestehende Datenbank um.
</p>
<p>
Die Option <b>-x</b> veranlat pgnscid, Text zwischen den Partien zu
ignorieren. Gem Voreinstellung wird Text zwischen Partien als
Kommentar vor der folgenden Partie gespeichert. Diese Option betrifft
nur Text zwischen Partien; Standardkommentare innerhalb der Partien
werden weiterhin konvertiert und gespeichert.
</p>

<h3>Spielernamen formatieren</h3>
<p>
Um die Anzahl verschiedener Namensschreibweisen desselben Spielers
zu reduzieren, werden von pgnscid einige Grundformatierungen
durchgefhrt. Zum Beispiel wird die Anzahl der Leerzeichen nach einem
Komma auf eins gesetzt, Leerzeichen am Anfang oder Ende eines Namens
werden ebenso wie ein Punkt am Namensende entfernt.
Hollndische Namenszustze wie "van den" und "Van Der" werden ebenfalls
normalisiert, so da sie ein groes "V" und kleines "d" haben.
</p>
<p>
Sie knnen Spieler-, Turnier-, Orts- und Rundenbezeichnungen in Scid
bearbeiten (und sogar automatische Schreibkorrekturen durchfhren);
zu den Details siehe die Hilfeseite <a Maintenance Editing>Wartung</a>.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


#################
### Sorting help:

set helpTitle(D,Sorting) "Datenbank sortieren"
set helpText(D,Sorting) {<h1>Eine Datenbank sortieren</h1>
<p>
Die <term>Sortier</term>-Funktionen sortieren alle Partien einer
Datenbank. Sie knnen mehrere Sortierkriterien auswhlen.
Wenn zwei Partien nach einem Kriterium gleichrangig sind, werden
sie nach dem zweiten Kriterium sortiert, und so weiter.
</p>

<h3>Sortierkriterien</h3>
<p>
Die verfgbaren Sortierkriterien sind:
</p>
<ul>
<li> Datum (lteste Partien zuerst)
<li> Jahr (wie Datum, aber nur das Jahr wird verwendet)
<li> Turnier (Ereignis)
<li> Ort
<li> Land (die letzten 3 Buchstaben des Ortes)
<li> Runde
<li> Wei
<li> Elo-Zahl (Durchschnitt von Wei und Schwarz, hhere zuerst)
<li> Schwarz
<li> Ergebnis (Wei gewinnt, danach Remis, danach Schwarz gewinnt)
<li> Lnge (Anzahl ganzer Zge in der Partie)
<li> ECO (Code der <a ECO>Enzyklopdie der Schacherffnungen</a>)
</ul>

<h3>Sortierergebnis</h3>
<p>
Wenn Sie eine nicht schreibgeschtzte Scid-Datenbank sortieren, wird das
Sortierergebnis gesichert, so da die Reihenfolge der Datenbankpartien
dauerhaft gendert ist. Falls Sie nur eine temporre Sortierung wollen,
schtzen Sie die Datenbank zuerst gegen berschreiben mit dem Menpunkt
<menu>Datei: Schreibschutz</menu>.
</p>
<p>
Wenn Sie eine Datenbank sortieren, die schreibgeschtzt ist oder aus
einer PGN-Datei besteht, kann das Sortierergebnis nicht gesichert werden,
so da die sortierte Partiereihenfolge verloren geht, wenn die Datei
geschlossen wird.
</p>
<p>
Beachten Sie, da das Sortieren einer Datenbank den
<a Searches Filter>Suchfilter</a> zurcksetzt auf alle Partien.
</p>

<h3>Wichtiger Hinweis zum Datenbank sortieren:</h3>
<p>
Wenn eine Datenbank sortiert wurde, ist die Indexdatei gendert, die
Partiendatei aber unverndert. Das heit, das Sortieren einer Datenbank
hinterlt die Partiedatenstze der Datei in einer zuflligen
Reihenfolge relativ zur Indexdatei. Das kann die <a Tree>Zugbaum</a>-,
Positions- und Material/Muster-<a Searches>Suche</a> merklich
<b>verlangsamen</b>, Sie sollten daher nach dem Datenbank sortieren
die Partiendatei durch <a Compact>Komprimieren</a> neuorganisieren,
um gute Suchleistungen zu erhalten.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


####################
### NAG values help:

set helpTitle(D,NAGs) "NAG-Werte"
set helpText(D,NAGs) {<h1>Standard-NAG-Werte</h1>
<p>
Standard-NAG-Werte (Numeric Annotation Glyph = "numerisches
Anmerkungszeichen"), im <a Author Related>PGN-Standard</a> definiert,
sind:
</p>
<cyan>
<ul>
<li>  1   Guter Zug (!) </li>
<li>  2   Schwacher Zug (?) </li>
<li>  3   Ausgezeichneter Zug (!!) </li>
<li>  4   Patzer / Grober Fehler (??) </li>
<li>  5   Interessanter Zug (!?) </li>
<li>  6   Zweifelhafter Zug (?!) </li>
<li>  7   Erzwungener Zug </li>
<li>  8   Der einzige Zug; keine vernnftige Alternative </li>
<li>  9   Schlechtester Zug </li>
<li> 10   Ausgeglichene Position (=) </li>
<li> 11   Gleiche Chancen, ruhige Stellung (=) </li>
<li> 12   Gleiche Chancen, aktive Stellung (=) </li>
<li> 13   Unklare Stellung (~) </li>
<li> 14   Wei hat leichten Vorteil, steht etwas besser (+=) </li>
<li> 15   Schwarz hat leichten Vorteil, steht etwas besser (=+) </li>
<li> 16   Wei hat Vorteil, steht besser (+/-) </li>
<li> 17   Schwarz hat Vorteil, steht besser (-/+) </li>
<li> 18   Wei hat entscheidenden Vorteil (+-) </li>
<li> 19   Schwarz hat entscheidenden Vorteil (-+) </li>
<li> 20   Wei hat berwltigenden Vorteil (+-) </li>
<li> 21   Schwarz hat berwltigenden Vorteil (-+) </li>
<li> 22   Wei ist in Zugzwang </li>
<li> 23   Schwarz ist in Zugzwang </li>
<li> 24   Wei hat leichten Raumvorteil </li>
<li> 25   Schwarz hat leichten Raumvorteil </li>
<li> 26   Wei hat Raumvorteil </li>
<li> 27   Schwarz hat Raumvorteil </li>
<li> 28   Wei hat entscheidenden Raumvorteil </li>
<li> 29   Schwarz hat entscheidenden Raumvorteil </li>
<li> 30   Wei hat leichten Zeit-(Entwicklungs)vorsprung </li>
<li> 31   Schwarz hat leichten Zeit-(Entwicklungs)vorsprung </li>
<li> 32   Wei hat Zeit-(Entwicklungs)vorsprung </li>
<li> 33   Schwarz hat Zeit-(Entwicklungs)vorsprung </li>
<li> 34   Wei hat entscheidenden Zeit-(Entwicklungs)vorsprung </li>
<li> 35   Schwarz hat entscheidenden Zeit-(Entwicklungs)vorsprung </li>
<li> 36   Wei hat die Initiative </li>
<li> 37   Schwarz hat die Initiative </li>
<li> 38   Wei hat andauernde Initiative </li>
<li> 39   Schwarz hat andauernde Initiative </li>
<li> 40   Wei hat Angriff </li>
<li> 41   Schwarz hat Angriff </li>
<li> 42   Wei hat keine ausreichende Kompensation fr das Material </li>
<li> 43   Schwarz hat keine ausreichende Kompensation fr das Material </li>
<li> 44   Wei hat ausreichende Kompensation fr das Material </li>
<li> 45   Schwarz hat ausreichende Kompensation fr das Material </li>
<li> 46   Wei hat mehr als ausreichende Kompensation fr das Material </li>
<li> 47   Schwarz hat mehr als ausreichende Kompensation fr das Material </li>
<li> 48   Wei hat leichtes bergewicht im Zentrum </li>
<li> 49   Schwarz hat leichtes bergewicht im Zentrum </li>
<li> 50   Wei hat bergewicht im Zentrum </li>
<li> 51   Schwarz hat bergewicht im Zentrum </li>
<li> 52   Wei hat entscheidendes bergewicht im Zentrum </li>
<li> 53   Schwarz hat entscheidendes bergewicht im Zentrum </li>
<li> 54   Wei hat leichtes bergewicht am Knigsflgel </li>
<li> 55   Schwarz hat leichtes bergewicht am Knigsflgel </li>
<li> 56   Wei hat bergewicht am Knigsflgel </li>
<li> 57   Schwarz hat bergewicht am Knigsflgel </li>
<li> 58   Wei hat entscheidendes bergewicht am Knigsflgel </li>
<li> 59   Schwarz hat entscheidendes bergewicht am Knigsflgel </li>
<li> 60   Wei hat leichtes bergewicht am Damenflgel </li>
<li> 61   Schwarz hat leichtes bergewicht am Damenflgel </li>
<li> 62   Wei hat bergewicht am Damenflgel </li>
<li> 63   Schwarz hat bergewicht am Damenflgel </li>
<li> 64   Wei hat entscheidendes bergewicht am Damenflgel </li>
<li> 65   Schwarz hat entscheidendes bergewicht am Damenflgel </li>
<li> 66   Wei hat eine schwache Grundreihe </li>
<li> 67   Schwarz hat eine schwache Grundreihe </li>
<li> 68   Wei hat eine gut gesicherte Grundreihe </li>
<li> 69   Schwarz hat eine gut gesicherte Grundreihe </li>
<li> 70   Wei hat einen schlecht gesicherten Knig </li>
<li> 71   Schwarz hat einen schlecht gesicherten Knig </li>
<li> 72   Wei hat einen gut gesicherten Knig </li>
<li> 73   Schwarz hat einen gut gesicherten Knig </li>
<li> 74   Der weie Knig steht schlecht </li>
<li> 75   Der schwarze Knig steht schlecht </li>
<li> 76   Der weie Knig steht gut </li>
<li> 77   Der schwarze Knig steht gut </li>
<li> 78   Wei hat eine sehr schwache Bauernstruktur </li>
<li> 79   Schwarz hat eine sehr schwache Bauernstruktur </li>
<li> 80   Wei hat eine schwache Bauernstruktur </li>
<li> 81   Schwarz hat eine schwache Bauernstruktur </li>
<li> 82   Wei hat eine starke Bauernstruktur </li>
<li> 83   Schwarz hat eine starke Bauernstruktur </li>
<li> 84   Wei hat eine sehr starke Bauernstruktur </li>
<li> 85   Schwarz hat eine sehr starke Bauernstruktur </li>
<li> 86   Der weie Springer steht schlecht </li>
<li> 87   Der schwarze Springer steht schlecht </li>
<li> 88   Der weie Springer steht gut </li>
<li> 89   Der schwarze Springer steht gut </li>
<li> 90   Der weie Lufer steht schlecht </li>
<li> 91   Der schwarze Lufer steht schlecht </li>
<li> 92   Der weie Lufer steht gut </li>
<li> 93   Der schwarze Lufer steht gut </li>
<li> 94   Der weie Turm steht schlecht </li>
<li> 95   Der schwarze Turm steht schlecht </li>
<li> 96   Der weie Turm steht gut </li>
<li> 97   Der schwarze Turm steht gut </li>
<li> 98   Die weie Dame steht schlecht </li>
<li> 99   Die schwarze Dame steht schlecht </li>
<li>100   Die weie Dame steht gut </li>
<li>101   Die schwarze Dame steht gut </li>
<li>102   Die weien Figuren sind schlecht koordiniert </li>
<li>103   Die schwarzen Figuren sind schlecht koordiniert </li>
<li>104   Die weien Figuren sind gut koordiniert </li>
<li>105   Die schwarzen Figuren sind gut koordiniert </li>
<li>106   Wei hat die Erffnung sehr schwach behandelt </li>
<li>107   Schwarz hat die Erffnung sehr schwach behandelt </li>
<li>108   Wei hat die Erffnung schwach behandelt </li>
<li>109   Schwarz hat die Erffnung schwach behandelt </li>
<li>110   Wei hat die Erffnung gut behandelt </li>
<li>111   Schwarz hat die Erffnung gut behandelt </li>
<li>112   Wei hat die Erffnung sehr gut behandelt </li>
<li>113   Schwarz hat die Erffnung sehr gut behandelt </li>
<li>114   Wei hat das Mittelspiel sehr schwach behandelt </li>
<li>115   Schwarz hat das Mittelspiel sehr schwach behandelt </li>
<li>116   Wei hat das Mittelspiel schwach behandelt </li>
<li>117   Schwarz hat das Mittelspiel schwach behandelt </li>
<li>118   Wei hat das Mittelspiel gut behandelt </li>
<li>119   Schwarz hat das Mittelspiel gut behandelt </li>
<li>120   Wei hat das Mittelspiel sehr gut behandelt </li>
<li>121   Schwarz hat das Mittelspiel sehr gut behandelt </li>
<li>122   Wei hat das Endspiel sehr schwach behandelt </li>
<li>123   Schwarz hat das Endspiel sehr schwach behandelt </li>
<li>124   Wei hat das Endspiel schwach behandelt </li>
<li>125   Schwarz hat das Endspiel schwach behandelt </li>
<li>126   Wei hat das Endspiel gut behandelt </li>
<li>127   Schwarz hat das Endspiel gut behandelt </li>
<li>128   Wei hat das Endspiel sehr gut behandelt </li>
<li>129   Schwarz hat das Endspiel sehr gut behandelt </li>
<li>130   Wei hat etwas Gegenspiel </li>
<li>131   Schwarz hat etwas Gegenspiel </li>
<li>132   Wei hat Gegenspiel </li>
<li>133   Schwarz hat Gegenspiel </li>
<li>134   Wei hat entscheidendes Gegenspiel </li>
<li>135   Schwarz hat entscheidendes Gegenspiel </li>
<li>136   Wei ist in leichter Zeitnot </li>
<li>137   Schwarz ist in leichter Zeitnot </li>
<li>138   Wei ist in erheblicher Zeitnot </li>
<li>139   Schwarz ist in erheblicher Zeitnot </li>
</ul>
</cyan>

<p>
Weitere vorgeschlagene NAG-Werte fr Schachinformator-Symbole sind u.a.:
</p>
<cyan>
<ul>
<li>140   Mit der Idee ... </li>
<li>141   Gerichtet gegen ... </li>
<li>142   Besser ist </li>
<li>143   Schlechter ist </li>
<li>144   Gleichwertig ist </li>
<li>145   Anmerkung des Herausgebers ("RR") </li>
<li>146   Neuerung ("N") </li>
<li>147   Schwacher Punkt </li>
<li>148   Endspiel </li>
<li>149   Linie </li>
<li>150   Diagonale </li>
<li>151   Wei hat das Luferpaar </li>
<li>152   Schwarz hat das Luferpaar </li>
<li>153   Verschiedenfarbige Lufer </li>
<li>154   Gleichfarbige Lufer </li>
</ul>
</cyan>

<p>
Andere Vorschlge sind:
</p>
<cyan>
<ul>
<li>190   Etc. </li>
<li>191   Doppelbauern </li>
<li>192   Isolierte Bauern </li>
<li>193   Verbundene Bauern </li>
<li>194   Hngende Bauern </li>
<li>195   Rckstndiger Bauer </li>
</ul>
</cyan>

<p>
Von Scid definierte Symbole zum internen Gebrauch:
</p>
<cyan>
<ul>
<li>201   Diagramm ("D", manchmal auch "#") </li>
</ul>
</cyan>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


######################
### File formats help:

set helpTitle(D,Formats) "Datei-Formate"
set helpText(D,Formats) {<h1>Scids Datei-Formate</h1>
<p>
Scid-Datenbanken bestehen aus drei essentiellen Dateien: eine
Indexdatei, eine Namendatei und eine Partiendatei. Alle haben eine
zweibuchstabige Dateiendung, beginnend mit "s": ".si" fr Indexdateien,
".sn" fr Namendateien und ".sg" fr Partiendateien.
</p>

<h3>Die Indexdatei (.si)</h3>
<p>
Diese Datei enthlt eine Beschreibung der Datenbank und fr jede Partie
einen kleinen Eintrag fester Lnge. Die aktuelle Gre ist 41 Bytes
pro Partie. Von diesen sind 28 Bytes wesentliche Informationen wie
Ergebnis, Datum, Indizes fr Spieler-, Turnier-, Ortsnamen (die
tatschlichen Namen befinden sich in der Namendatei) etc.
</p>
<p>
Die verbleibenden 13 Bytes enthalten redundante, aber ntzliche
Informationen zur Partie, die zur Beschleunigung der Positions-,
Material- und Mustersuche genutzt werden. Siehe den Abschnitt
<a Formats Fast>Schnelles Suchen</a> weiter unten fr weitere
Informationen.
</p>

<h3>Die Namendatei (.sn)</h3>
<p>
Diese Datei enthlt alle Spieler-, Turnier-, Orts- und Rundennamen, die
in der Datenbank verwendet werden. Jeder Name ist nur einmal gespeichert,
auch wenn er in vielen Partien vorkommt. Die Namendatei ist blicherweise
die kleinste der drei essentiellen Datenbankdateien.
</p>

<h3>Die Partiendatei (.sg)</h3>
<p>
Diese Datei enthlt die aktuellen Zge, Varianten und Kommentare jeder
Partie. Die Zugkodierung ist sehr kompakt: die meisten Zge bentigen
nur ein Byte.
</p>
<p>
Wenn eine Partie ersetzt wird, wird ihre neue Version am <i>Ende</i>
der Datei gespeichert, so da sich ber die Zeit nicht genutzter
Speicherplatz ansammelt. Sie knnen durch <a Compact>Komprimieren</a>
die minimale Gre einer Datenbank wiederherstellen.
</p>

<h3>Andere Scid-Dateien</h3>
<p>
Eine <a EPD>EPD</a>-Datei (Dateiendung: ".epd") enthlt eine Reihe von
Schachpositionen, jede mit einem Textkommentar.
Das EDP-Dateiformat ist beim <a Author Related>PGN-Standard</a>
beschrieben.
</p>
<p>
Eine E-Mail-Datei (Dateiendung: ".sem") einer Datenbank speichert
Daten der Gegner, denen Sie E-Mails senden.
</p>
<p>
Eine Suchoptionsdatei (Dateiendung: ".sso") enthlt Einstellungen fr
eine <a Searches Header>Partiedaten</a>- oder
<a Searches Material>Material/Muster</a>-Suche.
</p>

<h3><name Fast>Schnelles Suchen in Scid</name></h3>
<p>
Wie oben erwhnt, enthlt die Indexdatei einige redundante, aber
ntzliche Informationen ber jede Partie, um Positions- oder
Materialsuchen zu beschleunigen.
</p>
<p>
Beispielsweise ist das Material der Schlustellung gespeichert. Wenn Sie
nach Turm- und Bauernendspielen suchen, werden alle Partien, die mit
einer Dame, einem Lufer oder einem Springer auf dem Brett enden,
schnell bergangen.
</p>
<p>
Eine andere ntzliche Teilinformation ist in der Reihenfolge gespeichert,
in der Bauern ihre Ausgangsstellung verlassen haben (durch Ziehen oder
Geschlagenwerden). Dies wird zur Beschleunigung von Zugbaum- oder exakten
Suchen verwendet, insbesondere nach Erffnungspositionen. Beispielsweise
wird bei der Suche nach der Ausgangsstellung der Franzsischen
Verteidigung (1.e4 e6) jede Partie, die mit 1.e4 c5 oder 1.d4 etc.
beginnt, ausgelassen, Partien, die mit 1.e4 e5 anfangen, mssen aber
immer noch durchsucht werden.
</p>

<p><footer>(Aktualisiert: Scid 2.5, Juni 2001)</footer></p>
}


################
### Contact info

set helpTitle(D,Author) "Kontakt-Information"
set helpText(D,Author) {<h1>Kontakt-Information</h1>
<p>
Die Scid Internet - Seite ist erreichbar unter: <br>
<b><url http://scid.sourceforge.net/>http://scid.sourceforge.net/</url></b>
</p>
<p>
Sie bietet Downloads der neuesten Versionen von Scid und einigen anderen
zustzlichen und ntzlichen Dateien.
</p>
<p>
Bitte senden Sie Ihre Kommentare, Fragen, Vorschlge oder Fehlerberichte
an den Autor von Scid, Shane Hudson, an folgende E-Mail-Adresse: <br>
<b>scid-users@lists.sourceforge.net</b>
</p>

<h3><name Related>Links</name></h3>
<p>
Falls Sie Freude an Scid haben, knnten Sie die folgenden
Internetseiten interessieren:
</p>
<ul>
<li><url http://www.tim-mann.org/chess.html>http://www.tim_mann.org/chess.html</url> --
Homepage von Tim Mann's <b>xboard & winboard</b> Programm: eine grafische
Oberflche fr Schachprogramme und Schnittstelle fr Internet Schach
Server. Sie hat auch gute Informationen ber Crafty, GNUchess und
andere Schachprogramme.</li>

<li><url http://theweekinchess.com/twic>http://theweekinchess.com/twic</url> --
TWIC (the week in chess), ein hervorragendes Wochenmagazin fr
internationale Schachpartien, verfgbar im PGN-Format. </li>

<li><url http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm>http://www.saremba.de/chessgml/standards/pgn/pgn-complete.htm</url> --
der <b>PGN-Standard</b>, geschaffen von Steven J. Edwards im Jahre 1994.
Die Seite erklrt das PGN- und EPD-Format im Detail.</li>
</ul>

<p><footer>(Aktualisiert: Scid 4.7, August 2018)</footer></p>
}

# Book window help
set helpTitle(D,Book) "Buch-Fenster"
set helpText(D,Book) {<h1>Buch-Fenster</h1>
  <p>
 Das Buch-Fenster zeigt eine Liste aller im Buch-Verzeichnis von Scid verfgbaren Buch-Datenbanken an. Das Format der Bcher entspricht dem Format, welches von Polygot und den Engines Fruit und Toga verwendet wird.
  </p>
  <p>
 Das Buch-Fenster zeigt (aus dem ausgewhlten Buch) fr die aktuelle Position alle mglichen Zge, die im Buch enthalten sind und deren relativen Gewichtungen in Prozent an. Bei jedem Zug wird das Buch-Fenster aktualisiert. Beim Anklicken eines Zuges im Buch-Fenster wird dieser Zug in die aktuelle Stellung bernommen.
  </p>
  <p>
Zwischen den Bchern kann schnell gewechselt werden, in dem man in der oberen Liste ein anderes Buch auswhlt.
  </p>
  <p><footer>(Aktualisiert: Scid 3.6.21, Dezember 2007)</footer></p>
}

# Tactical game window help
set helpTitle(D,TacticalGame) "Trainingspartie-Fenster"
set helpText(D,TacticalGame) {<h1>Trainingspartie-Fenster</h1>
  <p>
  Hier kann eine Trainingspartie gegene eine Engine gespielt werden, die einen Gegner mit einer bestimmten ELO-Zahl simuliert.  
  Der Gegner wird von Phalanx gespielt, als Coach wird eine UCI-Engine eingesetzt. Diese Engines werden automatisch ber ihre Namen ausgewhlt und sollten korrekt konfiguriert sein. Standardmig werden diese Engines bei der Installation von Scid eingerichtet. 
  </p>
  <p>
  Folgende Parameter sind einzustellen:
  <ul>
  <li><term>Feste Strke</term>: setzt eine feste Elo-Bewertung fr den Gegner</li>.
  <li><term>Zufallsstrke</term>: Whlt eine zufllige Strke zwischen der
  minimalen und maximalen Strke, der durch den linken und rechten Schieberegler festgelegt wird, aus.
  </li>
  <li><term>Erffnung:</term>
  <ul>
     <li><term>Neue Partie</term>: startet ein neues Spiel mit einer zuflligen Erffnung.</li>
     <li><term>Von aktueller Position starten</term>: das Spiel bei der aktuellen Position fortsetzen.</li>
     <li><term>Ausgewhlte Erffnung</term>: der Gegner spielt eine ffnung, die aus der Liste ausgewhlt werden kann. Das ist ntzlich fr das Erffnungstraining.</li>
  </ul>
  <li><term>Analysezeit der Engine begrenzen</term> erlaubt es, die vom Coach verwendete Zeit, um die Zge der Spieler auf Fehler zu berprfen, zu begrenzen. Wenn dies nicht der Fall ist, darf der Coach im Hintergrund rechnen.</li><br>
  <p>Tipp: Schalten Sie die <a Graphs>Partiebewertung</a> ein, dann knnen Sie whrend der Partie den Verlauf der Zeit und die Bewertung der Stellung sehen.</p>
  <p>Eine hnliche Funktion kann bei einer <a SeriousGame>Ernsten Partie</a> durch das limitieren der Spielstrke einer UCI-Engine erreicht werden.</p>
  <p>Zum Starten der Partie "Spielen" drcken.</p> 
  <p><footer>(Aktualisiert: Scid 4.7, August 2018)</footer></p>
}

# Opening Trainer window help
set helpTitle(D,OpeningTrainer) "Erffnungstrainer"
set helpText(D,OpeningTrainer) {<h1>Erffnungstrainer</h1>
  <p>
   Eine SCID-Datenbank kann als Repertoire verwendet werden, wobei jedes Spiel eine Erffnungslinie darstellt. Die Spiele knnen Varianten enthalten. Auch NAG-Werte knnen angegeben werden, um so bevorzugte oder zweifelhafte Zeilen zu markieren. Eine Datenbank fr den Erffnungstrainer muss auch vom richtigen Typ sein: Das heit, wenn ffnungen fr Wei trainiert werden sollen, muss die Datenbank vom Typ ffnungen fr Wei sein (hnlich fr Schwarz und beide Farben). Der Typ kann ber das Fenster Wartung durch Auswahl des Symbols oder ber das Kontextmen des Datenbankumschalters eingestellt werden. 
  Eine Scid Datenbank kann als Repertoire genutzt werden, wenn sie mit dem entsprechenden Typ/Icon markiert wurde. Die Datenbank muss einer der folgenen Typen sein:
  <li>Openings for White</li>
  <li>Openings for Black</li>
  <li>Openings for either Color</li> <br>
  Der Typ muss mit der Auswahl "Konfiguration Trainingsrepertoire" (Wei, Schwarz, Beide) bereinstimmen. Jede Partie reprsentiert eine Erffnungsvariante. 
  </p>
  
  <h3>Erffnungstrainer Statistik</h3>
  <p>
   Vier Zahlen zeigen die Statistik fr die aktuelle Stellung:
  <ul>
  <li>Grn : Anzahl bereits korrekt gespielten Zge.</li>
  <li>Gelb : Anzahl zweifelhafter gespielter Zge im Repertoire</li>
  <li>Rot : Anzahl der Zge, die nicht im Repertoire enthalten sind.</li>
  <li>Wei : Hufigkeit der Stellung</li>
  </ul>
  </p>
  
  <h3>Der Bericht</h3>
  <p>
  Der Bericht zeigt fr das ganze Repertoire Statistiken und gibt Informationen ber das Wissen des Anwenders:  
  <ul>
  <li>Positionen im Repertoire: Anzahl der Positione im Repertoire (alle Varianten in der Datenbank)</li>
  <li>nicht gespielte Positionen : Anzahl der Stellungen, die bisher nie gespielt wurden</li>
  <li>gespielte Positionen : gespielte Stellungen und die Summe wie hufig sie ausgespielt wurden. Anmerkung: Diese Zahl reprsentiert das Vorkommen der Stellung in allen Erffnungsvarianten: Diese Zahl kann fr Stellungen nahe der Startaufstellung schnell sehr gro werden.</li>
  <li>Erfolgreich : Anzahl der guten Zge durch den Spieler</li>
  <li>Zweifelhafte Zge : Anzahl der schwachen/schlechten Zge durch den Spieler</li>
  <li>Nicht im Repertoire : Anzahl der Zge des Spieler, die nicht im Repertoire enthalten sind.</li>
  </ul>
  </p> 
  <p><footer>(Aktualisiert: Scid 3.6.21, Dezember 2007)</footer></p>
}


############################################################
#
# German tip of the day

set tips(D) {
  {
    Scid hat mehr als 30 <a Index>Hilfeseiten</a> und in den meisten
    Scid-Fenstern liefert die <b>F1</b>-Taste die Hilfeseite zu diesem
    Fenster.
  }
  {
    Einige Scid-Fenster (z.B. Informationsbereich und
    Datenbank-<a Switcher>Umschalter</a>) haben ein Kontextmenu.
    Drcken Sie einfach die rechte Maustaste in jedem Fenster, um zu
    sehen, ob es ein Men hat und welche Funktionen zur Verfgung
    stehen.
  }
  {
    Scid bietet Ihnen mehr als eine Mglichkeit, Schachzge einzugeben,
    und lt Ihnen die Wahl, welche Ihnen am meisten zusagt. Sie knnen
    die Maus verwenden (mit oder ohne Zugvorschlag) oder die Tastatur
    (mit oder ohne Zugergnzung). Fr Details lesen Sie die Hilfeseite
    <a Moves>Zge eingeben</a>.
  }
  {
    Wenn Sie einige Datenbanken hufig ffnen, fgen Sie zu jeder ein
    <a Bookmarks>Lesezeichen</a> hinzu, dann knnen Sie sie schneller
    mit dem Lesezeichen-Men ffnen.
  }
  {
    Sie knnen alle Zge einer Partie (mit allen Varianten und
    Kommentaren) mit dem <a PGN>PGN-Fenster</a> betrachten. Im
    PGN-Fenster knnen Sie zu jedem beliebigen Zug gehen, indem Sie
    ihn mit der linken Maustaste anklicken oder mit der mittleren
    Maustaste eine Voransicht dieser Stellung erhalten.
  }
  {
    Sie knnen Partien mit der linken Maustaste per "Drag & Drop" im
    <a Switcher>Datenbank-Umschalter</a> von einer Datenbank in eine
    andere kopieren.
  }
  {
    Scid kann PGN-Dateien selbst dann ffnen, wenn sie mit Gzip
    komprimiert wurden (Dateiname mit Erweiterung .gz). PGN-Dateien
    werden schreibgeschtzt geffnet. Wenn Sie also eine PGN-Datei
    editieren wollen, erstellen Sie eine neue Scid-Datenbank und
    kopieren die PGN-Datei mit dem <a Switcher>Datenbank-Umschalter</a>
    dorthin.
  }
  {
    Wenn Sie eine groe Datenbank haben, die Sie oftmals mit dem
    <a Tree>Zugbaumfenster</a> nutzen, lohnt es sich,
    <b>Cache-Datei fllen</b> im Dateimen des Zugbaumfensters zu
    whlen. Damit merken Sie sich Zugbaum-Statistiken fr viele
    hufige Erffnungspositionen und beschleunigen den Zugriff auf
    den Zugbaum fr die Datenbank.
  }
  {
    Das <a Tree>Zugbaum</a>-Fenster kann Ihnen alle Zge zeigen, die
    in der aktuellen Position gespielt wurden, aber wenn Sie auch alle
    Zugfolgen sehen wollen, mit denen diese Stellung erreicht wurde,
    finden Sie diese, wenn Sie einen <a Reports Opening>Erffnungsbericht</a>
    erstellen.
  }
  {
    Klicken Sie mit der linken oder rechten Maustaste auf die berschrift
    einer Spalte im <a GameList>Partieliste</a>-Fenster , um ihre
    Breite anzupassen.
  }
  {
    Mit dem Fenster <a PInfo>Spielerinformation</a> (um es zu ffnen,
    klicken Sie einfach auf einen Spielernamen im Informationsbereich
    unter dem Hauptfenster-Schachbrett) knnen Sie auf einfache Weise
    den <a Searches Filter>Filter</a> so einstellen, da er alle Partien
    eines bestimmten Spielers mit einem bestimmten Ergebnis enthlt,
    indem Sie auf irgendeinen <red>in Rot</red> dargestellten Wert
    klicken.
  }
  {
    Beim Erffnungsstudium kann es sehr hilfreich sein, fr eine wichtige
    Position eine <a Searches Board>Brettsuche</a> mit der <b>Bauern</b>-
    oder <b>Linien</b>-Option durchzufhren, was andere Erffnungen
    entdecken knnte, die zur selben Bauernstruktur fhren.
  }
  {
    Im Informationsbereich (unterhalb des Schachbretts) knnen Sie mit
    der rechten Maustaste ein Men zur Gestaltung der Ausgabe aktivieren.
    Zum Beispiel knnen Sie Scid veranlassen, den nchsten Zug zu
    verstecken, was ntzlich ist, wenn man zum Trainieren eine Partie
    nachspielt und die Zge zu erraten versucht.
  }
  {
    Wenn Sie fr eine groe Datenbank oftmals eine umfangreiche
    Datenbank-<a Maintenance>Wartung</a> durchfhren, knnen Sie
    mehrere Wartungsarbeiten gleichzeitig mit dem
    <a Maintenance Cleaner>Bereiniger</a> ausfhren.
  }
  {
    Wenn Sie eine groe Datenbank haben, wo die meisten Partien einen
    Turniereintrag besitzen und Sie wollen die Partien nach Datum
    sortiert haben, erwgen Sie ein <a Sorting>Sortieren</a> nach
    Turnierdatum und Turnier anstatt nach Datum und Turnier, da
    Ihnen das hilft, Partien desselben Turniers mit unterschiedlichen
    Daten zusammen zu halten (natrlich unter der Voraussetzung, da
    sie alle dasselbe Turnierdatum haben).
  }
  {
    Es ist eine gute Idee, vor einem <a Maintenance Twins>Dubletten
    lschen</a> eine <a Maintenance Spellcheck>Schreibkorrektur</a>
    Ihrer Datenbank durchzufhren, da es dies Scid ermglicht, mehr
    Dubletten zu finden und zum Lschen vorzumerken.
  }
  {
    <a Flags>Kennzeichen</a> sind ntzlich, um Datenbankpartien mit
    Charakteristiken zu versehen, nach denen Sie zu einem spteren
    Zeitpunkt vielleicht suchen wollen, wie etwa Bauernstruktur, Taktik
    etc. Sie knnen mit der <a Searches Header>Partiedaten-Suche</a>
    nach Kennzeichen suchen.
  }
  {
    Wenn Sie eine Partie nachspielen und einige Zge ausprobieren
    wollen, ohne die Partie zu verndern, schalten Sie einfach den
    Testmodus ein (mit der Tastenkombination <b>Strg+Leerzeichen</b>
    oder mit dem Symbol aus der Werkzeugleiste), und wenn Sie fertig
    sind, schalten Sie ihn wieder aus, um zur ursprnglichen Partie
    zurckzukommen.
  }
  {
    Um die prominentesten Partien (Spieler mit hohen Elo-Zahlen)
    zu finden, die eine bestimmte Position erreicht haben, ffnen
    Sie das <a Tree>Zugbaum</a>-Fenster und dort die Liste der
    besten Partien. Sie knnen sogar die Liste der besten Partien
    auf Partien mit einem bestimmten Ergebnis begrenzen.
  }
  {
    Eine ausgezeichnete Methode, eine Erffnung mit Hilfe einer groen
    Datenbank zu studieren, ist, den Trainingsmodus im
    <a Tree>Zugbaum</a>-Fenster zu aktivieren und dann gegen die
    Datenbank zu spielen, um zu sehen, welche Zge hufig vorkommen.
  }
  {
    Wenn Sie zwei Datenbanken geffnet haben und die
    <a Tree>Zugbaum</a>-Statistik der ersten Datenbank sehen wollen,
    whrend Sie eine Partie der zweiten Datenbank untersuchen, drcken
    Sie einfach den Schalter <b>Anbinden</b> im Zugbaumfenster, um die
    Partie an die erste Datenbank zu binden, und wechseln dann zur
    zweiten Datenbank.
  }
  {
    Die <a Tmt>Turniersuche</a> ist nicht nur zum Auffinden eines
    bestimmten Turniers ntzlich, sondern auch um zu sehen, an welchen
    Turnieren ein bestimmter Spieler vor kurzem teilgenommen hat,
    oder um die Spitzenturniere in einem bestimmten Land anzuzeigen.
  }
  {
    Es gibt eine Reihe hufiger Stellungsmuster, die im Fenster
    <a Searches Material>Material/Muster</a>-Suche definiert sind und
    die Ihnen beim Erffnungs- oder Mittelspielstudium ntzlich sein
    knnen.
  }
  {
    Wenn Sie im Fenster <a Searches Material>Material/Muster</a>-Suche
    nach einer bestimmten Materialkonstellation suchen, ist es oftmals
    hilfreich, die Suche auf Partien zu beschrnken, die mindestens fr
    einige Halbzge auf das Suchmuster passen, um Partien auszusondern,
    wo die gesuchte Konstellation nur kurz vorkam.
  }
  {
    Wenn Sie eine wichtige Datenbank haben, die Sie nicht versehentlich
    verndern wollen, whlen Sie <b>Schreibschutz...</b> im
    <b>Datei</b>-Men, nachdem Sie sie geffnet haben, oder ndern Sie
    ihre Dateizugriffsrechte auf "nur Lesen".
  }
  {
    Wenn Sie XBoard oder WinBoard benutzen (oder ein anderes
    Schachprogramm, das Schachpositionen in FEN-Standardnotation in die
    Zwischenablage kopieren kann) und wollen dessen aktuelle
    Schachposition nach Scid kopieren, ist der schnellste und einfachste
    Weg, <b>Position sichern</b> im Dateimen von XBoard/Winboard zu
    whlen, danach <b>Stellung einfgen</b> in Scids Men "Bearbeiten".
  }
  {
    Die <a Searches Header>Partiedaten-Suche</a> ignoriert bei
    Spieler/Turnier/Ort/Runden-Namen Gro- und Kleinschreibung.  Sie
    knnen sie aber bercksichtigen und gleichzeitig
    Platzhalterzeichen verwenden (mit "?" = irgendein einzelnes
    Zeichen und "*" = null oder mehr Zeichen), wenn Sie den Suchtext
    in Anfhrungszeichen ("...")  eingeben. Beispielsweise geben Sie
    "*BEL" (mit den Anfhrungszeichen) im Ortsfeld ein, um alle in
    Belgien, nicht aber in Belgrad gespielten Partien zu finden.
  }
  {
    Wenn Sie einen Partiezug korrigieren wollen, ohne die danach
    gespielten Zge zu verlieren, ffnen Sie das
    <a Import>Import</a>-Fenster, klicken auf <b>Aktuelle Partie
    einfgen</b>, editieren den falschen Zug und whlen dann
    <b>Importieren</b>.
  }
  {
    Wenn Sie eine ECO-Klassifikationsdatei geladen haben, knnen Sie
    zur am weitest klassifizierten Position der aktuellen Partie mit
    <b>Erffnung identifizieren</b> im <b>Partie</b>-Men gehen
    (Tastenkombination: Strg+Umsch+D).
  }
  {
    Wenn Sie vor dem ffnen einer Datei ihre Gre oder das Datum ihrer
    letzten Modifikation berprfen wollen, ffnen Sie sie mit der
    <a Finder>Dateisuche</a>.
  }
  {
    Eine <a Repertoire>Repertoire</a>-Datei ist eine ausgezeichnete
    Methode, Ihre favorisierten Erffnungsvarianten im Auge zu behalten
    und die Partien zu finden, wo diese Varianten gespielt wurden.
    Wenn Sie erst einmal Ihre Erffnungen in einer Repertoire-Datei
    gespeichert haben, knnen Sie jedesmal, wenn Sie eine neue Datei
    mit Partien haben, eine Repertoire-Suche durchfhren und die Partien
    mit Ihren favorisierten Erffnungen betrachten.
  }
  {
    Mit einem <a Reports Opening>Erffnungsbericht</a> kann man sehr gut
    mehr ber eine bestimmte Position lernen. Sie knnen die Erfolgsrate
    sehen, ob sie zu vielen Kurzremis fhrt und die typischen
    positionellen Themen.
  }
  {
    Sie knnen die gebruchlichsten Kommentarsymbole (!, !?, += etc.)
    dem aktuellen Zug oder der aktuellen Stellung mit Tastenkombinationen
    hinzufgen, ohne den Kommentareditor benutzen zu mssen -- um
    beispielsweise ein "!" hinzuzufgen, tippen Sie "!" und danach die
    Eingabetaste. Zu den Details siehe die Hilfeseite <a Moves>Zge
    eingeben</a>.
  }
  {
    Wenn Sie Erffnungen in einer Datenbank mit dem <a Tree>Zugbaum</a>
    betrachten, knnen Sie eine ntzlichen bersicht erhalten, welche
    Erfolge mit der aktuellen Erffnung in der letzten Zeit und zwischen
    Spitzenspielern erzielt wurden, indem Sie das Statistikfenster
    ffnen (Tastenkombination: Strg-I).
  }
  {
    Sie knnen die Gre des Hauptfensters ndern, indem Sie die
    <b>Strg</b>-Taste gedrckt halten und dann die Cursortaste
    <b>Links</b> oder <b>Rechts</b> drcken.
  }
  {
    Nach einer <a Searches>Suche</a> knnen Sie leicht durch alle
    passenden Partien blttern, indem Sie die <b>Strg</b>-Taste gedrckt
    halten und dann die Cursortaste <b>Auf</b> oder <b>Ab</b> drcken,
    um die vorherige bzw. nchste Partie im <a Searches Filter>Filter</a>
    zu laden.
  }
  {
    ber die Tasten <b>F2</b> und <b>F3</b> knnen direkt die letzten beiden Analyse-Engines gestartet werden, ohne dies nochmal auswhlen zu mssen. 
  }
}

set helpTitle(D,Appearance) "SCID-Oberflche anpassen"
set helpText(D,Appearance) {<h1>Scid-Oberflche anpassen</h1>
  <p>
  Scid hat einige Optionen um die Oberflche anzupassen.
  </p>
  <h3><name Themes>TTK-Designs konfigurieren</name></h3>
  <p>
    Ab Version 4.7 knnen neue Oberflchen-Designs installiert und ausgewhlt
    werden. Mit den TTK-Designs knnen verschiedene Erscheinungsbilder der
    SCID-Oberflche realisiert werden.<br>
    Im Scid-Repository steht ein mehrfarbiges Set von Designs zur direkten Nutzung zur Verfgung:
    <li><url https://sourceforge.net/projects/scid/files/Scid/Additional Files/>https://sourceforge.net/projects/scid/files/Scid/Additional Files</url> -- Home / Scid / Additional Files</li><br><br>
    Weitere Designs knnen auch unter folgenden Adressen heruntergeladen werden:
    <li><url https://wiki.tcl.tk/48689>https://wiki.tcl.tk/48689</url> -- wiki.tcl.tk List of ttk Themes</li>
    <li><url https://github.com/RedFantom/ttkthemes/tree/master/ttkthemes/themes>https://github.com/RedFantom/ttkthemes</url>
    -- RedFantom Sammlung von ttk-Themen</li><br><br>
    Zur Installation der Designs gehen Sie wie folgt vor:<br>
    <li>Entpacken Sie die scidthemes-Dateien in ein beliebiges Verzeichnis.</li>
    <li>Designs laden: ber den Menpunkt <b>Optionen - Design - Design(s) laden</b> whlen Sie die Datei pkgIndex.tcl aus dem Verzeichnis,
    in dem die Designs abgelegt sind.</li>
    <li>Design auswhlen: ber den Menpunkt <b>Optionen - Design - "Designname"</b>, z.b. scidblue scidmint scidpurple scidpurple scidsand scidpink,
    whlen Sie das zu verwendendte Design aus.</li>
    <li><b>Hinweis:</b> pkgIndex.tcl sind Dateien, die zustzlichen tcl-Pakete nachladen. Verwenden Sie nur pkgIndex.tcl Dateien, die auch TTK-Designs enthalten.</li>
    </p>
  <h3><name MenuColors>Farben der Mens einstellen</name></h3>
  <p>
    TTK-Designs besitzen technischbedingt keine angepassten Eigenschaften und
    Farben fr Mens. Die Farben fr Mens mssen daher gesondert angepasst
    und auf die Farben von Designs abgestimmt werden.<br>
    Unter <b>Optionen - Menfarben einstellen</b> knnen die Farben fr das Men konfiguriert werden:<br>
    <li>Hintergrundfarbe des Hauptmens</li>
    <li>Vorder- und Hintergrundfarbe aller Mens</li>
    <li>Vorder- und Hintergrundfarbe des ausgewhlten Meneintrages</li>
    <li>Farbe einer ausgewhlten Option im Men</li>
    <li><b>Hinweis:</b> Unter WINDOWS und MACOS wird fr die Hauptmenleiste die
    Systemeinstellungen verwendet und die konfigurierten Farben ignoriert.</li>
  </p>
  <p>
  Nach dem Konfigurieren des Design und der Menfarben die Einstellungen mit <b>Optionen - Optionen speichern</b> speichern.
  </p>
  <p><footer>(Erstellt: Scid 4.7, August 2018)</footer></p>
}

set helpTitle(D,SeriousGame) "Ernste Partie"
set helpText(D,SeriousGame) {<h1>Ernste Partie</h1>
  <p>
  Ernste Spiele knnen gegen jede <term>UCI</term> Engine gespielt werden.
  Eine Liste aller mglichen Gegner ist im Fenster <term>Spiel konfigurieren</term> angegeben. Die
  Schaltflche <term>UCI-Engine konfigurieren</term> bietet zustzlich Zugriff auf
  die Motorparameter. Standardmig wird die Einstellungen der <a Analyseliste>Analyseliste</a> verwendet.
  </p>
  <p>
  Es kann das Erffnungsbuch und die Erffnung ausgewhlt werden.
  Das Kontrollkstchen <term>Buch benutzen</term> de/aktiviert die Verwendung eines Erffnungsbuchs.
  </p>
  <p>
  Die Sektion <term>Zeitmodus</term> erlaubt die Einstellung der Zeit fr Spieler und Engine.
  Hier sind verschiedene Einstellungen mglich:
  <ul>
     <li><term>Zeit + Bonus</term> gibt die Zeit fr das gesamte Spiel an und eine mgliche
     Bonuszeit pro Zug (Fisher-Uhr). Die
     Standardeinstellung ist 5 Minuten pro Spiel und 10 Sekunden Inkrement pro Spiel.
     Beachten Sie, dass die
     Zeiten fr Schwarz und Wei unabhngig voneinander eingestellen knnen. Dies ermglicht
     eine kurze Zeitspanne fr den Motor einzustellen und eine lngere
     Zeit des Denkens fr den Spieler.
     </li>
     <li><term>Feste Tiefe</term> setzt die Zeit pro Spiel nicht, sondern
     die Tiefe, die der Motor in halben Zgen berechnet. Da dies der Engine
     die Mglichkeit nimmt, bei Bedarf tiefer zu rechnen, wird der
     Computer bestimmte Kombinationen nicht sehen, der Motor
     kann schwcher spielen und somit einen besseren Trainingspartner bieten.
     </li><p>
     <b>Tipp</b>: Einige, Engines bieten auch an
     ihre Strke in Elo-Einheiten einzustellen. Dies ist hchstwahrscheinlich ein
     geeigneterer Algorithmus als die Begrenzung der Suchtiefe.
     </p>
     <li><term>Knoten</term> ist eine hnlich Einschrnkung der Suchtiefe,
     aber hier stoppt der Motor nach der Auswertung eines bestimmten
     Anzahl der Positionen seine Berechnungen. (Die Vorgabe ist 10.000.)
     </li>
     <li><term>Sekunden pro Zug</term> erlaubt dem Motor, eine
     maximale Zeit fr die Berechnung eines Zuges. Einige
     Engines ziehen unter bestimmten Umstnden schneller, aber sie werden
     das hier eingestellte Zeitlimit nicht berschreiten. Wie <Term>Feste Tiefe</Term>Term
     und <term>Knoten</term> schrnkt auch dies die Spielstrke der Engine ein.
     </li>
  </ul>
  </p>
  <p>
  Ernste Partien knnen ab der aktuellen Brettposition beginnen, wenn die Box
  <term>Von aktueller Position starten</term> aktiviert ist. Dies ermglicht
  z.B. zum Ausspielen von definierten Mittelspielpositionen, die sich aus einer
  Erffnung ergeben haben.
  </p>
  <p>
  <term>Berechnung im Hintergrund</term> (manchmal auch Ponder genannt)
  erlaubt es der Engine, whrend der Spieler am Zug ist zu Rechnen. Wenn das Spiel
  auf eine feste Zeit pro Zug eingestellt ist, schwcht das den
  Motor.
  </p>
  <p>
  <term>Coach schaut zu</term> ffnet ein Dialogangebot, um
  einen Zug zurck, wenn der Spieler einen Fehler gemacht hat (aufgrund der Motoren
  Auswertung seines letzten Zuges).
  </p>
  <p>
  <term>Bewertung hinzufgen</term> fgt im Kommentar der Partie fr jeden Zug der Engine
  die Stellungsbewertung der Engine hinzu.
  </p>
  <p>
  Fr das Training von Erffnungen kann die Option <term>Ausgewhlte Erffnung</term>
  verwendet werden. In der Liste kann man die zu spielende Erffnung auswhlen. Der
  Spieler sollte dann der gewhlten Erffnung folgen, ansonsten fragt Scid
  ob der Zug zurckgenommen werden soll.
  </p>
  <p>
  Nach der Einstellung aller Parameter des Spiels und dem Drcken des Knopfes Spielen wird die Partie gestartet.
  Beachten Sie, dass es einige Zeit dauern kann, bis die Schachengine startet und richtig initialisiert ist.
  </p>
  <p><footer>(Erstellt: Scid 4.7, August 2018)</footer></p>
}
### End of file: deutsch.tcl
