/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.java.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.SortOrder;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.java.ClassNode;
import org.graalvm.visualvm.heapviewer.java.JavaHeapFragment;
import org.graalvm.visualvm.heapviewer.java.impl.Bundle;
import org.graalvm.visualvm.heapviewer.model.DataType;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNode;
import org.graalvm.visualvm.heapviewer.model.HeapViewerNodeFilter;
import org.graalvm.visualvm.heapviewer.model.Progress;
import org.graalvm.visualvm.heapviewer.model.RootNode;
import org.graalvm.visualvm.heapviewer.model.TextNode;
import org.graalvm.visualvm.heapviewer.ui.HeapViewPlugin;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.TreeTableView;
import org.graalvm.visualvm.heapviewer.ui.TreeTableViewColumn;
import org.graalvm.visualvm.lib.jfluid.heap.Field;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectArrayInstance;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;

public class ClassHierarchyPlugin
extends HeapViewPlugin {
    private static final JavaClass NO_CLASS = new FakeClass();
    private static final JavaClass EMPTY_CLASS = new FakeClass();
    private final Heap heap;
    private JavaClass selected;
    private final TreeTableView objectsView;

    public ClassHierarchyPlugin(HeapContext context, HeapViewerActions actions) {
        super(Bundle.ClassHierarchyPlugin_Name(), Bundle.ClassHierarchyPlugin_Description(), Icons.getIcon((String)"HeapWalkerIcons.Classes"));
        this.heap = context.getFragment().getHeap();
        this.objectsView = new TreeTableView("java_objects_hierarchy", context, actions, TreeTableViewColumn.classesPlain(this.heap)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected HeapViewerNode[] computeData(RootNode root, Heap heap, String viewID, HeapViewerNodeFilter viewFilter, List<DataType> dataTypes, List<SortOrder> sortOrders, Progress progress) throws InterruptedException {
                JavaClass javaClass;
                TreeTableView treeTableView = ClassHierarchyPlugin.this.objectsView;
                synchronized (treeTableView) {
                    javaClass = ClassHierarchyPlugin.this.selected;
                }
                if (javaClass != null) {
                    String className;
                    JavaClass plainClass;
                    if (javaClass == EMPTY_CLASS) {
                        return new HeapViewerNode[]{new TextNode(Bundle.ClassHierarchyPlugin_NoInformation())};
                    }
                    if (javaClass.isArray() && (plainClass = heap.getJavaClassByName(className = javaClass.getName().replace("[]", ""))) != null) {
                        javaClass = plainClass;
                    }
                    SuperClassNode node = null;
                    SuperClassNode firstNode = null;
                    SuperClassNode previousNode = null;
                    Thread worker = Thread.currentThread();
                    while (javaClass != null) {
                        node = new SuperClassNode(javaClass);
                        if (firstNode == null) {
                            firstNode = node;
                        } else {
                            previousNode.setChildren(new HeapViewerNode[]{node});
                        }
                        javaClass = javaClass.getSuperClass();
                        previousNode = node;
                        if (!worker.isInterrupted()) continue;
                        throw new InterruptedException();
                    }
                    node.setChildren(HeapViewerNode.NO_NODES);
                    return new HeapViewerNode[]{firstNode};
                }
                return new HeapViewerNode[]{new TextNode(Bundle.ClassHierarchyPlugin_NoSelection())};
            }

            @Override
            protected void childrenChanged() {
                RootNode root = this.getRoot();
                while (root != null) {
                    this.expandNode(root);
                    root = root.getNChildren() > 0 ? root.getChild(0) : null;
                }
            }
        };
    }

    @Override
    protected JComponent createComponent() {
        return this.objectsView.getComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void closed() {
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            this.selected = NO_CLASS;
        }
        this.objectsView.closed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void nodeSelected(HeapViewerNode node, boolean adjusting) {
        JavaClass sel;
        JavaClass javaClass = sel = node == null ? null : HeapViewerNode.getValue(node, DataType.CLASS, this.heap);
        if (sel != null && sel.getSuperClass() == null && !"java.lang.Object".equals(sel.getName())) {
            sel = EMPTY_CLASS;
        }
        TreeTableView treeTableView = this.objectsView;
        synchronized (treeTableView) {
            if (Objects.equals(this.selected, sel)) {
                return;
            }
            this.selected = sel;
        }
        this.objectsView.reloadView();
    }

    public static class Provider
    extends HeapViewPlugin.Provider {
        @Override
        public HeapViewPlugin createPlugin(HeapContext context, HeapViewerActions actions, String viewID) {
            if (JavaHeapFragment.isJavaHeap(context)) {
                return new ClassHierarchyPlugin(context, actions);
            }
            return null;
        }
    }

    private static class FakeClass
    implements JavaClass {
        private FakeClass() {
        }

        public Object getValueOfStaticField(String name) {
            throw new UnsupportedOperationException("Not supported.");
        }

        public long getAllInstancesSize() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean isArray() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Instance getClassLoader() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public ObjectArrayInstance getSigners() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Instance getProtectionDomain() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<Field> getFields() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getInstanceSize() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<Instance> getInstances() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Iterator<Instance> getInstancesIterator() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public int getInstancesCount() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public long getRetainedSizeByClass() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public long getJavaClassId() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public String getName() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public List<FieldValue> getStaticFieldValues() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Collection<JavaClass> getSubClasses() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public JavaClass getSuperClass() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public Heap getHeap() {
            throw new UnsupportedOperationException("Not supported.");
        }

        public boolean equals(Object o) {
            return o == this;
        }

        public int hashCode() {
            return -1;
        }
    }

    private static class SuperClassNode
    extends ClassNode {
        SuperClassNode(JavaClass javaClass) {
            super(javaClass);
        }

        @Override
        protected void setChildren(HeapViewerNode[] ch) {
            super.setChildren(ch);
        }

        @Override
        public boolean isLeaf() {
            return this.getChildCount() == 0;
        }
    }
}

