/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.swing;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.BorderFactory;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MenuButton
extends JMenuItem
implements ChangeListener {
    private static final String CONSUME_EVENT_KEY = "PopupMenu.consumeEventOnClose";
    private Object originalConsumeEvent;
    private final Color foreground = this.getForeground();
    private final Color background = this.getBackground();
    private final boolean opaque = this.isOpaque();
    private boolean listening;
    private boolean hovered;
    private boolean skipGainedFocus;

    public MenuButton(String text) {
        this(text, false);
    }

    public MenuButton(String text, final boolean selectable) {
        super(text);
        this.setModel(new JToggleButton.ToggleButtonModel(){

            @Override
            public void setSelected(boolean b) {
                if (!selectable) {
                    return;
                }
                boolean selected = this.isSelected();
                if (selected == b) {
                    return;
                }
                super.setSelected(b);
                if (selected != this.isSelected()) {
                    if (selected) {
                        MenuButton.this.setForeground(MenuButton.this.foreground);
                        MenuButton.this.setBackground(MenuButton.this.background);
                        MenuButton.this.setOpaque(MenuButton.this.opaque);
                        MenuButton.this.repaint();
                        MenuButton.this.deselected();
                    } else {
                        MenuButton.this.setForeground(Color.WHITE);
                        MenuButton.this.setBackground(UIManager.getColor("List.selectionBackground"));
                        MenuButton.this.setOpaque(true);
                        MenuButton.this.repaint();
                        MenuButton.this.selected();
                    }
                }
            }
        });
        this.setFocusable(true);
        this.setRolloverEnabled(true);
        this.setBorder(BorderFactory.createEmptyBorder(0, -11, 0, 0));
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.hovered = true;
                MenuButton.this.showHover();
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.hovered = true;
                MenuButton.this.showHover();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MenuButton.this.hovered = false;
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.hideHover();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.requestFocusInWindow();
                MenuButton.this.showHover();
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.requestFocusInWindow();
                MenuButton.this.showHover();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isLeftMouseButton(e)) {
                    MenuButton.this.clicked();
                    if (selectable) {
                        MenuButton.this.setSelected(true);
                    }
                }
            }
        };
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e) {
                if (e.getKeyChar() == ' ' || e.getKeyChar() == '\n') {
                    MenuButton.this.clicked();
                    if (selectable) {
                        MenuButton.this.setSelected(true);
                    }
                }
            }
        });
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                if (MenuButton.this.skipGainedFocus) {
                    MenuButton.this.skipGainedFocus = false;
                } else {
                    if (!MenuButton.this.canSelect()) {
                        return;
                    }
                    MenuButton.this.showHover();
                    MenuButton.this.scrollRectToVisible(MenuButton.this.getBounds());
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                MenuButton.this.hovered = false;
                if (!MenuButton.this.canSelect()) {
                    return;
                }
                MenuButton.this.hideHover();
            }
        });
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (MenuSelectionManager.defaultManager().getSelectedPath().length == 0 && this.hovered) {
            if (this.isFocusOwner()) {
                SwingUtilities.invokeLater(this::showHover);
            } else {
                this.showHover();
            }
        }
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        if (this.canSelect()) {
            super.processMouseEvent(e);
        }
    }

    protected void clicked() {
    }

    protected void selected() {
    }

    protected void deselected() {
    }

    private void showHover() {
        this.originalConsumeEvent = UIManager.get(CONSUME_EVENT_KEY);
        UIManager.put(CONSUME_EVENT_KEY, Boolean.FALSE);
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        msm.setSelectedPath(new MenuElement[]{this});
        if (!this.listening) {
            msm.addChangeListener(this);
            this.listening = true;
        }
        this.repaint();
    }

    private void hideHover() {
        MenuSelectionManager msm = MenuSelectionManager.defaultManager();
        if (this.listening) {
            msm.removeChangeListener(this);
            this.listening = false;
        }
        msm.clearSelectedPath();
        UIManager.put(CONSUME_EVENT_KEY, this.originalConsumeEvent);
        this.repaint();
    }

    private boolean canSelect() {
        MenuElement[] sel = MenuSelectionManager.defaultManager().getSelectedPath();
        if (sel.length == 0) {
            return true;
        }
        return sel[0] instanceof MenuButton;
    }
}

