/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JToolBar;
import javax.swing.border.AbstractBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicToolBarUI;
import org.graalvm.visualvm.lib.ui.UIUtils;

public class FlatToolBar
extends JToolBar {
    public static final int BUTTON_STYLE_HORIZONTAL = 1;
    public static final int BUTTON_STYLE_VERICAL = 2;
    int buttonStyle = 1;

    public FlatToolBar() {
        this(0, 1);
    }

    public FlatToolBar(int orientation) {
        this(orientation, 1);
    }

    public FlatToolBar(int orientation, int buttonStyle) {
        super(orientation);
        this.buttonStyle = buttonStyle;
        if (!UIUtils.isGTKLookAndFeel()) {
            this.setUI(new MyToolBarUI());
        }
        this.setFloatable(false);
        this.setOpaque(false);
        this.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        if (comp instanceof AbstractButton) {
            AbstractButton ab = (AbstractButton)comp;
            ab.setContentAreaFilled(false);
            ab.setMargin(new Insets(3, 3, 3, 3));
            if (this.buttonStyle == 2) {
                ab.setVerticalTextPosition(3);
                ab.setHorizontalTextPosition(0);
            }
        }
        super.addImpl(comp, constraints, index);
    }

    @Override
    protected JButton createActionComponent(Action a) {
        JButton b = super.createActionComponent(a);
        if (this.buttonStyle == 2) {
            b.putClientProperty("hideActionText", Boolean.FALSE);
            String iconBase = (String)a.getValue("iconBase");
            if (iconBase != null) {
                try {
                    System.err.println("URL for: " + FlatToolBar.insertBeforeSuffix(iconBase, "32"));
                    URL url = a.getClass().getResource(FlatToolBar.insertBeforeSuffix(iconBase, "32"));
                    System.err.println("is: " + url);
                    b.setIcon(new ImageIcon(url));
                }
                catch (Exception e) {
                    e.printStackTrace(System.err);
                }
            }
        }
        return b;
    }

    static String insertBeforeSuffix(String path, String toInsert) {
        String withoutSuffix = path;
        String suffix = "";
        if (path.lastIndexOf(46) >= 0) {
            withoutSuffix = path.substring(0, path.lastIndexOf(46));
            suffix = path.substring(path.lastIndexOf(46));
        }
        return withoutSuffix + toInsert + suffix;
    }

    private static class MyToolBarUI
    extends BasicToolBarUI {
        private AbstractBorder myRolloverBorder = new CompoundBorder(new FlatRolloverButtonBorder(Color.GRAY, Color.LIGHT_GRAY), new FlatMarginBorder());

        MyToolBarUI() {
        }

        @Override
        protected void setBorderToRollover(Component c) {
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                if (b.getBorder() instanceof UIResource) {
                    b.setBorder(this.myRolloverBorder);
                }
                b.setRolloverEnabled(true);
            }
        }
    }

    public static class FlatRolloverButtonBorder
    extends AbstractBorder {
        private Color normal;
        private Color pressed;
        private Color roll;
        private boolean borderPainted = false;

        public FlatRolloverButtonBorder(Color pressed, Color roll) {
            this.pressed = pressed;
            this.roll = roll;
            this.borderPainted = false;
        }

        public FlatRolloverButtonBorder(Color pressed, Color roll, Color normal) {
            this.pressed = pressed;
            this.roll = roll;
            this.normal = normal;
            this.borderPainted = true;
        }

        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            insets.top = 2;
            insets.right = 3;
            insets.bottom = 3;
            insets.left = 3;
            return insets;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            if (model.isRollover() && (!model.isPressed() || model.isArmed()) || model.isSelected()) {
                Color oldColor = g.getColor();
                g.translate(x, y);
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    g.setColor(this.pressed);
                    g.drawRect(0, 0, w - 1, h - 1);
                } else {
                    g.setColor(this.roll);
                    g.drawRect(0, 0, w - 1, h - 1);
                }
                g.translate(-x, -y);
                g.setColor(oldColor);
            } else if (this.borderPainted) {
                Color oldColor = g.getColor();
                g.translate(x, y);
                g.setColor(this.normal);
                g.drawRect(0, 0, w - 1, h - 1);
                g.translate(-x, -y);
                g.setColor(oldColor);
            }
        }
    }

    public static class FlatMarginBorder
    extends AbstractBorder {
        @Override
        public Insets getBorderInsets(Component c) {
            return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
        }

        @Override
        public Insets getBorderInsets(Component c, Insets insets) {
            Insets margin = null;
            if (c instanceof AbstractButton) {
                AbstractButton b = (AbstractButton)c;
                margin = b.getMargin();
            }
            insets.top = margin != null ? margin.top : 0;
            insets.left = margin != null ? margin.left : 0;
            insets.bottom = margin != null ? margin.bottom : 0;
            insets.right = margin != null ? margin.right : 0;
            return insets;
        }
    }
}

