/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.r;

import java.util.Collection;
import java.util.List;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.TruffleFrame;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.r.RObject;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectsView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleSummaryView;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.JavaClass;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;
import org.graalvm.visualvm.lib.profiler.heapwalk.details.api.DetailsSupport;

final class RViews {
    RViews() {
    }

    public static class ObjectsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (RHeapFragment.isRHeap(context)) {
                return new TruffleObjectsView(RLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class SummaryObjectsProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (RHeapFragment.isRHeap(context)) {
                return new TruffleSummaryView.ObjectsSection(RLanguage.instance(), context, actions, actionProviders);
            }
            return null;
        }
    }

    private static class SummaryOverview
    extends TruffleSummaryView.OverviewSection {
        SummaryOverview(HeapContext context) {
            super(context, 3, 3);
        }

        @Override
        protected void computeEnvironmentData(Object[][] environmentData) {
            RObject envObj;
            TruffleFrame envFrame;
            Instance envInstance;
            super.computeEnvironmentData(environmentData);
            environmentData[1][0] = Bundle.RViews_Version();
            environmentData[2][0] = Bundle.RViews_Platform();
            RHeapFragment fragment = (RHeapFragment)this.getContext().getFragment();
            Heap heap = fragment.getHeap();
            JavaClass envClass = heap.getJavaClassByName("com.oracle.truffle.r.runtime.env.REnvironment$Base");
            if (envClass != null && envClass.getInstancesCount() > 0 && RObject.isRObject(envInstance = (Instance)envClass.getInstancesIterator().next()) && (envFrame = (envObj = new RObject(envInstance)).getFrame()) != null && envFrame.isTruffleFrame()) {
                List<FieldValue> fields = envFrame.getLocalFieldValues();
                for (FieldValue field : fields) {
                    String fieldName = field.getField().getName();
                    if (!"R.version".equals(fieldName) && !"version".equals(fieldName) || !(field instanceof ObjectFieldValue)) continue;
                    Instance envI = ((ObjectFieldValue)field).getInstance();
                    if (!RObject.isRObject(envI)) break;
                    RObject env = new RObject(envI);
                    environmentData[1][1] = SummaryOverview.itemValue(env, "version.string", heap);
                    environmentData[2][1] = SummaryOverview.itemValue(env, "system", heap);
                    break;
                }
            }
            if (environmentData[1][1] == null) {
                environmentData[1][1] = Bundle.RViews_Unknown();
            }
            if (environmentData[2][1] == null) {
                environmentData[2][1] = Bundle.RViews_Unknown();
            }
        }

        private static String itemValue(RObject object, String item, Heap heap) {
            item = "(" + item + ")";
            List<FieldValue> items = object.getFieldValues();
            for (FieldValue itemv : items) {
                String itemn = itemv.getField().getName();
                if (itemn == null || !itemn.contains(item)) continue;
                Instance instance = itemv instanceof ObjectFieldValue ? ((ObjectFieldValue)itemv).getInstance() : null;
                return instance == null ? null : DetailsSupport.getDetailsString((Instance)instance);
            }
            return null;
        }
    }

    public static class SummaryOverviewProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (RHeapFragment.isRHeap(context)) {
                return new SummaryOverview(context);
            }
            return null;
        }
    }

    public static class SummaryViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (RHeapFragment.isRHeap(context)) {
                return new TruffleSummaryView(RLanguage.instance(), context, actions);
            }
            return null;
        }
    }
}

