/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.killapp;

import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.graalvm.visualvm.application.Application;
import org.graalvm.visualvm.core.datasupport.DataRemovedListener;
import org.graalvm.visualvm.core.ui.actions.ActionUtils;
import org.graalvm.visualvm.core.ui.actions.MultiDataSourceAction;
import org.graalvm.visualvm.host.Host;
import org.graalvm.visualvm.modules.killapp.Bundle;
import org.netbeans.api.progress.ProgressHandle;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public final class KillAction
extends MultiDataSourceAction<Application> {
    private final Set<Application> lastSelectedApplications;
    private final RequestProcessor killRP;
    private final PropertyChangeListener stateListener;

    public KillAction() {
        super(Application.class);
        this.putValue("Name", Bundle.CTL_KillAction());
        this.putValue("noIconInMenu", Boolean.TRUE);
        this.lastSelectedApplications = new HashSet<Application>();
        this.killRP = new RequestProcessor("KillAction processor", 5);
        this.stateListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                KillAction.this.updateState(ActionUtils.getSelectedDataSources(Application.class));
            }
        };
    }

    protected void actionPerformed(Set<Application> dataSources, ActionEvent ae) {
        for (Application dataSource : dataSources) {
            this.killApplication(dataSource);
        }
    }

    protected boolean isEnabled(Set<Application> dataSources) {
        for (Application application : dataSources) {
            this.lastSelectedApplications.add(application);
            application.addPropertyChangeListener("prop_state", this.stateListener);
            if (application.getState() != 1) {
                return false;
            }
            if (this.isEnabled(application)) continue;
            return false;
        }
        return true;
    }

    protected void updateState(Set<Application> dataSources) {
        if (!this.lastSelectedApplications.isEmpty()) {
            for (Application application : this.lastSelectedApplications) {
                application.removePropertyChangeListener("prop_state", this.stateListener);
            }
        }
        this.lastSelectedApplications.clear();
        super.updateState(dataSources);
    }

    private void killApplication(final Application app) {
        final String pidString = String.valueOf(app.getPid());
        final String[] command = this.getCommand(pidString, false);
        if (command == null) {
            return;
        }
        final Progress handle = new Progress(pidString);
        app.notifyWhenRemoved((DataRemovedListener)handle);
        this.killRP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    Runtime.getRuntime().exec(command);
                    Thread.sleep(5000L);
                    if (app.getState() == 1) {
                        Runtime.getRuntime().exec(KillAction.this.getCommand(pidString, true));
                        KillAction.this.refreshJvms();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                catch (InterruptedException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                finally {
                    handle.finish();
                }
            }
        });
    }

    private void refreshJvms() throws IOException {
        String javaSub = Utilities.isWindows() ? "bin\\java.exe" : "bin/java";
        File java = new File(System.getProperty("java.home"), javaSub);
        if (java.isFile()) {
            String[] command = new String[]{java.getAbsolutePath(), "-version"};
            Runtime.getRuntime().exec(command);
        }
    }

    private boolean isEnabled(Application application) {
        if (Application.CURRENT_APPLICATION.equals((Object)application)) {
            return false;
        }
        return Host.LOCALHOST.equals((Object)application.getHost());
    }

    private String[] getCommand(String pidString, boolean force) {
        if (Utilities.isWindows()) {
            if (force) {
                return new String[]{"taskkill", "/F", "/PID", pidString};
            }
            return new String[]{"taskkill", "/PID", pidString};
        }
        if (Utilities.isUnix()) {
            if (force) {
                return new String[]{"kill", "-9", pidString};
            }
            return new String[]{"kill", pidString};
        }
        assert (false) : "strange os";
        return null;
    }

    private static class Progress
    implements DataRemovedListener<Application> {
        ProgressHandle handle;
        boolean running;

        private Progress(String pid) {
            this.handle = ProgressHandle.createHandle((String)Bundle.MSG_Kill(pid));
            this.handle.setInitialDelay(500);
            this.handle.start();
            this.running = true;
        }

        private synchronized void finish() {
            if (this.running) {
                this.running = false;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        handle.finish();
                        handle = null;
                    }
                });
            }
        }

        public void dataRemoved(Application x) {
            this.finish();
        }
    }
}

