/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.ast;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyElementTypes;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.ast.PyAstElementKt;
import com.jetbrains.python.ast.PyAstElementVisitor;
import com.jetbrains.python.ast.PyAstFStringFragment;
import com.jetbrains.python.ast.PyAstStringElement;
import com.jetbrains.python.psi.impl.PyStringLiteralDecoder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public interface PyAstFormattedStringElement
extends PyAstStringElement,
PyAstElement {
    @NotNull
    default public List<? extends PyAstFStringFragment> getFragments() {
        List list = PyAstElementKt.findChildrenByType((PsiElement)this, (IElementType)PyElementTypes.FSTRING_FRAGMENT);
        if (list == null) {
            PyAstFormattedStringElement.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    default public List<TextRange> getLiteralPartRanges() {
        List textTokens = PyAstElementKt.findChildrenByType((PsiElement)this, PyTokenTypes.FSTRING_TEXT_TOKENS);
        List list = ContainerUtil.map(textTokens, PsiElement::getTextRangeInParent);
        if (list == null) {
            PyAstFormattedStringElement.$$$reportNull$$$0(1);
        }
        return list;
    }

    @Override
    @NotNull
    default public TextRange getContentRange() {
        TextRange textRange = this.getTextRange();
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        Object startToken = PyAstElementKt.findChildByTypeNotNull(this, (IElementType)PyTokenTypes.FSTRING_START);
        Object endToken = PyAstElementKt.findChildByType(this, (IElementType)PyTokenTypes.FSTRING_END);
        TextRange absoluteRange = TextRange.create((int)startToken.getTextRange().getEndOffset(), (int)(endToken != null ? endToken.getTextRange().getStartOffset() : endOffset));
        TextRange textRange2 = absoluteRange.shiftLeft(startOffset);
        if (textRange2 == null) {
            PyAstFormattedStringElement.$$$reportNull$$$0(2);
        }
        return textRange2;
    }

    @Override
    @NotNull
    default public List<Pair<TextRange, String>> getDecodedFragments() {
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        PyStringLiteralDecoder decoder = new PyStringLiteralDecoder(this);
        for (PsiElement child = this.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType childType = child.getNode().getElementType();
            TextRange relChildRange = child.getTextRangeInParent();
            if (PyTokenTypes.FSTRING_TEXT_TOKENS.contains(childType)) {
                result.addAll(decoder.decodeRange(relChildRange));
                continue;
            }
            if (childType != PyElementTypes.FSTRING_FRAGMENT) continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)relChildRange, (Object)child.getText()));
        }
        ArrayList<Pair<TextRange, String>> arrayList = result;
        if (arrayList == null) {
            PyAstFormattedStringElement.$$$reportNull$$$0(3);
        }
        return arrayList;
    }

    @Override
    @NotNull
    default public String getQuote() {
        Object start = PyAstElementKt.findChildByTypeNotNull(this, (IElementType)PyTokenTypes.FSTRING_START);
        String string = start.getText().substring(this.getPrefixLength());
        if (string == null) {
            PyAstFormattedStringElement.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    default public boolean isTerminated() {
        return PyAstElementKt.findChildByType(this, (IElementType)PyTokenTypes.FSTRING_END) != null;
    }

    @Override
    default public boolean isFormatted() {
        return StringUtil.containsIgnoreCase((String)this.getPrefix(), (String)"f");
    }

    @Override
    default public boolean isTemplate() {
        return StringUtil.containsIgnoreCase((String)this.getPrefix(), (String)"t");
    }

    @Override
    default public void acceptPyVisitor(PyAstElementVisitor pyVisitor) {
        pyVisitor.visitPyFormattedStringElement(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/python/ast/PyAstFormattedStringElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFragments";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLiteralPartRanges";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getContentRange";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDecodedFragments";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getQuote";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

