/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.validator;

import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.dictionary.FixedSizedBlockDictionary;
import com.intellij.internal.statistic.eventLog.dictionary.HashSetDictionary;
import com.intellij.internal.statistic.eventLog.validator.DictionaryStorage;
import com.jetbrains.fus.reporting.FileHandle;
import com.jetbrains.fus.reporting.FileStorage;
import com.jetbrains.fus.reporting.FileStorageMode;
import java.io.FileNotFoundException;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/intellij/internal/statistic/eventLog/validator/SimpleDictionaryStorage;", "Lcom/intellij/internal/statistic/eventLog/validator/DictionaryStorage;", "fileStorage", "Lcom/jetbrains/fus/reporting/FileStorage;", "accessMode", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary$AccessMode;", "(Lcom/jetbrains/fus/reporting/FileStorage;Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary$AccessMode;)V", "getAccessMode", "()Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary$AccessMode;", "dictionaries", "", "", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary;", "getFileStorage", "()Lcom/jetbrains/fus/reporting/FileStorage;", "closeAll", "", "getDictionaryByName", "name", "openDictionary", "updateDictionaryByName", "dictionary", "", "ap-validation"})
@SourceDebugExtension(value={"SMAP\nSimpleDictionaryStorage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SimpleDictionaryStorage.kt\ncom/intellij/internal/statistic/eventLog/validator/SimpleDictionaryStorage\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1#2:61\n1855#3,2:62\n*S KotlinDebug\n*F\n+ 1 SimpleDictionaryStorage.kt\ncom/intellij/internal/statistic/eventLog/validator/SimpleDictionaryStorage\n*L\n56#1:62,2\n*E\n"})
public final class SimpleDictionaryStorage
implements DictionaryStorage {
    @NotNull
    private final FileStorage fileStorage;
    @NotNull
    private final Dictionary.AccessMode accessMode;
    @NotNull
    private final Map<String, Dictionary> dictionaries;

    public SimpleDictionaryStorage(@NotNull FileStorage fileStorage, @NotNull Dictionary.AccessMode accessMode) {
        Intrinsics.checkNotNullParameter((Object)fileStorage, (String)"fileStorage");
        Intrinsics.checkNotNullParameter((Object)((Object)accessMode), (String)"accessMode");
        this.fileStorage = fileStorage;
        this.accessMode = accessMode;
        this.dictionaries = new LinkedHashMap();
    }

    public /* synthetic */ SimpleDictionaryStorage(FileStorage fileStorage, Dictionary.AccessMode accessMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            accessMode = Dictionary.AccessMode.RANDOM_FILE_ACCESS;
        }
        this(fileStorage, accessMode);
    }

    @NotNull
    public final FileStorage getFileStorage() {
        return this.fileStorage;
    }

    @NotNull
    public final Dictionary.AccessMode getAccessMode() {
        return this.accessMode;
    }

    private final Dictionary openDictionary(String name) {
        Dictionary dictionary;
        if (!this.fileStorage.exists("")) {
            throw new FileNotFoundException("File storage root doesn't exist");
        }
        FileHandle dictionaryHandle = this.fileStorage.openFileHandle("dictionaries/" + name, FileStorageMode.READ);
        if (!dictionaryHandle.exists()) {
            throw new FileNotFoundException("File dictionaries/" + name + " doesn't exist in file storage");
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.accessMode.ordinal()]) {
            case 1: {
                dictionary = FixedSizedBlockDictionary.Companion.openRandomAccessFile(dictionaryHandle);
                break;
            }
            case 2: {
                dictionary = HashSetDictionary.Companion.openFile(dictionaryHandle);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return dictionary;
    }

    @Override
    @NotNull
    public synchronized Dictionary getDictionaryByName(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Dictionary dictionary = this.dictionaries.get(name);
        if (dictionary != null) {
            Dictionary it = dictionary;
            boolean bl = false;
            return it;
        }
        Dictionary dictionary2 = this.openDictionary(name);
        this.dictionaries.put(name, dictionary2);
        return dictionary2;
    }

    @Override
    public synchronized void updateDictionaryByName(@NotNull String name, @NotNull byte[] dictionary) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)dictionary, (String)"dictionary");
        Dictionary dictionary2 = this.dictionaries.get(name);
        if (dictionary2 != null) {
            dictionary2.close();
        }
        this.dictionaries.remove(name);
        this.fileStorage.write("dictionaries/" + name, dictionary);
    }

    @Override
    public synchronized void closeAll() {
        Iterable $this$forEach$iv = this.dictionaries.values();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Dictionary it = (Dictionary)element$iv;
            boolean bl = false;
            it.close();
        }
        this.dictionaries.clear();
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Dictionary.AccessMode.values().length];
            try {
                nArray[Dictionary.AccessMode.RANDOM_FILE_ACCESS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Dictionary.AccessMode.IN_MEMORY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

