/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.java.dev.psiViewer.debug;

import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorProvider;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.dev.psiViewer.PsiViewerDialog;
import com.intellij.dev.psiViewer.PsiViewerSettings;
import com.intellij.dev.psiViewer.ViewerNodeDescriptor;
import com.intellij.dev.psiViewer.ViewerTreeStructure;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.IndexComparator;
import com.intellij.java.dev.JavaDevBundle;
import com.intellij.java.dev.psiViewer.debug.PsiDebuggerUtilKt;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugPanel;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugPanelKt;
import com.intellij.java.dev.psiViewer.debug.PsiViewerDebugSettings;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.text.DateFormatUtil;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\f\b\u0000\u0018\u0000 52\u00020\u00012\u00020\u0002:\t-./012345B@\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u000b\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000f\u0010\u0010J\b\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002J\n\u0010$\u001a\u0004\u0018\u00010!H\u0002J\u0014\u0010%\u001a\u00020#*\u00020\u00062\u0006\u0010&\u001a\u00020\u001cH\u0002J\n\u0010'\u001a\u0004\u0018\u00010\u0006H\u0002J\u0018\u0010(\u001a\u00020#2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0002J\b\u0010,\u001a\u00020#H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00160\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u001b\u001a\u00070\u001c\u00a2\u0006\u0002\b\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001e\u001a\u00060\u001fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "language", "Lcom/intellij/lang/Language;", "expression", "", "Lcom/intellij/openapi/util/NlsSafe;", "debugSession", "Lcom/intellij/xdebugger/XDebugSession;", "fileName", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lcom/intellij/lang/Language;Ljava/lang/String;Lcom/intellij/xdebugger/XDebugSession;Ljava/lang/String;)V", "watchMode", "", "showWhiteSpace", "showTreeNodes", "treeStructure", "Lcom/intellij/dev/psiViewer/ViewerTreeStructure;", "structureTreeModel", "Lcom/intellij/ui/tree/StructureTreeModel;", "psiTree", "Lcom/intellij/ui/treeStructure/Tree;", "expressionRange", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/annotations/NotNull;", "watchListener", "Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$DebugWatchSessionListener;", "initToolbar", "Ljavax/swing/JComponent;", "refreshPanel", "", "initPsiTree", "selectAndScroll", "textRange", "initEditor", "updatePsiTreeForSelection", "startOffset", "", "endOffset", "dispose", "OpenDialogAction", "WatchModeAction", "DebugWatchSessionListener", "ResetSelection", "ShowWhiteSpaceAction", "ShowTreeNodesAction", "PsiTreeSelectionListener", "EditorListener", "Companion", "intellij.java.dev"})
public final class PsiViewerDebugPanel
extends JPanel
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final EditorEx editor;
    @NotNull
    private final Language language;
    @NotNull
    private final String expression;
    @NotNull
    private final XDebugSession debugSession;
    @Nullable
    private final String fileName;
    private boolean watchMode;
    private boolean showWhiteSpace;
    private boolean showTreeNodes;
    @NotNull
    private final ViewerTreeStructure treeStructure;
    @NotNull
    private final StructureTreeModel<ViewerTreeStructure> structureTreeModel;
    @NotNull
    private final Tree psiTree;
    @NotNull
    private TextRange expressionRange;
    @NotNull
    private final DebugWatchSessionListener watchListener;

    /*
     * WARNING - void declaration
     */
    public PsiViewerDebugPanel(@NotNull Project project, @NotNull EditorEx editor, @NotNull Language language, @NotNull String expression, @NotNull XDebugSession debugSession, @Nullable String fileName) {
        Splitter splitter;
        void $this$treeStructure_u24lambda_u240;
        ViewerTreeStructure viewerTreeStructure;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)debugSession, (String)"debugSession");
        super(new BorderLayout());
        this.project = project;
        this.editor = editor;
        this.language = language;
        this.expression = expression;
        this.debugSession = debugSession;
        this.fileName = fileName;
        this.watchMode = PsiViewerDebugSettings.Companion.getInstance().getWatchMode();
        this.showWhiteSpace = PsiViewerSettings.getSettings().showWhiteSpaces;
        this.showTreeNodes = PsiViewerSettings.getSettings().showTreeNodes;
        ViewerTreeStructure viewerTreeStructure2 = viewerTreeStructure = new ViewerTreeStructure(this.project);
        PsiViewerDebugPanel psiViewerDebugPanel = this;
        boolean bl = false;
        PsiViewerSettings settings = PsiViewerSettings.getSettings();
        $this$treeStructure_u24lambda_u240.setShowWhiteSpaces(settings.showWhiteSpaces);
        $this$treeStructure_u24lambda_u240.setShowTreeNodes(settings.showTreeNodes);
        psiViewerDebugPanel.treeStructure = viewerTreeStructure;
        this.structureTreeModel = new StructureTreeModel((AbstractTreeStructure)this.treeStructure, (Comparator)IndexComparator.getInstance(), (Disposable)this);
        this.psiTree = new Tree();
        TextRange textRange = TextRange.create((int)this.editor.getSelectionModel().getSelectionStart(), (int)this.editor.getSelectionModel().getSelectionEnd());
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"create(...)");
        this.expressionRange = textRange;
        this.watchListener = new DebugWatchSessionListener();
        JComponent toolBar = this.initToolbar();
        this.add((Component)toolBar, "West");
        Splitter $this$_init__u24lambda_u240 = splitter = new Splitter(false, 0.3f);
        boolean bl2 = false;
        $this$_init__u24lambda_u240.setFirstComponent(this.initPsiTree());
        EditorEx editorEx = this.initEditor();
        $this$_init__u24lambda_u240.setSecondComponent(editorEx != null ? editorEx.getComponent() : null);
        Splitter splitter2 = splitter;
        this.add((Component)splitter2, "Center");
    }

    public /* synthetic */ PsiViewerDebugPanel(Project project, EditorEx editorEx, Language language, String string, XDebugSession xDebugSession, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x20) != 0) {
            string2 = null;
        }
        this(project, editorEx, language, string, xDebugSession, string2);
    }

    private final JComponent initToolbar() {
        DefaultActionGroup defaultActionGroup;
        DefaultActionGroup $this$initToolbar_u24lambda_u240 = defaultActionGroup = new DefaultActionGroup();
        boolean bl = false;
        $this$initToolbar_u24lambda_u240.add((AnAction)new OpenDialogAction());
        $this$initToolbar_u24lambda_u240.add((AnAction)new WatchModeAction());
        $this$initToolbar_u24lambda_u240.add((AnAction)new ResetSelection());
        $this$initToolbar_u24lambda_u240.add((AnAction)new ShowWhiteSpaceAction());
        $this$initToolbar_u24lambda_u240.add((AnAction)new ShowTreeNodesAction());
        DefaultActionGroup toolBarActions = defaultActionGroup;
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("PsiDump", (ActionGroup)toolBarActions, false);
        Intrinsics.checkNotNullExpressionValue((Object)actionToolbar, (String)"createActionToolbar(...)");
        ActionToolbar toolbar = actionToolbar;
        toolbar.setTargetComponent((JComponent)this.psiTree);
        JComponent jComponent = toolbar.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    private final void refreshPanel() {
        block0: {
            SuspendContextImpl suspendContext;
            XDebugProcess xDebugProcess = this.debugSession.getDebugProcess();
            JavaDebugProcess javaDebugProcess = xDebugProcess instanceof JavaDebugProcess ? (JavaDebugProcess)xDebugProcess : null;
            DebugProcessImpl debugProcess = javaDebugProcess != null && (javaDebugProcess = javaDebugProcess.getDebuggerSession()) != null ? javaDebugProcess.getProcess() : null;
            DebugProcessImpl debugProcessImpl = debugProcess;
            SuspendContextImpl suspendContextImpl = suspendContext = debugProcessImpl != null && (debugProcessImpl = debugProcessImpl.getSuspendManager()) != null ? debugProcessImpl.getPausedContext() : null;
            DebugProcessImpl debugProcessImpl2 = debugProcess;
            if (debugProcessImpl2 == null || (debugProcessImpl2 = debugProcessImpl2.getManagerThread()) == null) break block0;
            debugProcessImpl2.schedule((DebuggerCommandImpl)new SuspendContextCommandImpl(suspendContext, this, debugProcess){
                final /* synthetic */ PsiViewerDebugPanel this$0;
                final /* synthetic */ DebugProcessImpl $debugProcess;
                {
                    this.this$0 = $receiver;
                    this.$debugProcess = $debugProcess;
                    super($suspendContext);
                }

                public void contextAction(SuspendContextImpl suspendContext) {
                    Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
                    EvaluationContextImpl evalContext = new EvaluationContextImpl(suspendContext, suspendContext.getFrameProxy());
                    XDebuggerEvaluator xDebuggerEvaluator = PsiViewerDebugPanel.access$getDebugSession$p(this.this$0).getDebugProcess().getEvaluator();
                    if (xDebuggerEvaluator == null) {
                        return;
                    }
                    XDebuggerEvaluator evaluator = xDebuggerEvaluator;
                    evaluator.evaluate(PsiViewerDebugPanel.access$getExpression$p(this.this$0), new XDebuggerEvaluator.XEvaluationCallback(this.$debugProcess, evalContext, this.this$0){
                        final /* synthetic */ DebugProcessImpl $debugProcess;
                        final /* synthetic */ EvaluationContextImpl $evalContext;
                        final /* synthetic */ PsiViewerDebugPanel this$0;
                        {
                            this.$debugProcess = $debugProcess;
                            this.$evalContext = $evalContext;
                            this.this$0 = $receiver;
                        }

                        public void errorOccurred(String errorMessage) {
                            Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                            NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                            String string = JavaDevBundle.message("psi.viewer.debug.evaluation.failed", new Object[0]);
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                            notificationGroup.createNotification(string, NotificationType.ERROR);
                            PsiViewerDebugPanelKt.access$getLOG$p().warn("Failed to evaluate PSI expression");
                        }

                        public void evaluated(XValue result) {
                            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                            try {
                                NodeDescriptorProvider nodeDescriptorProvider = result instanceof NodeDescriptorProvider ? (NodeDescriptorProvider)result : null;
                                NodeDescriptorImpl nodeDescriptorImpl = nodeDescriptorProvider != null ? nodeDescriptorProvider.getDescriptor() : null;
                                ValueDescriptorImpl valueDescriptorImpl = nodeDescriptorImpl instanceof ValueDescriptorImpl ? (ValueDescriptorImpl)nodeDescriptorImpl : null;
                                if (valueDescriptorImpl == null) {
                                    return;
                                }
                                ValueDescriptorImpl descriptor = valueDescriptorImpl;
                                Value value = descriptor.getValue();
                                ObjectReference objectReference = value instanceof ObjectReference ? (ObjectReference)value : null;
                                if (objectReference == null) {
                                    return;
                                }
                                ObjectReference psiElemObj = objectReference;
                                Value value2 = PsiDebuggerUtilKt.invokeMethod((DebugProcess)this.$debugProcess, psiElemObj, "getContainingFile", (EvaluationContext)this.$evalContext);
                                ObjectReference objectReference2 = value2 instanceof ObjectReference ? (ObjectReference)value2 : null;
                                if (objectReference2 == null) {
                                    return;
                                }
                                ObjectReference psiFileObj = objectReference2;
                                String string = PsiDebuggerUtilKt.getText(psiFileObj, (DebugProcess)this.$debugProcess, (EvaluationContext)this.$evalContext);
                                if (string == null) {
                                    return;
                                }
                                String fileText = string;
                                TextRange textRange = PsiDebuggerUtilKt.getTextRange(psiElemObj, (DebugProcess)this.$debugProcess, (EvaluationContext)this.$evalContext);
                                if (textRange == null) {
                                    return;
                                }
                                TextRange psiRangeInFile = textRange;
                                DebuggerUIUtil.invokeLater(() -> refreshPanel.contextAction.1.evaluated$lambda$0(this.this$0, psiRangeInFile, fileText));
                            }
                            catch (EvaluateException e) {
                                NotificationGroup notificationGroup = XDebuggerManagerImpl.getNotificationGroup();
                                String string = JavaDevBundle.message("psi.viewer.debug.evaluation.failed", new Object[0]);
                                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                                notificationGroup.createNotification(string, NotificationType.ERROR);
                                PsiViewerDebugPanelKt.access$getLOG$p().warn("Failed to evaluate PSI expression", (Throwable)e);
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private static final void evaluated$lambda$0(PsiViewerDebugPanel this$0, TextRange $psiRangeInFile, String $fileText) {
                            PsiViewerDebugPanel.access$setExpressionRange$p(this$0, $psiRangeInFile);
                            PsiViewerDebugPanel.access$getEditor$p(this$0).getDocument().setReadOnly(false);
                            try {
                                ActionsKt.runWriteAction(() -> refreshPanel.contextAction.1.evaluated$lambda$0$0(this$0, $fileText));
                            }
                            finally {
                                PsiViewerDebugPanel.access$getEditor$p(this$0).getDocument().setReadOnly(true);
                            }
                            PsiViewerDebugPanel.access$selectAndScroll(this$0, PsiViewerDebugPanel.access$getEditor$p(this$0), $psiRangeInFile);
                        }

                        private static final Unit evaluated$lambda$0$0(PsiViewerDebugPanel this$0, String $fileText) {
                            PsiViewerDebugPanel.access$getEditor$p(this$0).getDocument().setText((CharSequence)$fileText);
                            return Unit.INSTANCE;
                        }
                    }, PsiViewerDebugPanel.access$getDebugSession$p(this.this$0).getCurrentPosition());
                }
            });
        }
    }

    private final JComponent initPsiTree() {
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)this.structureTreeModel, (Disposable)this);
        this.psiTree.setModel((TreeModel)asyncTreeModel);
        LanguageFileType languageFileType = this.language.getAssociatedFileType();
        if (languageFileType == null) {
            return null;
        }
        LanguageFileType fileType = languageFileType;
        Object object = this.fileName;
        if (object == null) {
            object = "Dummy." + fileType.getDefaultExtension();
        }
        String fileName = object;
        this.treeStructure.setRootPsiElement((PsiElement)PsiFileFactory.getInstance((Project)this.project).createFileFromText(fileName, (FileType)fileType, (CharSequence)this.editor.getDocument().getText()));
        this.psiTree.addTreeSelectionListener((TreeSelectionListener)new PsiTreeSelectionListener());
        PsiViewerDialog.initTree((JTree)this.psiTree);
        this.updatePsiTreeForSelection(this.expressionRange.getStartOffset(), this.expressionRange.getEndOffset());
        return (JComponent)new JBScrollPane((Component)this.psiTree);
    }

    private final void selectAndScroll(EditorEx $this$selectAndScroll, TextRange textRange) {
        $this$selectAndScroll.getSelectionModel().setSelection(textRange.getStartOffset(), textRange.getEndOffset());
        $this$selectAndScroll.getCaretModel().moveToOffset(textRange.getStartOffset());
        $this$selectAndScroll.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
    }

    private final EditorEx initEditor() {
        LanguageFileType languageFileType = this.language.getAssociatedFileType();
        if (languageFileType == null) {
            return null;
        }
        LanguageFileType fileType = languageFileType;
        EditorHighlighter editorHighlighter = EditorHighlighterFactory.Companion.getInstance().createEditorHighlighter(this.project, (FileType)fileType);
        this.editor.setHighlighter(editorHighlighter);
        this.editor.getDocument().setReadOnly(true);
        EditorListener editorListener = new EditorListener();
        this.editor.getCaretModel().addCaretListener((CaretListener)editorListener);
        this.editor.getSelectionModel().addSelectionListener((SelectionListener)editorListener);
        return this.editor;
    }

    private final void updatePsiTreeForSelection(int startOffset, int endOffset) {
        PsiElement psiElement = this.treeStructure.getRootPsiElement();
        PsiFile psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
        if (psiFile == null) {
            return;
        }
        PsiFile rootElement = psiFile;
        PsiElement psiElement2 = rootElement.findElementAt(startOffset);
        if (psiElement2 == null) {
            return;
        }
        PsiElement startElement = psiElement2;
        PsiElement psiElement3 = rootElement.findElementAt(endOffset - 1);
        if (psiElement3 == null) {
            return;
        }
        PsiElement endElement = psiElement3;
        PsiElement psiElement4 = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement);
        if (psiElement4 == null) {
            return;
        }
        PsiElement commonElement = psiElement4;
        this.structureTreeModel.select((Object)commonElement, (JTree)this.psiTree, arg_0 -> PsiViewerDebugPanel.updatePsiTreeForSelection$lambda$1(PsiViewerDebugPanel::updatePsiTreeForSelection$lambda$0, arg_0));
    }

    public void dispose() {
        if (!this.editor.isDisposed()) {
            EditorFactory.getInstance().releaseEditor((Editor)this.editor);
        }
        this.debugSession.removeSessionListener((XDebugSessionListener)this.watchListener);
    }

    private static final Unit updatePsiTreeForSelection$lambda$0(TreePath it) {
        return Unit.INSTANCE;
    }

    private static final void updatePsiTreeForSelection$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$setExpressionRange$p(PsiViewerDebugPanel $this, TextRange textRange) {
        $this.expressionRange = textRange;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u000b\u0010\u0007\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$Companion;", "", "<init>", "()V", "getTitle", "", "Lorg/jetbrains/annotations/Nls;", "name", "inWatchMode", "", "intellij.java.dev"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTitle(@NotNull String name, boolean inWatchMode) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return inWatchMode ? name : name + " " + DateFormatUtil.formatTimeWithSeconds((long)System.currentTimeMillis());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$DebugWatchSessionListener;", "Lcom/intellij/xdebugger/XDebugSessionListener;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "sessionPaused", "", "intellij.java.dev"})
    public final class DebugWatchSessionListener
    implements XDebugSessionListener {
        public void sessionPaused() {
            PsiViewerDebugPanel.this.refreshPanel();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$EditorListener;", "Lcom/intellij/openapi/editor/event/SelectionListener;", "Lcom/intellij/openapi/editor/event/CaretListener;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "caretPositionChanged", "", "event", "Lcom/intellij/openapi/editor/event/CaretEvent;", "selectionChanged", "e", "Lcom/intellij/openapi/editor/event/SelectionEvent;", "intellij.java.dev"})
    private final class EditorListener
    implements SelectionListener,
    CaretListener {
        public void caretPositionChanged(@NotNull CaretEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!PsiViewerDebugPanel.this.editor.getContentComponent().hasFocus()) {
                return;
            }
            if (PsiViewerDebugPanel.this.editor.getSelectionModel().hasSelection()) {
                return;
            }
            PsiElement psiElement = PsiViewerDebugPanel.this.treeStructure.getRootPsiElement();
            PsiFile psiFile = psiElement instanceof PsiFile ? (PsiFile)psiElement : null;
            if (psiFile == null) {
                return;
            }
            PsiFile rootElement = psiFile;
            PsiElement psiElement2 = rootElement.findElementAt(event.getCaret().getOffset());
            if (psiElement2 == null) {
                return;
            }
            PsiElement element = psiElement2;
            PsiViewerDebugPanel.this.structureTreeModel.select((Object)element, (JTree)PsiViewerDebugPanel.this.psiTree, arg_0 -> EditorListener.caretPositionChanged$lambda$1(EditorListener::caretPositionChanged$lambda$0, arg_0));
        }

        public void selectionChanged(@NotNull SelectionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!PsiViewerDebugPanel.this.editor.getContentComponent().hasFocus()) {
                return;
            }
            int startOffset = e.getNewRange().getStartOffset();
            int endOffset = e.getNewRange().getEndOffset();
            PsiViewerDebugPanel.this.updatePsiTreeForSelection(startOffset, endOffset);
        }

        private static final Unit caretPositionChanged$lambda$0(TreePath it) {
            return Unit.INSTANCE;
        }

        private static final void caretPositionChanged$lambda$1(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$OpenDialogAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.java.dev"})
    private final class OpenDialogAction
    extends AnAction {
        public OpenDialogAction() {
            super(JavaDevBundle.message("psi.viewer.show.open.dialog.action", new Object[0]), JavaDevBundle.message("psi.viewer.show.open.dialog.description", new Object[0]), AllIcons.ToolbarDecorator.Export);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiViewerDialog dialog = new PsiViewerDialog(PsiViewerDebugPanel.this.project, (Editor)PsiViewerDebugPanel.this.editor);
            dialog.show();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$PsiTreeSelectionListener;", "Ljavax/swing/event/TreeSelectionListener;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "valueChanged", "", "e", "Ljavax/swing/event/TreeSelectionEvent;", "intellij.java.dev"})
    private final class PsiTreeSelectionListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(@NotNull TreeSelectionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (!PsiViewerDebugPanel.this.psiTree.hasFocus()) {
                return;
            }
            TreePath treePath = PsiViewerDebugPanel.this.psiTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            TreePath path = treePath;
            Object object = path.getLastPathComponent();
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type javax.swing.tree.DefaultMutableTreeNode");
            DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)object;
            Object object2 = selectedNode.getUserObject();
            ViewerNodeDescriptor viewerNodeDescriptor = object2 instanceof ViewerNodeDescriptor ? (ViewerNodeDescriptor)((Object)object2) : null;
            if (viewerNodeDescriptor == null) {
                return;
            }
            ViewerNodeDescriptor nodeDescriptor = viewerNodeDescriptor;
            Object object3 = nodeDescriptor.getElement();
            PsiElement psiElement = object3 instanceof PsiElement ? (PsiElement)object3 : null;
            if (psiElement == null) {
                return;
            }
            PsiElement element = psiElement;
            TextRange textRange = InjectedLanguageManager.getInstance((Project)PsiViewerDebugPanel.this.project).injectedToHost(element, element.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"injectedToHost(...)");
            TextRange elementRange = textRange;
            PsiViewerDebugPanel.this.selectAndScroll(PsiViewerDebugPanel.this.editor, elementRange);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$ResetSelection;", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.java.dev"})
    private final class ResetSelection
    extends AnAction {
        public ResetSelection() {
            super(JavaDevBundle.message("psi.viewer.show.reset.selection.action", new Object[0]), JavaDevBundle.message("psi.viewer.show.reset.selection.description", new Object[0]), AllIcons.General.Reset);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            if (PsiViewerDebugPanel.this.editor.getContentComponent().hasFocus()) {
                PsiViewerDebugPanel.this.selectAndScroll(PsiViewerDebugPanel.this.editor, PsiViewerDebugPanel.this.expressionRange);
            }
            PsiViewerDebugPanel.this.updatePsiTreeForSelection(PsiViewerDebugPanel.this.expressionRange.getStartOffset(), PsiViewerDebugPanel.this.expressionRange.getEndOffset());
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$ShowTreeNodesAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.dev"})
    private final class ShowTreeNodesAction
    extends ToggleAction {
        public ShowTreeNodesAction() {
            super(JavaDevBundle.message("psi.viewer.show.tree.nodes.action", new Object[0]), JavaDevBundle.message("psi.viewer.show.tree.nodes.description", new Object[0]), AllIcons.Actions.PrettyPrint);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return PsiViewerDebugPanel.this.showTreeNodes;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiViewerDebugPanel.this.showTreeNodes = state;
            PsiViewerSettings.getSettings().showTreeNodes = state;
            PsiViewerDebugPanel.this.treeStructure.setShowTreeNodes(state);
            PsiViewerDebugPanel.this.structureTreeModel.invalidateAsync();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$ShowWhiteSpaceAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.dev"})
    private final class ShowWhiteSpaceAction
    extends ToggleAction {
        public ShowWhiteSpaceAction() {
            super(JavaDevBundle.message("psi.viewer.show.whitespace.action", new Object[0]), JavaDevBundle.message("psi.viewer.show.whitespace.description", new Object[0]), AllIcons.Diff.GutterCheckBox);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return PsiViewerDebugPanel.this.showWhiteSpace;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            PsiViewerDebugPanel.this.showWhiteSpace = state;
            PsiViewerSettings.getSettings().showWhiteSpaces = state;
            PsiViewerDebugPanel.this.treeStructure.setShowWhiteSpaces(state);
            PsiViewerDebugPanel.this.structureTreeModel.invalidateAsync();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0016\u00a8\u0006\r"}, d2={"Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel$WatchModeAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "<init>", "(Lcom/intellij/java/dev/psiViewer/debug/PsiViewerDebugPanel;)V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "isSelected", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "intellij.java.dev"})
    private final class WatchModeAction
    extends ToggleAction {
        public WatchModeAction() {
            super(JavaDevBundle.message("psi.viewer.toggle.watch.mode.action", new Object[0]), JavaDevBundle.message("psi.viewer.toggle.watch.mode.description", new Object[0]), AllIcons.Debugger.Watch);
            if (PsiViewerDebugSettings.Companion.getInstance().getWatchMode()) {
                PsiViewerDebugPanel.this.debugSession.addSessionListener((XDebugSessionListener)PsiViewerDebugPanel.this.watchListener);
            } else {
                PsiViewerDebugPanel.this.debugSession.removeSessionListener((XDebugSessionListener)PsiViewerDebugPanel.this.watchListener);
            }
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.EDT;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            return PsiViewerDebugPanel.this.watchMode;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            RunnerLayoutUi runnerLayout = PsiViewerDebugPanel.this.debugSession.getUI();
            if (runnerLayout == null) {
                return;
            }
            Content content = runnerLayout.getContentManager().getContent((JComponent)PsiViewerDebugPanel.this);
            PsiViewerDebugPanel.this.watchMode = state;
            content.setDisplayName(Companion.getTitle(PsiViewerDebugPanel.this.expression, state));
            PsiViewerDebugSettings.Companion.getInstance().setWatchMode(state);
            if (state) {
                PsiViewerDebugPanel.this.refreshPanel();
                PsiViewerDebugPanel.this.debugSession.addSessionListener((XDebugSessionListener)PsiViewerDebugPanel.this.watchListener);
            } else {
                PsiViewerDebugPanel.this.debugSession.removeSessionListener((XDebugSessionListener)PsiViewerDebugPanel.this.watchListener);
            }
        }
    }
}

