/*
 * Decompiled with CFR 0.152.
 */
package org.zmlx.hg4idea.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zmlx.hg4idea.HgFile;
import org.zmlx.hg4idea.HgRevisionNumber;
import org.zmlx.hg4idea.execution.HgCommandExecutor;
import org.zmlx.hg4idea.execution.HgCommandResult;

public class HgCatCommand {
    private final Project myProject;

    public HgCatCommand(Project project) {
        this.myProject = project;
    }

    @Nullable
    public HgCommandResult execute(@NotNull HgFile hgFile, @Nullable HgRevisionNumber vcsRevisionNumber, @Nullable Charset charset) {
        if (hgFile == null) {
            HgCatCommand.$$$reportNull$$$0(0);
        }
        List<String> arguments = HgCatCommand.createArguments(vcsRevisionNumber, hgFile.getRelativePath());
        HgCommandExecutor executor = new HgCommandExecutor(this.myProject);
        executor.setSilent(true);
        executor.setOutputAlwaysSuppressed(true);
        executor.setCharset(charset);
        executor.setBinary(true);
        return executor.executeInCurrentThread(hgFile.getRepo(), "cat", arguments);
    }

    private static List<String> createArguments(HgRevisionNumber vcsRevisionNumber, String fileName) {
        LinkedList<String> arguments = new LinkedList<String>();
        if (vcsRevisionNumber != null) {
            arguments.add("--rev");
            if (!StringUtil.isEmptyOrSpaces((String)vcsRevisionNumber.getChangeset())) {
                arguments.add(vcsRevisionNumber.getChangeset());
            } else {
                arguments.add(vcsRevisionNumber.getRevision());
            }
        }
        arguments.add(fileName);
        return arguments;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hgFile", "org/zmlx/hg4idea/command/HgCatCommand", "execute"));
    }
}

