/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.analysis;

import jakarta.json.stream.JsonGenerator;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.analysis.EdgeNGramSide;
import org.opensearch.client.opensearch._types.analysis.TokenFilterBase;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinition;
import org.opensearch.client.opensearch._types.analysis.TokenFilterDefinitionVariant;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class EdgeNGramTokenFilter
extends TokenFilterBase
implements TokenFilterDefinitionVariant,
ToCopyableBuilder<Builder, EdgeNGramTokenFilter> {
    @Nullable
    private final Integer maxGram;
    @Nullable
    private final Integer minGram;
    @Nullable
    private final Boolean preserveOriginal;
    @Nullable
    private final EdgeNGramSide side;
    public static final JsonpDeserializer<EdgeNGramTokenFilter> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, EdgeNGramTokenFilter::setupEdgeNGramTokenFilterDeserializer);

    private EdgeNGramTokenFilter(Builder builder) {
        super(builder);
        this.maxGram = builder.maxGram;
        this.minGram = builder.minGram;
        this.preserveOriginal = builder.preserveOriginal;
        this.side = builder.side;
    }

    public static EdgeNGramTokenFilter of(Function<Builder, ObjectBuilder<EdgeNGramTokenFilter>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public TokenFilterDefinition.Kind _tokenFilterDefinitionKind() {
        return TokenFilterDefinition.Kind.EdgeNgram;
    }

    @Nullable
    public final Integer maxGram() {
        return this.maxGram;
    }

    @Nullable
    public final Integer minGram() {
        return this.minGram;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    @Nullable
    public final EdgeNGramSide side() {
        return this.side;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.write("type", "edge_ngram");
        super.serializeInternal(generator, mapper);
        if (this.maxGram != null) {
            generator.writeKey("max_gram");
            generator.write(this.maxGram.intValue());
        }
        if (this.minGram != null) {
            generator.writeKey("min_gram");
            generator.write(this.minGram.intValue());
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
        if (this.side != null) {
            generator.writeKey("side");
            this.side.serialize(generator, mapper);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupEdgeNGramTokenFilterDeserializer(ObjectDeserializer<Builder> op) {
        EdgeNGramTokenFilter.setupTokenFilterBaseDeserializer(op);
        op.add(Builder::maxGram, JsonpDeserializer.integerDeserializer(), "max_gram");
        op.add(Builder::minGram, JsonpDeserializer.integerDeserializer(), "min_gram");
        op.add(Builder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.add(Builder::side, EdgeNGramSide._DESERIALIZER, "side");
        op.ignore("type");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.maxGram);
        result = 31 * result + Objects.hashCode(this.minGram);
        result = 31 * result + Objects.hashCode(this.preserveOriginal);
        result = 31 * result + Objects.hashCode(this.side);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EdgeNGramTokenFilter other = (EdgeNGramTokenFilter)o;
        return Objects.equals(this.maxGram, other.maxGram) && Objects.equals(this.minGram, other.minGram) && Objects.equals(this.preserveOriginal, other.preserveOriginal) && Objects.equals(this.side, other.side);
    }

    public static class Builder
    extends TokenFilterBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, EdgeNGramTokenFilter> {
        @Nullable
        private Integer maxGram;
        @Nullable
        private Integer minGram;
        @Nullable
        private Boolean preserveOriginal;
        @Nullable
        private EdgeNGramSide side;

        public Builder() {
        }

        private Builder(EdgeNGramTokenFilter o) {
            super(o);
            this.maxGram = o.maxGram;
            this.minGram = o.minGram;
            this.preserveOriginal = o.preserveOriginal;
            this.side = o.side;
        }

        private Builder(Builder o) {
            super(o);
            this.maxGram = o.maxGram;
            this.minGram = o.minGram;
            this.preserveOriginal = o.preserveOriginal;
            this.side = o.side;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder maxGram(@Nullable Integer value) {
            this.maxGram = value;
            return this;
        }

        @Nonnull
        public final Builder minGram(@Nullable Integer value) {
            this.minGram = value;
            return this;
        }

        @Nonnull
        public final Builder preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return this;
        }

        @Nonnull
        public final Builder side(@Nullable EdgeNGramSide value) {
            this.side = value;
            return this;
        }

        @Override
        @Nonnull
        public EdgeNGramTokenFilter build() {
            this._checkSingleUse();
            return new EdgeNGramTokenFilter(this);
        }
    }
}

