/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch._types.aggregations;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch._types.aggregations.AggregationBase;
import org.opensearch.client.util.ApiTypeHelper;

public abstract class MatrixAggregation
extends AggregationBase {
    @Nonnull
    private final List<String> fields;
    @Nonnull
    private final Map<String, Double> missing;

    protected MatrixAggregation(AbstractBuilder<?> builder) {
        super(builder);
        this.fields = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).fields);
        this.missing = ApiTypeHelper.unmodifiable(((AbstractBuilder)builder).missing);
    }

    @Nonnull
    public final List<String> fields() {
        return this.fields;
    }

    @Nonnull
    public final Map<String, Double> missing() {
        return this.missing;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (String string : this.fields) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.missing)) {
            generator.writeKey("missing");
            generator.writeStartObject();
            for (Map.Entry entry : this.missing.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write(((Double)entry.getValue()).doubleValue());
            }
            generator.writeEnd();
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupMatrixAggregationDeserializer(ObjectDeserializer<BuilderT> op) {
        MatrixAggregation.setupAggregationBaseDeserializer(op);
        op.add(AbstractBuilder::fields, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "fields");
        op.add(AbstractBuilder::missing, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.doubleDeserializer()), "missing");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.fields);
        result = 31 * result + Objects.hashCode(this.missing);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MatrixAggregation other = (MatrixAggregation)o;
        return Objects.equals(this.fields, other.fields) && Objects.equals(this.missing, other.missing);
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends AggregationBase.AbstractBuilder<BuilderT> {
        @Nullable
        private List<String> fields;
        @Nullable
        private Map<String, Double> missing;

        protected AbstractBuilder() {
        }

        protected AbstractBuilder(MatrixAggregation o) {
            super(o);
            this.fields = AbstractBuilder._listCopy(o.fields);
            this.missing = AbstractBuilder._mapCopy(o.missing);
        }

        protected AbstractBuilder(AbstractBuilder<BuilderT> o) {
            super(o);
            this.fields = AbstractBuilder._listCopy(o.fields);
            this.missing = AbstractBuilder._mapCopy(o.missing);
        }

        @Nonnull
        public final BuilderT fields(List<String> list) {
            this.fields = AbstractBuilder._listAddAll(this.fields, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT fields(String value, String ... values) {
            this.fields = AbstractBuilder._listAdd(this.fields, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT missing(Map<String, Double> map) {
            this.missing = AbstractBuilder._mapPutAll(this.missing, map);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        @Nonnull
        public final BuilderT missing(String key, Double value) {
            this.missing = AbstractBuilder._mapPut(this.missing, key, value);
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

