/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.transport;

import java.io.IOException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionRequestValidationException;
import org.opensearch.core.common.io.stream.StreamInput;
import org.opensearch.core.common.io.stream.StreamOutput;
import org.opensearch.search.builder.SearchSourceBuilder;

public class OpenSearchDocRequest
extends ActionRequest {
    private final String id;
    private final SearchSourceBuilder searchSourceBuilder;

    public OpenSearchDocRequest(String id) {
        this.id = id;
        this.searchSourceBuilder = new SearchSourceBuilder();
    }

    public OpenSearchDocRequest(SearchSourceBuilder searchSourceBuilder) {
        this.id = null;
        this.searchSourceBuilder = searchSourceBuilder;
    }

    public OpenSearchDocRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.searchSourceBuilder = new SearchSourceBuilder(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        this.searchSourceBuilder.writeTo(out);
    }

    public String getId() {
        return this.id;
    }

    public SearchSourceBuilder getSearchSourceBuilder() {
        return this.searchSourceBuilder;
    }

    public ActionRequestValidationException validate() {
        return null;
    }
}

